/*
    Melody maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __GENERAL_H__
#define __GENERAL_H__


#include "mmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:一般関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:メニューを設定する
    mmaid,ウインドウ情報                                                    */
void
set_menu_bar (MmaidWindow *mmaid);


/*  ja:ファイルの保存を問い合わせる
    mmaid,ウインドウ情報
      RET,TRUE:ファイルは閉じる,FALSE:ファイルを閉じない                    */
gboolean
prompt_close (MmaidWindow *mmaid);


/*  ja:タブの編集済みマークの変更
      mmaid,ウインドウ情報
    is_edit,TRUE:編集済み,FALSE:未編集                                      */
void
mmaid_change_edit (MmaidWindow *mmaid,
                   gboolean     is_edit);


/******************************************************************************
*                                                                             *
* ja:項目関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:タグを比較する
    id3tag0,タグ0
    id3tag1,タグ1
        RET,TRUE:等しい,FALSE:異なる                                        */
gboolean
cmp_id3tag (const ID3Tag *id3tag0,
            const ID3Tag *id3tag1);


/*  ja:タグをコピーする
    id3tag,タグ
       RET,タグ                                                             */
ID3Tag *
copy_id3tag (const ID3Tag *id3tag);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif
