/*
    Melody maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "command.h"
#include "general.h"
#include "mm_list.h"
#include "toolbar.h"
#include "misc/charuty.h"
#include "misc/misc.h"
#include "misc/misc_mdi.h"


/******************************************************************************
*                                                                             *
* ja:一般関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:メニューを設定する
    mmaid,ウインドウ情報                                                    */
void
set_menu_bar (MmaidWindow *mmaid)
{
  if (mmaid)
    {
      gboolean arrow_up = FALSE, arrow_down = FALSE, arrow_select = FALSE;
      gboolean created;
      gint i, count;

      count = mm_list_length (MM_LIST (mmaid->list));
      for (i = 0; i < count ; i++)
        if (mm_list_is_selected (MM_LIST (mmaid->list), i))
          {
            arrow_select = TRUE;
            break;
          }
      if (arrow_select)
        {
          for (i = count - 1; i > 0; i--)
            if (mm_list_is_selected (MM_LIST (mmaid->list), i))
              {
                arrow_up = TRUE;
                break;
              }
          if (arrow_up)
            {
              arrow_up = FALSE;
              while (--i >= 0)
                if (!mm_list_is_selected (MM_LIST (mmaid->list), i))
                  {
                    arrow_up = TRUE;
                    break;
                  }
            }
          for (i = 0; i < count - 1; i++)
            if (mm_list_is_selected (MM_LIST (mmaid->list), i))
              {
                arrow_down = TRUE;
                break;
              }
          if (arrow_down)
            {
              arrow_down = FALSE;
              while (++i < count)
                if (!mm_list_is_selected (MM_LIST (mmaid->list), i))
                  {
                    arrow_down = TRUE;
                    break;
                  }
            }
        }
      created = misc_mdi_get_created (MISC_MDI (mdi),
                        misc_mdi_get_page_from_data (MISC_MDI (mdi), mmaid));
      gtk_widget_set_sensitive (gtk_menu_get_attach_widget (GTK_MENU
            (gtk_item_factory_get_widget (ifactory_menu, "<main>/Tag"))),
                                                                        TRUE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Close"), TRUE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Save"), count);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Save As..."), count);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Reload..."), !created);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Export..."), arrow_select);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Up"), arrow_up);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Down"), arrow_down);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Root..."), count);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Refresh..."), count);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Add..."), TRUE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Edit..."), arrow_select);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Search..."), TRUE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Cut"), arrow_select);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Copy"), arrow_select);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Delete"), arrow_select);
      gtk_widget_set_sensitive (toolbar_items[ 2].item, count);
      gtk_widget_set_sensitive (toolbar_items[ 4].item, arrow_select);
      gtk_widget_set_sensitive (toolbar_items[ 5].item, arrow_select);
      gtk_widget_set_sensitive (toolbar_items[ 6].item, TRUE);
      gtk_widget_set_sensitive (toolbar_items[ 7].item, arrow_select);
      gtk_widget_set_sensitive (toolbar_items[ 9].item, count);
      gtk_widget_set_sensitive (toolbar_items[10].item, count);
      gtk_widget_set_sensitive (toolbar_items[11].item, TRUE);
      gtk_widget_set_sensitive (toolbar_items[12].item, arrow_select);
      gtk_widget_set_sensitive (toolbar_items[13].item, TRUE);
      gtk_widget_set_sensitive (toolbar_items[15].item, arrow_up);
      gtk_widget_set_sensitive (toolbar_items[16].item, arrow_down);
    }
  else
    {
      gtk_widget_set_sensitive (gtk_menu_get_attach_widget (GTK_MENU
            (gtk_item_factory_get_widget (ifactory_menu, "<main>/Tag"))),
                                                                        FALSE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Close"), FALSE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Save"), FALSE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Save As..."), FALSE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Reload..."), FALSE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Export..."), FALSE);
      gtk_widget_set_sensitive (toolbar_items[ 2].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[ 4].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[ 5].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[ 6].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[ 7].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[ 9].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[10].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[11].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[12].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[13].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[15].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[16].item, FALSE);
    }
}


/*  ja:ファイルの保存を問い合わせる
    mmaid,ウインドウ情報
      RET,TRUE:ファイルは閉じる,FALSE:ファイルを閉じない                    */
gboolean
prompt_close (MmaidWindow *mmaid)
{
  gint page;

  page = misc_mdi_get_page_from_data (MISC_MDI (mdi), mmaid);
  if (misc_mdi_get_edited (MISC_MDI (mdi), page))
    {
      gchar *text, *utf8str;

      utf8str = g_filename_to_utf8
            (misc_mdi_get_file (MISC_MDI (mdi), page), -1, NULL, NULL, NULL);
      text = g_strdup_printf (_("File %s was edited.\nSave?"), utf8str);
      g_free (utf8str);
      switch (misc_message_box ("Melody maid", text, 0,
                                    _("_Yes"), _("_No"), _("Cancel"), NULL))
        {
          case 0:
            {
              gint page_num;

              page_num = gtk_notebook_get_current_page (GTK_NOTEBOOK (mdi));
              if (page != page_num)
                gtk_notebook_set_current_page (GTK_NOTEBOOK (mdi), page);
              else
                page_num = -1;
              command_save (NULL, 0, NULL);
              if (page_num >= 0)
                gtk_notebook_set_current_page (GTK_NOTEBOOK (mdi), page_num);
              if (!misc_mdi_get_edited (MISC_MDI (mdi), page))
                break;
            }
          case 2:
          case -1:
            g_free (text);
            return FALSE;
        }
      g_free (text);
    }
  return TRUE;
}


/*  ja:キャラクターセットを置換する
    charlist,置換するキャラクターセット                                     */
void
charlist_renewal_all (const gchar *charlist)
{
  gchar *tmp;
  gint i;

  if (!charlist)
    return;
  if (charset_list != charlist)
    {
      tmp = charuty_append (charset_list, charlist);
      g_free (charset_list);
      charset_list = tmp;
    }
  for (i = misc_mdi_get_n_pages (MISC_MDI (mdi)) - 1; i >= 0; i--)
    {
      MmaidWindow *mmaid;

      mmaid = misc_mdi_get_data (MISC_MDI (mdi), i);
      if (mmaid->charset != charlist)
        {
          tmp = charuty_rename (mmaid->charset, charlist);
          g_free (mmaid->charset);
          mmaid->charset = tmp;
        }
      mm_list_charset_renewal (MM_LIST (mmaid->list), charlist);
    }
}


/******************************************************************************
*                                                                             *
* ja:項目関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:タグを比較する
    id3tag0,タグ0
    id3tag1,タグ1
        RET,TRUE:等しい,FALSE:異なる                                        */
gboolean
cmp_id3tag (const ID3Tag *id3tag0,
            const ID3Tag *id3tag1)
{
  return g_strfilecmp (id3tag0->file, id3tag1->file) == 0
      && ((!id3tag0->title   && !id3tag1->title)
                        || (id3tag0->title   && id3tag1->title
                        && !g_strcmp (id3tag0->title,   id3tag1->title)))
      && ((!id3tag0->artist  && !id3tag1->artist)
                        || (id3tag0->artist  && id3tag1->artist
                        && !g_strcmp (id3tag0->artist,  id3tag1->artist)))
      && ((!id3tag0->album   && !id3tag1->album)
                        || (id3tag0->album   && id3tag1->album
                        && !g_strcmp (id3tag0->album,   id3tag1->album)))
      && ((!id3tag0->year    && !id3tag1->year)
                        || (id3tag0->year    && id3tag1->year
                        && !g_strcmp (id3tag0->year,    id3tag1->year)))
      && ((!id3tag0->comment && !id3tag1->comment)
                        || (id3tag0->comment && id3tag1->comment
                        && !g_strcmp (id3tag0->comment, id3tag1->comment)))
      && id3tag0->track == id3tag1->track
      && ((!id3tag0->genre   && !id3tag1->genre)
                        || (id3tag0->genre   && id3tag1->genre
                        && !g_strcmp (id3tag0->genre,   id3tag1->genre)))
      && ((!id3tag0->charset && !id3tag1->charset)
                        || (id3tag0->charset && id3tag1->charset
                        && !g_strcmp (id3tag0->charset, id3tag1->charset)));
}


/*  ja:タグをコピーする
    id3tag,タグ
       RET,タグ                                                             */
ID3Tag *
copy_id3tag (const ID3Tag *id3tag)
{
  ID3Tag *id3tag0;

  if (!id3tag)
    return NULL;
  id3tag0 = g_malloc0 (sizeof (ID3Tag));
  id3tag0->file = g_strdup (id3tag->file);
  if (id3tag->title)
    id3tag0->title = g_strdup (id3tag->title);
  if (id3tag->artist)
    id3tag0->artist = g_strdup (id3tag->artist);
  if (id3tag->album)
    id3tag0->album = g_strdup (id3tag->album);
  if (id3tag->year)
    id3tag0->year = g_strdup (id3tag->year);
  if (id3tag->comment)
    id3tag0->comment = g_strdup (id3tag->comment);
    id3tag0->track = id3tag->track;
  if (id3tag->genre)
    id3tag0->genre = g_strdup (id3tag->genre);
  if (id3tag->charset)
    id3tag0->charset = g_strdup (id3tag->charset);
  return id3tag0;
}
