/*
    Melody maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <locale.h>
#include "mmaid.h"
#include "command.h"
#include "file.h"
#include "general.h"
#include "genre.h"
#include "mm_list.h"
#include "process.h"
#include "sigmain.h"
#include "toolbar.h"
#include "version.h"
#include "misc/argument.h"
#include "misc/charuty.h"
#include "misc/fileio.h"
#include "misc/license.h"
#include "misc/misc_accel.h"
#include "misc/misc_comm.h"
#include "misc/misc_history.h"
#include "misc/misc_mdi.h"
#include "misc/misc_winmenu.h"
#include "misc/profile.h"


gboolean newfile = FALSE;           /* ja:TRUE:新規ファイル,FALSE:なし */
gboolean second = FALSE;            /* ja:TRUE:新規,FALSE:既存 */
gboolean def_hold = TRUE;           /* ja:TRUE:保持,FALSE:上書き */
gchar *open_path = NULL;            /* ja:開くのパス */
gchar *save_path = NULL;            /* ja:名前を付けて保存のパス */
gchar *clipboard_id3tag = NULL;     /* ja:クリップボードのタグ */
gchar *charset_list = NULL;         /* ja:キャラクターセットリスト */
gchar *cmd_play = NULL;             /* ja:演奏コマンド */
gchar *cmd_stop = NULL;             /* ja:停止コマンド */
gchar *genre[256][256];             /* ja:ジャンル */
gint genres = 0;                    /* ja:ジャンルの数 */
gint def_gnum = 192;                /* ja:デフォルトのジャンル */
gint def_width, def_height;         /* ja:デフォルトのウインドウのサイズ */
gint playlist = 0;                  /* ja:プレイリスト */
GObject *history;                   /* ja:ファイルの履歴 */
GdkAtom atom_targets;               /* ja:ターゲット */
GdkAtom atom_id3tag;                /* ja:ID3タグ */
GtkWidget *window;                  /* ja:ウインドウ */
GtkWidget *mdi;                     /* en:MDI */
GtkPositionType n_pos = GTK_POS_TOP;/* ja:ノートブックの位置 */
GtkItemFactory *ifactory_menu;      /* ja:メニュー */
GtkItemFactory *ifactory_popup;     /* ja:ポップアップ */
GtkTargetEntry targets_mmaid[] = {  /* ja:提供可能なセレクション */
    {"Melody maid ID3 Tag", 0, TARGET_MMAID}};
#ifdef G_OS_WIN32
UINT uFormat = 0;                   /* ja:クリップボード */
#endif /* G_OS_WIN32 */


/******************************************************************************
*                                                                             *
* ja:メイン関数                                                               *
*                                                                             *
******************************************************************************/
static gchar *
menu_translate (const gchar *path,
                gpointer     func_data)
{
  return _(path);
}


int
main (int   argc,
      char *argv[])
{
  gboolean *arg_files, license = FALSE;
  gchar *section, *key, *utf8str;
  gint i, j, count;
  MmaidWindow *mmaid = NULL;
  Profile *profile;
  GObject *accel, *winmenu;
  GtkAccelGroup *accel_group;
  GtkWidget *menu_bar, *handle, *toolbar, *vbox;
  GtkItemFactoryEntry menu_items[] = {
{N_("/_File"),                         NULL,              NULL,            0, "<Branch>"},
{N_("/File/_New"),                     "<control>N",      command_new,     0, "<Item>"},
{N_("/File/_Open..."),                 "<control>O",      command_open,    0, "<Item>"},
{N_("/File/_Close"),                   "<control>W",      command_close,   0, "<Item>"},
{N_("/File/_Save"),                    "<control>S",      command_save,    0, "<Item>"},
{N_("/File/Save _As..."),              NULL,              command_saveas,  0, "<Item>"},
{N_("/File/_Reload..."),               "<control>R",      command_reload,  0, "<Item>"},
{N_("/File/Sep1"),                     NULL,              NULL,            0, "<Separator>"},
{N_("/File/_Export..."),               "<control>E",      command_export,  0, "<Item>"},
{N_("/File/Sep2"),                     NULL,              NULL,            0, "<Separator>"},
{N_("/File/E_xit"),                    "<control>Q",      command_exit,    0, "<Item>"},
{N_("/_Tag"),                          NULL,              NULL,            0, "<Branch>"},
{N_("/Tag/_Up"),                       NULL,              command_up,      0, "<Item>"},
{N_("/Tag/_Down"),                     NULL,              command_down,    0, "<Item>"},
{N_("/Tag/Sep1"),                      NULL,              NULL,            0, "<Separator>"},
{N_("/Tag/R_oot..."),                  "<control>H",      command_root,    0, "<Item>"},
{N_("/Tag/_Refresh..."),               "F5",              command_refresh, 0, "<Item>"},
{N_("/Tag/A_dd..."),                   "Insert",          command_add,     0, "<Item>"},
{N_("/Tag/_Edit..."),                  "<control>Return", command_edit,    0, "<Item>"},
{N_("/Tag/_Search..."),                "<control>F",      command_search,  0, "<Item>"},
{N_("/Tag/Sep2"),                      NULL,              NULL,            0, "<Separator>"},
{N_("/Tag/Cu_t"),                      "<control>X",      command_cut,     0, "<Item>"},
{N_("/Tag/_Copy"),                     "<control>C",      command_copy,    0, "<Item>"},
{N_("/Tag/_Paste"),                    "<control>V",      command_paste,   0, "<Item>"},
{N_("/Tag/De_lete"),                   "Delete",          command_delete,  0, "<Item>"},
{N_("/Tag/Sep3"),                      NULL,              NULL,            0, "<Separator>"},
{N_("/Tag/_All"),                      "<control>A",      command_all,     0, "<Item>"},
{N_("/_Option"),                       NULL,              NULL,            0, "<Branch>"},
{N_("/Option/_Configuration..."),      NULL,              command_conf,    0, "<Item>"},
{N_("/Option/_Genre..."),              NULL,              genre_dialog,    0, "<Item>"},
{N_("/Option/Character _Encoding..."), NULL,              command_charset, 0, "<Item>"},
{N_("/Option/_Process..."),            NULL,              process_dialog,  0, "<Item>"},
{N_("/_Window"),                       NULL,              NULL,            0, "<Branch>"},
{N_("/_Help"),                         NULL,              NULL,            0, "<Branch>"},
{N_("/Help/_About..."),                NULL,              version_dialog,  0, "<Item>"}};
    GtkItemFactoryEntry popup_items[] = {
{N_("/Play"),                          NULL,              command_play,    0, "<Item>"},
{N_("/Stop"),                          NULL,              command_stop,    0, "<Item>"},
{"/Sep1",                              NULL,              NULL,            0, "<Separator>"},
{N_("/Cu_t"),                          "<control>X",      command_cut,     0, "<Item>"},
{N_("/_Copy"),                         "<control>C",      command_copy,    0, "<Item>"},
{N_("/_Paste"),                        "<control>V",      command_paste,   0, "<Item>"},
{N_("/De_lete"),                       "Delete",          command_delete,  0, "<Item>"},
{"/Sep2",                              NULL,              NULL,            0, "<Separator>"},
{N_("/_All"),                          "<control>A",      command_all,     0, "<Item>"}};
  /* Drag&Drop */
  GtkTargetEntry drag_types[1] = {{"text/uri-list", 0, 0}};

  /* 初期化 */
  setlocale (LC_ALL, "");
#ifdef LOCALEDIR
  bindtextdomain (PACKAGE, LOCALEDIR);
#else /* not LOCALEDIR */
  {
    gchar *dirname, *path, *locale;

    path = fileio_get_full_path (argv[0]);
    dirname = g_path_get_dirname (path);
    g_free (path);
    locale = g_strconcat (dirname, G_DIR_SEPARATOR_S, "locale", NULL);
    g_free (dirname);
    bindtextdomain (PACKAGE, locale);
    g_free (locale);
  }
#endif /* not LOCALEDIR */
  bind_textdomain_codeset (PACKAGE, "UTF-8");
  textdomain (PACKAGE);
  gtk_set_locale ();
  gtk_init (&argc, &argv);

  def_width  = gdk_screen_width ()  * 2 / 3;
  def_height = gdk_screen_height () * 2 / 3;
  g_memset (genre, 0, sizeof (gchar *) * 256 * 256);

  /* ja:ファイルの履歴 */
  history = misc_history_new ();

  /* ja:レジストリから読み出す */
  profile = profile_open (NULL);
  if (profile)
    {
      gint num;

      if (!profile_get_value (profile, "mmaid", "license",
                (gpointer)&license, sizeof (gboolean),
                                                    PROFILE_VALUE_TYPE_BOOL))
        license = FALSE;
      if (profile_get_value (profile, "mmaid", "history",
                (gpointer)&num, sizeof (gint), PROFILE_VALUE_TYPE_INT))
        misc_history_set_num (MISC_HISTORY (history), num);
      if (!profile_get_value (profile, "mmaid", "newfile",
                (gpointer)&newfile, sizeof (gboolean),
                                                    PROFILE_VALUE_TYPE_BOOL))
        newfile = FALSE;
      if (!profile_get_value (profile, "mmaid", "second",
                (gpointer)&second, sizeof (gboolean), PROFILE_VALUE_TYPE_BOOL))
        second = FALSE;
      if (!profile_get_value (profile, "mmaid", "def_hold",
                (gpointer)&def_hold, sizeof (gboolean),
                                                    PROFILE_VALUE_TYPE_BOOL))
        def_hold = TRUE;
      if (!profile_get_value (profile, "mmaid", "def_gnum",
                (gpointer)&def_gnum, sizeof (gint), PROFILE_VALUE_TYPE_INT))
        def_gnum = 192;
      if (!profile_get_value (profile, "mmaid", "def_width",
                (gpointer)&def_width, sizeof (gint), PROFILE_VALUE_TYPE_INT))
        def_width = gdk_screen_width () * 2 / 3;
      if (!profile_get_value (profile, "mmaid", "def_height",
                (gpointer)&def_height, sizeof (gint), PROFILE_VALUE_TYPE_INT))
        def_height = gdk_screen_height () * 2 / 3;
      if (!profile_get_value (profile, "mmaid", "n_pos",
                (gpointer)&n_pos, sizeof (gint), PROFILE_VALUE_TYPE_INT))
        n_pos = GTK_POS_TOP;
      if (!profile_get_value (profile, "mmaid", "playlist",
                (gpointer)&playlist, sizeof (gint), PROFILE_VALUE_TYPE_INT))
        playlist = 0;
      cmd_play = profile_get_string (profile, "mmaid", "cmd_play");
      cmd_stop = profile_get_string (profile, "mmaid", "cmd_stop");
      charset_list = profile_get_string (profile, "mmaid", "charlist");
      if (charset_list)
        {
          gchar *tmp;

          tmp = charuty_strip (charset_list);
          g_free (charset_list);
          charset_list = tmp;
        }
      utf8str = profile_get_string (profile, "mmaid", "openpath");
      open_path = utf8str
                ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
      g_free (utf8str);
      utf8str = profile_get_string (profile, "mmaid", "savepath");
      save_path = utf8str
                ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
      g_free (utf8str);
      /* ja:ファイルの履歴 */
      for (i = misc_history_get_num (MISC_HISTORY (history)) - 1; i >= 0; i--)
        {
          key = g_strdup_printf ("history%d", i);
          utf8str = profile_get_string (profile, "mmaid", key);
          g_free (key);
          if (utf8str)
            {
              gchar *file;

              file = g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL);
              g_free (utf8str);
              misc_history_add_file (MISC_HISTORY (history), file);
              g_free (file);
            }
        }
      /* ja:ジャンル */
      for (i = 0; i < 256; i++)
        {
          section = g_strdup_printf ("genre%03d", i);
          count = 0;
          for (j = 0; j < 256; j++)
            {
              key = g_strdup_printf ("genre%03d", j);
              genre[i][j] = profile_get_string (profile, section, key);
              g_free (key);
              if (genre[i][j] && (genre[i][j])[0] == '\0')
                {
                  g_free (genre[i][j]);
                  genre[i][j] = NULL;
                }
              if (genre[i][j])
                count++;
            }
          g_free (section);
          if (count <= 0)
            break;
          genres++;
        }
      profile_close (profile);
    }
  if (!license)
    license = license_dialog ();
  if (!license)
    gtk_exit (0);
  /* ja:キャラクターセット */
  if (!charset_list)
    {
      const gchar *charset;

      charset_list = !g_get_charset (&charset) && charset != NULL
                ? g_strdup_printf ("%s,UTF-8", charset) : g_strdup ("UTF-8");
    }
  /* ja:ジャンル */
  if (genres <= 0)
    {
      genres = 2;
      count = 0;
      for (i = 0; i < 256; i++)
        if (def_genre_list[i])
          {
            genre[0][i] = g_strdup (_(def_genre_list[i]));
            genre[1][i] = g_strdup   (def_genre_list[i]);
            if (genre[0][i] && (genre[0][i])[0] == '\0')
              {
                g_free (genre[0][i]);
                genre[0][i] = NULL;
              }
            if (genre[0][i] && g_strcmp (genre[0][i], genre[1][i]) != 0)
              count++;
          }
      if (count <= 0)
        {
          genres = 1;
          for (i = 0; i < 256; i++)
            {
              g_free (genre[0][i]);
              genre[0][i] = genre[1][i];
              genre[1][i] = NULL;
            }
        }
    }

  /* ja:コマンドラインの解析 */
  {
    gint array[2], def[2];
    ArgumentBool arg_n, arg_x;
    ArgumentValue arg_h;
    ArgumentArray arg_s;
    ArgumentExit arg_v;
    ArgumentHelp arg_q;
    ArgumentList arg_opts[] = {
{"history", 'h',  "NUM",          N_("History"),     ARGUMENT_TYPE_VALUE, &arg_h},
{"new",     'n',  "ON/OFF",       N_("New File"),    ARGUMENT_TYPE_BOOL,  &arg_n},
{"size",    's',  "WIDTH,HEIGHT", N_("Window Size"), ARGUMENT_TYPE_ARRAY, &arg_s},
{"second",  'x',  "ON/OFF",       N_("Open Window"), ARGUMENT_TYPE_BOOL,  &arg_x},
{"version", 'v',  NULL,           N_("About"),       ARGUMENT_TYPE_EXIT,  &arg_v},
{"help",    '?',  NULL,           N_("Help"),        ARGUMENT_TYPE_HELP,  &arg_q},
{NULL,      '\0', NULL,           NULL,              0,                   NULL}};

    /* ja:ファイルの履歴 */
    arg_h.val = misc_history_get_num (MISC_HISTORY (history));
    arg_h.def = 4;
    /* ja:新規ファイル */
    arg_n.flag = newfile;
    arg_n.def = FALSE;
    /* ja:ウインドウサイズ */
    array[0] = def_width;
    array[1] = def_height;
    def[0] = gdk_screen_width ()  * 2 / 3;
    def[1] = gdk_screen_height () * 2 / 3;
    arg_s.leng = 2;
    arg_s.array = array;
    arg_s.def = def;
    /* ja:新規ウインドウ */
    arg_x.flag = second;
    arg_x.def = FALSE;
    /* ja:バージョン */
    arg_v.str =
MMAID_VERSION_NOTICE"\n"
MMAID_COPYRIGHT_NOTICE"\n"
"This is free software; see the source for copying conditions.  There is NO\n"
"warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n";
    /* ja:ヘルプ */
    arg_q.str = MMAID_COPYRIGHT_NOTICE"\n\n";
    arg_files = arg_analyse (argv, arg_opts);
    misc_history_set_num (MISC_HISTORY (history), arg_h.val);
    def_width = array[0];
    def_height = array[1];
    second = arg_x.flag;
  }

  /* ja:メインウインドウ */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Melody maid");
  gtk_window_set_default_size (GTK_WINDOW (window), def_width, def_height);
  g_signal_connect (G_OBJECT (window), "delete-event",
                                            G_CALLBACK (signal_delete), NULL);
  g_signal_connect (G_OBJECT (window), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  gtk_widget_realize (window);
  /* en:Drag and Drop */
  gtk_drag_dest_set (window, GTK_DEST_DEFAULT_MOTION
                        | GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP,
                                            drag_types, 1, GDK_ACTION_COPY);
  g_signal_connect (G_OBJECT (window), "drag-data-received",
                                G_CALLBACK (signal_drag_data_received), NULL);
#ifdef G_OS_WIN32
  /* ja:クリップボード */
  uFormat = RegisterClipboardFormat (_T("Melody maid ID3 Tag"));
#endif /* G_OS_WIN32 */
  /* ja:クリップボード */
  atom_targets = gdk_atom_intern ("TARGETS", FALSE);
  atom_id3tag = gdk_atom_intern ("Melody maid ID3 Tag", FALSE);
  gtk_selection_add_targets (window, GDK_SELECTION_CLIPBOARD,
            targets_mmaid, sizeof (targets_mmaid) / sizeof (GtkTargetEntry));
  g_signal_connect (G_OBJECT (window), "selection-clear-event",
                                G_CALLBACK (signal_selection_clear), NULL);
  g_signal_connect (G_OBJECT(window), "selection-get",
                                G_CALLBACK (signal_selection_get), NULL);
  g_signal_connect (G_OBJECT (window), "selection-received",
                                G_CALLBACK (signal_selection_received), NULL);
  /* en:MDI */
  mdi = misc_mdi_new ();
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (mdi), TRUE);
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (mdi), n_pos);
  g_signal_connect (G_OBJECT (mdi), "close-window",
                                G_CALLBACK (signal_close_window), NULL);
  g_signal_connect (G_OBJECT (mdi), "switch-window",
                                G_CALLBACK (signal_switch_window), NULL);
  /* ja:ポップアップ */
  accel_group = gtk_accel_group_new ();
  ifactory_popup = gtk_item_factory_new (GTK_TYPE_MENU, "<main>", accel_group);
  gtk_item_factory_set_translate_func (ifactory_popup, menu_translate,
                                                                NULL, NULL);
  gtk_item_factory_create_items (ifactory_popup,
    sizeof (popup_items) / sizeof (GtkItemFactoryEntry), popup_items, NULL);
  /* ja:メニュー */
  accel_group = gtk_accel_group_new ();
  ifactory_menu = gtk_item_factory_new (GTK_TYPE_MENU_BAR,
                                                        "<main>", accel_group);
  gtk_item_factory_set_translate_func (ifactory_menu, menu_translate,
                                                                NULL, NULL);
  gtk_item_factory_create_items (ifactory_menu,
        sizeof(menu_items) / sizeof (GtkItemFactoryEntry), menu_items, NULL);
  gtk_widget_add_events (window, GDK_KEY_PRESS_MASK);
  menu_bar = gtk_item_factory_get_widget (ifactory_menu, "<main>");
  /* ja:ファイルの履歴 */
  misc_history_set_menu (MISC_HISTORY (history),
    gtk_item_factory_get_widget (ifactory_menu, "<main>/File"), MENUFILE - 2);
  g_signal_connect (MISC_HISTORY (history), "activate",
                            G_CALLBACK (signal_activate_menu_history), NULL);
  /* ja:ウインドウメニュー */
  winmenu = misc_winmenu_new ();
  misc_winmenu_set_mdi (MISC_WINMENU (winmenu), MISC_MDI (mdi));
  misc_winmenu_set_menu (MISC_WINMENU (winmenu),
            gtk_item_factory_get_widget (ifactory_menu, "<main>/Window"), 0);
  /* ja:アクセルグループ */
  accel = misc_accel_new ();
  misc_accel_set_window (MISC_ACCEL (accel), GTK_WINDOW (window));
  misc_accel_add_accel_group (MISC_ACCEL (accel), accel_group);
  /* ja:ツールバー */
  toolbar = gtk_toolbar_new ();
  gtk_toolbar_set_orientation (GTK_TOOLBAR (toolbar),
                                                GTK_ORIENTATION_HORIZONTAL);
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_ICONS);
  for (i = 0; toolbar_items[i].name != (gpointer)-1; i++)
    if (toolbar_items[i].name)
      {
        GdkBitmap *mask;
        GdkPixmap *pixmap;

        pixmap = gdk_pixmap_create_from_xpm_d (window->window,
                                            &mask, NULL, toolbar_items[i].xpm);
        toolbar_items[i].item = gtk_toolbar_append_item
                                (GTK_TOOLBAR (toolbar),
                                 NULL,
                                 _(toolbar_items[i].name),
                                 NULL,
                                 gtk_pixmap_new (pixmap, mask),
                                 GTK_SIGNAL_FUNC (toolbar_items[i].callback),
                                 toolbar_items[i].user_data);
      }
    else
      {
        gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
      }
  /* ja:垂直ボックス/ハンドルボックス */
  vbox = gtk_vbox_new (FALSE, 0);
  handle = gtk_handle_box_new ();
  gtk_container_set_border_width (GTK_CONTAINER (handle), 2);
  gtk_container_add (GTK_CONTAINER (handle), menu_bar);
  gtk_box_pack_start (GTK_BOX (vbox), handle, FALSE, FALSE, 0);
  handle = gtk_handle_box_new ();
  gtk_container_set_border_width (GTK_CONTAINER (handle), 2);
  gtk_container_add (GTK_CONTAINER (handle), toolbar);
  gtk_box_pack_start (GTK_BOX (vbox), handle, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), mdi, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox);

  /* ja:メニュー表示 */
  set_menu_bar (NULL);

  /* ja:既に起動しているかチェックする */
  if (!second)
    {
      GObject *comm;

      comm = misc_comm_new (window, "Melody maid InterProcess communication");
      if (!misc_comm_is_first (MISC_COMM (comm)))
        {
          misc_comm_send_with_files (MISC_COMM (comm), argc, argv, arg_files);
          gtk_exit (0);
        }
      g_signal_connect (G_OBJECT (comm), "recv",
                                    G_CALLBACK (signal_selection_recv), NULL);
    }

  /* ja:表示 */
  gtk_widget_show_all (window);
  gtk_window_set_policy (GTK_WINDOW (window), TRUE, TRUE, TRUE);

  /* ja:新規ウインドウ */
  count = 0;
  for (i = 1; i < argc; i++)
    if (arg_files[i])
      switch (file_is_type (argv[i]))
        {
          case FILE_KIND_ERROR:
          case FILE_KIND_DB:
          case FILE_KIND_LIST:
            mmaid = file_open_edit (argv[i]);
            count++;
            break;
          case FILE_KIND_UNKNOWN:
          case FILE_KIND_TAG:
            {
              ID3Tag *id3tag;

              id3tag = file_open_id3tag (argv[i], charset_list);
              if (id3tag && (!mmaid
                    || mm_list_search (MM_LIST (mmaid->list),
                                        MM_LIST_FILE, id3tag->file, -1) < 0))
                {
                  if (!mmaid)
                    {
                      mmaid = file_open_edit (NULL);
                      count++;
                    }
                  mm_list_append (MM_LIST (mmaid->list), id3tag);
                  misc_mdi_set_edited (MISC_MDI (mdi),
                    misc_mdi_get_page_from_data (MISC_MDI (mdi), mmaid), TRUE);
                }
            }
        }
  g_free (arg_files);
  if (newfile && count <= 0)
    file_open_edit (NULL);

  gtk_main();

  /* ja:レジストリに書き込む */
  profile = profile_open (NULL);
  if (profile)
    {
      gint num;
      GList *glist;

      num = misc_history_get_num (MISC_HISTORY (history));
      profile_set_value (profile, "mmaid", "license",
            (gpointer)&license, sizeof (gboolean), PROFILE_VALUE_TYPE_BOOL);
      profile_set_value (profile, "mmaid", "history",
            (gpointer)&num, sizeof (gint), PROFILE_VALUE_TYPE_INT);
      profile_set_value (profile, "mmaid", "newfile",
            (gpointer)&newfile, sizeof (gboolean), PROFILE_VALUE_TYPE_BOOL);
      profile_set_value (profile, "mmaid", "second",
            (gpointer)&second, sizeof (gboolean), PROFILE_VALUE_TYPE_BOOL);
      profile_set_value (profile, "mmaid", "def_hold",
            (gpointer)&def_hold, sizeof (gboolean), PROFILE_VALUE_TYPE_BOOL);
      profile_set_value (profile, "mmaid", "def_gnum",
            (gpointer)&def_gnum, sizeof (gint), PROFILE_VALUE_TYPE_INT);
      profile_set_value (profile, "mmaid", "def_width",
            (gpointer)&def_width, sizeof (gint), PROFILE_VALUE_TYPE_INT);
      profile_set_value (profile, "mmaid", "def_height",
            (gpointer)&def_height, sizeof (gint), PROFILE_VALUE_TYPE_INT);
      profile_set_value (profile, "mmaid", "n_pos",
            (gpointer)&n_pos, sizeof (gint), PROFILE_VALUE_TYPE_INT);
      profile_set_value (profile, "mmaid", "playlist",
            (gpointer)&playlist, sizeof (gint), PROFILE_VALUE_TYPE_INT);
      profile_set_value (profile, "mmaid", "cmd_play", (gpointer)cmd_play,
                                (g_strlen (cmd_play) + 1) * sizeof (gchar),
                                                    PROFILE_VALUE_TYPE_STRING);
      profile_set_value (profile, "mmaid", "cmd_stop", (gpointer)cmd_stop,
                                (g_strlen (cmd_stop) + 1) * sizeof (gchar),
                                                    PROFILE_VALUE_TYPE_STRING);
      profile_set_value (profile, "mmaid", "charlist", (gpointer)charset_list,
                                (g_strlen (charset_list) + 1) * sizeof (gchar),
                                                    PROFILE_VALUE_TYPE_STRING);
      if (open_path)
        {
          utf8str = g_filename_to_utf8 (open_path, -1, NULL, NULL, NULL);
          if (utf8str)
            {
              profile_set_value (profile, "mmaid", "openpath",
                                    (gpointer)utf8str,
                                    (g_strlen (utf8str) + 1) * sizeof (gchar),
                                                    PROFILE_VALUE_TYPE_STRING);
              g_free (utf8str);
            }
        }
      if (save_path)
        {
          utf8str = g_filename_to_utf8 (save_path, -1, NULL, NULL, NULL);
          if (utf8str)
            {
              profile_set_value (profile, "mmaid", "savepath",
                                    (gpointer)utf8str,
                                    (g_strlen (utf8str) + 1) * sizeof (gchar),
                                                    PROFILE_VALUE_TYPE_STRING);
              g_free (utf8str);
            }
        }
      /* ja:ファイルの履歴 */
      glist = misc_history_get_file (MISC_HISTORY (history));
      for (i = 0; i < g_list_length (glist); i++)
        {
          key = g_strdup_printf ("history%d", i);
          utf8str = g_filename_to_utf8 (g_list_nth_data (glist, i), -1,
                                                            NULL, NULL, NULL);
          if (utf8str)
            {
              profile_set_value (profile, "mmaid", key, (gpointer)utf8str,
                                    (g_strlen (utf8str) + 1) * sizeof (gchar),
                                                    PROFILE_VALUE_TYPE_STRING);
              g_free (utf8str);
            }
          g_free (key);
        }
      g_list_free (glist);
      while (i <= MISC_HISTORY_NUM_MAX)
        {
          key = g_strdup_printf ("history%d", i++);
          profile_delete_key (profile, "mmaid", key);
          g_free (key);
        }
      /* ja:ジャンル */
      for (i = 0; i < genres; i++)
        {
          section = g_strdup_printf ("genre%03d", i);
          for (j = 0; j < 256; j++)
            {
              key = g_strdup_printf ("genre%03d", j);

              if (genre[i][j])
                profile_set_value (profile, section, key,
                            (gpointer)genre[i][j],
                            (g_strlen (genre[i][j]) + 1) * sizeof (gchar),
                                                    PROFILE_VALUE_TYPE_STRING);
              else
                profile_delete_key (profile, section, key);
              g_free (key);
            }
          g_free (section);
        }
      while (i < 256)
        {
          section = g_strdup_printf ("genre%03d", i++);
          profile_delete_section (profile, section);
          g_free (section);
        }
      profile_close (profile);
    }
  for (i = 0; i < genres; i++)
    for (j = 0; j < 256; j++)
      g_free (genre[i][j]);
  g_free (cmd_play);
  g_free (cmd_stop);
  g_free (charset_list);
  g_free (open_path);
  g_free (save_path);
  g_free (clipboard_id3tag);
  return 0;
}
