/*
    Melody maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "command.h"
#include "file.h"
#include "general.h"
#include "mm_list.h"
#include "sigfile.h"
#include "misc/fileio.h"
#include "misc/misc.h"
#include "misc/misc_mdi.h"


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(マウス)                                          *
*                                                                             *
******************************************************************************/
gboolean
signal_button_press (GtkWidget      *widget,
                     GdkEventButton *event,
                     MmaidWindow    *mmaid)
{
  if (event->type == GDK_BUTTON_PRESS && event->button == 3)
    {
      gboolean arrow_select = FALSE;
      gint i, n, c;

      mm_list_get_cursor_from_pos (MM_LIST (mmaid->list),
                                    (gint)event->x, (gint)event->y, &n, &c);
      if (n >= 0)
        mm_list_set_cursor (MM_LIST (mmaid->list), n, c);
      mm_list_get_cursor (MM_LIST (mmaid->list), &n, NULL);
      for (i = mm_list_length (MM_LIST (mmaid->list)) - 1; i >= 0; i--)
        if (mm_list_is_selected (MM_LIST (mmaid->list), i))
          {
            arrow_select = TRUE;
            break;
          }
      if (cmd_play != NULL || cmd_stop != NULL)
        {
          gtk_widget_show (gtk_item_factory_get_widget
                                            (ifactory_popup, "<main>/Play"));
          gtk_widget_show (gtk_item_factory_get_widget
                                            (ifactory_popup, "<main>/Stop"));
          gtk_widget_show (gtk_item_factory_get_widget
                                            (ifactory_popup, "<main>/Sep1"));
          gtk_widget_set_sensitive (gtk_item_factory_get_widget
                            (ifactory_popup, "<main>/Play"), n >= 0);
          gtk_widget_set_sensitive (gtk_item_factory_get_widget
                            (ifactory_popup, "<main>/Stop"), cmd_stop != NULL);
        }
      else
        {
          gtk_widget_hide (gtk_item_factory_get_widget
                                            (ifactory_popup, "<main>/Play"));
          gtk_widget_hide (gtk_item_factory_get_widget
                                            (ifactory_popup, "<main>/Stop"));
          gtk_widget_hide (gtk_item_factory_get_widget
                                            (ifactory_popup, "<main>/Sep1"));
        }
      gtk_widget_set_sensitive (gtk_item_factory_get_widget
                            (ifactory_popup, "<main>/Cut"), arrow_select);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget
                            (ifactory_popup, "<main>/Copy"), arrow_select);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget
                            (ifactory_popup, "<main>/Delete"), arrow_select);
      gtk_menu_popup (GTK_MENU
                    (gtk_item_factory_get_widget (ifactory_popup,"<main>")),
                        NULL, NULL, NULL, NULL, event->button, event->time);
      return TRUE;
    }
  return FALSE;
}


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(フレーム)                                        *
*                                                                             *
******************************************************************************/
void
signal_changed (GtkWidget   *widget,
                MmaidWindow *mmaid)
{
  if (mmaid == misc_mdi_get_data (MISC_MDI (mdi), -1))
    set_menu_bar (mmaid);
}


void
signal_clicked (GtkWidget   *widget,
                MmaidWindow *mmaid)
{
  misc_mdi_set_edited (MISC_MDI (mdi),
                    misc_mdi_get_page_from_data (MISC_MDI (mdi), mmaid), TRUE);
  if (mmaid == misc_mdi_get_data (MISC_MDI (mdi), -1))
    set_menu_bar (mmaid);
}


void
signal_edited (GtkWidget   *widget,
               const gint   n,
               const gint   c,
               MmaidWindow *mmaid)
{
  if (c == MM_LIST_ID3TAG || c == MM_LIST_FILE || c == MM_LIST_TITLE
            || c == MM_LIST_ARTIST || c == MM_LIST_ALBUM || c == MM_LIST_GENRE)
    misc_mdi_set_edited (MISC_MDI (mdi),
                    misc_mdi_get_page_from_data (MISC_MDI (mdi), mmaid), TRUE);
  if (mmaid == misc_mdi_get_data (MISC_MDI (mdi), -1))
    set_menu_bar (mmaid);
}


void
signal_inserted (GtkWidget   *widget,
                 const gint   n,
                 MmaidWindow *mmaid)
{
  misc_mdi_set_edited (MISC_MDI (mdi),
                    misc_mdi_get_page_from_data (MISC_MDI (mdi), mmaid), TRUE);
  if (mmaid == misc_mdi_get_data (MISC_MDI (mdi), -1))
    set_menu_bar (mmaid);
}


void
signal_moved (GtkWidget   *widget,
              const gint   n0,
              const gint   n1,
              MmaidWindow *mmaid)
{
  misc_mdi_set_edited (MISC_MDI (mdi),
                    misc_mdi_get_page_from_data (MISC_MDI (mdi), mmaid), TRUE);
  if (mmaid == misc_mdi_get_data (MISC_MDI (mdi), -1))
    set_menu_bar (mmaid);
}


void
signal_destroy_list (GtkWidget   *widget,
                     MmaidWindow *mmaid)
{
  /* ja:メニュー */
  if (misc_mdi_get_n_pages (MISC_MDI (mdi)) <= 1)
    set_menu_bar (NULL);
  /* ja:メモリを解放する */
  g_free (mmaid->charset);
  g_free (mmaid);
}
