/*
    Melody maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "add.h"
#include "general.h"
#include "mm_list.h"
#include "misc/charuty.h"
#include "misc/fileio.h"
#include "orz/orzcharset.h"
#include "orz/orzmdi.h"


/******************************************************************************
*                                                                             *
* ja:追加ダイアログ関数群                                                     *
*                                                                             *
******************************************************************************/
static GtkWidget *dialog, *button9, *check, *entry0, *entry4, *spin;
static GtkWidget *combo1, *combo2, *combo3, *combo5, *combo7, *charset8;
static GtkWidget *label0, *label1, *label2, *label3;
static GtkWidget *label4, *label5, *label7, *label8;


#if ! GTK_CHECK_VERSION(2,4,0)
/* ja:参照でOKボタンが押された */
static void
add_dialog_clicked_browse_ok (GtkWidget *widget,
                              GtkWidget *dialog_browse)
{
  gchar **file;

  file = g_object_get_data (G_OBJECT (dialog_browse), "user_data");
  *file = g_filename_to_utf8 (gtk_file_selection_get_filename
                (GTK_FILE_SELECTION (dialog_browse)), -1, NULL, NULL, NULL);
  gtk_widget_destroy (dialog_browse);
}
#endif /* not GTK_CHECK_VERSION(2,4,0) */


/* ja:参照ボタンが押された */
static void
add_dialog_clicked_browse (GtkWidget *widget,
                           gpointer   user_data)
{
  gchar *file;
  GtkWidget *dialog_browse;

#if GTK_CHECK_VERSION(2,4,0)
  dialog_browse = gtk_file_chooser_dialog_new (_("Browse"),
                        GTK_WINDOW (window), GTK_FILE_CHOOSER_ACTION_OPEN,
                        GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                        NULL);
  file = g_filename_from_utf8 (gtk_entry_get_text (GTK_ENTRY (entry0)),
                                                        -1, NULL, NULL, NULL);
  if (fileio_isfile (file))
    {
      gtk_file_chooser_set_filename (GTK_FILE_CHOOSER (dialog_browse), file);
    }
  else
    {
      gchar *dir, *path;

      dir = g_path_get_dirname (file);
      path = fileio_get_full_path (dir);
      g_free (dir);
      if (fileio_isfile (path))
        gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog_browse),
                                                                        path);
      g_free (path);
    }
  g_free (file);
  file = gtk_dialog_run (GTK_DIALOG (dialog_browse)) == GTK_RESPONSE_ACCEPT
    ? gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog_browse)) : NULL;
  gtk_widget_destroy (dialog_browse);
#else /* not GTK_CHECK_VERSION(2,4,0) */
  dialog_browse = gtk_file_selection_new (_("Browse"));
  g_signal_connect (G_OBJECT (dialog_browse), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  g_signal_connect (G_OBJECT (GTK_FILE_SELECTION (dialog_browse)->ok_button),
       "clicked", G_CALLBACK (add_dialog_clicked_browse_ok), dialog_browse);
  g_signal_connect_swapped
                (G_OBJECT (GTK_FILE_SELECTION (dialog_browse)->cancel_button),
       "clicked", G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (dialog_browse));
  g_object_set_data (G_OBJECT (dialog_browse), "user_data", &file);
  file = g_filename_from_utf8 (gtk_entry_get_text (GTK_ENTRY (entry0)),
                                                        -1, NULL, NULL, NULL);
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (dialog_browse), file);
  g_free (file);
  file = NULL;
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (dialog_browse));
  gtk_widget_show (dialog_browse);
  gtk_grab_add (dialog_browse);
  gtk_main ();
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  if (file)
    {
      gchar *utf8str;

      utf8str = g_filename_to_utf8 (file, -1, NULL, NULL, NULL);
      gtk_entry_set_text (GTK_ENTRY (entry0), utf8str);
      g_free (utf8str);
      g_free (file);
    }
}


/* ja:OKボタンが押された */
static void
add_dialog_clicked_ok (GtkWidget   *widget,
                       MmaidWindow *mmaid)
{
  gchar *file, *tmp, *charset;
  const gchar *title, *artist, *album, *year, *comment, *genre;
  gint n, c;
  ID3Tag *id3tag;

  file = g_filename_from_utf8 (gtk_entry_get_text (GTK_ENTRY (entry0)), -1,
                                                            NULL, NULL, NULL);
  tmp = fileio_get_full_path (file);
  g_free (file);
  file = g_filename_to_utf8 (tmp, -1, NULL, NULL, NULL);
  g_free (tmp);
  if (!file)
    return;
  id3tag = g_malloc0 (sizeof (ID3Tag));
#if GTK_CHECK_VERSION(2,4,0)
  title   = gtk_entry_get_text (GTK_ENTRY (GTK_BIN (combo1)->child));
  artist  = gtk_entry_get_text (GTK_ENTRY (GTK_BIN (combo2)->child));
  album   = gtk_entry_get_text (GTK_ENTRY (GTK_BIN (combo3)->child));
#else /* not GTK_CHECK_VERSION(2,4,0) */
  title   = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo1)->entry));
  artist  = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo2)->entry));
  album   = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo3)->entry));
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  year    = gtk_entry_get_text (GTK_ENTRY (entry4));
#if GTK_CHECK_VERSION(2,4,0)
  comment = gtk_entry_get_text (GTK_ENTRY (GTK_BIN (combo5)->child));
#else /* not GTK_CHECK_VERSION(2,4,0) */
  comment = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo5)->entry));
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  id3tag->track = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check))
              ? gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin)) : -1;
#if GTK_CHECK_VERSION(2,4,0)
  genre   = gtk_entry_get_text (GTK_ENTRY (GTK_BIN (combo7)->child));
#else /* not GTK_CHECK_VERSION(2,4,0) */
  genre   = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo7)->entry));
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  charset = orz_charset_get_charset (ORZ_CHARSET (charset8));
  if (file && file[0] != '\0')
    id3tag->file = g_strdup (file);
  if (title[0] != '\0')
    id3tag->title = g_strdup (title);
  if (artist[0] != '\0')
    id3tag->artist = g_strdup (artist);
  if (album[0] != '\0')
    id3tag->album = g_strdup (album);
  if (year[0] != '\0')
    id3tag->year = g_strdup (year);
  if (comment[0] != '\0')
    id3tag->comment = g_strdup (comment);
  if (genre[0] != '\0')
    id3tag->genre = g_strdup (genre);
  if (orz_charset_is_valid (ORZ_CHARSET (charset8)))
    id3tag->charset = charset;
  else
    g_free (charset);
  mm_list_get_cursor (MM_LIST (mmaid->list), &n, &c);
  n = n >= 0 ? mm_list_insert (MM_LIST (mmaid->list), n, id3tag)
             : mm_list_append (MM_LIST (mmaid->list), id3tag);
  mm_list_set_cursor (MM_LIST (mmaid->list), n, c);
  mm_list_unselect_all (MM_LIST (mmaid->list));
  mm_list_select (MM_LIST (mmaid->list), n);
  if (orz_charset_is_valid (ORZ_CHARSET (charset8)))
    charlist_renewal_all (charset);
  orz_mdi_set_edited (ORZ_MDI (mdi),
                    orz_mdi_get_page_from_data (ORZ_MDI (mdi), mmaid), TRUE);
  gtk_widget_destroy (dialog);
}


/* ja:コンボボックス/エントリー/スピンボタンでリターンが押された */
static void
add_dialog_activate (GtkWidget  *widget,
                     gpointer    user_data)
{
  if (GTK_WIDGET_IS_SENSITIVE (button9))
    add_dialog_clicked_ok (widget, user_data);
}


/* ja:チェックボタンが変更された */
#define add_dialog_toggled add_dialog_changed


/* ja:文字符号化方式が変更された */
#define add_dialog_edited add_dialog_changed


/* ja:コンボボックス/エントリー/スピンボタンが変更された */
static void
add_dialog_changed (GtkWidget   *widget,
                    MmaidWindow *mmaid)
{
  gboolean result;
  gchar *charset;

  charset = orz_charset_get_charset (ORZ_CHARSET (charset8));
  result = mm_list_is_valid_file (MM_LIST (mmaid->list), -1,
                                    gtk_entry_get_text (GTK_ENTRY (entry0)))
    && (charset[0] == '\0' || orz_charset_is_valid (ORZ_CHARSET (charset8)));
  g_free (charset);
  gtk_widget_set_sensitive (button9, result);
}


/* ja:ESCが押された */
static gboolean
add_dialog_key_press (GtkWidget    *widget,
                       GdkEventKey *event,
                       gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_widget_destroy (widget);
  return FALSE;
}


/*  ja:追加ダイアログ表示
    mmaid,ウインドウ情報                                                    */
void
add_dialog (MmaidWindow *mmaid)
{
  gint i, n, c, count;
  GList *glist1 = NULL, *glist2 = NULL, *glist3 = NULL;
  GList *glist5 = NULL, *glist7 = NULL;
  GtkWidget *button0, *button10, *table, *hbox, *vbox;
  const ID3Tag *id3tag;

  /* ja:メインウインドウ */
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Add"));
  g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                    G_CALLBACK (add_dialog_key_press), NULL);
  g_signal_connect (G_OBJECT (dialog), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  /* ja:ボタン */
  button0  = gtk_button_new_with_mnemonic (_("_Browse..."));
  button9  = gtk_button_new_with_label (_("OK"));
  button10 = gtk_button_new_with_label (_("Cancel"));
  g_signal_connect (G_OBJECT (button0), "clicked",
                        G_CALLBACK (add_dialog_clicked_browse), NULL);
  g_signal_connect (G_OBJECT (button9), "clicked",
                        G_CALLBACK (add_dialog_clicked_ok), mmaid);
  g_signal_connect_swapped (G_OBJECT (button10), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
  GTK_WIDGET_SET_FLAGS (button0,  GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button9,  GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button10, GTK_CAN_DEFAULT);
  /* ja:コンボボックス(準備) */
  count = mm_list_length (MM_LIST (mmaid->list));
  for (i = 0; i < count; i++)
    {
      id3tag = mm_list_get_nth (MM_LIST (mmaid->list), i);
      if (id3tag->title   && !g_list_find_custom (glist1, id3tag->title,
                                                        (GCompareFunc)strcmp))
        glist1 = g_list_insert_sorted (glist1, g_strdup (id3tag->title),
                                                        (GCompareFunc)strcmp);
      if (id3tag->artist  && !g_list_find_custom (glist2, id3tag->artist,
                                                        (GCompareFunc)strcmp))
        glist2 = g_list_insert_sorted (glist2, g_strdup (id3tag->artist),
                                                        (GCompareFunc)strcmp);
      if (id3tag->album   && !g_list_find_custom (glist3, id3tag->album,
                                                        (GCompareFunc)strcmp))
        glist3 = g_list_insert_sorted (glist3, g_strdup (id3tag->album),
                                                        (GCompareFunc)strcmp);
      if (id3tag->comment && !g_list_find_custom (glist5, id3tag->comment,
                                                        (GCompareFunc)strcmp))
        glist5 = g_list_insert_sorted (glist5, g_strdup (id3tag->comment),
                                                        (GCompareFunc)strcmp);
    }
  for (i = 0; i < 256; i++)
    if (genre[0][i] && !g_list_find_custom (glist7, genre[0][i],
                                                        (GCompareFunc)strcmp))
      glist7 = g_list_append (glist7, g_strdup (genre[0][i]));
  /* ja:コンボボックス */
#if GTK_CHECK_VERSION(2,4,0)
  combo1 = gtk_combo_box_entry_new_text ();
  combo2 = gtk_combo_box_entry_new_text ();
  combo3 = gtk_combo_box_entry_new_text ();
  combo5 = gtk_combo_box_entry_new_text ();
  combo7 = gtk_combo_box_entry_new_text ();
  for (i = g_list_length (glist1) - 1; i >= 0; i--)
    gtk_combo_box_prepend_text (GTK_COMBO_BOX (combo1),
                                                g_list_nth_data (glist1, i));
  for (i = g_list_length (glist2) - 1; i >= 0; i--)
    gtk_combo_box_prepend_text (GTK_COMBO_BOX (combo2),
                                                g_list_nth_data (glist2, i));
  for (i = g_list_length (glist3) - 1; i >= 0; i--)
    gtk_combo_box_prepend_text (GTK_COMBO_BOX (combo3),
                                                g_list_nth_data (glist3, i));
  for (i = g_list_length (glist5) - 1; i >= 0; i--)
    gtk_combo_box_prepend_text (GTK_COMBO_BOX (combo5),
                                                g_list_nth_data (glist5, i));
  for (i = g_list_length (glist7) - 1; i >= 0; i--)
    gtk_combo_box_prepend_text (GTK_COMBO_BOX (combo7),
                                                g_list_nth_data (glist7, i));
#else /* not GTK_CHECK_VERSION(2,4,0) */
  combo1 = gtk_combo_new ();
  combo2 = gtk_combo_new ();
  combo3 = gtk_combo_new ();
  combo5 = gtk_combo_new ();
  combo7 = gtk_combo_new ();
  if (glist1)
    gtk_combo_set_popdown_strings (GTK_COMBO (combo1), glist1);
  if (glist2)
    gtk_combo_set_popdown_strings (GTK_COMBO (combo2), glist2);
  if (glist3)
    gtk_combo_set_popdown_strings (GTK_COMBO (combo3), glist3);
  if (glist5)
    gtk_combo_set_popdown_strings (GTK_COMBO (combo5), glist5);
  if (glist7)
    gtk_combo_set_popdown_strings (GTK_COMBO (combo7), glist7);
  gtk_combo_set_value_in_list (GTK_COMBO (combo1), FALSE, FALSE);
  gtk_combo_set_value_in_list (GTK_COMBO (combo2), FALSE, FALSE);
  gtk_combo_set_value_in_list (GTK_COMBO (combo3), FALSE, FALSE);
  gtk_combo_set_value_in_list (GTK_COMBO (combo5), FALSE, FALSE);
  gtk_combo_set_value_in_list (GTK_COMBO (combo7), FALSE, FALSE);
  gtk_combo_set_case_sensitive (GTK_COMBO (combo1), TRUE);
  gtk_combo_set_case_sensitive (GTK_COMBO (combo2), TRUE);
  gtk_combo_set_case_sensitive (GTK_COMBO (combo3), TRUE);
  gtk_combo_set_case_sensitive (GTK_COMBO (combo5), TRUE);
  gtk_combo_set_case_sensitive (GTK_COMBO (combo7), TRUE);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  mm_list_get_cursor (MM_LIST (mmaid->list), &n, &c);
  id3tag = n >= 0 ? mm_list_get_nth (MM_LIST (mmaid->list), n) : NULL;
#if GTK_CHECK_VERSION(2,4,0)
  gtk_entry_set_text (GTK_ENTRY (GTK_BIN (combo1)->child),
                            id3tag && id3tag->title ? id3tag->title : "");
  gtk_entry_set_text (GTK_ENTRY (GTK_BIN (combo2)->child),
                            id3tag && id3tag->artist ? id3tag->artist : "");
  gtk_entry_set_text (GTK_ENTRY (GTK_BIN (combo3)->child),
                            id3tag && id3tag->album ? id3tag->album : "");
  gtk_entry_set_text (GTK_ENTRY (GTK_BIN (combo5)->child),
                            id3tag && id3tag->comment ? id3tag->comment : "");
  gtk_entry_set_text (GTK_ENTRY (GTK_BIN (combo7)->child),
                            id3tag && id3tag->genre ? id3tag->genre : "");
  g_signal_connect (G_OBJECT (GTK_BIN (combo1)->child), "activate",
                                    G_CALLBACK (add_dialog_activate), mmaid);
  g_signal_connect (G_OBJECT (GTK_BIN (combo2)->child), "activate",
                                    G_CALLBACK (add_dialog_activate), mmaid);
  g_signal_connect (G_OBJECT (GTK_BIN (combo3)->child), "activate",
                                    G_CALLBACK (add_dialog_activate), mmaid);
  g_signal_connect (G_OBJECT (GTK_BIN (combo5)->child), "activate",
                                    G_CALLBACK (add_dialog_activate), mmaid);
  g_signal_connect (G_OBJECT (GTK_BIN (combo7)->child), "activate",
                                    G_CALLBACK (add_dialog_activate), mmaid);
  g_signal_connect (G_OBJECT (GTK_BIN (combo1)->child), "changed",
                                    G_CALLBACK (add_dialog_changed), mmaid);
  g_signal_connect (G_OBJECT (GTK_BIN (combo2)->child), "changed",
                                    G_CALLBACK (add_dialog_changed), mmaid);
  g_signal_connect (G_OBJECT (GTK_BIN (combo3)->child), "changed",
                                    G_CALLBACK (add_dialog_changed), mmaid);
  g_signal_connect (G_OBJECT (GTK_BIN (combo5)->child), "changed",
                                    G_CALLBACK (add_dialog_changed), mmaid);
  g_signal_connect (G_OBJECT (GTK_BIN (combo7)->child), "changed",
                                    G_CALLBACK (add_dialog_changed), mmaid);
#else /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo1)->entry),
                            id3tag && id3tag->title ? id3tag->title : "");
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo2)->entry),
                            id3tag && id3tag->artist ? id3tag->artist : "");
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo3)->entry),
                            id3tag && id3tag->album ? id3tag->album : "");
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo5)->entry),
                            id3tag && id3tag->comment ? id3tag->comment : "");
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo7)->entry),
                            id3tag && id3tag->genre ? id3tag->genre : "");
  g_signal_connect (G_OBJECT (GTK_COMBO (combo1)->entry), "activate",
                                    G_CALLBACK (add_dialog_activate), mmaid);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo2)->entry), "activate",
                                    G_CALLBACK (add_dialog_activate), mmaid);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo3)->entry), "activate",
                                    G_CALLBACK (add_dialog_activate), mmaid);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo5)->entry), "activate",
                                    G_CALLBACK (add_dialog_activate), mmaid);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo7)->entry), "activate",
                                    G_CALLBACK (add_dialog_activate), mmaid);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo1)->entry), "changed",
                                    G_CALLBACK (add_dialog_changed), mmaid);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo2)->entry), "changed",
                                    G_CALLBACK (add_dialog_changed), mmaid);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo3)->entry), "changed",
                                    G_CALLBACK (add_dialog_changed), mmaid);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo5)->entry), "changed",
                                    G_CALLBACK (add_dialog_changed), mmaid);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo7)->entry), "changed",
                                    G_CALLBACK (add_dialog_changed), mmaid);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  for (i = g_list_length (glist1) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist1, i));
  for (i = g_list_length (glist2) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist2, i));
  for (i = g_list_length (glist3) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist3, i));
  for (i = g_list_length (glist5) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist5, i));
  for (i = g_list_length (glist7) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist7, i));
  g_list_free (glist1);
  g_list_free (glist2);
  g_list_free (glist3);
  g_list_free (glist5);
  g_list_free (glist7);
  /* ja:文字符号化方式 */
  charset8 = orz_charset_new ();
  orz_charset_add_candidate (ORZ_CHARSET (charset8), charset_list);
  orz_charset_set_charset (ORZ_CHARSET (charset8),
                            id3tag && id3tag->charset ? id3tag->charset : "");
  g_signal_connect (G_OBJECT (charset8), "activate",
                                    G_CALLBACK (add_dialog_activate), mmaid);
  g_signal_connect (G_OBJECT (charset8), "edited",
                                    G_CALLBACK (add_dialog_edited), mmaid);
  /* ja:エントリー */
  entry0 = gtk_entry_new ();
  entry4 = gtk_entry_new ();
  if (id3tag)
    {
      if (id3tag->file)
        gtk_entry_set_text (GTK_ENTRY (entry0), id3tag->file);
      if (id3tag->year)
        gtk_entry_set_text (GTK_ENTRY (entry4), id3tag->year);
    }
  g_signal_connect (G_OBJECT (entry0), "activate",
                                    G_CALLBACK (add_dialog_activate), mmaid);
  g_signal_connect (G_OBJECT (entry4), "activate",
                                    G_CALLBACK (add_dialog_activate), mmaid);
  g_signal_connect (G_OBJECT (entry0), "changed",
                                    G_CALLBACK (add_dialog_changed), mmaid);
  g_signal_connect (G_OBJECT (entry4), "changed",
                                    G_CALLBACK (add_dialog_changed), mmaid);
  /* ja:チェックボタン */
  check = gtk_check_button_new_with_mnemonic (_("T_rack"));
  if (id3tag)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check),
                                0 <= id3tag->track && id3tag->track <= 255);
  g_signal_connect (G_OBJECT (check), "toggled",
        G_CALLBACK (add_dialog_toggled), gtk_bin_get_child (GTK_BIN (check)));
  /* ja:スピンボタン */
  spin = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
     (id3tag && 0 <= id3tag->track && id3tag->track <= 255 ? id3tag->track : 0,
                                                    0, 255, 1, 5, 0)), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin), TRUE);
  g_signal_connect (G_OBJECT (spin), "activate",
                                    G_CALLBACK (add_dialog_activate), mmaid);
  g_signal_connect (G_OBJECT (spin), "changed",
        G_CALLBACK (add_dialog_changed), gtk_bin_get_child (GTK_BIN (check)));
  /* ja:ラベル */
  label0 = gtk_label_new_with_mnemonic (_("_File"));
  label1 = gtk_label_new_with_mnemonic (_("_Title"));
  label2 = gtk_label_new_with_mnemonic (_("_Artist"));
  label3 = gtk_label_new_with_mnemonic (_("A_lbum"));
  label4 = gtk_label_new_with_mnemonic (_("_Year"));
  label5 = gtk_label_new_with_mnemonic (_("_Comment"));
  label7 = gtk_label_new_with_mnemonic (_("_Genre"));
  label8 = gtk_label_new_with_mnemonic (_("Character _Encoding"));
  gtk_label_set_mnemonic_widget (GTK_LABEL (label0), entry0);
#if GTK_CHECK_VERSION(2,4,0)
  gtk_label_set_mnemonic_widget (GTK_LABEL (label1), GTK_BIN (combo1)->child);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label2), GTK_BIN (combo2)->child);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label3), GTK_BIN (combo3)->child);
#else /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_label_set_mnemonic_widget (GTK_LABEL (label1),
                                                    GTK_COMBO (combo1)->entry);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label2),
                                                    GTK_COMBO (combo2)->entry);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label3),
                                                    GTK_COMBO (combo3)->entry);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_label_set_mnemonic_widget (GTK_LABEL (label4), entry4);
#if GTK_CHECK_VERSION(2,4,0)
  gtk_label_set_mnemonic_widget (GTK_LABEL (label5), GTK_BIN (combo5)->child);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label7), GTK_BIN (combo7)->child);
#else /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_label_set_mnemonic_widget (GTK_LABEL (label5),
                                                    GTK_COMBO (combo5)->entry);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label7),
                                                    GTK_COMBO (combo7)->entry);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_label_set_mnemonic_widget (GTK_LABEL (label8), charset8);
  /* ja:フレームとボックス */
  table = gtk_table_new (7, 4, FALSE);
  gtk_table_set_row_spacings (GTK_TABLE (table), SPACING);
  gtk_table_set_col_spacings (GTK_TABLE (table), SPACING);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), label0, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 0, 1,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox), entry0, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), button0, FALSE, FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), hbox,   1, 4, 0, 1);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), label1, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 1, 2,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), combo1, 1, 4, 1, 2);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), label2, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 2, 3,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), combo2, 1, 4, 2, 3);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), label3, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 3, 4,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), combo3, 1, 4, 3, 4);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), label5, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 4, 5,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), combo5, 1, 4, 4, 5);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), label4, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 5, 6,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), entry4, 1, 2, 5, 6);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), check, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 2, 3, 5, 6,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), spin,   3, 4, 5, 6);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), label7, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 6, 7,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), combo7, 1, 2, 6, 7);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), label8, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 2, 3, 6, 7,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), charset8, 3, 4, 6, 7);
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_end (GTK_BOX (hbox), button10, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), button9, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);

  /* ja:表示 */
  gtk_widget_set_sensitive (button9, FALSE);
  switch (c)
    {
      case MM_LIST_FILE:
        gtk_widget_grab_focus (entry0);                    break;
      case MM_LIST_TITLE:
#if GTK_CHECK_VERSION(2,4,0)
        gtk_widget_grab_focus (GTK_BIN (combo1)->child);   break;
      case MM_LIST_ARTIST:
        gtk_widget_grab_focus (GTK_BIN (combo2)->child);   break;
      case MM_LIST_ALBUM:
        gtk_widget_grab_focus (GTK_BIN (combo3)->child);   break;
#else /* not GTK_CHECK_VERSION(2,4,0) */
        gtk_widget_grab_focus (GTK_COMBO (combo1)->entry); break;
      case MM_LIST_ARTIST:
        gtk_widget_grab_focus (GTK_COMBO (combo2)->entry); break;
      case MM_LIST_ALBUM:
        gtk_widget_grab_focus (GTK_COMBO (combo3)->entry); break;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      case MM_LIST_YEAR:
        gtk_widget_grab_focus (entry4);                    break;
      case MM_LIST_COMMENT:
#if GTK_CHECK_VERSION(2,4,0)
        gtk_widget_grab_focus (GTK_BIN (combo5)->child);   break;
      case MM_LIST_TRACK:
        gtk_widget_grab_focus (check);                     break;
      case MM_LIST_GENRE:
        gtk_widget_grab_focus (GTK_BIN (combo7)->child);   break;
#else /* not GTK_CHECK_VERSION(2,4,0) */
        gtk_widget_grab_focus (GTK_COMBO (combo5)->entry); break;
      case MM_LIST_TRACK:
        gtk_widget_grab_focus (check);                     break;
      case MM_LIST_GENRE:
        gtk_widget_grab_focus (GTK_COMBO (combo7)->entry); break;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      case MM_LIST_CHARSET:
        gtk_widget_grab_focus (charset8);                  break;
      default:
        gtk_widget_grab_focus (button10);
    }

  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
  gtk_grab_add (dialog);
  gtk_widget_show_all (dialog);
  gtk_main ();
}
