/*
    Profile
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __PROFILE_H__
#define __PROFILE_H__


#include "common.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define PROFILE_DATA_TYPE_UNKNOW 0
#define PROFILE_DATA_TYPE_SPACE 1
#define PROFILE_DATA_TYPE_COMMENT 2
#define PROFILE_DATA_TYPE_SECTION 3
#define PROFILE_DATA_TYPE_KEY 4
#define PROFILE_VALUE_TYPE_BOOL 0
#define PROFILE_VALUE_TYPE_INT 1
#define PROFILE_VALUE_TYPE_STRING 2
#define PROFILE_VALUE_TYPE_ARRAY 3


typedef struct _Profile Profile;


/******************************************************************************
*                                                                             *
* ja:初期化ファイル関数群                                                     *
*                                                                             *
******************************************************************************/
/*  ja:初期化ファイルを開く
    file,ファイル名
     RET,プロファイル                                                       */
Profile *
profile_open (const gchar *file);


/*  ja:初期化ファイルを閉じる
    profile,プロファイル
        RET,TRUE:正常終了,FALSE:エラー                                      */
gboolean
profile_close (Profile *profile);


/*  ja:初期化ファイルから文字列を取得する
    profile,プロファイル
    section,セクション
        key,キー
        RET,文字列,NULL:エラー                                              */
gchar *profile_get_string (Profile     *profile,
                           const gchar *section,
                           const gchar *key);


/*  ja:初期化ファイルから値のサイズ取得する
    profile,プロファイル
    section,セクション
        key,キー
       type,タイプ
        RET,バイト数,0:エラー                                               */
gint
profile_get_size (Profile     *profile,
                  const gchar *section,
                  const gchar *key,
                  const guint  type);


/*  ja:初期化ファイルから値を取得する
    profile,プロファイル
    section,セクション
        key,キー
      value,値を入れるバッファ
       size,値を入れるバッファのサイズ
       type,タイプ
        RET,TRUE:正常終了,FALSE:エラー                                      */
gboolean
profile_get_value (Profile     *profile,
                   const gchar *section,
                   const gchar *key,
                   gpointer     value,
                   const gint   size,
                   const guint  type);


/*  ja:初期化ファイルに値を設定する
    profile,プロファイル
    section,セクション
        key,キー
      value,値が入っているバッファ
       size,値が入っているバッファのサイズ
       type,タイプ
        RET,TRUE:正常終了,FALSE:エラー                                      */
gboolean
profile_set_value (Profile       *profile,
                   const gchar   *section,
                   const gchar   *key,
                   gconstpointer  value,
                   const gint     size,
                   const guint    type);


/*  ja:初期化ファイルのセクションを削除する
    profile,プロファイル
    section,セクション
        RET,TRUE:正常終了,FALSE:エラー                                      */
gboolean
profile_delete_section (Profile     *profile,
                        const gchar *section);


/*  ja:初期化ファイルのキーを削除する
    profile,プロファイル
    section,セクション
        key,キー
        RET,TRUE:正常終了,FALSE:エラー                                      */
gboolean
profile_delete_key (Profile     *profile,
                    const gchar *section,
                    const gchar *key);


/*  ja:初期化ファイルのセクションを列挙する
    profile,プロファイル
        RET,セクションのリスト,NULL:エラー                                  */
GList *
profile_enum_section (Profile *profile);


/*  ja:初期化ファイルのキーを列挙する
    profile,プロファイル
    section,セクション
        RET,セクションのリスト,NULL:エラー                                  */
GList *
profile_enum_key (Profile     *profile,
                  const gchar *section);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __PROFILE_H__ */
