/*
    Melody maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "process.h"


/******************************************************************************
*                                                                             *
* ja:子プロセス起動ダイアログ関数群                                           *
*                                                                             *
******************************************************************************/
GtkWidget *button0, *entry0, *entry1;


/* ja:OKボタンが押された */
static void
process_dialog_clicked (GtkWidget *widget,
                        GtkWidget *dialog)
{
  const gchar *str0, *str1;

  g_free (cmd_play);
  g_free (cmd_stop);
  str0 = gtk_entry_get_text (GTK_ENTRY (entry0));
  str1 = gtk_entry_get_text (GTK_ENTRY (entry1));
  cmd_play = str0 && str0[0] != '\0' ? g_strdup (str0) : NULL;
  cmd_stop = str1 && str1[0] != '\0' ? g_strdup (str1) : NULL;
  gtk_widget_destroy (dialog);
}


/* ja:エントリーでリターンが押された */
static void
process_dialog_activate (GtkWidget *widget,
                         gpointer   user_data)
{
  if (GTK_WIDGET_IS_SENSITIVE (button0))
    process_dialog_clicked (widget, user_data);
}


/* ja:エントリーが変更された */
static void
process_dialog_changed (GtkWidget *widget,
                        gpointer   user_data)
{
  gtk_widget_set_sensitive (button0, TRUE);
}


/* ja:ESCが押された */
static gboolean
process_dialog_key_press (GtkWidget   *widget,
                          GdkEventKey *event,
                          gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_widget_destroy (widget);
  return FALSE;
}


/*  ja:子プロセス起動ダイアログ表示                                         */
void
process_dialog (void)
{
  GtkWidget *dialog, *button1, *label0, *label1, *hbox, *vbox;

  /* ja:メインウインドウ */
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Process"));
  g_signal_connect_after (G_OBJECT(dialog), "key-press-event",
                                G_CALLBACK (process_dialog_key_press), NULL);
  g_signal_connect (G_OBJECT (dialog), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  /* ja:ボタン */
  button0 = gtk_button_new_with_label (_("OK"));
  button1 = gtk_button_new_with_label (_("Cancel"));
  g_signal_connect (G_OBJECT (button0), "clicked",
                                G_CALLBACK (process_dialog_clicked), dialog);
  g_signal_connect_swapped (G_OBJECT (button1), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
  GTK_WIDGET_SET_FLAGS (button0, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
  /* ja:エントリー */
  entry0 = gtk_entry_new_with_max_length (256);
  entry1 = gtk_entry_new_with_max_length (256);
  if (cmd_play)
    gtk_entry_set_text (GTK_ENTRY (entry0), cmd_play);
  if (cmd_stop)
    gtk_entry_set_text (GTK_ENTRY (entry1), cmd_stop);
  g_signal_connect (G_OBJECT (entry0), "changed",
                                G_CALLBACK (process_dialog_changed), NULL);
  g_signal_connect (G_OBJECT (entry1), "changed",
                                G_CALLBACK (process_dialog_changed), NULL);
  g_signal_connect (G_OBJECT (entry0), "activate",
                                G_CALLBACK (process_dialog_activate), dialog);
  g_signal_connect (G_OBJECT (entry1), "activate",
                                G_CALLBACK (process_dialog_activate), dialog);
  /* ja:ラベル */
  label0 = gtk_label_new_with_mnemonic (_("_Play"));
  label1 = gtk_label_new_with_mnemonic (_("_Stop"));
  gtk_label_set_mnemonic_widget (GTK_LABEL (label0), entry0);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label1), entry1);
  /* ja:フレームとボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), label0, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), entry0, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), label1, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), entry1, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_end (GTK_BOX (hbox), button1, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), button0, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);

  /* ja:表示 */
  gtk_widget_set_sensitive (button0, FALSE);
  gtk_widget_grab_focus (button1);

  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
  gtk_grab_add (dialog);
  gtk_widget_show_all (dialog);
  gtk_main ();
}
