/*
    Argument
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "argument.h"
#include "misc.h"


/******************************************************************************
*                                                                             *
* ja:引数解析関数群                                                           *
*                                                                             *
******************************************************************************/
/*  ja:引数を解析する
        argv,引数
    arg_opts,オプション
         RET,ファイル配列                                                   */
gboolean *
arg_analyse (gchar              **argv,
             const ArgumentList  *arg_opts)
{
  gboolean *arg_files;
  gint i;

  for (i = 1; argv[i]; i++);
  arg_files = g_malloc0 (i * sizeof (gboolean));
  i = 1;
  while (argv[i])
    {
      const gchar *str, *val = NULL;
      gint j;
      const ArgumentList *arg = NULL;

      /* ja:先頭の1つ以上の-を取り除く */
      for (str = argv[i]; *str == '-'; str++);
      if (str != argv[i])
        for (j = 0; arg_opts[j].name; j++)
          {
            gsize leng;

            /* ja:長いオプション */
            leng = g_strlen (arg_opts[j].name);
            if (g_strncasecmp (arg_opts[j].name, str, leng) == 0
                                    && (str[leng] == '\0' || str[leng] == '='))
              {
                arg = arg_opts + j;
                if (str[leng] == '=')
                  val = str + leng + 1;
                break;
              }
            /* ja:短いオプション */
            if (str[0] != '\0' && (str[1] == '\0' || str[1] == '=')
                                        && g_ascii_tolower (arg_opts[j].key)
                                                == g_ascii_tolower (str[0]))
              {
                arg = arg_opts + j;
                if (str[1] == '=')
                  val = str + 2;
                break;
              }
          }
      if (arg)
        {/* ja:オプション */
          i++;
          switch (arg->type)
            {
              case ARGUMENT_TYPE_BOOL:
                {
                  ArgumentBool *arg_bool;

                  arg_bool = arg->data;
                  if (!val && argv[i] && (g_strcasecmp (argv[i], "yes") == 0
                                    || g_strcasecmp (argv[i], "no") == 0
                                    || g_strcasecmp (argv[i], "on") == 0
                                    || g_strcasecmp (argv[i], "off") == 0
                                    || g_strcasecmp (argv[i], "ok") == 0
                                    || g_strcasecmp (argv[i], "cancel") == 0
                                    || g_strcasecmp (argv[i], "true") == 0
                                    || g_strcasecmp (argv[i], "false") == 0))
                    val = argv[i++];
                  if (val && (g_strcasecmp (val, "yes") == 0
                                    || g_strcasecmp (val, "on") == 0
                                    || g_strcasecmp (val, "ok") == 0
                                    || g_strcasecmp (val, "true") == 0))
                    arg_bool->flag = TRUE;
                  else if (val && (g_strcasecmp (val, "no") == 0
                                    || g_strcasecmp (val, "off") == 0
                                    || g_strcasecmp (val, "cancel") == 0
                                    || g_strcasecmp (val, "false") == 0))
                    arg_bool->flag = FALSE;
                  else
                    arg_bool->flag = arg_bool->def;
                }
                break;
              case ARGUMENT_TYPE_VALUE:
                {
                  gint value;
                  ArgumentValue *arg_value;

                  arg_value = arg->data;
                  if (val)
                    {
                      if (misc_str_to_val (&value, val, 10, TRUE))
                        arg_value->val = value;
                    }
                  else if (argv[i])
                    {
                      if (misc_str_to_val (&value, argv[i], 10, TRUE))
                        {
                          arg_value->val = value;
                          i++;
                        }
                    }
                  else
                    {
                      arg_value->val = arg_value->def;
                    }
                }
                break;
              case ARGUMENT_TYPE_ARRAY:
                {
                  gsize size;
                  gint *array = NULL;
                  ArgumentArray *arg_array;

                  arg_array = arg->data;
                  if (val)
                    {
                      array = misc_str_to_array (&size, 0, val, 10, TRUE);
                    }
                  else if (argv[i])
                    {
                      array = misc_str_to_array (&size, 0, argv[i], 10, TRUE);
                      if (array)
                        i++;
                    }
                  if (array)
                    {
                      g_memmove (arg_array->array, array,
                                                        size * sizeof (gint));
                      g_free (array);
                    }
                  else if (arg_array->def)
                    {
                      g_memmove (arg_array->array, arg_array->def,
                                            arg_array->leng * sizeof (gint));
                    }
                }
                break;
              case ARGUMENT_TYPE_STRING:
                {
                  ArgumentString *arg_string;

                  arg_string = arg->data;
                  if (!val && argv[i])
                    val = argv[++i];
                  g_free (arg_string->str);
                  arg_string->str = val ? g_strdup (val) : arg_string->def
                                        ? g_strdup (arg_string->def) : NULL;
                }
                break;
              case ARGUMENT_TYPE_EXIT:
                {
                  ArgumentExit *arg_exit;

                  arg_exit = arg->data;
                  g_free (arg_files);
                  if (arg_exit->str)
                    g_print (arg_exit->str);
                  gtk_exit (0);
                }
                break;
              case ARGUMENT_TYPE_HELP:
                {
                  gboolean keys = FALSE;
                  gsize leng = 0;
                  gchar *format;
                  ArgumentHelp *arg_help;

                  arg_help = arg->data;
                  g_free (arg_files);
                  g_print("%sUsage: %s [OPTION...] [FILE...]\n\n",
                                                    arg_help->str, argv[0]);
                  for (j = 0; arg_opts[j].name; j++)
                    if (arg_opts[j].key != '\0')
                      {
                        keys = TRUE;
                        break;
                      }
                  for (j = 0; arg_opts[j].name; j++)
                    {
                      gsize s;

                      s = g_strlen (arg_opts[j].name);
                      if (arg_opts[j].opt)
                        s += g_strlen (arg_opts[j].opt) + 1;
                      if (leng < s)
                        leng = s;
                    }
                  format = g_strdup_printf ("  %%s--%%-%ds %%s\n", leng);
                  for (j = 0; arg_opts[j].name; j++)
                    {
                      gchar *tmp0, *tmp1;

                      if (arg_opts[j].key != '\0')
                        tmp0 = g_strdup_printf ("-%c, ", arg_opts[j].key);
                      else if (keys)
                        tmp0 = g_strdup ("    ");
                      else
                        tmp0 = g_strdup ("");
                      tmp1 = g_strconcat (arg_opts[j].name,
                          arg_opts[j].opt ? "=" : NULL, arg_opts[j].opt, NULL);
                      g_print (format, tmp0, tmp1, _(arg_opts[j].doc));
                      g_free (tmp0);
                      g_free (tmp1);
                    }
                  g_free (format);
                  gtk_exit (0);
                }
            }
        }
      else
        {/* ja:ファイル */
          arg_files[i++] = TRUE;
        }
    }
  return arg_files;
}
