/*
    Melody maid
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "add.h"
#include "general.h"
#include "mm_list.h"
#include "misc/charuty.h"
#include "misc/fileio.h"
#include "orz/orzcharset.h"
#include "orz/orzmdi.h"


/******************************************************************************
*                                                                             *
* ja:追加ダイアログ関数群                                                     *
*                                                                             *
******************************************************************************/
typedef struct _AddDialog
{
  gboolean ok_sensitive;
  GtkWidget *dialog, *entry, *charset, *list;
} AddDialog;


/* ja:参照ボタンが押された */
static void
add_dialog_clicked (GtkWidget *widget,
                    AddDialog *adddlg)
{
  gchar *file;
  GtkWidget *dialog;

#if GTK_CHECK_VERSION(2,4,0)
  dialog = gtk_file_chooser_dialog_new (_("Browse"),
                    GTK_WINDOW (adddlg->dialog), GTK_FILE_CHOOSER_ACTION_OPEN,
                    GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                    GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
                    NULL);
  file = g_filename_from_utf8 (gtk_entry_get_text (GTK_ENTRY (adddlg->entry)),
                                                        -1, NULL, NULL, NULL);
  if (fileio_isfile (file))
    {
      gtk_file_chooser_set_filename (GTK_FILE_CHOOSER (dialog), file);
    }
  else
    {
      gchar *dir, *path;

      dir = g_path_get_dirname (file);
      path = fileio_get_full_path (dir);
      g_free (dir);
      if (fileio_isfile (path))
        gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), path);
      g_free (path);
    }
  g_free (file);
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
    {
      gchar *utf8str;

      file = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
      utf8str = g_filename_to_utf8 (file, -1, NULL, NULL, NULL);
      gtk_entry_set_text (GTK_ENTRY (adddlg->entry), utf8str);
      g_free (utf8str);
      g_free (file);
    }
#else /* not GTK_CHECK_VERSION(2,4,0) */
  dialog = gtk_file_selection_new (_("Browse"));
  file = g_filename_from_utf8 (gtk_entry_get_text (GTK_ENTRY (adddlg->entry)),
                                                        -1, NULL, NULL, NULL);
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (dialog), file);
  g_free (file);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (dialog));
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
    {
      gchar *utf8str;

      utf8str = g_filename_to_utf8 (gtk_file_selection_get_filename
                        (GTK_FILE_SELECTION (dialog), -1, NULL, NULL, NULL);
      gtk_entry_set_text (GTK_ENTRY (adddlg->entry), utf8str);
      g_free (utf8str);
    }
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_widget_destroy (dialog);
}


/* ja:コンボボックス/エントリー/スピンボタンでリターンが押された */
static void
add_dialog_activate (GtkWidget *widget,
                     AddDialog *adddlg)
{
  if (adddlg->ok_sensitive)
    gtk_dialog_response (GTK_DIALOG (adddlg->dialog), GTK_RESPONSE_OK);
}


/* ja:チェックボタンが変更された */
#define add_dialog_toggled add_dialog_changed


/* ja:文字符号化方式が変更された */
#define add_dialog_edited add_dialog_changed


/* ja:コンボボックス/エントリー/スピンボタンが変更された */
static void
add_dialog_changed (GtkWidget *widget,
                    AddDialog *adddlg)
{
  gboolean result;
  gchar *charset;

  charset = orz_charset_get_charset (ORZ_CHARSET (adddlg->charset));
  result = mm_list_is_valid_file (MM_LIST (adddlg->list), -1,
                                gtk_entry_get_text (GTK_ENTRY (adddlg->entry)))
    && (charset[0] == '\0'
                    || orz_charset_is_valid (ORZ_CHARSET (adddlg->charset)));
  g_free (charset);
  adddlg->ok_sensitive = result;
  gtk_dialog_set_response_sensitive (GTK_DIALOG (adddlg->dialog),
                                                    GTK_RESPONSE_OK, result);
}


/*  ja:追加ダイアログ表示
    mmaid,ウインドウ情報                                                    */
void
add_dialog (MmaidWindow *mmaid)
{
  gchar *title;
  gint i, n, c, count;
  GList *glist_title = NULL, *glist_artist = NULL, *glist_album = NULL;
  GList *glist_comment = NULL, *glist_genre = NULL;
  GtkStockItem stock_item;
  GtkWidget *table, *hbox, *button, *check, *entry, *spin;
  GtkWidget *combo_title, *combo_artist, *combo_album;
  GtkWidget *combo_comment, *combo_genre;
  GtkWidget *label_file, *label_title, *label_artist, *label_album;
  GtkWidget *label_comment, *label_year, *label_genre, *label_charset;
  const ID3Tag *id3tag;
  AddDialog adddlg;

  adddlg.list = mmaid->list;
  /* ja:メインウインドウ */
  gtk_stock_lookup (GTK_STOCK_ADD, &stock_item);
  title = misc_mnemonic_to_text (stock_item.label);
  adddlg.dialog = gtk_dialog_new_with_buttons
                            (title,
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
                            NULL);
  g_free (title);
  g_signal_connect (G_OBJECT (adddlg.dialog), "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);
  /* ja:ボタン */
  button = gtk_button_new_with_mnemonic (_("_Browse..."));
  g_signal_connect (G_OBJECT (button), "clicked",
                                    G_CALLBACK (add_dialog_clicked), &adddlg);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  /* ja:コンボボックス(準備) */
  count = mm_list_length (MM_LIST (mmaid->list));
  for (i = 0; i < count; i++)
    {
      id3tag = mm_list_get_nth (MM_LIST (mmaid->list), i);
      if (id3tag->title && !g_list_find_custom (glist_title, id3tag->title,
                                                        (GCompareFunc)strcmp))
        glist_title = g_list_insert_sorted (glist_title,
                            g_strdup (id3tag->title), (GCompareFunc)strcmp);
      if (id3tag->artist && !g_list_find_custom (glist_artist, id3tag->artist,
                                                        (GCompareFunc)strcmp))
        glist_artist = g_list_insert_sorted (glist_artist,
                            g_strdup (id3tag->artist), (GCompareFunc)strcmp);
      if (id3tag->album && !g_list_find_custom (glist_album, id3tag->album,
                                                        (GCompareFunc)strcmp))
        glist_album = g_list_insert_sorted (glist_album,
                            g_strdup (id3tag->album), (GCompareFunc)strcmp);
      if (id3tag->comment && !g_list_find_custom (glist_comment,
                                        id3tag->comment, (GCompareFunc)strcmp))
        glist_comment = g_list_insert_sorted (glist_comment,
                            g_strdup (id3tag->comment), (GCompareFunc)strcmp);
    }
  for (i = 0; i < 256; i++)
    if (genre[0][i] && !g_list_find_custom (glist_genre, genre[0][i],
                                                        (GCompareFunc)strcmp))
      glist_genre = g_list_append (glist_genre, g_strdup (genre[0][i]));
  /* ja:コンボボックス */
#if GTK_CHECK_VERSION(2,4,0)
  combo_title = gtk_combo_box_entry_new_text ();
  combo_artist = gtk_combo_box_entry_new_text ();
  combo_album = gtk_combo_box_entry_new_text ();
  combo_comment = gtk_combo_box_entry_new_text ();
  combo_genre = gtk_combo_box_entry_new_text ();
  for (i = g_list_length (glist_title) - 1; i >= 0; i--)
    gtk_combo_box_prepend_text (GTK_COMBO_BOX (combo_title),
                                        g_list_nth_data (glist_title, i));
  for (i = g_list_length (glist_artist) - 1; i >= 0; i--)
    gtk_combo_box_prepend_text (GTK_COMBO_BOX (combo_artist),
                                        g_list_nth_data (glist_artist, i));
  for (i = g_list_length (glist_album) - 1; i >= 0; i--)
    gtk_combo_box_prepend_text (GTK_COMBO_BOX (combo_album),
                                        g_list_nth_data (glist_album, i));
  for (i = g_list_length (glist_comment) - 1; i >= 0; i--)
    gtk_combo_box_prepend_text (GTK_COMBO_BOX (combo_comment),
                                        g_list_nth_data (glist_comment, i));
  for (i = g_list_length (glist_genre) - 1; i >= 0; i--)
    gtk_combo_box_prepend_text (GTK_COMBO_BOX (combo_genre),
                                        g_list_nth_data (glist_genre, i));
#else /* not GTK_CHECK_VERSION(2,4,0) */
  combo_title = gtk_combo_new ();
  combo_artist = gtk_combo_new ();
  combo_album = gtk_combo_new ();
  combo_comment = gtk_combo_new ();
  combo_genre = gtk_combo_new ();
  if (glist_title)
    gtk_combo_set_popdown_strings (GTK_COMBO (combo_title), glist_title);
  if (glist_artist)
    gtk_combo_set_popdown_strings (GTK_COMBO (combo_artist), glist_artist);
  if (glist_album)
    gtk_combo_set_popdown_strings (GTK_COMBO (combo_album), glist_album);
  if (glist_comment)
    gtk_combo_set_popdown_strings (GTK_COMBO (combo_comment), glist_comment);
  if (glist_genre)
    gtk_combo_set_popdown_strings (GTK_COMBO (combo_genre), glist_genre);
  gtk_combo_set_value_in_list (GTK_COMBO (combo_title), FALSE, FALSE);
  gtk_combo_set_value_in_list (GTK_COMBO (combo_artist), FALSE, FALSE);
  gtk_combo_set_value_in_list (GTK_COMBO (combo_album), FALSE, FALSE);
  gtk_combo_set_value_in_list (GTK_COMBO (combo_comment), FALSE, FALSE);
  gtk_combo_set_value_in_list (GTK_COMBO (combo_genre), FALSE, FALSE);
  gtk_combo_set_case_sensitive (GTK_COMBO (combo_title), TRUE);
  gtk_combo_set_case_sensitive (GTK_COMBO (combo_artist), TRUE);
  gtk_combo_set_case_sensitive (GTK_COMBO (combo_album), TRUE);
  gtk_combo_set_case_sensitive (GTK_COMBO (combo_comment), TRUE);
  gtk_combo_set_case_sensitive (GTK_COMBO (combo_genre), TRUE);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  mm_list_get_cursor (MM_LIST (mmaid->list), &n, &c);
  id3tag = n >= 0 ? mm_list_get_nth (MM_LIST (mmaid->list), n) : NULL;
#if GTK_CHECK_VERSION(2,4,0)
  gtk_entry_set_text (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (combo_title))),
                            id3tag && id3tag->title ? id3tag->title : "");
  gtk_entry_set_text (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (combo_artist))),
                            id3tag && id3tag->artist ? id3tag->artist : "");
  gtk_entry_set_text (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (combo_album))),
                            id3tag && id3tag->album ? id3tag->album : "");
  gtk_entry_set_text (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (combo_comment))),
                            id3tag && id3tag->comment ? id3tag->comment : "");
  gtk_entry_set_text (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (combo_genre))),
                            id3tag && id3tag->genre ? id3tag->genre : "");
  g_signal_connect (G_OBJECT (gtk_bin_get_child (GTK_BIN (combo_title))),
                        "activate", G_CALLBACK (add_dialog_activate), &adddlg);
  g_signal_connect (G_OBJECT (gtk_bin_get_child (GTK_BIN (combo_artist))),
                        "activate", G_CALLBACK (add_dialog_activate), &adddlg);
  g_signal_connect (G_OBJECT (gtk_bin_get_child (GTK_BIN (combo_album))),
                        "activate", G_CALLBACK (add_dialog_activate), &adddlg);
  g_signal_connect (G_OBJECT (gtk_bin_get_child (GTK_BIN (combo_comment))),
                        "activate", G_CALLBACK (add_dialog_activate), &adddlg);
  g_signal_connect (G_OBJECT (gtk_bin_get_child (GTK_BIN (combo_genre))),
                        "activate", G_CALLBACK (add_dialog_activate), &adddlg);
  g_signal_connect (G_OBJECT (gtk_bin_get_child (GTK_BIN (combo_title))),
                        "changed", G_CALLBACK (add_dialog_changed), &adddlg);
  g_signal_connect (G_OBJECT (gtk_bin_get_child (GTK_BIN (combo_artist))),
                        "changed", G_CALLBACK (add_dialog_changed), &adddlg);
  g_signal_connect (G_OBJECT (gtk_bin_get_child (GTK_BIN (combo_album))),
                        "changed", G_CALLBACK (add_dialog_changed), &adddlg);
  g_signal_connect (G_OBJECT (gtk_bin_get_child (GTK_BIN (combo_comment))),
                        "changed", G_CALLBACK (add_dialog_changed), &adddlg);
  g_signal_connect (G_OBJECT (gtk_bin_get_child (GTK_BIN (combo_genre))),
                        "changed", G_CALLBACK (add_dialog_changed), &adddlg);
#else /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo_title)->entry),
                            id3tag && id3tag->title ? id3tag->title : "");
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo_artist)->entry),
                            id3tag && id3tag->artist ? id3tag->artist : "");
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo_album)->entry),
                            id3tag && id3tag->album ? id3tag->album : "");
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo_comment)->entry),
                            id3tag && id3tag->comment ? id3tag->comment : "");
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo_genre)->entry),
                            id3tag && id3tag->genre ? id3tag->genre : "");
  g_signal_connect (G_OBJECT (GTK_COMBO (combo_title)->entry), "activate",
                                    G_CALLBACK (add_dialog_activate), &adddlg);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo_artist)->entry), "activate",
                                    G_CALLBACK (add_dialog_activate), &adddlg);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo_album)->entry), "activate",
                                    G_CALLBACK (add_dialog_activate), &adddlg);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo_comment)->entry), "activate",
                                    G_CALLBACK (add_dialog_activate), &adddlg);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo_genre)->entry), "activate",
                                    G_CALLBACK (add_dialog_activate), &adddlg);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo_title)->entry), "changed",
                                    G_CALLBACK (add_dialog_changed), &adddlg);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo_artist)->entry), "changed",
                                    G_CALLBACK (add_dialog_changed), &adddlg);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo_album)->entry), "changed",
                                    G_CALLBACK (add_dialog_changed), &adddlg);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo_comment)->entry), "changed",
                                    G_CALLBACK (add_dialog_changed), &adddlg);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo_genre)->entry), "changed",
                                    G_CALLBACK (add_dialog_changed), &adddlg);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  for (i = g_list_length (glist_title) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist_title, i));
  for (i = g_list_length (glist_artist) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist_artist, i));
  for (i = g_list_length (glist_album) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist_album, i));
  for (i = g_list_length (glist_comment) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist_comment, i));
  for (i = g_list_length (glist_genre) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist_genre, i));
  g_list_free (glist_title);
  g_list_free (glist_artist);
  g_list_free (glist_album);
  g_list_free (glist_comment);
  g_list_free (glist_genre);
  /* ja:文字符号化方式 */
  adddlg.charset = orz_charset_new ();
  orz_charset_add_candidate (ORZ_CHARSET (adddlg.charset), charset_list);
  orz_charset_set_charset (ORZ_CHARSET (adddlg.charset),
                            id3tag && id3tag->charset ? id3tag->charset : "");
  g_signal_connect (G_OBJECT (adddlg.charset), "activate",
                                    G_CALLBACK (add_dialog_activate), &adddlg);
  g_signal_connect (G_OBJECT (adddlg.charset), "edited",
                                    G_CALLBACK (add_dialog_edited), &adddlg);
  /* ja:エントリー */
  adddlg.entry = gtk_entry_new ();
  entry = gtk_entry_new ();
  if (id3tag)
    {
      if (id3tag->file)
        gtk_entry_set_text (GTK_ENTRY (adddlg.entry), id3tag->file);
      if (id3tag->year)
        gtk_entry_set_text (GTK_ENTRY (entry), id3tag->year);
    }
  g_signal_connect (G_OBJECT (adddlg.entry), "activate",
                                    G_CALLBACK (add_dialog_activate), &adddlg);
  g_signal_connect (G_OBJECT (entry), "activate",
                                    G_CALLBACK (add_dialog_activate), &adddlg);
  g_signal_connect (G_OBJECT (adddlg.entry), "changed",
                                    G_CALLBACK (add_dialog_changed), &adddlg);
  g_signal_connect (G_OBJECT (entry), "changed",
                                    G_CALLBACK (add_dialog_changed), &adddlg);
  /* ja:チェックボタン */
  check = gtk_check_button_new_with_mnemonic (_("T_rack"));
  if (id3tag)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check),
                                0 <= id3tag->track && id3tag->track <= 255);
  g_signal_connect (G_OBJECT (check), "toggled",
                                    G_CALLBACK (add_dialog_toggled), &adddlg);
  /* ja:スピンボタン */
  spin = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
     (id3tag && 0 <= id3tag->track && id3tag->track <= 255 ? id3tag->track : 0,
                                                    0, 255, 1, 5, 0)), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin), TRUE);
  g_signal_connect (G_OBJECT (spin), "activate",
                                    G_CALLBACK (add_dialog_activate), &adddlg);
  g_signal_connect (G_OBJECT (spin), "changed",
                                    G_CALLBACK (add_dialog_changed), &adddlg);
  /* ja:ラベル */
  label_file = gtk_label_new_with_mnemonic (_("_File"));
  label_title = gtk_label_new_with_mnemonic (_("_Title"));
  label_artist = gtk_label_new_with_mnemonic (_("_Artist"));
  label_album = gtk_label_new_with_mnemonic (_("A_lbum"));
  label_year = gtk_label_new_with_mnemonic (_("_Year"));
  label_comment = gtk_label_new_with_mnemonic (_("_Comment"));
  label_genre = gtk_label_new_with_mnemonic (_("_Genre"));
  label_charset = gtk_label_new_with_mnemonic (_("Character _Encoding"));
  gtk_label_set_mnemonic_widget (GTK_LABEL (label_file), adddlg.entry);
#if GTK_CHECK_VERSION(2,4,0)
  gtk_label_set_mnemonic_widget (GTK_LABEL (label_title),
                                gtk_bin_get_child (GTK_BIN (combo_title)));
  gtk_label_set_mnemonic_widget (GTK_LABEL (label_artist),
                                gtk_bin_get_child (GTK_BIN (combo_artist)));
  gtk_label_set_mnemonic_widget (GTK_LABEL (label_album),
                                gtk_bin_get_child (GTK_BIN (combo_album)));
#else /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_label_set_mnemonic_widget (GTK_LABEL (label_title),
                                            GTK_COMBO (combo_title)->entry);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label_artist),
                                            GTK_COMBO (combo_artist)->entry);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label_album),
                                            GTK_COMBO (combo_album)->entry);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_label_set_mnemonic_widget (GTK_LABEL (label_year), entry);
#if GTK_CHECK_VERSION(2,4,0)
  gtk_label_set_mnemonic_widget (GTK_LABEL (label_comment),
                                gtk_bin_get_child (GTK_BIN (combo_comment)));
  gtk_label_set_mnemonic_widget (GTK_LABEL (label_genre),
                                gtk_bin_get_child (GTK_BIN (combo_genre)));
#else /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_label_set_mnemonic_widget (GTK_LABEL (label_comment),
                                            GTK_COMBO (combo_comment)->entry);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label_genre),
                                            GTK_COMBO (combo_genre)->entry);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_label_set_mnemonic_widget (GTK_LABEL (label_charset), adddlg.charset);
  /* ja:フレームとボックス */
  table = gtk_table_new (7, 4, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (table), SPACING);
  gtk_table_set_row_spacings (GTK_TABLE (table), SPACING);
  gtk_table_set_col_spacings (GTK_TABLE (table), SPACING);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), label_file, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 0, 1,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox), adddlg.entry, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), hbox,   1, 4, 0, 1);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), label_title, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 1, 2,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), combo_title, 1, 4, 1, 2);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), label_artist, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 2, 3,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), combo_artist, 1, 4, 2, 3);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), label_album, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 3, 4,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), combo_album, 1, 4, 3, 4);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), label_comment, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 4, 5,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), combo_comment, 1, 4, 4, 5);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), label_year, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 5, 6,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), entry, 1, 2, 5, 6);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), check, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 2, 3, 5, 6,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), spin,   3, 4, 5, 6);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), label_genre, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 0, 1, 6, 7,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), combo_genre, 1, 2, 6, 7);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), label_charset, FALSE, FALSE, 0);
  gtk_table_attach (GTK_TABLE (table), hbox, 2, 3, 6, 7,
                                                    GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), adddlg.charset, 3, 4, 6, 7);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (adddlg.dialog)->vbox), table);

  /* ja:表示 */
  gtk_dialog_set_response_sensitive (GTK_DIALOG (adddlg.dialog),
                                                    GTK_RESPONSE_OK, FALSE);
  switch (c)
    {
      case MM_LIST_FILE:
        gtk_widget_grab_focus (adddlg.entry); break;
      case MM_LIST_TITLE:
#if GTK_CHECK_VERSION(2,4,0)
        gtk_widget_grab_focus (gtk_bin_get_child (GTK_BIN (combo_title)));
        break;
      case MM_LIST_ARTIST:
        gtk_widget_grab_focus (gtk_bin_get_child (GTK_BIN (combo_artist)));
        break;
      case MM_LIST_ALBUM:
        gtk_widget_grab_focus (gtk_bin_get_child (GTK_BIN (combo_album)));
        break;
#else /* not GTK_CHECK_VERSION(2,4,0) */
        gtk_widget_grab_focus (GTK_COMBO (combo_title)->entry); break;
      case MM_LIST_ARTIST:
        gtk_widget_grab_focus (GTK_COMBO (combo_artist)->entry); break;
      case MM_LIST_ALBUM:
        gtk_widget_grab_focus (GTK_COMBO (combo_album)->entry); break;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      case MM_LIST_YEAR:
        gtk_widget_grab_focus (entry); break;
      case MM_LIST_COMMENT:
#if GTK_CHECK_VERSION(2,4,0)
        gtk_widget_grab_focus (gtk_bin_get_child (GTK_BIN (combo_comment)));
        break;
      case MM_LIST_TRACK:
        gtk_widget_grab_focus (check); break;
      case MM_LIST_GENRE:
        gtk_widget_grab_focus (gtk_bin_get_child (GTK_BIN (combo_genre)));
        break;
#else /* not GTK_CHECK_VERSION(2,4,0) */
        gtk_widget_grab_focus (GTK_COMBO (combo_comment)->entry); break;
      case MM_LIST_TRACK:
        gtk_widget_grab_focus (check); break;
      case MM_LIST_GENRE:
        gtk_widget_grab_focus (GTK_COMBO (combo_comment)->entry); break;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      case MM_LIST_CHARSET:
        gtk_widget_grab_focus (adddlg.charset); break;
    }
  gtk_widget_show_all (table);

  adddlg.ok_sensitive = FALSE;

  if (gtk_dialog_run (GTK_DIALOG (adddlg.dialog)) == GTK_RESPONSE_OK)
    {
      gchar *file, *tmp;

      file = g_filename_from_utf8
        (gtk_entry_get_text (GTK_ENTRY (adddlg.entry)), -1, NULL, NULL, NULL);
      tmp = fileio_get_full_path (file);
      g_free (file);
      file = g_filename_to_utf8 (tmp, -1, NULL, NULL, NULL);
      g_free (tmp);
      if (file)
        {
          gchar *charset;
          const gchar *title, *artist, *album, *year, *comment, *genre;
          gint n, c;
          ID3Tag *id3tag;

          id3tag = g_malloc0 (sizeof (ID3Tag));
#if GTK_CHECK_VERSION(2,4,0)
          title   = gtk_entry_get_text
                    (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (combo_title))));
          artist  = gtk_entry_get_text
                    (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (combo_artist))));
          album   = gtk_entry_get_text
                    (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (combo_album))));
#else /* not GTK_CHECK_VERSION(2,4,0) */
          title   = gtk_entry_get_text
                                (GTK_ENTRY (GTK_COMBO (combo_title)->entry));
          artist  = gtk_entry_get_text
                                (GTK_ENTRY (GTK_COMBO (combo_artist)->entry));
          album   = gtk_entry_get_text
                                (GTK_ENTRY (GTK_COMBO (combo_album)->entry));
#endif /* not GTK_CHECK_VERSION(2,4,0) */
          year    = gtk_entry_get_text (GTK_ENTRY (entry));
#if GTK_CHECK_VERSION(2,4,0)
          comment = gtk_entry_get_text
                    (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (combo_comment))));
#else /* not GTK_CHECK_VERSION(2,4,0) */
          comment = gtk_entry_get_text
                                (GTK_ENTRY (GTK_COMBO (combo_comment)->entry));
#endif /* not GTK_CHECK_VERSION(2,4,0) */
          id3tag->track
                    = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check))
              ? gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin)) : -1;
#if GTK_CHECK_VERSION(2,4,0)
          genre   = gtk_entry_get_text
                    (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (combo_genre))));
#else /* not GTK_CHECK_VERSION(2,4,0) */
          genre   = gtk_entry_get_text
                    (GTK_ENTRY (gtk_bin_get_child (GTK_COMBO (combo_genre))));
#endif /* not GTK_CHECK_VERSION(2,4,0) */
          charset = orz_charset_get_charset (ORZ_CHARSET (adddlg.charset));
          if (file && file[0] != '\0')
            id3tag->file = g_strdup (file);
          if (title[0] != '\0')
            id3tag->title = g_strdup (title);
          if (artist[0] != '\0')
            id3tag->artist = g_strdup (artist);
          if (album[0] != '\0')
            id3tag->album = g_strdup (album);
          if (year[0] != '\0')
            id3tag->year = g_strdup (year);
          if (comment[0] != '\0')
            id3tag->comment = g_strdup (comment);
          if (genre[0] != '\0')
            id3tag->genre = g_strdup (genre);
          if (orz_charset_is_valid (ORZ_CHARSET (adddlg.charset)))
            id3tag->charset = charset;
          else
            g_free (charset);
          mm_list_get_cursor (MM_LIST (mmaid->list), &n, &c);
                n = n >= 0 ? mm_list_insert (MM_LIST (mmaid->list), n, id3tag)
                           : mm_list_append (MM_LIST (mmaid->list), id3tag);
          mm_list_set_cursor (MM_LIST (mmaid->list), n, c);
          mm_list_unselect_all (MM_LIST (mmaid->list));
          mm_list_select (MM_LIST (mmaid->list), n);
          if (orz_charset_is_valid (ORZ_CHARSET (adddlg.charset)))
            charlist_renewal_all (charset);
          orz_mdi_set_edited (ORZ_MDI (mdi),
                    orz_mdi_get_page_from_data (ORZ_MDI (mdi), mmaid), TRUE);
          g_free (file);
        }
    }
  gtk_widget_destroy (adddlg.dialog);
}
