/*
    Melody maid
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "mm_list.h"
#include "mm_dialog.h"
#include <gdk/gdkkeysyms.h>


static void mm_dialog_class_init (MmDialogClass *klass);
static void mm_dialog_init       (MmDialog      *dialog);
static void mm_dialog_escape     (MmDialog      *dialog);


static GtkDialogClass *parent_class = NULL;


enum
{
  ESCAPE_SIGNAL,
  LAST_SIGNAL
};


static gint mm_dialog_signals[LAST_SIGNAL] = {0};


/******************************************************************************
*                                                                             *
******************************************************************************/
GtkType
mm_dialog_get_type (void)
{
  static GType type = 0;

  if (!type)
    {
      const static GTypeInfo info =
      {
        sizeof (MmDialogClass),
        NULL,               /* base_init */
        NULL,               /* base_finalize */
        (GClassInitFunc)mm_dialog_class_init,
        NULL,               /* class_finalize */
        NULL,               /* class_data */
        sizeof (MmDialog),
        0,              /* n_preallocs */
        (GInstanceInitFunc)mm_dialog_init,
      };

      type = g_type_register_static (GTK_TYPE_DIALOG, "MmDialog", &info, 0);
    }

  return type;
}


static void
mm_dialog_class_init (MmDialogClass *klass)
{
  GObjectClass *gobject_class;
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;
  GtkBindingSet *binding_set;

  gobject_class = (GObjectClass*) klass;
  object_class = (GtkObjectClass*) klass;
  widget_class = (GtkWidgetClass*) klass;

  parent_class = g_type_class_peek_parent (klass);

  klass->escape = mm_dialog_escape;

  mm_dialog_signals[ESCAPE_SIGNAL]
                = g_signal_new ("escape",
                                G_TYPE_FROM_CLASS (klass),
                                G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION,
                                G_STRUCT_OFFSET (MmDialogClass, escape),
                                NULL, NULL,
                                g_cclosure_marshal_VOID__VOID,
                                G_TYPE_NONE, 0);

  binding_set = gtk_binding_set_by_class (klass);
  gtk_binding_entry_add_signal (binding_set, GDK_Escape, 0, "escape", 0);
}


static void
mm_dialog_escape (MmDialog *dialog)
{
  if (GTK_WIDGET_VISIBLE (dialog->abort_button)
                            && GTK_WIDGET_SENSITIVE (dialog->abort_button))
    g_signal_emit_by_name (G_OBJECT (dialog->abort_button), "clicked");
  else if (GTK_WIDGET_VISIBLE (dialog->cancel_button)
                            && GTK_WIDGET_SENSITIVE (dialog->cancel_button))
    g_signal_emit_by_name (G_OBJECT (dialog->cancel_button), "clicked");
  else if (GTK_WIDGET_VISIBLE (dialog->ok_button)
                            && GTK_WIDGET_SENSITIVE (dialog->ok_button))
    g_signal_emit_by_name (G_OBJECT (dialog->ok_button), "clicked");
}


/* ja:閉じるボタンが押された */
static gboolean
mm_dialog_delete (GtkWidget *widget,
                  GdkEvent  *event,
                  gpointer   user_data)
{
  if (GTK_WIDGET_VISIBLE (MM_DIALOG (widget)->abort_button)
                && GTK_WIDGET_SENSITIVE (MM_DIALOG (widget)->abort_button))
    g_signal_emit_by_name
                    (G_OBJECT (MM_DIALOG (widget)->abort_button), "clicked");
  else if (GTK_WIDGET_VISIBLE (MM_DIALOG (widget)->cancel_button)
                && GTK_WIDGET_SENSITIVE (MM_DIALOG (widget)->cancel_button))
    g_signal_emit_by_name
                    (G_OBJECT (MM_DIALOG (widget)->cancel_button), "clicked");
  else if (GTK_WIDGET_VISIBLE (MM_DIALOG (widget)->ok_button)
                && GTK_WIDGET_SENSITIVE (MM_DIALOG (widget)->ok_button))
    g_signal_emit_by_name
                    (G_OBJECT (MM_DIALOG (widget)->ok_button), "clicked");
  else
    return FALSE;
  return TRUE;
}


static void
mm_dialog_init (MmDialog *dialog)
{
  GtkWidget *scroll;

  /* ja:メインウインドウ */
  gtk_window_set_default_size (GTK_WINDOW (dialog),
                    gdk_screen_width () * 2 / 3, gdk_screen_height () * 2 / 3);
  g_signal_connect (G_OBJECT (dialog), "delete-event",
                                        G_CALLBACK (mm_dialog_delete), NULL);
  /* ja:ボタン */
  dialog->abort_button = gtk_dialog_add_button (GTK_DIALOG (dialog),
                                        GTK_STOCK_STOP, GTK_RESPONSE_REJECT);
  dialog->cancel_button = gtk_dialog_add_button (GTK_DIALOG (dialog),
                                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL);
  dialog->ok_button = gtk_dialog_add_button (GTK_DIALOG (dialog),
                                        GTK_STOCK_OK, GTK_RESPONSE_OK);
  /* ja:リスト */
  dialog->list = mm_list_new ();
  /* ja:スクロールウインドウ */
  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_add (GTK_CONTAINER (scroll), dialog->list);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_set_border_width (GTK_CONTAINER (scroll), SPACING);
  /* ja:フレームとボックス */
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), scroll);

  /* ja:表示 */
  gtk_widget_show_all (scroll);
  gtk_widget_hide (dialog->abort_button);
  gtk_widget_hide (dialog->ok_button);
  gtk_widget_hide (dialog->cancel_button);
}


/******************************************************************************
*                                                                             *
* ja:更新関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,ウィジェット                                                        */
GtkWidget*
mm_dialog_new (void)
{
  return GTK_WIDGET (g_object_new (MM_TYPE_DIALOG, NULL));
}
