/*
    Melody maid
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "process.h"


/******************************************************************************
*                                                                             *
* ja:子プロセス起動ダイアログ関数群                                           *
*                                                                             *
******************************************************************************/
GtkWidget *button0, *entry0, *entry1;


/* ja:エントリーでリターンが押された */
static void
process_dialog_activate (GtkWidget *widget,
                         GtkWidget *dialog)
{
  if (GPOINTER_TO_INT (g_object_get_data (G_OBJECT (dialog), "user_data")))
    gtk_dialog_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);
}


/* ja:エントリーが変更された */
static void
process_dialog_changed (GtkWidget *widget,
                        GtkWidget *dialog)
{
  g_object_set_data (G_OBJECT (dialog), "user_data", GINT_TO_POINTER (TRUE));
  gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog), GTK_RESPONSE_OK,
                                                                        TRUE);
}


/*  ja:子プロセス起動ダイアログ表示                                         */
void
process_dialog (void)
{
  GtkWidget *dialog, *entry0, *entry1, *label0, *label1, *hbox, *vbox;

  /* ja:メインウインドウ */
  dialog = gtk_dialog_new_with_buttons
                            (_("Process"),
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
                            NULL);
  g_signal_connect (G_OBJECT(dialog), "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);
  g_object_set_data (G_OBJECT (dialog), "user_data", GINT_TO_POINTER (FALSE));
  /* ja:エントリー */
  entry0 = gtk_entry_new_with_max_length (256);
  entry1 = gtk_entry_new_with_max_length (256);
  if (cmd_play)
    gtk_entry_set_text (GTK_ENTRY (entry0), cmd_play);
  if (cmd_stop)
    gtk_entry_set_text (GTK_ENTRY (entry1), cmd_stop);
  g_signal_connect (G_OBJECT (entry0), "activate",
                                G_CALLBACK (process_dialog_activate), dialog);
  g_signal_connect (G_OBJECT (entry1), "activate",
                                G_CALLBACK (process_dialog_activate), dialog);
  g_signal_connect (G_OBJECT (entry0), "changed",
                                G_CALLBACK (process_dialog_changed), dialog);
  g_signal_connect (G_OBJECT (entry1), "changed",
                                G_CALLBACK (process_dialog_changed), dialog);
  /* ja:ラベル */
  label0 = gtk_label_new_with_mnemonic (_("_Play"));
  label1 = gtk_label_new_with_mnemonic (_("_Stop"));
  gtk_label_set_mnemonic_widget (GTK_LABEL (label0), entry0);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label1), entry1);
  /* ja:フレームとボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), label0, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), entry0, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), label1, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), entry1, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), vbox);

  /* ja:表示 */
  gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog), GTK_RESPONSE_OK,
                                                                        FALSE);
  gtk_widget_show_all (vbox);

  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
    {
      const gchar *str0, *str1;

      g_free (cmd_play);
      g_free (cmd_stop);
      str0 = gtk_entry_get_text (GTK_ENTRY (entry0));
      str1 = gtk_entry_get_text (GTK_ENTRY (entry1));
      cmd_play = str0 && str0[0] != '\0' ? g_strdup (str0) : NULL;
      cmd_stop = str1 && str1[0] != '\0' ? g_strdup (str1) : NULL;
    }
  gtk_widget_destroy (dialog);
}
