/*
    orzhistory
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __ORZ_HISTORY_H__
#define __ORZ_HISTORY_H__


#include "common.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define ORZ_TYPE_HISTORY            (orz_history_get_type ())
#define ORZ_HISTORY(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORZ_TYPE_HISTORY, OrzHistory))
#define ORZ_HISTORY_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), ORZ_TYPE_HISTORY, OrzHistoryClass))
#define ORZ_IS_HISTORY(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORZ_TYPE_HISTORY))
#define ORZ_IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ORZ_TYPE_HISTORY))
#define ORZ_HISTORY_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), ORZ_TYPE_HISTORY, OrzHistoryClass))


#define ORZ_HISTORY_NUM_DEF 4
#define ORZ_HISTORY_NUM_MIN 0
#define ORZ_HISTORY_NUM_MAX 9


typedef struct _OrzHistory      OrzHistory;
typedef struct _OrzHistoryClass OrzHistoryClass;
typedef struct _OrzHistoryItem  OrzHistoryItem;


struct _OrzHistory
{
  /*< private >*/
  GObject    parent;

  /*< public >*/

  /*< private >*/
  gint       num;
  gint       position;
  gulong     handler_destroy;
  GtkWidget *menu_shell;
  GtkWidget *menu_item_head;
  GtkWidget *menu_item_foot;
  GList     *glist;
};
struct _OrzHistoryClass
{
  GObjectClass parent_class;

  /* -- signals -- */
  void (*activate) (OrzHistory  *history,
                    const gchar *file);
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
orz_history_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:ウインドウメニュー関数群                                                 *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,オブジェクト                                                        */
GObject*
orz_history_new (void);


/*  ja:メニューにファイルを追加する
    history,オブジェクト
       file,ファイル                                                        */
void
orz_history_add_file (OrzHistory  *history,
                      const gchar *file);


/*  ja:メニューのファイルを取得する
    history,オブジェクト
        RET,ファイルのリスト                                                */
GList *
orz_history_get_file (OrzHistory *history);


/*  ja:メニューを取得する
    history,オブジェクト
        RET,メニュー                                                        */
#define orz_history_get_menu(history)                                       \
                            ((history)?ORZ_HISTORY(history)->menu_shell:NULL)


/*  ja:メニューを設定する
       history,オブジェクト
    menu_shell,メニュー
      position,位置(0...,-1:末尾)                                           */
void
orz_history_set_menu (OrzHistory *history,
                      GtkWidget  *menu_shell,
                      const gint  position);


/*  ja:メニューの数を取得する
    history,オブジェクト
        RET,メニューの数                                                    */
gint
orz_history_get_num (OrzHistory *history);


/*  ja:メニューの数を設定する
    history,オブジェクト
        num,メニューの数
        RET,TRUE:正常終了,FALSE:エラー                                      */
gboolean
orz_history_set_num (OrzHistory *history,
                     const gint  num);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __ORZ_HISTORY_H__ */
