/*
    Melody maid
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "reload.h"
#include "orz/orzcharset.h"


/******************************************************************************
*                                                                             *
* ja:リロードダイアログ関数群                                                 *
*                                                                             *
******************************************************************************/
/* ja:コンボボックスが変更された */
static void
reload_dialog_edited (GtkWidget *widget,
                            GtkWidget *dialog)
{
  GtkWidget *charset;

  charset = g_object_get_data (G_OBJECT (dialog), "user_data");
  gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog), GTK_RESPONSE_ACCEPT,
                                orz_charset_is_valid (ORZ_CHARSET (charset)));
}


/* ja:コンボボックスでリターンが押された */
static void
reload_dialog_activate (GtkWidget *widget,
                        GtkWidget *dialog)
{
  GtkWidget *charset;

  charset = g_object_get_data (G_OBJECT (dialog), "user_data");
  if (orz_charset_is_valid (ORZ_CHARSET (charset)))
    gtk_dialog_response (GTK_DIALOG (dialog), GTK_RESPONSE_ACCEPT);
}


/*  ja:リロードダイアログ表示
    mmaid,ウインドウ情報
     text,説明文(Yes/No),NULL:説明なし(OK/Cansel)                           */
gboolean
reload_dialog (MmaidWindow *mmaid,
               const gchar *text)
{
  gboolean result;
  gchar *title;
  GtkStockItem stock_item;
  GtkWidget *dialog, *charset, *vbox;

  /* ja:メインウインドウ */
  gtk_stock_lookup (GTK_STOCK_REVERT_TO_SAVED, &stock_item);
  title = misc_mnemonic_to_text (stock_item.label);
  dialog = gtk_dialog_new_with_buttons
                            (title,
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            NULL);
  g_free (title);
  g_signal_connect (G_OBJECT (dialog), "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);
  /* ja:ボタン */
  if (text)
    gtk_dialog_add_buttons (GTK_DIALOG (dialog),
                            GTK_STOCK_NO, GTK_RESPONSE_REJECT,
                            GTK_STOCK_YES, GTK_RESPONSE_ACCEPT,
                            NULL);
  else
    gtk_dialog_add_buttons (GTK_DIALOG (dialog),
                            GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT,
                            GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
                            NULL);
  /* ja:文字符号化方式 */
  charset = orz_charset_new ();
  orz_charset_add_candidate (ORZ_CHARSET (charset), charset_list);
  orz_charset_set_charset (ORZ_CHARSET (charset), mmaid->charset);
  g_signal_connect (ORZ_CHARSET (charset), "activate",
                                G_CALLBACK (reload_dialog_activate), dialog);
  g_signal_connect (ORZ_CHARSET (charset), "edited",
                                G_CALLBACK (reload_dialog_edited), dialog);
  g_object_set_data (G_OBJECT (dialog), "user_data", charset);
  /* ja:フレームとボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  if (text)
    gtk_box_pack_start (GTK_BOX (vbox), gtk_label_new (text), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), charset, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), vbox);

  /* ja:表示 */
  gtk_widget_show_all (vbox);

  result = gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT;
  if (result)
    {
      g_free (mmaid->charset);
      mmaid->charset = orz_charset_get_charset (ORZ_CHARSET (charset));
    }
  gtk_widget_destroy (dialog);

  return result;
}
