/*
    Melody maid
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "icons.h"
#include "version.h"
#include "misc/gnugpl.h"


/******************************************************************************
*                                                                             *
* ja:バージョン情報関数群                                                     *
*                                                                             *
******************************************************************************/
/*  ja:バージョン表示                                                       */
void
version_dialog (void)
{
  GdkPixbuf *pixbuf;
  GtkTextBuffer *buffer;
  GtkTextIter where;
  GtkWidget *dialog, *notebook, *hbox0, *hbox1, *vbox;
  GtkWidget *text, *scroll;
  const static gchar *authors =
"Supreme Programmer:\n"
" Kazuki IWAMOTO <iwm@maid.org>\n"
"\n"
"Icons Author:\n"
" from GTK+ Stock Icons\n"
"\n"
"Special Thanks:\n"
" kyun2\n"
" And all Melody maid users";

  /* ja:メインウインドウ */
  dialog = gtk_dialog_new_with_buttons
                            (_("About Melody maid"),
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
                            NULL);
  gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);
  gtk_window_set_default_size (GTK_WINDOW (dialog),
                    gdk_screen_width () * 2 / 3, gdk_screen_height () * 2 / 3);
  g_signal_connect (G_OBJECT (dialog), "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);
  /* ja:ノートブック */
  notebook = gtk_notebook_new ();
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (notebook), TRUE);
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), n_pos);

  /* ja:ライセンス */
  /* ja:テキスト */
  text = gtk_text_view_new ();
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text));
  gtk_text_buffer_set_text (buffer, gnugpl, -1);
  gtk_text_buffer_get_start_iter (buffer, &where);
  gtk_text_buffer_place_cursor (buffer, &where);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (text), FALSE);
  /* ja:スクロールウインドウ */
  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (scroll), text);
  /* ja:ノートブック */
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), scroll,
                                                gtk_label_new (_("License")));

  /* ja:作者 */
  /* ja:テキスト */
  text = gtk_text_view_new ();
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text));
  gtk_text_buffer_set_text (buffer, authors, -1);
  gtk_text_buffer_get_start_iter (buffer, &where);
  gtk_text_buffer_place_cursor (buffer, &where);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (text), FALSE);
  /* ja:スクロールウインドウ */
  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (scroll), text);
  /* ja:ノートブック */
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), scroll,
                                gtk_label_new (_("Authors & Contributors")));

  /* ja:フレームとボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  hbox0 = gtk_hbox_new (FALSE, SPACING);
  pixbuf = gdk_pixbuf_new_from_xpm_data (mmaid32_xpm);
  gtk_box_pack_start (GTK_BOX (hbox0),
                        gtk_image_new_from_pixbuf (pixbuf), FALSE, FALSE, 0);
  g_object_unref (pixbuf);
  gtk_box_pack_start (GTK_BOX (hbox0),
            gtk_label_new (MMAID_VERSION_NOTICE"\n"MMAID_COPYRIGHT_NOTICE), 
                                                            FALSE, FALSE, 0);
  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox1), hbox0, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX(vbox), hbox1, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), notebook, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), vbox);

  /* ja:表示 */
  gtk_widget_show_all (vbox);

  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}
