/*
    Melody maid
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "general.h"
#include "mm_list.h"
#include "root.h"
#include "misc/fileio.h"
#include "orz/orzmdi.h"


/******************************************************************************
*                                                                             *
* ja:ルートダイアログ関数群                                                   *
*                                                                             *
******************************************************************************/
typedef struct _RootDialog
{
  gboolean ok_sensitive, unselect_all;
  GtkWidget *dialog, *combo, *entry;
  MmaidWindow *mmaid;
} RootDialog;


/* ja:参照ボタンが押された */
static void
root_dialog_clicked (GtkWidget  *widget,
                     RootDialog *rtdlg)
{
  gchar *root, *path;
  GtkWidget *dialog;

  root = g_strdup (gtk_entry_get_text (GTK_ENTRY (rtdlg->entry)));
  if (root[0] == '\0' || !G_IS_DIR_SEPARATOR (root[g_strlen (root) - 1]))
#if GTK_CHECK_VERSION(2,6,0)
    root = gtk_combo_box_get_active_text (GTK_COMBO_BOX (rtdlg->combo));
#elif GTK_CHECK_VERSION(2,4,0)
    {
      GtkTreeIter iter;

      if (gtk_combo_box_get_active_iter (GTK_COMBO_BOX (rtdlg->combo), &iter))
        gtk_tree_model_get (gtk_combo_box_get_model
                        (GTK_COMBO_BOX (rtdlg->combo)), &iter, 0, &root, -1);
      else
        root = NULL;
    }
#else /* not GTK_CHECK_VERSION(2,4,0) */
    root = g_strdup (gtk_entry_get_text
                                (GTK_ENTRY (GTK_COMBO (rtdlg->combo)->entry)));
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  path = root && root[0] != '\0'
                            && G_IS_DIR_SEPARATOR (root[g_strlen (root) - 1])
                    ? g_filename_from_utf8 (root, -1, NULL, NULL, NULL) : NULL;
  g_free (root);
#if GTK_CHECK_VERSION(2,4,0)
  dialog = gtk_file_chooser_dialog_new (_("Browse"),
                        GTK_WINDOW (rtdlg->dialog),
                        GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                        GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
                        NULL);
  if (path)
    {
      gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), path);
      g_free (path);
    }
  path = gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT
                    ? gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog))
                    : NULL;
#else /* not GTK_CHECK_VERSION(2,4,0) */
  dialog = gtk_file_selection_new (_("Browse"));
  if (path)
    {
      gtk_file_selection_set_filename (GTK_FILE_SELECTION (dialog), path);
      g_free (path);
    }
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (dialog));
  gtk_widget_hide
            (gtk_widget_get_parent (GTK_FILE_SELECTION (dialog)->file_list));
  gtk_widget_hide (GTK_FILE_SELECTION (dialog)->selection_entry);
  path = gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK
    ? g_strdup (gtk_file_selection_get_filename (GTK_FILE_SELECTION (dialog)))
    : NULL;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_widget_destroy (dialog);
  if (path)
    {
      gchar *utf8str;

      utf8str = g_filename_to_utf8 (path, -1, NULL, NULL, NULL);
      gtk_entry_set_text (GTK_ENTRY (rtdlg->entry), utf8str);
      g_free (utf8str);
      g_free (path);
    }
}


/* ja:コンボボックス/エントリーでリターンが押された */
static void
root_dialog_activate (GtkWidget  *widget,
                      RootDialog *rtdlg)
{
  if (rtdlg->ok_sensitive)
    gtk_dialog_response (GTK_DIALOG (rtdlg->dialog), GTK_RESPONSE_OK);
}


/* ja:コンボボックス/エントリーが変更された */
static void
root_dialog_changed (GtkWidget  *widget,
                     RootDialog *rtdlg)
{
  gboolean result = TRUE;
  gchar *file, *replace, *tmp;
#if GTK_CHECK_VERSION(2,4,0)
  gchar *find;
#else /* not GTK_CHECK_VERSION(2,4,0) */
  const gchar *find;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  gint i, count, leng;
  const ID3Tag *id3tag;

#if GTK_CHECK_VERSION(2,6,0)
  find = gtk_combo_box_get_active_text (GTK_COMBO_BOX (rtdlg->combo));
#elif GTK_CHECK_VERSION(2,4,0)
    {
      GtkTreeIter iter;

      if (gtk_combo_box_get_active_iter (GTK_COMBO_BOX (rtdlg->combo), &iter))
        gtk_tree_model_get (gtk_combo_box_get_model
                        (GTK_COMBO_BOX (rtdlg->combo)), &iter, 0, &find, -1);
    }
#else /* not GTK_CHECK_VERSION(2,4,0) */
  find = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (rtdlg->combo)->entry));
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  replace = g_filename_from_utf8 (gtk_entry_get_text
                            (GTK_ENTRY (rtdlg->entry)), -1, NULL, NULL, NULL);
  tmp = fileio_get_full_path (replace);
  g_free (replace);
  replace = g_filename_to_utf8 (tmp, -1, NULL, NULL, NULL);
  g_free (tmp);
  leng = g_strlen (find);
  count = mm_list_length (MM_LIST (rtdlg->mmaid->list));
  for (i = 0; i < count && result; i++)
    if (rtdlg->unselect_all
                    || mm_list_is_selected (MM_LIST (rtdlg->mmaid->list), i))
      {
        id3tag = mm_list_get_nth (MM_LIST (rtdlg->mmaid->list), i);
        if (g_strfilencmp (id3tag->file, find, leng) == 0)
          {
            file = g_strconcat (replace, id3tag->file + leng, NULL);
            result = mm_list_is_valid_file
                                    (MM_LIST (rtdlg->mmaid->list), -1, file);
            g_free (file);
          }
      }
#if GTK_CHECK_VERSION(2,4,0)
  g_free (find);
#endif /* GTK_CHECK_VERSION(2,4,0) */
  g_free (replace);
  rtdlg->ok_sensitive = result;
  gtk_dialog_set_response_sensitive (GTK_DIALOG (rtdlg->dialog),
                                                    GTK_RESPONSE_OK, result);
}


/*  ja:ルートダイアログ表示
    mmaid,ウインドウ情報                                                    */
void
root_dialog (MmaidWindow *mmaid)
{
  gint i, count;
  GList *glist = NULL;
  GtkWidget *button, *label0, *label1, *hbox0, *hbox1, *vbox;
  RootDialog rtdlg;

  rtdlg.mmaid = mmaid;
  /* ja:メインウインドウ */
  rtdlg.dialog = gtk_dialog_new_with_buttons
                            (_("Root"),
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
#ifdef G_OS_WIN32
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
#else /* not G_OS_WIN32 */
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
#endif /* not G_OS_WIN32 */
                            NULL);
  g_signal_connect (G_OBJECT (rtdlg.dialog), "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);
  /* ja:ボタン */
  button = gtk_button_new_with_mnemonic (_("_Browse..."));
  g_signal_connect (G_OBJECT (button), "clicked",
                                    G_CALLBACK (root_dialog_clicked), &rtdlg);
  /* ja:コンボボックス */
  rtdlg.unselect_all = TRUE;
  count = mm_list_length (MM_LIST (mmaid->list));
  for (i = 0; i < count; i++)
    if (mm_list_is_selected (MM_LIST (mmaid->list), i))
      {
        rtdlg.unselect_all = FALSE;
        break;
      }
  for (i = 0; i < count; i++)
    if (rtdlg.unselect_all || mm_list_is_selected (MM_LIST (mmaid->list), i))
      {
        gchar **dir, *path = NULL;
        gint j;
        const ID3Tag *id3tag;

        id3tag = mm_list_get_nth (MM_LIST (mmaid->list), i);
#ifdef G_OS_WIN32
        if (g_strlen (id3tag->file) > 2 && G_IS_DIR_SEPARATOR (id3tag->file[0])
                                    && G_IS_DIR_SEPARATOR (id3tag->file[1]))
          {
            path = g_strdup (G_DIR_SEPARATOR_S G_DIR_SEPARATOR_S);
            dir = g_strsplit (id3tag->file + 2, G_DIR_SEPARATOR_S, 0);
          }
        else
          {
            dir = g_strsplit (id3tag->file, G_DIR_SEPARATOR_S, 0);
          }
#else /* not G_OS_WIN32 */
        dir = g_strsplit (id3tag->file, G_DIR_SEPARATOR_S, 0);
#endif /* not G_OS_WIN32 */
        for (j = 0; dir[j] && dir[j + 1]; j++)
          {
            gchar *tmp;

            tmp = path ? g_strconcat (path, dir[j], G_DIR_SEPARATOR_S, NULL)
                       : g_strconcat (      dir[j], G_DIR_SEPARATOR_S, NULL);
            g_free (path);
            path = tmp;
#ifdef G_OS_WIN32
            if (!g_list_find_custom (glist, path,
                                            (GCompareFunc)g_ascii_strcasecmp))
              glist = g_list_insert_sorted (glist, g_strdup (path),
                                            (GCompareFunc)g_ascii_strcasecmp);
#else /* not G_OS_WIN32 */
            if (!g_list_find_custom (glist, path, (GCompareFunc)strcmp))
              glist = g_list_insert_sorted (glist, g_strdup (path),
                                                (GCompareFunc)strcmp);
#endif /* not G_OS_WIN32 */
          }
        g_strfreev (dir);
        g_free (path);
      }
#if GTK_CHECK_VERSION(2,4,0)
  rtdlg.combo = gtk_combo_box_new_text ();
  for (i = g_list_length (glist) - 1; i >= 0; i--)
    gtk_combo_box_prepend_text (GTK_COMBO_BOX (rtdlg.combo),
                                                g_list_nth_data (glist, i));
  gtk_combo_box_set_active (GTK_COMBO_BOX (rtdlg.combo), 0);
  g_signal_connect (G_OBJECT (rtdlg.combo), "changed",
                                    G_CALLBACK (root_dialog_changed), &rtdlg);
#else /* not GTK_CHECK_VERSION(2,4,0) */
  combo = gtk_combo_new ();
  gtk_combo_set_popdown_strings (GTK_COMBO (rtdlg.combo), glist);
  gtk_combo_set_value_in_list (GTK_COMBO (rtdlg.combo), FALSE, FALSE);
# ifdef G_OS_WIN32
  gtk_combo_set_case_sensitive (GTK_COMBO (rtdlg.combo), FALSE);
# else /* not G_OS_WIN32 */
  gtk_combo_set_case_sensitive (GTK_COMBO (rtdlg.combo), TRUE);
# endif /* not G_OS_WIN32 */
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (rtdlg.combo)->entry),
                                                g_list_nth_data (glist, 0));
  gtk_editable_set_editable (GTK_EDITABLE (GTK_COMBO (rtdlg.combo)->entry),
                                                                        FALSE);
  g_signal_connect (G_OBJECT (GTK_COMBO (rtdlg.combo)->entry), "activate",
                                    G_CALLBACK (root_dialog_activate), &rtdlg);
  g_signal_connect (G_OBJECT (GTK_COMBO (rtdlg.combo)->entry), "changed",
                                    G_CALLBACK (root_dialog_changed), &rtdlg);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  for (i = g_list_length (glist) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist, i));
  g_list_free (glist);
  /* ja:エントリー */
  rtdlg.entry = gtk_entry_new ();
  g_signal_connect (G_OBJECT (rtdlg.entry), "changed",
                                    G_CALLBACK (root_dialog_changed), &rtdlg);
  g_signal_connect (G_OBJECT (rtdlg.entry), "activate",
                                    G_CALLBACK (root_dialog_activate), &rtdlg);
  /* ja:ラベル */
  label0 = gtk_label_new_with_mnemonic (_("_Find Path"));
  label1 = gtk_label_new_with_mnemonic (_("_Replace Path"));
#if GTK_CHECK_VERSION(2,4,0)
  gtk_label_set_mnemonic_widget (GTK_LABEL (label0), rtdlg.combo);
#else /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_label_set_mnemonic_widget (GTK_LABEL (label0),
                                            GTK_COMBO (rtdlg.combo)->entry);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_label_set_mnemonic_widget (GTK_LABEL (label1), rtdlg.entry);
  /* ja:フレームとボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  hbox0 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox0), label0, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox0), rtdlg.combo, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
  hbox0 = gtk_hbox_new (FALSE, SPACING);
  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox1), rtdlg.entry, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox0), hbox1, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox0), button, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (rtdlg.dialog)->vbox), vbox);

  /* ja:表示 */
  gtk_dialog_set_response_sensitive (GTK_DIALOG (rtdlg.dialog),
                                                    GTK_RESPONSE_OK, FALSE);
  gtk_widget_show_all (vbox);

  rtdlg.ok_sensitive = FALSE;

  if (gtk_dialog_run (GTK_DIALOG (rtdlg.dialog)) == GTK_RESPONSE_OK)
    {
      gchar *replace, *tmp;
#if GTK_CHECK_VERSION(2,4,0)
      gchar *find;
#else /* not GTK_CHECK_VERSION(2,4,0) */
      const gchar *find;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      gint i, count, leng;
      const ID3Tag *id3tag;

#if GTK_CHECK_VERSION(2,6,0)
      find = gtk_combo_box_get_active_text (GTK_COMBO_BOX (rtdlg.combo));
#elif GTK_CHECK_VERSION(2,4,0)
        {
          GtkTreeIter iter;

          if (gtk_combo_box_get_active_iter
                                        (GTK_COMBO_BOX (rtdlg.combo), &iter))
            gtk_tree_model_get (gtk_combo_box_get_model
                        (GTK_COMBO_BOX (rtdlg.combo)), &iter, 0, &find, -1);
        }
#else /* not GTK_CHECK_VERSION(2,4,0) */
      find = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (rtdlg.combo)->entry));
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      replace = g_filename_from_utf8 (gtk_entry_get_text
                            (GTK_ENTRY (rtdlg.entry)), -1, NULL, NULL, NULL);
      tmp = fileio_get_full_path (replace);
      g_free (replace);
      replace = g_filename_to_utf8 (tmp, -1, NULL, NULL, NULL);
      g_free (tmp);
      leng = g_strlen (find);
      count = mm_list_length (MM_LIST (mmaid->list));
      for (i = 0; i < count; i++)
        if (rtdlg.unselect_all
                            || mm_list_is_selected (MM_LIST (mmaid->list), i))
          {
            id3tag = mm_list_get_nth (MM_LIST (mmaid->list), i);
            if (g_strfilencmp (id3tag->file, find, leng) == 0)
              mm_list_change (MM_LIST (mmaid->list), i, MM_LIST_FILE,
                        g_strconcat (replace, id3tag->file + leng, NULL), -1);
          }
#if GTK_CHECK_VERSION(2,4,0)
      g_free (find);
#endif /* GTK_CHECK_VERSION(2,4,0) */
      g_free (replace);
      orz_mdi_set_edited (ORZ_MDI (mdi),
                    orz_mdi_get_page_from_data (ORZ_MDI (mdi), mmaid), TRUE);
    }
  gtk_widget_destroy (rtdlg.dialog);
}
