/*
    Melody maid
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "export.h"
#include "general.h"
#include "mm_list.h"
#include "misc/fileio.h"
#include "orz/orzcharset.h"


/******************************************************************************
*                                                                             *
* ja:エクスポートダイアログ関数群                                             *
*                                                                             *
******************************************************************************/
typedef struct _ExportDialog
{
  GtkWidget *dialog, *charset, *label, *spin;
} ExportDialog;


/* ja:コンボボックス/スピンボタンでリターンが押された */
static void
export_dialog_activate (GtkWidget    *widget,
                        ExportDialog *expdlg)
{
  gint g;

  g = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (expdlg->spin));
  if (0 <= g && g <= 255
                    && orz_charset_is_valid (ORZ_CHARSET (expdlg->charset)))
    gtk_dialog_response (GTK_DIALOG (expdlg->dialog), GTK_RESPONSE_OK);
}


/* ja:文字符号化方式が変更された */
static void
export_dialog_edited (GtkWidget    *widget,
                      ExportDialog *expdlg)
{
  gint g;

  g = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (expdlg->spin));
  gtk_dialog_set_response_sensitive (GTK_DIALOG (expdlg->dialog),
                                            GTK_RESPONSE_OK, 0 <= g && g <= 255
                    && orz_charset_is_valid (ORZ_CHARSET (expdlg->charset)));
}


/* ja:スピンボタンが変更された */
static void
export_dialog_changed (GtkWidget    *widget,
                       ExportDialog *expdlg)
{
  gchar *str = "";
  gint g;

  g = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget));
  if (0 <= g && g <= 255)
    {
      gint i;

      for (i = 0; i < genres; i++)
        if (genre[i][g])
          {
            str = genre[i][g];
            break;
          }
    }
  gtk_label_set_text (GTK_LABEL (expdlg->label), str);
  gtk_dialog_set_response_sensitive (GTK_DIALOG (expdlg->dialog),
                                            GTK_RESPONSE_OK, 0 <= g && g <= 255
                    && orz_charset_is_valid (ORZ_CHARSET (expdlg->charset)));
}


/*  ja:エクスポートダイアログ表示
    def_charset,デフォルトのキャラクターセット                              */
ExportInfo *
export_dialog (const gchar *def_charset)
{
  gint i;
  GtkWidget *check, *label, *frame, *hbox, *vbox;
  ExportInfo *expinfo;
  ExportDialog expdlg;

  /* ja:メインウインドウ */
  expdlg.dialog = gtk_dialog_new_with_buttons
                            (_("Export"),
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
#ifdef G_OS_WIN32
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
#else /* not G_OS_WIN32 */
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
#endif /* not G_OS_WIN32 */
                            NULL);
  g_signal_connect (G_OBJECT (expdlg.dialog), "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);
  /* ja:文字符号化方式 */
  expdlg.charset = orz_charset_new ();
  orz_charset_add_candidate (ORZ_CHARSET (expdlg.charset), charset_list);
  orz_charset_set_charset (ORZ_CHARSET (expdlg.charset), def_charset);
  g_signal_connect (G_OBJECT (expdlg.charset), "activate",
                                G_CALLBACK (export_dialog_activate), &expdlg);
  g_signal_connect (G_OBJECT (expdlg.charset), "edited",
                                G_CALLBACK (export_dialog_edited), &expdlg);
  /* ja:チェックボタン */
  check = gtk_check_button_new_with_mnemonic (_("_Hold existing tags"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check), def_hold);
  /* ja:スピンボタン */
  expdlg.spin = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
                                        (def_gnum, 0, 255, 1, 5, 0)), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (expdlg.spin), TRUE);
  g_signal_connect (G_OBJECT (expdlg.spin), "activate",
                                G_CALLBACK (export_dialog_activate), &expdlg);
  g_signal_connect (G_OBJECT (expdlg.spin), "changed",
                                G_CALLBACK (export_dialog_changed), &expdlg);
  /* ja:フレーム */
  frame = gtk_frame_new (NULL);
  label = gtk_label_new_with_mnemonic (_("_Genre"));
  gtk_frame_set_label_widget (GTK_FRAME (frame), label);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label), expdlg.spin);
  /* ja:ラベル */
  for (i = 0; i < genres; i++)
    if (genre[i][def_gnum])
      break;
  expdlg.label = gtk_label_new (i < genres ? genre[i][def_gnum] : "");
  label = gtk_label_new_with_mnemonic (_("Character _Encoding"));
  gtk_label_set_mnemonic_widget (GTK_LABEL (label), expdlg.charset);
  /* ja:ボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), expdlg.spin, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), expdlg.label, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 0);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), expdlg.charset, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), check, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (expdlg.dialog)->vbox), vbox);

  /* ja:表示 */
  gtk_widget_show_all (vbox);

  if (gtk_dialog_run (GTK_DIALOG (expdlg.dialog)) == GTK_RESPONSE_OK)
    {
      expinfo = g_malloc (sizeof (ExportInfo));
      expinfo->gnum = gtk_spin_button_get_value_as_int
                                            (GTK_SPIN_BUTTON (expdlg.spin));
      expinfo->charset = orz_charset_get_charset
                                                (ORZ_CHARSET (expdlg.charset));
      expinfo->hold = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check));
      charlist_renewal_all (expinfo->charset);
    }
  else
    {
      expinfo = NULL;
    }
  gtk_widget_destroy (expdlg.dialog);

  return expinfo;
}
