/*
    Melody maid
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "icons.h"


/******************************************************************************
*                                                                             *
* ja:アイコン                                                                 *
*                                                                             *
******************************************************************************/
/* XPM */
const gchar *mmaid16_xpm[] = {
"16 16 5 1",
"   c None",
".  c #000000",
"+  c #00FFFF",
"@  c #C0C0C0",
"#  c #FFFFFF",
" @@@@@@@@@@@@@  ",
" .............  ",
" .+#+#+#+#+#+.  ",
" .#+#+#+#+#+#.  ",
" .+#+#+#+#+#+.  ",
" .#+#+#+#+#+#.  ",
" .............  ",
" ....@...@....  ",
" .....@@@.....  ",
" .....@@@.....  ",
" .....@@@.....  ",
" ....@...@....  ",
" .............  ",
" .............  ",
" .@@@@@@@@@@@.  ",
" @@@@@@@@@@@@@  "};


/* XPM */
const gchar *mmaid24_xpm[] = {
"24 24 5 1",
"   c None",
".  c #000000",
"+  c #00FFFF",
"@  c #C0C0C0",
"#  c #FFFFFF",
"  @@@@@@@@@@@@@@@@@@@   ",
"  @@@@@@@@@@@@@@@@@@@   ",
"  ...................   ",
"  .+#+#+#+#+#+#+#+#+.   ",
"  .#+#+#+#+#+#+#+#+#.   ",
"  .+#+#+#+#+#+#+#+#+.   ",
"  .#+#+#+#+#+#+#+#+#.   ",
"  .+#+#+#+#+#+#+#+#+.   ",
"  .#+#+#+#+#+#+#+#+#.   ",
"  ...................   ",
"  ......@.....@......   ",
"  .....@.......@.....   ",
"  ....@.@.@@@.@.@....   ",
"  .......@@@@@.......   ",
"  ......@@@@@@@......   ",
"  ......@@@@@@@......   ",
"  ......@@@@@@@......   ",
"  .......@@@@@.......   ",
"  ....@.@.@@@.@.@....   ",
"  .....@.......@.....   ",
"  ......@.....@......   ",
"  ...................   ",
"  .@@@@@@@@@@@@@@@@@.   ",
"  @@@@@@@@@@@@@@@@@@@   "};


/* XPM */
const gchar *mmaid32_xpm[] = {
"32 32 10 1",
"   c None",
".  c #000000",
"+  c #0000FF",
"@  c #FF0000",
"#  c #FF00FF",
"$  c #00FF00",
"%  c #00FFFF",
"&  c #C0C0C0",
"*  c #FFFF00",
"=  c #FFFFFF",
"   &&&&&&&&&&&&&&&&&&&&&&&&&    ",
"   &&&&&&&&&&&&&&&&&&&&&&&&&    ",
"   .........................    ",
"   .........................    ",
"   ..%=%=%=%=%=%=%=%=%=%=%..    ",
"   ..=%=%=%=%=%=%=%=%=%=%=..    ",
"   ..%=%=%=%=%=%=%=%=%=%=%..    ",
"   ..=%=%=%=%=%=%=%=%=%=%=..    ",
"   ..%=%=%=%=%=%=%=%=%=%=%..    ",
"   ..=%=%=%=%=%=%=%=%=%=%=..    ",
"   ..%=%=%=%=%=%=%=%=%=%=%..    ",
"   ..=%=%=%=%=%=%=%=%=%=%=..    ",
"   ..%=%=%=%=%=%=%=%=%=%=%..    ",
"   ............#............    ",
"   ...........##............    ",
"   ..........###............    ",
"   ..........###............    ",
"   ......@..####++++++......    ",
"   ......@@@####+++++.......    ",
"   .......@@@@##+++%........    ",
"   .......@@@@@#+%%%........    ",
"   ........@@@*$%%%%%.......    ",
"   ........@***$$%%%%.......    ",
"   .......*****$$$$%%%......    ",
"   ......******$$$$..%......    ",
"   ............$$$..........    ",
"   ............$$$..........    ",
"   ............$$...........    ",
"   ............$............    ",
"   ..&&&&&&&&&&&&&&&&&&&&&..    ",
"   &&&&&&&&&&&&&&&&&&&&&&&&&    ",
"   &&&&&&&&&&&&&&&&&&&&&&&&&    "};


/* XPM */
const gchar *mmaid48_xpm[] = {
"48 48 10 1",
"   c None",
".  c #000000",
"+  c #0000FF",
"@  c #FF0000",
"#  c #FF00FF",
"$  c #00FF00",
"%  c #00FFFF",
"&  c #C0C0C0",
"*  c #FFFF00",
"=  c #FFFFFF",
"    &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&    ",
"    &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&    ",
"    &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&    ",
"    ........................................    ",
"    ........................................    ",
"    ..%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=..    ",
"    ..=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%..    ",
"    ..%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=..    ",
"    ..=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%..    ",
"    ..%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=..    ",
"    ..=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%..    ",
"    ..%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=..    ",
"    ..=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%..    ",
"    ..%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=..    ",
"    ..=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%..    ",
"    ..%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=..    ",
"    ..=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%..    ",
"    ..%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=..    ",
"    ..=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%..    ",
"    ..%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=%=..    ",
"    ....................#...................    ",
"    ...................##...................    ",
"    ...................##...................    ",
"    ..................###...................    ",
"    .................####...................    ",
"    ..........@.....#####+++++++++..........    ",
"    ..........@@@...#####++++++++...........    ",
"    ...........@@@.######++++++.............    ",
"    ...........@@@@@#####+++++..............    ",
"    ............@@@@@####+++%%..............    ",
"    ............@@@@@@@##++%%%%.............    ",
"    ............@@@@@@@@#%%%%%%.............    ",
"    .............@@@@@@$%%%%%%%%............    ",
"    .............@@@@**$$%%%%%%%............    ",
"    ..............@@***$$$$%%%%%............    ",
"    ..............*****$$$$$$%%%%...........    ",
"    .............******$$$$$$.%%%...........    ",
"    ...........********$$$$$...%%%..........    ",
"    ..........*********$$$$$.....%..........    ",
"    ...................$$$$.................    ",
"    ...................$$$..................    ",
"    ...................$$...................    ",
"    ...................$$...................    ",
"    ...................$....................    ",
"    ....&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&....    ",
"    ...&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&...    ",
"    &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&    ",
"    &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&    "};


/* XPM */
const gchar *export16_xpm[] = {
"16 16 91 1",
"   c None",
".  c #000000",
"+  c #F7F8FA",
"@  c #CBDDEB",
"#  c #C88A80",
"$  c #D18F84",
"%  c #0F0F0E",
"&  c #2C2D28",
"*  c #BFD5E8",
"=  c #DBE7F1",
"-  c #8DA9BE",
";  c #B7877E",
">  c #C77568",
",  c #C77467",
"'  c #F0F1F0",
")  c #CDD8C8",
"!  c #747C65",
"~  c #54697C",
"{  c #CFE0ED",
"]  c #D7D7D7",
"^  c #FEFEFE",
"/  c #EDEEE8",
"(  c #9FB999",
"_  c #586748",
":  c #4F6475",
"<  c #A0BA9B",
"[  c #496072",
"}  c #FCFCFC",
"|  c #A0BA9A",
"1  c #D4D4D4",
"2  c #C5C5C5",
"3  c #9EB899",
"4  c #EEEEEE",
"5  c #F2F2F2",
"6  c #EBEBEB",
"7  c #9EB898",
"8  c #576648",
"9  c #AEBFCD",
"0  c #CAD6DF",
"a  c #C7CFDA",
"b  c #BFCBD6",
"c  c #9CB796",
"d  c #89A6BC",
"e  c #7F9AAE",
"f  c #819AAE",
"g  c #9AB593",
"h  c #8CA8BD",
"i  c #A8B1BD",
"j  c #CECECE",
"k  c #010101",
"l  c #090909",
"m  c #95B390",
"n  c #59694A",
"o  c #050604",
"p  c #84A0B5",
"q  c #183042",
"r  c #33495A",
"s  c #151513",
"t  c #82867D",
"u  c #C5D0C3",
"v  c #A3BDA0",
"w  c #78996F",
"x  c #516147",
"y  c #11120F",
"z  c #86A4B9",
"A  c #CDCDCD",
"B  c #2E4353",
"C  c #5A7082",
"D  c #121411",
"E  c #666E63",
"F  c #9EB49A",
"G  c #647A5D",
"H  c #6B7882",
"I  c #839EB2",
"J  c #E6E6E6",
"K  c #213648",
"L  c #5F7989",
"M  c #C2C2C2",
"N  c #1D1E1A",
"O  c #646F5E",
"P  c #9FA9B0",
"Q  c #59636D",
"R  c #A1A1A1",
"S  c #C0C0C0",
"T  c #909090",
"U  c #868686",
"V  c #6E6E6E",
"W  c #7A7A7A",
"X  c #3E4F5C",
"Y  c #80878F",
"Z  c #1A3140",
" .............. ",
".+@#$$$$$..%&.*.",
".=-;>,,,,.')!.~.",
".{-]^^^^^./(_.:.",
".{-]]]]]]./<_.[.",
".{-]^^^^}./|_.[.",
".{-]]]]12./3_.[.",
".{-4^^566./78.[.",
".{-90abbb./c8.[.",
".{--defff./g8.[.",
".{-hi22jkl/mnok.",
".{-p22qrstuvwxy.",
".{zf2ABC2DEFG.[.",
".HIfAJKL2MNO.P[.",
" .Q:RSTTUVW.XYZ.",
"  ............. "};


/* XPM */
const gchar *export24_xpm[] = {
"24 24 212 2",
"   c None",
".  c #000000",
"+  c #C3D7F4",
"@  c #A9CDE5",
"#  c #75757A",
"$  c #EFC5BB",
"%  c #F1C8BE",
"&  c #F0C6BC",
"*  c #EEBCB2",
"=  c #EEBEB5",
"-  c #EEC1B8",
";  c #EDBFB6",
">  c #E9B7AD",
",  c #E9B8AF",
"'  c #E9B9B1",
")  c #E5BFBA",
"!  c #737277",
"~  c #B3CDE3",
"{  c #A1BED6",
"]  c #BBD6E8",
"^  c #8AAAC5",
"/  c #605F68",
"(  c #E08D7E",
"_  c #E0826E",
":  c #E0806E",
"<  c #DC7A68",
"[  c #DC8171",
"}  c #DA7868",
"|  c #D48173",
"1  c #D47D6E",
"2  c #626169",
"3  c #87A3B7",
"4  c #567187",
"5  c #BAD5E9",
"6  c #88A7C3",
"7  c #686670",
"8  c #C8817B",
"9  c #CB7C74",
"0  c #CB7A73",
"a  c #CB7B73",
"b  c #CC7C72",
"c  c #CB7D73",
"d  c #BF6B64",
"e  c #CC7A70",
"f  c #FAFAFA",
"g  c #DDDFD2",
"h  c #8B8E7C",
"i  c #819EB6",
"j  c #547086",
"k  c #B6D3E7",
"l  c #87ABC1",
"m  c #737373",
"n  c #FFFFFF",
"o  c #E5E7DD",
"p  c #84A77E",
"q  c #586546",
"r  c #83A0B8",
"s  c #526C80",
"t  c #B9D3E7",
"u  c #85A4BF",
"v  c #81A57C",
"w  c #4F697C",
"x  c #B9D3E6",
"y  c #84A3BF",
"z  c #CECECE",
"A  c #CDCDCD",
"B  c #EDEEE8",
"C  c #81A57B",
"D  c #88A4BB",
"E  c #486276",
"F  c #B7D2E7",
"G  c #82A0BB",
"H  c #636363",
"I  c #ECEDE6",
"J  c #465E70",
"K  c #B5CAE5",
"L  c #7FA2B9",
"M  c #87A3BA",
"N  c #455C6D",
"O  c #AECCE5",
"P  c #7DA0B6",
"Q  c #546069",
"R  c #B0D1E4",
"S  c #83A1B6",
"T  c #735B5B",
"U  c #7EA379",
"V  c #515C64",
"W  c #AACEE3",
"X  c #7B9BB2",
"Y  c #7A8E9A",
"Z  c #7A7A7A",
"`  c #6B6F72",
" . c #6F6F6F",
".. c #7DA377",
"+. c #6F777E",
"@. c #86A2B9",
"#. c #3A515D",
"$. c #A9C9E2",
"%. c #7494AF",
"&. c #829FB7",
"*. c #7F9DB6",
"=. c #7E9CB5",
"-. c #7998B2",
";. c #DDDFD3",
">. c #7DA378",
",. c #8AA5BB",
"'. c #364A59",
"). c #ABC4E2",
"!. c #7294AD",
"~. c #6F90AC",
"{. c #7192AE",
"]. c #414A4E",
"^. c #424A51",
"/. c #525B63",
"(. c #626F79",
"_. c #5F6C76",
":. c #C9D5C4",
"<. c #7EA378",
"[. c #364853",
"}. c #AAC9E2",
"|. c #7091AA",
"1. c #6F8FA7",
"2. c #4A5359",
"3. c #97938C",
"4. c #DFDDDA",
"5. c #E3E1DE",
"6. c #EBEAE8",
"7. c #7C7E73",
"8. c #DFE7DE",
"9. c #CCDACA",
"0. c #90B08C",
"a. c #76986D",
"b. c #6C855E",
"c. c #22231E",
"d. c #34464E",
"e. c #AAC9E1",
"f. c #6C8EA6",
"g. c #6C8CA4",
"h. c #40474D",
"i. c #DAD8D3",
"j. c #E7E6E2",
"k. c #67655E",
"l. c #524F47",
"m. c #D9D7D4",
"n. c #3F443B",
"o. c #C8D8C7",
"p. c #9DB89A",
"q. c #76966B",
"r. c #3D4237",
"s. c #B3CADC",
"t. c #313E49",
"u. c #A8C8E1",
"v. c #6B8DA6",
"w. c #728FA4",
"x. c #E2E1DD",
"y. c #F0EFEC",
"z. c #CDCAC6",
"A. c #C2BFB9",
"B. c #565B4E",
"C. c #9EBA9A",
"D. c #3C4237",
"E. c #4F6F84",
"F. c #BACCDC",
"G. c #A4C4DE",
"H. c #698BA3",
"I. c #708AA1",
"J. c #383E43",
"K. c #E0DEDA",
"L. c #514E46",
"M. c #4F4C44",
"N. c #C7C4BE",
"O. c #C0BCB5",
"P. c #CBC8C2",
"Q. c #5E6154",
"R. c #4E6879",
"S. c #4D6C80",
"T. c #A3C3DB",
"U. c #383F43",
"V. c #778999",
"W. c #6E899E",
"X. c #65859C",
"Y. c #33383C",
"Z. c #D7D4D0",
"`. c #D6D4D0",
" + c #4E4A43",
".+ c #4D4942",
"++ c #D1CEC9",
"@+ c #E6E5E2",
"#+ c #EDECEA",
"$+ c #454F55",
"%+ c #486173",
"&+ c #4D6678",
"*+ c #A1C1DA",
"=+ c #373C40",
"-+ c #0C0D0F",
";+ c #4E5E6A",
">+ c #5B6E7C",
",+ c #4F5B62",
"'+ c #A4A099",
")+ c #B8B3AB",
"!+ c #CCC9C3",
"~+ c #D7D5D1",
"{+ c #E4E2E0",
"]+ c #EAE9E7",
"^+ c #DDDBD7",
"/+ c #B8B5B0",
"(+ c #3E474D",
"_+ c #4A6176",
":+ c #4A6070",
"<+ c #9BC3D8",
"[+ c #363C41",
"}+ c #28323E",
"                                                ",
"    . . . . . . . . . . . . . . . . . . .       ",
"  . + @ # $ % & * = - ; > , > , ' ) ! ~ { .     ",
"  . ] ^ / ( _ : < [ } | 1 . . . . . 2 3 4 .     ",
"  . 5 6 7 8 9 0 a b c d e . f g h . 7 i j .     ",
"  . k l m n n n n n n n n . o p q . m r s .     ",
"  . t u m n n n n n n n n . o v q . m r w .     ",
"  . x y m z A A A A A A A . B C q . m D E .     ",
"  . F G H n n n n n n n n . I C q . m D J .     ",
"  . K L m n n n n n n n n . o v q . m M N .     ",
"  . O P m z A A A A A A A . o v q . m M Q .     ",
"  . R S T n n n n n n n n . o U q . m r V .     ",
"  . W X Y Z m m m m m `  .. o ..q . +.@.#..     ",
"  . $.%.i r @.&.*.=.&.-.@.. ;.>.q . r ,.'..     ",
"  . ).!.~.{.].^./.(._.. . . :.<.q . . . [..     ",
"  . }.|.1.2.3.4.5.6.6.. 7.8.9.0.a.b.c.. d..     ",
"  . e.f.g.h.i.j.k.l.l.m.. n.o.p.q.r.. s.t..     ",
"  . u.v.w.h.x.y.k.l.l.z.A.. B.C.D.. E.F.t..     ",
"  . G.H.I.J.K.6.L.M.M.N.O.P.. Q.. R.S.T.U..     ",
"  . V.W.X.Y.Z.`. +.+.+O.++@+#+. $+%+&+*+=+.     ",
"    -+;+>+,+'+O.)+!+!+~+{+]+^+/+(+_+:+<+[+.     ",
"      . . . . . . . . . . . . . . . . }+.       ",
"                                                ",
"                                                "};


/* XPM */
const gchar *root16_xpm[] = {
"16 16 64 1",
"   c None",
".  c #000000",
"+  c #A8AFA0",
"@  c #DEE6D6",
"#  c #CCDCB8",
"$  c #BDD2A1",
"%  c #BAD09D",
"&  c #9FA498",
"*  c #9BB46F",
"=  c #7C9B40",
"-  c #728E3A",
";  c #B1C491",
">  c #50652A",
",  c #35431B",
"'  c #E4E5DF",
")  c #D5D6CB",
"!  c #D6D7CA",
"~  c #9CB476",
"{  c #F5F6F0",
"]  c #8D907B",
"^  c #92957E",
"/  c #90937D",
"(  c #6B7957",
"_  c #EAECDB",
":  c #8A8C7D",
"<  c #8E917B",
"[  c #91947F",
"}  c #7F816F",
"|  c #989B86",
"1  c #767868",
"2  c #F7F7F7",
"3  c #878A75",
"4  c #666858",
"5  c #4B4D3F",
"6  c #4D4F40",
"7  c #3A3B30",
"8  c #23241D",
"9  c #C6C6BE",
"0  c #848672",
"a  c #25261F",
"b  c #F1F2E9",
"c  c #DDE0C7",
"d  c #D6DABB",
"e  c #CDD2AC",
"f  c #BBBF9D",
"g  c #C6C7BE",
"h  c #5F6152",
"i  c #888980",
"j  c #ABAF8F",
"k  c #9FA19A",
"l  c #EFF0E5",
"m  c #9EA284",
"n  c #80817B",
"o  c #96968D",
"p  c #E3E5D1",
"q  c #83866D",
"r  c #97998D",
"s  c #EDEFE2",
"t  c #A2A688",
"u  c #767671",
"v  c #E7E9DA",
"w  c #D1D3BD",
"x  c #989B80",
"y  c #6E715C",
"         .      ",
"       ..+.     ",
"      .@#$%.    ",
"     .&*==-. .  ",
"  ....;>.,.  .. ",
" .')!.~. .   .@.",
".{]^/.(..... .=.",
"._:<[}..|1.@.>=.",
".234567.8.@===>.",
".90abcdef.~=>>. ",
".ghiceeeej.~... ",
".kaldeeeeej.m.  ",
".nopeeeeeeeeq.  ",
".rseeeeeeeet.   ",
".uvwffffffxy.   ",
" ...........    "};


/* XPM */
const gchar *root24_xpm[] = {
"24 24 78 1",
"   c None",
".  c #000000",
"+  c #A8AFA0",
"@  c #DEE6D6",
"#  c #CCDCB8",
"$  c #BDD2A1",
"%  c #BAD09D",
"&  c #9FA498",
"*  c #9BB46F",
"=  c #7C9B40",
"-  c #728E3A",
";  c #B1C491",
">  c #50652A",
",  c #35431B",
"'  c #9CB476",
")  c #6B7957",
"!  c #E4E5DF",
"~  c #D5D6CB",
"{  c #D6D7CA",
"]  c #A3A39D",
"^  c #F5F6F0",
"/  c #8D907B",
"(  c #92957E",
"_  c #90937D",
":  c #979B84",
"<  c #6D705F",
"[  c #EAECDB",
"}  c #8A8C7D",
"|  c #8E917B",
"1  c #91947F",
"2  c #8B8E7A",
"3  c #999B87",
"4  c #919480",
"5  c #989B86",
"6  c #B1B4A2",
"7  c #A2A394",
"8  c #F7F7F7",
"9  c #878A75",
"0  c #666858",
"a  c #4B4D3F",
"b  c #4D4F40",
"c  c #404135",
"d  c #424337",
"e  c #434437",
"f  c #404236",
"g  c #3C3D32",
"h  c #48493C",
"i  c #1A1A16",
"j  c #C6C6BE",
"k  c #848672",
"l  c #25261F",
"m  c #F1F2E9",
"n  c #DDE0C7",
"o  c #D6DABB",
"p  c #CDD2AC",
"q  c #C7CCA7",
"r  c #989C80",
"s  c #C6C7BE",
"t  c #5F6152",
"u  c #888980",
"v  c #A7AB8C",
"w  c #878A70",
"x  c #9FA19A",
"y  c #EFF0E5",
"z  c #9EA284",
"A  c #80817B",
"B  c #96968D",
"C  c #E3E5D1",
"D  c #83866D",
"E  c #97998D",
"F  c #EDEFE2",
"G  c #A2A688",
"H  c #767671",
"I  c #E7E9DA",
"J  c #D1D3BD",
"K  c #BBBF9D",
"L  c #989B80",
"M  c #6E715C",
"                        ",
"              .         ",
"            ..+.        ",
"           .@#$%.       ",
"          .&*==-.       ",
"          .;>.,.        ",
"          .'. .     .   ",
"          .).       ..  ",
"           ..       .@. ",
"            .     . .=. ",
"                 .@.>=. ",
"   ....         .@===>. ",
"  .!~{].        .'=>>.  ",
" .^/(_:<.....    .'..   ",
" .[}|12345467.    .     ",
" .890abcddefghi         ",
" .jklmnopppppqr.        ",
" .stunpppppppvw.        ",
" .xlyopppppppz.         ",
" .ABCppppppppD.         ",
" .EFppppppppG.          ",
" .HIJKKKKKKLM.          ",
"  ...........           ",
"                        "};


#if ! GTK_CHECK_VERSION(2,6,0)
/* XPM */
const gchar *edit16_xpm[] = {
"16 16 60 1",
"   c None",
".  c #000000",
"+  c #FEFEFE",
"@  c #FDFDFD",
"#  c #E0E0E0",
"$  c #C1C1C1",
"%  c #F1F1F1",
"&  c #C3C3C3",
"*  c #FBFBFB",
"=  c #A8A8A8",
"-  c #CCCCCC",
";  c #ADADAD",
">  c #767676",
",  c #5D5D5D",
"'  c #404040",
")  c #F0F0F0",
"!  c #E2E2E2",
"~  c #858585",
"{  c #4B4B49",
"]  c #FBE73B",
"^  c #F2B64D",
"/  c #CACACA",
"(  c #EFEFEF",
"_  c #C9C9C9",
":  c #FCEB3D",
"<  c #F7B544",
"[  c #61542E",
"}  c #EEEEEE",
"|  c #FCE93B",
"1  c #F7B545",
"2  c #6C5F34",
"3  c #F9DF39",
"4  c #F4B244",
"5  c #665D3E",
"6  c #EDEDED",
"7  c #ECECEC",
"8  c #EBEBEB",
"9  c #F6D236",
"0  c #EFB44D",
"a  c #5C4F2B",
"b  c #C4C4C4",
"c  c #E8E8E8",
"d  c #D7AE74",
"e  c #655930",
"f  c #C0C0C0",
"g  c #EAEAEA",
"h  c #E9E9E9",
"i  c #4F4115",
"j  c #E7E7E7",
"k  c #BFBFBF",
"l  c #C2C2C2",
"m  c #E6E6E6",
"n  c #E5E5E5",
"o  c #BEBEBE",
"p  c #E4E4E4",
"q  c #BDBDBD",
"r  c #E3E3E3",
"s  c #BBBBBB",
"t  c #BCBCBC",
"u  c #A0A0A0",
"  .........     ",
" .++++++@#$.    ",
" .+%%%%%%&*=.   ",
" .+%---%%;>,'.. ",
" .+%%%%%)!~{.]^.",
" .+%////(/_.:<[.",
" .+(((}}}}.|12. ",
" .@}__}__.345.  ",
" .@67778.90a..  ",
" .@8bbbc.de.f.  ",
" .@gghh.i..jk.  ",
" .@clml..mmno.  ",
" .@jjmmmnnppq.  ",
" .@mnnnpprrrs.  ",
" .lqqqttssssu.  ",
"  ...........   "};


/* XPM */
const gchar *edit24_xpm[] = {
"24 24 189 2",
"   c None",
".  c #000000",
"+  c #0E0E0E",
"@  c #282828",
"#  c #616161",
"$  c #D3D3D3",
"%  c #F6F6F6",
"&  c #FFFFFF",
"*  c #F9F9F9",
"=  c #F9F9F8",
"-  c #E7E7E7",
";  c #E4E4E4",
">  c #CDCDCD",
",  c #1F1F1F",
"'  c #EFEFEE",
")  c #AFAFAE",
"!  c #E9E9E9",
"~  c #B3B3B3",
"{  c #383838",
"]  c #C2C2C2",
"^  c #C1C1C1",
"/  c #C0C0C0",
"(  c #BDBDBC",
"_  c #B5B5B5",
":  c #A4A4A3",
"<  c #F0F0F0",
"[  c #F4F4F4",
"}  c #ABABAB",
"|  c #050505",
"1  c #FEFEFE",
"2  c #FDFDFD",
"3  c #FCFCFB",
"4  c #FBFBFB",
"5  c #F2F2F2",
"6  c #9E9E9E",
"7  c #BFBFBE",
"8  c #BEBEBE",
"9  c #BEBEBD",
"0  c #B9B9B9",
"a  c #A1A1A0",
"b  c #B9B7B6",
"c  c #828280",
"d  c #FBE73B",
"e  c #F2B64D",
"f  c #FAFAF9",
"g  c #F8F8F7",
"h  c #F8F7F6",
"i  c #F3F2F1",
"j  c #E0E0DF",
"k  c #DBD9D7",
"l  c #FCEB3D",
"m  c #F7B544",
"n  c #5D502B",
"o  c #BCBCBB",
"p  c #BCBBBB",
"q  c #BBBBBA",
"r  c #BBBBB9",
"s  c #B9B8B8",
"t  c #B7B6B5",
"u  c #B5B4B3",
"v  c #FCE93B",
"w  c #F7B545",
"x  c #6C5F34",
"y  c #F7F6F5",
"z  c #F6F6F4",
"A  c #F5F4F3",
"B  c #F4F3F2",
"C  c #FAE43A",
"D  c #F4B244",
"E  c #615738",
"F  c #BAB9B8",
"G  c #B8B8B7",
"H  c #B8B8B6",
"I  c #B4B4B3",
"J  c #F9DF39",
"K  c #F3AF42",
"L  c #5D5232",
"M  c #6F6B63",
"N  c #F6F5F4",
"O  c #F5F5F3",
"P  c #F3F3F1",
"Q  c #F2F2F0",
"R  c #F1F1EF",
"S  c #F0EFED",
"T  c #F9DC38",
"U  c #EFB44D",
"V  c #665A32",
"W  c #9B9997",
"X  c #7C786F",
"Y  c #B6B6B5",
"Z  c #B5B5B4",
"`  c #B6B5B4",
" . c #F8D837",
".. c #F0A93F",
"+. c #655930",
"@. c #767673",
"#. c #ADACA9",
"$. c #908A81",
"%. c #F0F0EE",
"&. c #EFEFED",
"*. c #F1F0EE",
"=. c #F6D236",
"-. c #EDA43E",
";. c #5B5230",
">. c #9B9A98",
",. c #ADACAA",
"'. c #C6C4C2",
"). c #9E998E",
"!. c #B5B5B3",
"~. c #B5B4B2",
"{. c #B4B3B2",
"]. c #B3B2B1",
"^. c #AEADAC",
"/. c #D7AE74",
"(. c #61562F",
"_. c #757473",
":. c #9A9A97",
"<. c #DAD9D5",
"[. c #9F9A8E",
"}. c #EDEDEB",
"|. c #EDECEA",
"1. c #ECEBE9",
"2. c #EBEAE8",
"3. c #E6E5E2",
"4. c #4F4115",
"5. c #ADABA9",
"6. c #B9B8B5",
"7. c #D1D0CD",
"8. c #D8D7D3",
"9. c #DBDAD6",
"0. c #A19B90",
"a. c #B1B0AE",
"b. c #B0AFAE",
"c. c #B0AFAD",
"d. c #AFAEAC",
"e. c #A8A7A5",
"f. c #C1C0BD",
"g. c #C2C2BE",
"h. c #CECDC9",
"i. c #D2D1CE",
"j. c #DCDBD7",
"k. c #E7E6E3",
"l. c #E5E4E1",
"m. c #E4E2DF",
"n. c #E0DFDB",
"o. c #DDDBD9",
"p. c #DEDDD9",
"q. c #D5D4D1",
"r. c #D9D8D4",
"s. c #DBD9D5",
"t. c #D9D7D3",
"u. c #9F998D",
"v. c #E4E3E0",
"w. c #E3E2DF",
"x. c #E3E2DE",
"y. c #E4E3DF",
"z. c #DDDCD8",
"A. c #DCDAD6",
"B. c #D8D6D2",
"C. c #9E988D",
"D. c #EDEDED",
"E. c #E1E0DD",
"F. c #E1DFDC",
"G. c #E1E0DC",
"H. c #E2E1DD",
"I. c #DFDEDA",
"J. c #DEDCD8",
"K. c #D8D6D1",
"L. c #D7D5D1",
"M. c #9D978B",
"N. c #D1D1D1",
"O. c #E1DFDB",
"P. c #E0DEDA",
"Q. c #DFDDD9",
"R. c #DDDBD7",
"S. c #D7D6D1",
"T. c #D5D3CE",
"U. c #9B958A",
"V. c #999891",
"W. c #A39E92",
"X. c #A49E93",
"Y. c #A39D92",
"Z. c #A39D91",
"`. c #A19C90",
" + c #A29C90",
".+ c #A19B8F",
"++ c #9D978C",
"@+ c #9B968A",
"#+ c #676359",
"                                                ",
"    . . . . . . . . . . . . . . + @ #           ",
"    . $ % & & & & & & & & * = = - ; > ,         ",
"    . % & & & & & & & & & & = ' ) ! & ~ {       ",
"    . & & ] ] ] ] ] ^ ] ^ / ( _ : < & [ } |     ",
"    . & & & & & 1 2 3 2 3 4 = 5 6 . . . . .     ",
"    . & & ] ^ / 7 8 9 8 9 ( ( 0 a b c . d e .   ",
"    . & 1 2 3 4 f = g = g h = i j k . l m n .   ",
"    . & 3 8 9 ( o p q p q r s t u . v w x .     ",
"    . & f = g h y z A z A B B i . C D E . .     ",
"    . & g p q r F s G s G H I . J K L . M .     ",
"    . & N O B B P Q R Q R S . T U V . W X .     ",
"    . & B G H Y Z t ` t u .  ...+.. @.#.$..     ",
"    . & B i Q %.&.*.S S . =.-.;.. >.,.'.)..     ",
"    . & %.Z Z !.~.{.].^.. /.(.. _.c :.<.[..     ",
"    . & }.|.1.1.1.2.3.. 4.. . 5.6.7.8.9.0..     ",
"    . & 2.a.a.b.c.d.e.. . f.g.h.i.8.9.j.0..     ",
"    . & k.3.3.3.l.m.n.o.p.q.<.r.9.<.s.t.u..     ",
"    . * v.w.x.m.y.n.p.<.8.<.z.j.A.A.t.B.C..     ",
"    . D.E.F.G.n.H.I.I.9.j.z.J.A.A.t.K.L.M..     ",
"    . N.O.P.I.p.n.p.Q.j.J.R.J.A.A.B.S.T.U..     ",
"    . V.W.X.Y.Z.Y.`. +`. +.+0.u.u.++++@+#+.     ",
"    . . . . . . . . . . . . . . . . . . . .     ",
"                                                "};
#endif /* not GTK_CHECK_VERSION(2,6,0) */


/* XPM */
const gchar *search16_xpm[] = {
"16 16 90 1",
"   c None",
".  c #000000",
"+  c #E4E5DF",
"@  c #D5D6CB",
"#  c #D6D7CA",
"$  c #A3A39D",
"%  c #F5F6F0",
"&  c #8D907B",
"*  c #92957E",
"=  c #90937D",
"-  c #979B84",
";  c #6D705F",
">  c #EAECDB",
",  c #8A8C7D",
"'  c #8E917B",
")  c #91947F",
"!  c #8B8E7A",
"~  c #999B87",
"{  c #919480",
"]  c #989B86",
"^  c #B1B4A2",
"/  c #A2A394",
"(  c #F7F7F7",
"_  c #878A75",
":  c #666858",
"<  c #4B4D3F",
"[  c #4D4F40",
"}  c #404135",
"|  c #424337",
"1  c #434437",
"2  c #404236",
"3  c #3C3D32",
"4  c #48493C",
"5  c #1A1A16",
"6  c #C6C6BE",
"7  c #848672",
"8  c #25261F",
"9  c #F1F2E9",
"0  c #DDE0C7",
"a  c #D6DABB",
"b  c #CDD2AC",
"c  c #C7CCA7",
"d  c #989C80",
"e  c #C6C7BE",
"f  c #5F6152",
"g  c #888980",
"h  c #6F725D",
"i  c #292A23",
"j  c #040404",
"k  c #5B5D4C",
"l  c #878A70",
"m  c #9FA19A",
"n  c #EFF0E5",
"o  c #B1B695",
"p  c #262626",
"q  c #C5C5C5",
"r  c #EEEEEE",
"s  c #EDEDED",
"t  c #ABABAB",
"u  c #464646",
"v  c #80817B",
"w  c #96968D",
"x  c #E3E5D1",
"y  c #878787",
"z  c #F1F1F1",
"A  c #FEFEFE",
"B  c #FDFDFD",
"C  c #FCFCFC",
"D  c #EAEAEA",
"E  c #707070",
"F  c #97998D",
"G  c #EDEFE2",
"H  c #FBFBFB",
"I  c #E8E8E8",
"J  c #767671",
"K  c #E7E9DA",
"L  c #D1D3BD",
"M  c #262620",
"N  c #B0B0B0",
"O  c #FFFFFF",
"P  c #FAFAFA",
"Q  c #A4A4A4",
"R  c #E5E5E5",
"S  c #E4E4E4",
"T  c #F9F9F9",
"U  c #BABABA",
"V  c #E7E7E7",
"W  c #858585",
"X  c #E3E3E3",
"Y  c #6D6D6D",
"  ....          ",
" .+@#$.         ",
".%&*=-;.....    ",
".>,')!~{]{^/.   ",
".(_:<[}||12345  ",
".67890abbbbbcd. ",
".efg0bbhijjikl. ",
".m8naoipqrstu.  ",
".vwxbiyzAABCDE. ",
".FGbhuzAAAABHIu ",
".JKLMNAAOAABCPQ.",
" ....rABAAAOOPR.",
"    .sBOOOOOAPS.",
"    .tCBBBCHPTU.",
"     uDHCHHPTVu ",
"     .WIPPPTXY. "};


/* XPM */
const gchar *search24_xpm[] = {
"24 24 99 2",
"   c None",
".  c #000000",
"+  c #E4E5DF",
"@  c #D5D6CB",
"#  c #D6D7CA",
"$  c #A3A39D",
"%  c #F5F6F0",
"&  c #8D907B",
"*  c #92957E",
"=  c #90937D",
"-  c #979B84",
";  c #6D705F",
">  c #EAECDB",
",  c #8A8C7D",
"'  c #8E917B",
")  c #91947F",
"!  c #8B8E7A",
"~  c #999B87",
"{  c #919480",
"]  c #989B86",
"^  c #B1B4A2",
"/  c #A2A394",
"(  c #F7F7F7",
"_  c #878A75",
":  c #666858",
"<  c #4B4D3F",
"[  c #4D4F40",
"}  c #404135",
"|  c #424337",
"1  c #434437",
"2  c #404236",
"3  c #3C3D32",
"4  c #48493C",
"5  c #1A1A16",
"6  c #C6C6BE",
"7  c #848672",
"8  c #25261F",
"9  c #F1F2E9",
"0  c #DDE0C7",
"a  c #D6DABB",
"b  c #CDD2AC",
"c  c #C7CCA7",
"d  c #989C80",
"e  c #C6C7BE",
"f  c #5F6152",
"g  c #888980",
"h  c #A7AB8C",
"i  c #878A70",
"j  c #9FA19A",
"k  c #EFF0E5",
"l  c #9EA284",
"m  c #80817B",
"n  c #96968D",
"o  c #E3E5D1",
"p  c #6F725D",
"q  c #1A1B16",
"r  c #97998D",
"s  c #EDEFE2",
"t  c #B1B695",
"u  c #292A23",
"v  c #262626",
"w  c #C5C5C5",
"x  c #EEEEEE",
"y  c #EDEDED",
"z  c #ABABAB",
"A  c #464646",
"B  c #767671",
"C  c #E7E9DA",
"D  c #D1D3BD",
"E  c #BBBF9D",
"F  c #262620",
"G  c #878787",
"H  c #F1F1F1",
"I  c #FEFEFE",
"J  c #FDFDFD",
"K  c #FCFCFC",
"L  c #EAEAEA",
"M  c #707070",
"N  c #FBFBFB",
"O  c #E8E8E8",
"P  c #B0B0B0",
"Q  c #FFFFFF",
"R  c #FAFAFA",
"S  c #A4A4A4",
"T  c #E5E5E5",
"U  c #E4E4E4",
"V  c #F9F9F9",
"W  c #BABABA",
"X  c #E7E7E7",
"Y  c #858585",
"Z  c #E3E3E3",
"`  c #6D6D6D",
" . c #A1A1A1",
".. c #202020",
"+. c #686868",
"@. c #343434",
"#. c #797979",
"$. c #3A3A3A",
"%. c #1F1F1F",
"    . . . .                                     ",
"  . + @ # $ .                                   ",
". % & * = - ; . . . . .                         ",
". > , ' ) ! ~ { ] { ^ / .                       ",
". ( _ : < [ } | | 1 2 3 4 5                     ",
". 6 7 8 9 0 a b b b b b c d .                   ",
". e f g 0 b b b b b b b h i .                   ",
". j 8 k a b b b b b b b l .                     ",
". m n o b b b b b b b p q . . .                 ",
". r s b b b b b b t u v w x y z A .             ",
". B C D E E E E E F G H I I J K L M .           ",
"  . . . . . . . . A H I I I I J N O A           ",
"                . P I I Q I I J K R S .         ",
"                . x I J I I I Q Q R T .         ",
"                . y J Q Q Q Q Q I R U .         ",
"                . z K J J J K N R V W .         ",
"                  A L N K N N R V X A           ",
"                  . Y O R R R V Z ` .           ",
"                    . A S T U  .A . . . .       ",
"                        . . . .     ..... .     ",
"                                    . +.@.. .   ",
"                                      . #.$.. . ",
"                                        . +.%.. ",
"                                          . .   "};


#if ! GTK_CHECK_VERSION(2,10,0)
/* XPM */
const gchar *select_all16_xpm[] = {
"16 16 42 1",
"   c None",
".  c #000000",
"+  c #FEFEFE",
"@  c #FDFDFD",
"#  c #E0E0E0",
"$  c #C1C1C1",
"%  c #F1F1F1",
"&  c #C3C3C3",
"*  c #FBFBFB",
"=  c #A8A8A8",
"-  c #494066",
";  c #ADADAD",
">  c #767676",
",  c #5D5D5D",
"'  c #404040",
")  c #FFFFFF",
"!  c #E2E2E2",
"~  c #858585",
"{  c #4B4B49",
"]  c #161616",
"^  c #EEEEEE",
"/  c #C5C5C5",
"(  c #EFEFEF",
"_  c #ECECEC",
":  c #C4C4C4",
"<  c #EBEBEB",
"[  c #EDEDED",
"}  c #EAEAEA",
"|  c #E8E8E8",
"1  c #C0C0C0",
"2  c #E7E7E7",
"3  c #BFBFBF",
"4  c #E5E5E5",
"5  c #BEBEBE",
"6  c #E6E6E6",
"7  c #E4E4E4",
"8  c #BDBDBD",
"9  c #E3E3E3",
"0  c #BBBBBB",
"a  c #C2C2C2",
"b  c #BCBCBC",
"c  c #A0A0A0",
"  .........     ",
" .++++++@#$.    ",
" .+%%%%%%&*=.   ",
" .+%-----;>,'.  ",
" .+%-)))-!~{].  ",
" .+%-------^/.  ",
" .+(-)-)))-_:.  ",
" .@^-------<&.  ",
" .@[-))-))-}$.  ",
" .@<-------|1.  ",
" .@}-)-)))-23.  ",
" .@|-------45.  ",
" .@2266644778.  ",
" .@6444779990.  ",
" .a888bb0000c.  ",
"  ...........   "};


/* XPM */
const gchar *select_all24_xpm[] = {
"24 24 91 1",
"   c None",
".  c #000000",
"+  c #0E0E0E",
"@  c #282828",
"#  c #616161",
"$  c #D3D3D3",
"%  c #F6F6F6",
"&  c #FFFFFF",
"*  c #F9F9F9",
"=  c #F9F9F8",
"-  c #E7E7E7",
";  c #E4E4E4",
">  c #CDCDCD",
",  c #1F1F1F",
"'  c #EFEFEE",
")  c #AFAFAE",
"!  c #E9E9E9",
"~  c #B3B3B3",
"{  c #383838",
"]  c #494066",
"^  c #EEEEEE",
"/  c #A4A4A3",
"(  c #F0F0F0",
"_  c #F4F4F4",
":  c #ABABAB",
"<  c #050505",
"[  c #F2F2F2",
"}  c #9E9E9E",
"|  c #D4D4D3",
"1  c #B9B7B6",
"2  c #838381",
"3  c #848381",
"4  c #6A6763",
"5  c #FEFEFE",
"6  c #F3F2F1",
"7  c #E0E0DF",
"8  c #DCDAD8",
"9  c #CACAC8",
"0  c #B6B6B4",
"a  c #72706C",
"b  c #FCFCFB",
"c  c #C4C3C0",
"d  c #817D74",
"e  c #FAFAF9",
"f  c #E1DFDC",
"g  c #8B867D",
"h  c #F8F8F7",
"i  c #A49E93",
"j  c #F6F5F4",
"k  c #F4F3F2",
"l  c #F0F0EE",
"m  c #E0DFDB",
"n  c #A19C90",
"o  c #EDEDEB",
"p  c #DDDCD8",
"q  c #A19B90",
"r  c #EBEAE8",
"s  c #DCDBD7",
"t  c #E7E6E3",
"u  c #D9D7D3",
"v  c #9F998D",
"w  c #E4E3E0",
"x  c #D8D6D2",
"y  c #9E988D",
"z  c #EDEDED",
"A  c #E1E0DD",
"B  c #E1E0DC",
"C  c #E2E1DD",
"D  c #DFDEDA",
"E  c #E0DEDA",
"F  c #DDDBD7",
"G  c #DCDAD6",
"H  c #D8D6D1",
"I  c #D7D5D1",
"J  c #9D978B",
"K  c #D1D1D1",
"L  c #E1DFDB",
"M  c #DEDDD9",
"N  c #DEDCD8",
"O  c #D7D6D1",
"P  c #D5D3CE",
"Q  c #9B958A",
"R  c #999891",
"S  c #A39E92",
"T  c #A39D92",
"U  c #A39D91",
"V  c #A29C90",
"W  c #A19B8F",
"X  c #9D978C",
"Y  c #9B968A",
"Z  c #676359",
"                        ",
"   .............+@#     ",
"  .$%&&&&&&&&*==-;>,    ",
"  .%&&&&&&&&&&=')!&~{   ",
"  .&&]]]]]]]]]=^/(&_:<  ",
"  .&&]&&]&&&&]=[}.....  ",
"  .&&]]]]]]]]]=_|1234.  ",
"  .&5]&&&&]&&]=67890a.  ",
"  .&b]]]]]]]]]]]]]]cd.  ",
"  .&e]&&&&&&]&&&]&]fg.  ",
"  .&h]]]]]]]]]]]]]]fi.  ",
"  .&j]&&&&&&&]&&&&]fi.  ",
"  .&k]]]]]]]]]]]]]]fi.  ",
"  .&k]&&&]&&]&&&&]]fi.  ",
"  .&l]]]]]]]]]]]]]]mn.  ",
"  .&o]&&&&&]&&&&]&]pq.  ",
"  .&r]]]]]]]]]]]]]]sq.  ",
"  .&t]&&&&&&]&&&&&]uv.  ",
"  .*w]]]]]]]]]]]]]]xy.  ",
"  .zAfBmCmBmBDEFGuHIJ.  ",
"  .KLEDMmMEMENNGGxOPQ.  ",
"  .RSiTUTnVnVWqvvXXYZ.  ",
"   ..................   ",
"                        "};
#endif /* not GTK_CHECK_VERSION(2,10,0) */


/* XPM */
const gchar *genre16_xpm[] = {
"16 16 87 1",
"   c None",
".  c #000000",
"+  c #FEFEFE",
"@  c #DADADA",
"#  c #CBCBCB",
"$  c #FDFDFD",
"%  c #E0E0E0",
"&  c #C1C1C1",
"*  c #F1F1F1",
"=  c #CAC8C1",
"-  c #BBBBBB",
";  c #C3C3C3",
">  c #FBFBFB",
",  c #A8A8A8",
"'  c #B1B1B1",
")  c #EBEBE8",
"!  c #EBEBEB",
"~  c #ADADAD",
"{  c #767676",
"]  c #5D5D5D",
"^  c #D8D8D8",
"/  c #F9F8F8",
"(  c #CCCCCC",
"_  c #E2E2E2",
":  c #858585",
"<  c #3D3D3C",
"[  c #D2D0CC",
"}  c #F7F7F7",
"|  c #DEDBD6",
"1  c #A9A9A9",
"2  c #EFEFEF",
"3  c #848484",
"4  c #737373",
"5  c #D3D2CF",
"6  c #E3E2E1",
"7  c #DFDEDC",
"8  c #DBDAD7",
"9  c #A4A19C",
"0  c #656565",
"a  c #292929",
"b  c #838383",
"c  c #C4C4C4",
"d  c #F3F3F3",
"e  c #1D1D1D",
"f  c #D2D1D0",
"g  c #50504F",
"h  c #EDEDED",
"i  c #ECECEC",
"j  c #111111",
"k  c #3D3D3D",
"l  c #494746",
"m  c #DEDEDE",
"n  c #BFBFBF",
"o  c #363636",
"p  c #C8C7C6",
"q  c #6C6967",
"r  c #708295",
"s  c #CFD6DD",
"t  c #7C91A7",
"u  c #E8E8E8",
"v  c #D6D5D5",
"w  c #8A8784",
"x  c #7D8C9C",
"y  c #788DA4",
"z  c #7F99B3",
"A  c #1F272F",
"B  c #E6E6E6",
"C  c #ECEBEA",
"D  c #72706D",
"E  c #8D99A5",
"F  c #748AA2",
"G  c #849EB9",
"H  c #4D5F73",
"I  c #E5E5E5",
"J  c #E4E4E4",
"K  c #D5D4D3",
"L  c #6B6A69",
"M  c #7D91A7",
"N  c #849EBA",
"O  c #D9D9D9",
"P  c #E3E3E3",
"Q  c #DCDCDC",
"R  c #525252",
"S  c #66798F",
"T  c #ACACAC",
"U  c #BCBCBC",
"V  c #A0A0A0",
"  .........     ",
" .++@.#+$%&.  . ",
" .+*.=.-*;>,..'.",
" .+**.).!~{].^. ",
" ..**./.(_:<..  ",
" .[..}|.123.4.  ",
" ..56789.0abc.  ",
" .d.e..fg.0!;.  ",
" .$hiiijkl.mn.  ",
" .$!...o.pq.'.  ",
" .$.rst.u.vw..  ",
" ..xsyzAB(.CD.  ",
" .EsFGH.IIJ.KL. ",
" .sMNH.OJPPQ.fR ",
" .MSH.TU----V.. ",
" ............   "};


/* XPM */
const gchar *genre24_xpm[] = {
"24 24 218 2",
"   c None",
".  c #000000",
"+  c #BAB5AB",
"@  c #D0CDC6",
"#  c #88857D",
"$  c #D2D2D2",
"%  c #ECECEC",
"&  c #DFDFDF",
"*  c #C9C6BE",
"=  c #CCC8C1",
"-  c #F8F8F8",
";  c #FEFEFE",
">  c #F9F9F9",
",  c #DADADA",
"'  c #585858",
")  c #F4F4F4",
"!  c #E9E9E9",
"~  c #D1D1D1",
"{  c #E5E3E0",
"]  c #D5D5D5",
"^  c #FDFDFD",
"/  c #FFFFFF",
"(  c #C7C7C7",
"_  c #D6D6D6",
":  c #757575",
"<  c #7B7B7B",
"[  c #F2F2F2",
"}  c #E1E1E1",
"|  c #2E2E2E",
"1  c #F6F5F5",
"2  c #929292",
"3  c #C0C0C0",
"4  c #EFEFEF",
"5  c #CCCCCC",
"6  c #AFAFAF",
"7  c #D3D1CB",
"8  c #909090",
"9  c #C1C0BF",
"0  c #F0EFED",
"a  c #9B9A96",
"b  c #5A5A5A",
"c  c #F3F3F2",
"d  c #FAFAFA",
"e  c #AFAFAE",
"f  c #DCDCDC",
"g  c #A5A19C",
"h  c #EAE9E5",
"i  c #F3F1F0",
"j  c #ECECEB",
"k  c #F7F7F6",
"l  c #A4A4A3",
"m  c #EDEDED",
"n  c #202020",
"o  c #A19D96",
"p  c #C1BDB4",
"q  c #DBD8D3",
"r  c #D9D6D1",
"s  c #89857E",
"t  c #F0EFEE",
"u  c #9C9C9C",
"v  c #EBEBEB",
"w  c #AAAAAA",
"x  c #636363",
"y  c #121212",
"z  c #EAE9E6",
"A  c #F5F4F3",
"B  c #C6C2BA",
"C  c #939391",
"D  c #848383",
"E  c #646363",
"F  c #5F5C54",
"G  c #EAEAEA",
"H  c #D7D7D6",
"I  c #CCCCCB",
"J  c #C7C7C6",
"K  c #C7C6C5",
"L  c #C2C1C1",
"M  c #F4F4F3",
"N  c #CBC7C0",
"O  c #AEADAC",
"P  c #B5B5B3",
"Q  c #BBBAB8",
"R  c #A9A8A6",
"S  c #86827A",
"T  c #EDEDEC",
"U  c #E8E7E6",
"V  c #E4E3E2",
"W  c #E2E2E0",
"X  c #DAD9D8",
"Y  c #A6A5A4",
"Z  c #D3D2D0",
"`  c #CFCECD",
" . c #C3C2C1",
".. c #8F8A81",
"+. c #F3F3F1",
"@. c #F2F1F0",
"#. c #E9E9E7",
"$. c #D9D9D7",
"%. c #C3C3C2",
"&. c #676560",
"*. c #54524D",
"=. c #C0BFBD",
"-. c #E1E0DD",
";. c #D2D1CE",
">. c #8D887E",
",. c #F4F3F2",
"'. c #F3F2F1",
"). c #F1F1EF",
"!. c #777676",
"~. c #797978",
"{. c #85827E",
"]. c #79756F",
"^. c #AFAEAC",
"/. c #DFDDDA",
"(. c #979288",
"_. c #7590AE",
":. c #A4BAD0",
"<. c #90A6BE",
"[. c #908F8E",
"}. c #9F9F9E",
"|. c #BEBDBC",
"1. c #B8B4AD",
"2. c #87837C",
"3. c #9C9A98",
"4. c #A29C91",
"5. c #EFEFED",
"6. c #D3DFEA",
"7. c #A2AEBC",
"8. c #9DB6CE",
"9. c #637B95",
"0. c #AAA9A7",
"a. c #A5A4A3",
"b. c #E2E2E2",
"c. c #EEEEED",
"d. c #636059",
"e. c #849CB6",
"f. c #D7E2ED",
"g. c #8D98A5",
"h. c #9DB8D2",
"i. c #607791",
"j. c #B7B6B4",
"k. c #C3C2C0",
"l. c #B9B9B6",
"m. c #99ADC3",
"n. c #DFE7F0",
"o. c #8193A9",
"p. c #586D84",
"q. c #5B7189",
"r. c #D0CECB",
"s. c #CCCBC8",
"t. c #BAB9B5",
"u. c #F1F1F1",
"v. c #EEEDEB",
"w. c #A7A6A5",
"x. c #726F6A",
"y. c #A1B4C8",
"z. c #EEF3F6",
"A. c #60768F",
"B. c #B1B0AD",
"C. c #C1C1BD",
"D. c #D6D5D1",
"E. c #DAD9D5",
"F. c #CACAC6",
"G. c #B5B5B1",
"H. c #DEDDDC",
"I. c #787776",
"J. c #4E4E4D",
"K. c #91A6BE",
"L. c #F0F4F7",
"M. c #97A5B6",
"N. c #898886",
"O. c #BAB9B6",
"P. c #CECDC9",
"Q. c #DBDAD6",
"R. c #DFDEDA",
"S. c #D7D6D3",
"T. c #C8C6C2",
"U. c #B4B2AF",
"V. c #BFBEBD",
"W. c #AAAAA9",
"X. c #ACACAB",
"Y. c #B0C6DB",
"Z. c #EDF2F6",
"`. c #818A95",
" + c #6B6A68",
".+ c #B6B5B2",
"++ c #C8C7C3",
"@+ c #D9D8D4",
"#+ c #DEDDD9",
"$+ c #E0DEDA",
"%+ c #DCDAD6",
"&+ c #D5D4D0",
"*+ c #C4C2BF",
"=+ c #B1AFAB",
"-+ c #6C85A1",
";+ c #C0D1E2",
">+ c #545352",
",+ c #B2B1AE",
"'+ c #C5C3C0",
")+ c #D3D2CE",
"!+ c #DEDCD8",
"~+ c #DBD9D5",
"{+ c #D2D0CC",
"]+ c #C3C2BE",
"^+ c #B2B1AC",
"/+ c #7D7870",
"(+ c #3D3B36",
"_+ c #827D74",
":+ c #8C887D",
"<+ c #999388",
"[+ c #9F9A8E",
"}+ c #A29C90",
"|+ c #A19B8F",
"1+ c #A19B90",
"2+ c #9F998D",
"3+ c #9C968B",
"4+ c #928D82",
"5+ c #5F5C52",
"            . .                                 ",
"      . . . + @ # . . . . . . .                 ",
"    . $ % & . * = + . - ; > , ' .     . .       ",
"    . ) - ! ~ . { * . ] ^ / ( ~ _ . . / : .     ",
"    . . < [ } | 1 * . 2 > ^ 3 } 4 . / 5 6 .     ",
"    . 7 8 . . 9 0 + a b c d e ! ^ . f 6 .       ",
"    . g = = h i + + + . j k l 4 . m . . .       ",
"    . n o p = * q r + s . t u . v . . . . .     ",
"    . w x . . . y z A B s . . 5 . C D E F .     ",
"    . G H I J K L . t M N . 6 . O P Q R S .     ",
"    . > T U V W X J . j . 6 . . Y Z `  ....     ",
"    . ; A +.@.t #.$.%.. 6 . &.*.. =.-.;.>..     ",
"    . / ,.'.).. . . . 6 . !.~.{.].. ^./.(..     ",
"    . / ,.@.. _.:.<.. . [.. }.|.1.2.. 3.4..     ",
"    . / 5.. _.6.7.8.9.. 0.a.. b.c.N s . d..     ",
"    . ; . e.f.g.9.h.i.. j.k.l.. T i * s . .     ",
"    . . m.n.o.p.h._.q.. Q r.s.t.. u.v.w.x.. .   ",
"    . y.z.o.A.h._.q.. B.C.D.E.F.G.. H.I.J.6 .   ",
"  . K.L.M.A.h._.q.. N.O.P.Q.R.S.T.U.. V.W.X..   ",
"  . Y.Z.`.h._.q..  +.+++@+#+$+%+&+*+=+. . .     ",
"  . -+h.;+K.q.. >+,+'+)+!+!+!+%+~+{+]+^+/+.     ",
"    . -+-+9.. (+_+:+<+[+}+|+1+2+2+3+<+4+5+.     ",
"    . . . . . . . . . . . . . . . . . . .       ",
"                                                "};


/* XPM */
const gchar *character16_xpm[] = {
"16 16 40 1",
"   c None",
".  c #000000",
"+  c #BFBFBF",
"@  c #F5F5F5",
"#  c #F6F6F6",
"$  c #F7F7F7",
"%  c #F8F8F8",
"&  c #F9F9F9",
"*  c #B9B9B9",
"=  c #E1E1E1",
"-  c #E2E2E2",
";  c #E3E3E3",
">  c #E4E4E4",
",  c #E5E5E5",
"'  c #E7E7E7",
")  c #E8E8E8",
"!  c #E9E9E9",
"~  c #EAEAEA",
"{  c #EBEBEB",
"]  c #EDEDED",
"^  c #EEEEEE",
"/  c #EFEFEF",
"(  c #6D6D6D",
"_  c #6F6F6F",
":  c #707070",
"<  c #717171",
"[  c #727272",
"}  c #F0F0F0",
"|  c #F1F1F1",
"1  c #737373",
"2  c #F3F3F3",
"3  c #F4F4F4",
"4  c #767676",
"5  c #747474",
"6  c #757575",
"7  c #FAFAFA",
"8  c #FBFBFB",
"9  c #FCFCFC",
"0  c #BEBEBE",
"a  c #C1C1C1",
" .............  ",
" +@@####$$%%&&* ",
".@=-;>,')!~{]^/.",
".@-(..._::<[[/}.",
".#;..'..~{]^/}|.",
".#>.....<[[11|2.",
".#,..!..]^/}|23.",
".#'..:.......3@.",
".$)!~{]^/}...@#.",
".$!:<[[11...4#$.",
".%~{]^/}...@#$&.",
".&][1156.....78.",
".&^/}|23@#$&789.",
".0/}|23@#$&789a ",
"  ............  ",
"                "};


/* XPM */
const gchar *character24_xpm[] = {
"24 24 56 1",
"   c None",
".  c #000000",
"+  c #E2E2E2",
"@  c #F2F2F2",
"#  c #F3F3F3",
"$  c #F4F4F4",
"%  c #F5F5F5",
"&  c #F6F6F6",
"*  c #F7F7F7",
"=  c #DBDBDB",
"-  c #F0F0F0",
";  c #E0E0E0",
">  c #E1E1E1",
",  c #E3E3E3",
"'  c #E4E4E4",
")  c #E5E5E5",
"!  c #E6E6E6",
"~  c #E7E7E7",
"{  c #E8E8E8",
"]  c #E9E9E9",
"^  c #EAEAEA",
"/  c #EBEBEB",
"(  c #ECECEC",
"_  c #EDEDED",
":  c #EEEEEE",
"<  c #EFEFEF",
"[  c #868686",
"}  c #878787",
"|  c #888888",
"1  c #898989",
"2  c #8A8A8A",
"3  c #8B8B8B",
"4  c #8C8C8C",
"5  c #8D8D8D",
"6  c #8E8E8E",
"7  c #F1F1F1",
"8  c #8F8F8F",
"9  c #909090",
"0  c #919191",
"a  c #929292",
"b  c #F8F8F8",
"c  c #939393",
"d  c #F9F9F9",
"e  c #FAFAFA",
"f  c #949494",
"g  c #959595",
"h  c #FBFBFB",
"i  c #FCFCFC",
"j  c #FDFDFD",
"k  c #969696",
"l  c #FEFEFE",
"m  c #FFFFFF",
"n  c #979797",
"o  c #989898",
"p  c #C9C9C9",
"q  c #BDBDBD",
" ....................   ",
".+@@@@###$$$%%%&&**$=.  ",
".-;;>+,')!~{{]^/(_:<_.  ",
".@>[[}}|11223344556-7.  ",
".@+,,....{]^/((_:<-7@.  ",
".#,}..11..344555688@#.  ",
".#')..~{../(_:<<-7@#$.  ",
".#)1......455688899$%.  ",
".$!~..^^.._:<-7@##$%&.  ",
".$~2..44..5688990aa&*.  ",
".%{]^/(_::<-7@#$%&**b.  ",
".%]344556888......cbd.  ",
".%^/(_:<-7@@#$%...dee.  ",
".&/4556889900a...fghi.  ",
".*__:<-7@#$%%...dehij.  ",
".*:6688990aa...fggkjl.  ",
".b-7@@#$%&*b......lmm.  ",
".b79900aaccfggkkknomm.  ",
".@@#$%&&*bdehijlmmmm(.  ",
".p_b%&*bbdehijlmmmm:q.  ",
" ....................   ",
"                        ",
"                        ",
"                        "};


/* XPM */
const gchar *process16_xpm[] = {
"16 16 71 1",
"   c None",
".  c #000000",
"+  c #FEFEFE",
"@  c #FDFDFD",
"#  c #E0E0E0",
"$  c #C1C1C1",
"%  c #F1F1F1",
"&  c #010101",
"*  c #FBFBFB",
"=  c #A8A8A8",
"-  c #CFCFCF",
";  c #0C0C0C",
">  c #C0C0C0",
",  c #060606",
"'  c #DDDCDA",
")  c #040404",
"!  c #5E5E5E",
"~  c #030303",
"{  c #EEEEEE",
"]  c #B2B2B0",
"^  c #484641",
"/  c #9F9D96",
"(  c #888781",
"_  c #050505",
":  c #9D9C98",
"<  c #91908A",
"[  c #908E86",
"}  c #97958E",
"|  c #807D74",
"1  c #BFBFBF",
"2  c #595854",
"3  c #605E57",
"4  c #898883",
"5  c #76746B",
"6  c #090909",
"7  c #43423F",
"8  c #282724",
"9  c #363430",
"0  c #6D6B63",
"a  c #EEEEED",
"b  c #B6B5AF",
"c  c #21201E",
"d  c #0A0908",
"e  c #181816",
"f  c #E6E6E4",
"g  c #65635C",
"h  c #161614",
"i  c #8C8B89",
"j  c #DFDEDC",
"k  c #BBBBBB",
"l  c #0B0B0B",
"m  c #B0AFA9",
"n  c #D5D4D1",
"o  c #93918B",
"p  c #ABA9A3",
"q  c #5D5C55",
"r  c #343434",
"s  c #494943",
"t  c #2A2A2A",
"u  c #C6C6C6",
"v  c #B7B7B7",
"w  c #191919",
"x  c #42413C",
"y  c #181818",
"z  c #B5B5B5",
"A  c #C2C2C2",
"B  c #BDBDBD",
"C  c #BCBCBC",
"D  c #101010",
"E  c #0E0E0E",
"F  c #A0A0A0",
"  .........     ",
" .++++++@#$.    ",
" .+%%%%&&&*=.   ",
" .+-;;>,')!)~.  ",
" .+;{];^/^,(_.  ",
" .+;:<///[}|^.  ",
" .+1;//234|56.  ",
" .&&^/3789/0^.. ",
" .&ab/2cdef|g3. ",
" .&,^/49hijg^.. ",
" .@klm|bfnog6.  ",
" .@lbp/||55q^.  ",
" .@lr26^5^lst.  ",
" .@ullvwxyzl6.  ",
" .ABBBCDEEkkF.  ",
"  ...........   "};


/* XPM */
const gchar *process24_xpm[] = {
"24 24 192 2",
"   c None",
".  c #000000",
"+  c #CECDC9",
"@  c #D3D3D3",
"#  c #F2F2F2",
"$  c #E1E1E0",
"%  c #97958F",
"&  c #898781",
"*  c #8E8C85",
"=  c #838078",
"-  c #929292",
";  c #D9D9D9",
">  c #575757",
",  c #F5F5F5",
"'  c #7B7973",
")  c #67655F",
"!  c #403F3B",
"~  c #686661",
"{  c #7C7A72",
"]  c #CFCFCF",
"^  c #BCBCBC",
"/  c #D6D6D6",
"(  c #FDFDFD",
"_  c #DDDCDB",
":  c #9A9992",
"<  c #53524E",
"[  c #171614",
"}  c #767573",
"|  c #9B9993",
"1  c #52504A",
"2  c #AEAEAE",
"3  c #DEDEDE",
"4  c #F0F0F0",
"5  c #9B9B9B",
"6  c #FCFCFC",
"7  c #7B7A75",
"8  c #86847D",
"9  c #9A9996",
"0  c #B7B6B3",
"a  c #7D7B75",
"b  c #B3B3B3",
"c  c #9B9B9A",
"d  c #E5E5E5",
"e  c #FFFFFF",
"f  c #DFDFDF",
"g  c #8F8F8F",
"h  c #E9E9E9",
"i  c #8B8984",
"j  c #6B6964",
"k  c #78756C",
"l  c #5F5D56",
"m  c #54534D",
"n  c #696969",
"o  c #B8B8B7",
"p  c #939393",
"q  c #EAEAEA",
"r  c #CECECE",
"s  c #A2A2A2",
"t  c #FEFEFE",
"u  c #F4F4F4",
"v  c #42413C",
"w  c #8D8D8C",
"x  c #C4C3C2",
"y  c #010101",
"z  c #F9F9F8",
"A  c #C3C3C2",
"B  c #848483",
"C  c #070707",
"D  c #080808",
"E  c #9C9C9B",
"F  c #050505",
"G  c #E4E3E1",
"H  c #040404",
"I  c #717170",
"J  c #060606",
"K  c #504D47",
"L  c #F1F1F0",
"M  c #E2E2E1",
"N  c #D1D0CF",
"O  c #BABAB9",
"P  c #AFAFAE",
"Q  c #E2E2E2",
"R  c #B3B3B1",
"S  c #484641",
"T  c #9F9D96",
"U  c #888781",
"V  c #1E1E1D",
"W  c #050504",
"X  c #F8F8F7",
"Y  c #F7F6F5",
"Z  c #F4F3F2",
"`  c #ECECEA",
" . c #DFDEDE",
".. c #D8D7D6",
"+. c #0A0A0A",
"@. c #B0AFAD",
"#. c #A8A7A1",
"$. c #908E86",
"%. c #97958E",
"&. c #807D74",
"*. c #050404",
"=. c #F6F5F4",
"-. c #F5F5F3",
";. c #F3F2F1",
">. c #F1F1EF",
",. c #EBEBE9",
"'. c #ACACAA",
"). c #090909",
"!. c #595854",
"~. c #605E57",
"{. c #898883",
"]. c #76746B",
"^. c #484540",
"/. c #F0EFEE",
"(. c #EFEFED",
"_. c #EDEDEB",
":. c #43423F",
"<. c #282724",
"[. c #363430",
"}. c #6D6B63",
"|. c #0A0A09",
"1. c #A9A9A9",
"2. c #A7A7A6",
"3. c #ACACAB",
"4. c #B6B5AF",
"5. c #21201E",
"6. c #0A0908",
"7. c #181816",
"8. c #E6E6E4",
"9. c #65635C",
"0. c #CFCECA",
"a. c #161614",
"b. c #8C8B89",
"c. c #DFDEDC",
"d. c #080707",
"e. c #797978",
"f. c #7D7C7B",
"g. c #B0AFA9",
"h. c #D5D4D1",
"i. c #93918B",
"j. c #4F4C47",
"k. c #D6D5D2",
"l. c #ABA9A3",
"m. c #5D5C55",
"n. c #DBDAD9",
"o. c #222121",
"p. c #494943",
"q. c #1D1D1C",
"r. c #7A7A75",
"s. c #7B7B79",
"t. c #737371",
"u. c #0F0F0F",
"v. c #0E0E0E",
"w. c #6D6C6A",
"x. c #5B5851",
"y. c #5E5E5C",
"z. c #9D9C99",
"A. c #ADACA9",
"B. c #ACABA8",
"C. c #A7A7A4",
"D. c #0C0C0B",
"E. c #0B0B0A",
"F. c #949390",
"G. c #A2A19D",
"H. c #A2A19E",
"I. c #79756B",
"J. c #80807D",
"K. c #B3B1AE",
"L. c #C7C6C2",
"M. c #CCCAC7",
"N. c #C9C8C4",
"O. c #C3C2BE",
"P. c #ADABA8",
"Q. c #A3A19E",
"R. c #AAA8A5",
"S. c #BDBCB8",
"T. c #C1BFBB",
"U. c #8E887E",
"V. c #777671",
"W. c #67635C",
"X. c #6F6B64",
"Y. c #7B776E",
"Z. c #8F8A7F",
"`. c #9B978B",
" + c #A09A8E",
".+ c #9E988C",
"++ c #9B958A",
"@+ c #938D82",
"#+ c #918B81",
"$+ c #979187",
"%+ c #989387",
"&+ c #666258",
"              . . .                             ",
"      . . . . . + . . . . . . .                 ",
"    . @ # . $ % & * = . - ; @ > .               ",
"    . , . . ' ) ! ~ { . . ] ^ ] / .             ",
"    . ( . _ : < [ } | 1 . ^ 2 3 4 5 .           ",
"    . 6 . . 7 8 9 0 a . . b c d e f g .         ",
"    . ( h . i j k l m . n o p q 6 # r s .       ",
"    . t u . . . v . . . w x y . . . . . . .     ",
"    . e z d A . . . B C D E F G H I J F K .     ",
"    . e z L M N O P D Q R D S T S C U V W .     ",
"    . e X Y Z `  ...+.@.#.T T T $.%.&.S *..     ",
"    . e =.-.Z ;.>.,.'.).T T !.~.{.&.].J ^..     ",
"    . e ;./.(._._.y y S T ~.:.<.[.T }.S |..     ",
"    . 1.. . . 2.3.y M 4.T !.5.6.7.8.&.9.~..     ",
"    . . . 0.. . . y H S T {.[.a.b.c.9.S d..     ",
"    . $ % & * = . e.f.C g.&.4.8.h.i.9.J j..     ",
"  . . ' ) ! ~ { . . D k.l.T &.&.].].m.S *..     ",
"  . n.: < [ } | 1 . C o.!.F S ].S J p.q.H .     ",
"  . . r.8 9 0 a . . s.C d.t.u.v v.w.J J x..     ",
"    . i j k l m . y.z.A.B.C.v.D.E.F.G.H.I..     ",
"    . . . v . . . J.K.L.M.N.O.P.Q.R.S.T.U..     ",
"    . V.. . . W.X.Y.Z.`. +.+++@+Z.#+$+%+&+.     ",
"      . . . . . . . . . . . . . . . . . .       ",
"                                                "};


#if ! GTK_CHECK_VERSION(2,6,0)
/* XPM */
const gchar *about16_xpm[] = {
"16 16 15 1",
"   c None",
".  c #000000",
"+  c #EEF63E",
"@  c #EAF13D",
"#  c #F0F83F",
"$  c #CBD235",
"%  c #E9F03D",
"&  c #E5EC3C",
"*  c #E8F03D",
"=  c #ABB02D",
"-  c #ECF33E",
";  c #EFF73F",
">  c #CED636",
",  c #B4BA2F",
"'  c #CDD435",
"                ",
"                ",
"                ",
"                ",
"        .       ",
"       .+.      ",
"     ..@#$..    ",
"    .######%.   ",
"     .####&.    ",
"     .*###=.    ",
"     .#-.;>.    ",
"     .,. .'.    ",
"      .   .     ",
"                ",
"                ",
"                "};


/* XPM */
const gchar *about24_xpm[] = {
"24 24 15 1",
"   c None",
".  c #000000",
"+  c #EEF63E",
"@  c #EAF13D",
"#  c #F0F83F",
"$  c #C9D034",
"%  c #E9F03D",
"&  c #E5EC3C",
"*  c #E8F03D",
"=  c #A9AE2C",
"-  c #ECF33E",
";  c #EFF73F",
">  c #CED636",
",  c #B1B72E",
"'  c #CCD334",
"                        ",
"     .          .       ",
"    .+.        .+.      ",
"  ..@#$..    ..@#$..    ",
" .######%.  .######%.   ",
"  .####&.    .####&.    ",
"  .*###=.    .*###=.    ",
"  .#-.;>.    .#-.;>.    ",
"  .,. .'.    .,. .'.    ",
"   .   .      .   .     ",
"                        ",
"                        ",
"                        ",
"     .          .       ",
"    .+.        .+.      ",
"  ..@#$..    ..@#$..    ",
" .######%.  .######%.   ",
"  .####&.    .####&.    ",
"  .*###=.    .*###=.    ",
"  .#-.;>.    .#-.;>.    ",
"  .,. .'.    .,. .'.    ",
"   .   .      .   .     ",
"                        ",
"                        "};


/* XPM */
const gchar *media_play16_xpm[] = {
"16 16 27 1",
"   c None",
".  c #000000",
"+  c #727170",
"@  c #7B7B7A",
"#  c #6C6B6A",
"$  c #7F7E7D",
"%  c #999996",
"&  c #7D7C7B",
"*  c #828180",
"=  c #9D9C9A",
"-  c #B0AFAC",
";  c #908F8D",
">  c #8C8B89",
",  c #A9A8A5",
"'  c #BDBCB9",
")  c #C5C3C0",
"!  c #D0CECC",
"~  c #FFFFFF",
"{  c #8F8E8C",
"]  c #B5B3B1",
"^  c #C7C6C3",
"/  c #D2D1CE",
"(  c #B9B6B4",
"_  c #D8D7D5",
":  c #A19F9D",
"<  c #C7C6C4",
"[  c #A7A6A3",
"                ",
"     .          ",
"     ..         ",
"     .+.        ",
"     .@#.       ",
"     .$%&.      ",
"     .*=-;.     ",
"     .>,')!.~   ",
"     .{]^/.~    ",
"     .=(_.~     ",
"     .:<.~      ",
"     .[.~       ",
"     ..~        ",
"     .~         ",
"     ~          ",
"                "};


/* XPM */
const gchar *media_play24_xpm[] = {
"24 24 37 1",
"   c None",
".  c #000000",
"+  c #727170",
"@  c #7B7B7A",
"#  c #6C6B6A",
"$  c #7F7E7D",
"%  c #999996",
"&  c #7D7C7B",
"*  c #828180",
"=  c #9D9C9A",
"-  c #B0AFAC",
";  c #908F8D",
">  c #868583",
",  c #A1A09E",
"'  c #B4B3B1",
")  c #B6B4B2",
"!  c #A5A4A1",
"~  c #898886",
"{  c #B9B7B4",
"]  c #BAB9B6",
"^  c #BCBAB7",
"/  c #C3C2BF",
"(  c #FFFFFF",
"_  c #8C8B89",
":  c #A9A8A5",
"<  c #BDBCB9",
"[  c #C5C3C0",
"}  c #D0CECC",
"|  c #8F8E8C",
"1  c #B5B3B1",
"2  c #C7C6C3",
"3  c #D2D1CE",
"4  c #B9B6B4",
"5  c #D8D7D5",
"6  c #A19F9D",
"7  c #C7C6C4",
"8  c #A7A6A3",
"                        ",
"                        ",
"                        ",
"                        ",
"         .              ",
"         ..             ",
"         .+.            ",
"         .@#.           ",
"         .$%&.          ",
"         .*=-;.         ",
"         .>,')!.        ",
"         .~!{]^/.(      ",
"         ._:<[}.(       ",
"         .|123.(        ",
"         .=45.(         ",
"         .67.(          ",
"         .8.(           ",
"         ..(            ",
"         .(             ",
"         (              ",
"                        ",
"                        ",
"                        ",
"                        "};


/* XPM */
const gchar *media_stop16_xpm[] = {
"16 16 29 1",
"   c None",
".  c #000000",
"+  c #FFFFFF",
"@  c #737372",
"#  c #848483",
"$  c #888887",
"%  c #7E7E7D",
"&  c #A8A7A6",
"*  c #A4A4A3",
"=  c #A6A5A4",
"-  c #B5B4B3",
";  c #858483",
">  c #AAA9A7",
",  c #C0BFBE",
"'  c #91908E",
")  c #AFAEAC",
"!  c #CACAC8",
"~  c #A6A5A2",
"{  c #BBBAB7",
"]  c #D4D3D2",
"^  c #AEADA9",
"/  c #BFBDBA",
"(  c #D7D5D3",
"_  c #B2B0AD",
":  c #C3C1BE",
"<  c #D9D8D6",
"[  c #B5B3B0",
"}  c #D1CFCC",
"|  c #DEDDDB",
"                ",
" .............+ ",
" .@#$$$$$$$$$.+ ",
" .%&*********.+ ",
" .%=---------.+ ",
" .;>,,,,,,,,,.+ ",
" .')!!!!!!!!!.+ ",
" .')!!!!!!!!!.+ ",
" .~{]]]]]]]]].+ ",
" .~{]]]]]]]]].+ ",
" .^/(((((((((.+ ",
" ._:<<<<<<<<<.+ ",
" .[}|||||||||.+ ",
" .............+ ",
" ++++++++++++++ ",
"                "};


/* XPM */
const gchar *media_stop24_xpm[] = {
"24 24 29 1",
"   c None",
".  c #000000",
"+  c #FFFFFF",
"@  c #737372",
"#  c #848483",
"$  c #888887",
"%  c #7E7E7D",
"&  c #A8A7A6",
"*  c #A4A4A3",
"=  c #A6A5A4",
"-  c #B5B4B3",
";  c #858483",
">  c #AAA9A7",
",  c #C0BFBE",
"'  c #91908E",
")  c #AFAEAC",
"!  c #CACAC8",
"~  c #A6A5A2",
"{  c #BBBAB7",
"]  c #D4D3D2",
"^  c #AEADA9",
"/  c #BFBDBA",
"(  c #D7D5D3",
"_  c #B2B0AD",
":  c #C3C1BE",
"<  c #D9D8D6",
"[  c #B5B3B0",
"}  c #D1CFCC",
"|  c #DEDDDB",
"                        ",
"                        ",
"                        ",
"                        ",
"                        ",
"     .............+     ",
"     .@#$$$$$$$$$.+     ",
"     .%&*********.+     ",
"     .%=---------.+     ",
"     .;>,,,,,,,,,.+     ",
"     .')!!!!!!!!!.+     ",
"     .')!!!!!!!!!.+     ",
"     .~{]]]]]]]]].+     ",
"     .~{]]]]]]]]].+     ",
"     .^/(((((((((.+     ",
"     ._:<<<<<<<<<.+     ",
"     .[}|||||||||.+     ",
"     .............+     ",
"     ++++++++++++++     ",
"                        ",
"                        ",
"                        ",
"                        ",
"                        "};
#endif /* not GTK_CHECK_VERSION(2,6,0) */
