/*
    Melody maid
    copyright (c) 1998-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "abort.h"


gboolean userbreak;


/******************************************************************************
*                                                                             *
* ja:中断関数群                                                               *
*                                                                             *
******************************************************************************/
/* ja:中断ボタンが押された */
static void
abort_dialog_clicked (GtkWidget *widget,
                      gpointer   user_data)
{
  userbreak = FALSE;
}


/*  ja:中断ダイアログ表示
    text,説明文                                                             */
GtkWidget *
abort_dialog (const gchar *text)
{
  GtkWidget *dialog, *button, *label;

  /* ja:メインウインドウ */
  dialog = gtk_dialog_new_with_buttons
                            (_("Abort"),
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            NULL);
  g_signal_connect (G_OBJECT (dialog), "delete-event",
                                                G_CALLBACK (gtk_true), NULL);
  /* ja:ボタン */
  button = gtk_dialog_add_button (GTK_DIALOG (dialog),
                                        GTK_STOCK_STOP, GTK_RESPONSE_REJECT);
  g_signal_connect (G_OBJECT (button), "clicked",
                                    G_CALLBACK (abort_dialog_clicked), NULL);
  /* ja:ラベル */
  label = gtk_label_new (text);
  gtk_misc_set_padding (GTK_MISC (label), SPACING, SPACING);
  /* ja:フレームとボックス */
  gtk_container_add
    (GTK_CONTAINER (gtk_dialog_get_content_area (GTK_DIALOG (dialog))), label);

  /* ja:表示 */
  gtk_widget_grab_focus (button);
  gtk_widget_show_all (dialog);

  return dialog;
}
