/*
    Melody maid
    copyright (c) 1998-2012 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "command.h"
#include "file.h"
#include "general.h"
#include "mm_list.h"
#include "sigmain.h"
#include "misc/argument.h"
#include "misc/misc.h"
#include "orz/orzhistory.h"
#include "orz/orzmdi.h"
#if GLIB_CHECK_VERSION(2,16,0)
# include <gio/gio.h>
#endif /* GLIB_CHECK_VERSION(2,16,0) */


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(メニュー)                                        *
*                                                                             *
******************************************************************************/
void
signal_activate_menu_history (GtkWidget   *widget,
                              const gchar *file)
{
  file_open_edit (file);
}


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(MDI)                                             *
*                                                                             *
******************************************************************************/
void
signal_close_window (GtkWidget   *widget,
                     guint        page_num,
                     MmaidWindow *mmaid)
{
  if (prompt_close (mmaid))
    gtk_notebook_remove_page (GTK_NOTEBOOK (mdi), page_num);
}


void
signal_switch_window (GtkWidget   *widget,
                      guint        page_num,
                      MmaidWindow *mmaid)
{
  /* ja:メニュー表示 */
  set_menu_bar (mmaid);
}


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(セレクション)                                    *
*                                                                             *
******************************************************************************/
void
signal_drag_data_received (GtkWidget        *widget,
                           GdkDragContext   *context,
                           gint              x,
                           gint              y,
                           GtkSelectionData *data,
                           guint             info,
                           guint             time)
{
  gchar **files;

  files = g_strsplit ((const gchar *)gtk_selection_data_get_data (data),
                                                                    "\r\n", 0);
  if (files)
    {
      gint i;
      MmaidWindow *mmaid;

      i = gtk_notebook_get_current_page (GTK_NOTEBOOK (mdi));
      mmaid = i >= 0 ? orz_mdi_get_data (ORZ_MDI (mdi), i) : NULL;
      for (i = 0; files[i] && *files[i] !='\0'; i++)
        {
#if GLIB_CHECK_VERSION(2,16,0)
          GFile *gfile;

          gfile = g_file_new_for_uri (files[i]);
          if (gfile)
            {
              gchar *file;

              file = g_file_get_path (gfile);
              g_object_unref (gfile);
#else /* not GLIB_CHECK_VERSION(2,16,0) */
          gchar *file;

          file = g_filename_from_uri (files[i], NULL, NULL);
#endif /* not GLIB_CHECK_VERSION(2,16,0) */
              if (file)
                {
                  switch (file_is_type (file))
                    {
                      case FILE_KIND_ERROR:
                      case FILE_KIND_DB:
                      case FILE_KIND_LIST:
                        mmaid = file_open_edit (file);
                        break;
                      case FILE_KIND_UNKNOWN:
                      case FILE_KIND_TAG:
                        {
                          ID3Tag *id3tag;

                          id3tag = file_open_id3tag (file, charset_list);
                          if (id3tag)
                            {
                              if (!mmaid
                                    || mm_list_search (MM_LIST (mmaid->list),
                                        MM_LIST_FILE, id3tag->file, -1) >= 0)
                                mmaid = file_open_edit (NULL);
                              mm_list_append (MM_LIST (mmaid->list), id3tag);
                              orz_mdi_set_edited (ORZ_MDI (mdi),
                                orz_mdi_get_page_from_data (ORZ_MDI (mdi),
                                                                mmaid), TRUE);
                            }
                        }
                    }
                  g_free (file);
                }
#if GLIB_CHECK_VERSION(2,16,0)
            }
#endif /* GLIB_CHECK_VERSION(2,16,0) */
         }
      g_strfreev (files);
    }
}


void
signal_selection_recv (GObject   *object,
                       gchar    **argv,
                       gpointer   user_data)
{
  gboolean *arg_files;
  gint i, array[2], def[2];
  MmaidWindow *mmaid;
  ArgumentBool arg_n, arg_x;
  ArgumentValue arg_h;
  ArgumentArray arg_s;
  ArgumentList arg_opts[] = {
{"history", 'h',  "NUM",          N_("History"),     ARGUMENT_TYPE_VALUE, &arg_h},
{"new",     'n',  "ON/OFF",       N_("New File"),    ARGUMENT_TYPE_BOOL,  &arg_n},
{"size",    's',  "WIDTH,HEIGHT", N_("Window Size"), ARGUMENT_TYPE_ARRAY, &arg_s},
{"second",  'x',  "ON/OFF",       N_("Open Window"), ARGUMENT_TYPE_BOOL,  &arg_x},
{NULL,      '\0', NULL,           NULL,              0,                   NULL}};

  i = gtk_notebook_get_current_page (GTK_NOTEBOOK (mdi));
  mmaid = i >= 0 ? orz_mdi_get_data (ORZ_MDI (mdi), i) : NULL;
  /* ja:プロセス間通信 */
  /* ja:ファイルの履歴 */
  arg_h.val = orz_history_get_num (ORZ_HISTORY (history));
  arg_h.def = 4;
  /* ja:新規ファイル */
  arg_n.flag = newfile;
  arg_n.def = FALSE;
  /* ja:ウインドウサイズ */
  array[0] = def_width;
  array[1] = def_height;
  def[0] = gdk_screen_width () * 2 / 3;
  def[1] = gdk_screen_height () * 2 / 3;
  arg_s.leng = 2;
  arg_s.array = array;
  arg_s.def = def;
  /* ja:新規ウインドウ */
  arg_x.flag = second;
  arg_x.def = FALSE;
  /* ja:コマンドラインの解析 */
  arg_files = arg_analyse (argv, arg_opts);
  /* ja:ファイルの履歴 */
  orz_history_set_num (ORZ_HISTORY (history), arg_h.val);
  /* ja:新規ファイル */
  newfile = arg_n.flag;
  /* ja:ウインドウサイズ */
  def_width = array[0];
  def_height = array[1];
  /* ja:新規ウインドウ */
  second = arg_x.flag;
  for (i = 1; argv[i]; i++)
    if (arg_files[i])
      switch (file_is_type (argv[i]))
        {
          case FILE_KIND_ERROR:
          case FILE_KIND_DB:
          case FILE_KIND_LIST:
            mmaid = file_open_edit (argv[i]);
            break;
          case FILE_KIND_UNKNOWN:
          case FILE_KIND_TAG:
            {
              ID3Tag *id3tag;

              id3tag = file_open_id3tag (argv[i], charset_list);
              if (id3tag)
                {
                  if (!mmaid || mm_list_search (MM_LIST (mmaid->list),
                                        MM_LIST_FILE, id3tag->file, -1) >= 0)
                    mmaid = file_open_edit (NULL);
                  mm_list_append (MM_LIST (mmaid->list), id3tag);
                  orz_mdi_set_edited (ORZ_MDI (mdi),
                    orz_mdi_get_page_from_data (ORZ_MDI (mdi), mmaid), TRUE);
                }
            }
        }
  g_free (arg_files);
}


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(クリップボード)                                  *
*                                                                             *
******************************************************************************/
void
signal_clipboard_get (GtkClipboard     *clipboard,
                      GtkSelectionData *data,
                      guint             info,
                      gpointer          user_data)
{
  gtk_selection_data_set (data, atom_id3tag, 8,
                                    (guchar *)user_data, g_strlen (user_data));
}


void
signal_clipboard_clear (GtkClipboard *clipboard,
                        gpointer      user_data)
{
  g_free (user_data);
}


void
signal_clipboard_received (GtkClipboard     *clipboard,
                           GtkSelectionData *data,
                           gpointer          user_data)
{
  if (gtk_selection_data_get_length (data) >= 0
                    && gtk_selection_data_get_data_type (data) == atom_id3tag)
    {
      gchar **tag;
      gint i, n, c;
      MmaidWindow *mmaid;

      /* ja:貼り付け */
      mmaid = orz_mdi_get_data (ORZ_MDI (mdi), -1);
      mm_list_get_cursor (MM_LIST (mmaid->list), &n, &c);
      mm_list_unselect_all (MM_LIST (mmaid->list));
      tag = g_strsplit ((const gchar *)gtk_selection_data_get_data (data),
                                                                    "\n", 0);
      for (i = 0; tag[i]; i++)
        {
          gchar **a;
          gint j, s;
          ID3Tag *id3tag;

          id3tag = g_malloc (sizeof (ID3Tag));
          a = g_strsplit (tag[i], "\t", 0);
          for (j = 0; a[j]; j++);
          if (j == 9)
            {
              id3tag->file    = *a[0] != '\0' ? g_strdup (a[0]) : NULL;
              id3tag->title   = *a[1] != '\0' ? g_strdup (a[1]) : NULL;
              id3tag->artist  = *a[2] != '\0' ? g_strdup (a[2]) : NULL;
              id3tag->album   = *a[3] != '\0' ? g_strdup (a[3]) : NULL;
              id3tag->year    = *a[4] != '\0' ? g_strdup (a[4]) : NULL;
              id3tag->comment = *a[5] != '\0' ? g_strdup (a[5]) : NULL;
              misc_str_to_val (&id3tag->track, a[6], 10, TRUE);
              id3tag->genre   = *a[7] != '\0' ? g_strdup (a[7]) : NULL;
              id3tag->charset = *a[8] != '\0' ? g_strdup (a[8]) : NULL;
              s = mm_list_search (MM_LIST (mmaid->list),
                                            MM_LIST_FILE, id3tag->file, -1);
              if (s >= 0)
                mm_list_change (MM_LIST (mmaid->list), s,
                                                MM_LIST_ID3TAG, id3tag, -1);
              else if (n >= 0)
                n = mm_list_insert (MM_LIST (mmaid->list), n, id3tag);
              else
                n = mm_list_append (MM_LIST (mmaid->list), id3tag);
              mm_list_select (MM_LIST (mmaid->list), n);
            }
          g_strfreev (a);
        }
      g_strfreev (tag);
      mm_list_set_cursor (MM_LIST (mmaid->list), n, c);
      orz_mdi_set_edited (ORZ_MDI (mdi),
                    orz_mdi_get_page_from_data (ORZ_MDI (mdi), mmaid), TRUE);
    }
}


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(メイン)                                          *
*                                                                             *
******************************************************************************/
gboolean
signal_delete (GtkWidget *widget,
               GdkEvent  *event,
               gpointer   user_data)
{
  gint page;

  while ((page = gtk_notebook_get_current_page (GTK_NOTEBOOK (mdi))) >= 0)
    {
      if (!prompt_close ((MmaidWindow *)
                                    orz_mdi_get_data (ORZ_MDI (mdi), page)))
        return TRUE;
      gtk_notebook_remove_page (GTK_NOTEBOOK (mdi), page);
    }
  return FALSE;
}
