/*
    Melody maid
    copyright (c) 1998-2012 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "genre.h"
#include "keyfile.h"
#include "misc/charuty.h"
#include "misc/fileio.h"
#include "orz/orzhistory.h"


/******************************************************************************
*                                                                             *
* ja:キーファイル関数群                                                       *
*                                                                             *
******************************************************************************/
/*  ja:キーファイルから読み込む
    file,ファイル名(NULL:読み込まない)                                      */
void
keyfile_read (const gchar *file)
{
  GKeyFile *key_file;

  /* ja:レジストリから読み出す */
  key_file = g_key_file_new ();
  if (g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL))
    {
      gchar *utf8str;
      gint i;

      license = g_key_file_get_integer (key_file, "license", "hash", NULL);
      orz_history_set_num (ORZ_HISTORY (history),
                g_key_file_get_integer (key_file, "pref", "history", NULL));
      newfile = g_key_file_get_boolean (key_file, "pref", "newfile", NULL);
      second = g_key_file_get_boolean (key_file, "pref", "second", NULL);
      def_width = g_key_file_get_integer (key_file, "pref", "width", NULL);
      def_height = g_key_file_get_integer (key_file, "pref", "height", NULL);
      n_pos = g_key_file_get_integer (key_file, "pref", "npos", NULL);
      def_hold = g_key_file_get_boolean (key_file, "mmaid", "defhold", NULL);
      def_gnum = g_key_file_get_integer (key_file, "mmaid", "defgnum", NULL);
      def_plist = g_key_file_get_integer (key_file, "mmaid", "playlist", NULL);
      def_sep = g_key_file_get_integer (key_file, "mmaid", "separator", NULL);
      def_crlf = g_key_file_get_integer (key_file, "mmaid", "crlf", NULL);
      def_head = g_key_file_get_boolean (key_file, "mmaid", "header", NULL);
      cmd_play = g_key_file_get_string (key_file, "mmaid", "cmdplay", NULL);
      cmd_stop = g_key_file_get_string (key_file, "mmaid", "cmdstop", NULL);
      charset_list = g_key_file_get_string (key_file, "mmaid", "charsetlist",
                                                                        NULL);
      if (charset_list)
        {
          gchar *tmp;

          tmp = charuty_strip (charset_list);
          g_free (charset_list);
          charset_list = tmp;
        }
      utf8str = g_key_file_get_string (key_file, "mmaid", "openpath", NULL);
      open_path = utf8str
                ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
      g_free (utf8str);
      utf8str = g_key_file_get_string (key_file, "mmaid", "savepath", NULL);
      save_path = utf8str
                ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
      g_free (utf8str);
      /* ja:ファイルの履歴 */
      for (i = orz_history_get_num (ORZ_HISTORY (history)) - 1; i >= 0; i--)
        {
          gchar *key;

          key = g_strdup_printf ("file%d", i);
          utf8str = g_key_file_get_string (key_file, "history", key, NULL);
          g_free (key);
          if (utf8str)
            {
              gchar *file;

              file = g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL);
              g_free (utf8str);
              orz_history_add_file (ORZ_HISTORY (history), file);
              g_free (file);
            }
        }
      /* ja:ジャンル */
      for (i = 0; i < 256; i++)
        {
          gchar *group;
          gint j, count = 0;

          group = g_strdup_printf ("genre%03d", i);
          for (j = 0; j < 256; j++)
            {
              gchar *key;

              key = g_strdup_printf ("genre%03d", j);
              genre[i][j] = g_key_file_get_string (key_file, group, key, NULL);
              g_free (key);
              if (genre[i][j] && (genre[i][j])[0] == '\0')
                {
                  g_free (genre[i][j]);
                  genre[i][j] = NULL;
                }
              if (genre[i][j])
                count++;
            }
          g_free (group);
          if (count <= 0)
            break;
          genres++;
        }
    }
  g_key_file_free (key_file);

  /* ja:キャラクターセット */
  if (!charset_list)
    {
      const gchar *charset;

      charset_list = !g_get_charset (&charset) && charset
                ? g_strdup_printf ("%s,UTF-8", charset) : g_strdup ("UTF-8");
    }
  /* ja:ジャンル */
  if (genres <= 0)
    {
      gint i, count = 0;

      genres = 2;
      for (i = 0; i < 256; i++)
        if (def_genre_list[i])
          {
            genre[0][i] = g_strdup (_(def_genre_list[i]));
            genre[1][i] = g_strdup   (def_genre_list[i]);
            if (genre[0][i] && (genre[0][i])[0] == '\0')
              {
                g_free (genre[0][i]);
                genre[0][i] = NULL;
              }
            if (genre[0][i] && g_strcmp (genre[0][i], genre[1][i]) != 0)
              count++;
          }
      if (count <= 0)
        {
          genres = 1;
          for (i = 0; i < 256; i++)
            {
              g_free (genre[0][i]);
              genre[0][i] = genre[1][i];
              genre[1][i] = NULL;
            }
        }
    }
}


/*  ja:キーファイルに書き込む
    file,ファイル名(NULL:書き込まない)                                      */
void
keyfile_write (const gchar *file)
{
  /* ja:レジストリに書き込む */
  if (file)
    {
      gsize length;
      gchar *data;
      gint i;
      GKeyFile *key_file;
      GList *glist;

      key_file = g_key_file_new ();
      g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL);
      g_key_file_set_integer (key_file, "license", "hash", license);
      g_key_file_set_integer (key_file, "pref", "history",
                                orz_history_get_num (ORZ_HISTORY (history)));
      g_key_file_set_boolean (key_file, "pref", "newfile", newfile);
      g_key_file_set_boolean (key_file, "pref", "second", second);
      g_key_file_set_integer (key_file, "pref", "width", def_width);
      g_key_file_set_integer (key_file, "pref", "height", def_height);
      g_key_file_set_integer (key_file, "pref", "npos", n_pos);
      g_key_file_set_boolean (key_file, "mmaid", "defhold", def_hold);
      g_key_file_set_integer (key_file, "mmaid", "defgnum", def_gnum);
      g_key_file_set_integer (key_file, "mmaid", "playlist", def_plist);
      g_key_file_set_integer (key_file, "mmaid", "separator", def_sep);
      g_key_file_set_integer (key_file, "mmaid", "crlf", def_crlf);
      g_key_file_set_boolean (key_file, "mmaid", "header", def_head);
      g_key_file_set_string (key_file, "mmaid", "charsetlist", charset_list);
      if (cmd_play)
        g_key_file_set_string (key_file, "mmaid", "cmdplay", cmd_play);
      else
        g_key_file_remove_key (key_file, "mmaid", "cmdplay", NULL);
      if (cmd_stop)
        g_key_file_set_string (key_file, "mmaid", "cmdstop", cmd_stop);
      else
        g_key_file_remove_key (key_file, "mmaid", "cmdstop", NULL);
      if (open_path)
        {
          gchar *utf8str;

          utf8str = g_filename_to_utf8 (open_path, -1, NULL, NULL, NULL);
          if (utf8str)
            {
              g_key_file_set_string (key_file, "mmaid", "openpath", utf8str);
              g_free (utf8str);
            }
        }
      if (save_path)
        {
          gchar *utf8str;

          utf8str = g_filename_to_utf8 (save_path, -1, NULL, NULL, NULL);
          if (utf8str)
            {
              g_key_file_set_string (key_file, "mmaid", "savepath", utf8str);
              g_free (utf8str);
            }
        }
      /* ja:ファイルの履歴 */
      glist = orz_history_get_file (ORZ_HISTORY (history));
      for (i = 0; i < g_list_length (glist); i++)
        {
          gchar *key, *utf8str;

          key = g_strdup_printf ("file%d", i);
          utf8str = g_filename_to_utf8 (g_list_nth_data (glist, i), -1,
                                                            NULL, NULL, NULL);
          if (utf8str)
            {
              g_key_file_set_string (key_file, "history", key, utf8str);
              g_free (utf8str);
            }
          g_free (key);
        }
      g_list_free (glist);
      while (i <= ORZ_HISTORY_NUM_MAX)
        {
          gchar *key;

          key = g_strdup_printf ("file%d", i++);
          g_key_file_remove_key (key_file, "history", key, NULL);
          g_free (key);
        }
      /* ja:ジャンル */
      for (i = 0; i < genres; i++)
        {
          gchar *group;
          gint j;

          group = g_strdup_printf ("genre%03d", i);
          for (j = 0; j < 256; j++)
            {
              gchar *key;

              key = g_strdup_printf ("genre%03d", j);
              if (genre[i][j])
                g_key_file_set_string (key_file, group, key, genre[i][j]);
              else
                g_key_file_remove_key (key_file, group, key, NULL);
              g_free (key);
            }
          g_free (group);
        }
      while (i < 256)
        {
          gchar *group;

          group = g_strdup_printf ("genre%03d", i++);
          g_key_file_remove_group (key_file, group, NULL);
          g_free (group);
        }
      data = g_key_file_to_data (key_file, &length, NULL);
      g_key_file_free (key_file);
      if (data)
        {
          fileio_save (file, data, length);
          g_free (data);
        }
    }
}
