/*
    Melody maid
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __MMAID_H__
#define __MMAID_H__


#include "misc/gcommon.h"
#ifdef G_OS_WIN32
# include <tchar.h>
# include <windows.h>
#endif /* G_OS_WIN32 */


G_BEGIN_DECLS


#define MMAID_VERSION_NOTICE "Melody maid "VERSION" ("BUILD_ENVIRONMENT")"
#define MMAID_COPYRIGHT_NOTICE "Copyright (C) 1998-2013 Kazuki Iwamoto"


#define PLAYLIST_RELATIVE 0
#define PLAYLIST_ABSOLUTE 1
#define PLAYLIST_BASENAME 2


#define CODE_CRLF 0
#define CODE_CR   1
#define CODE_LF   2


typedef struct _MmaidWindow
{
  gchar *charset;               /* ja:キャラクターセット */
  guint filetype;               /* ja:ファイルの種類 */
  gint playlist;                /* ja:プレイリスト */
  gint separator;               /* ja:パスの区切り */
  gint crlf;                    /* ja:改行コード */
  gboolean header;              /* ja:ヘッダ */
  GtkWidget *list;              /* ja:描画領域 */
} MmaidWindow;
typedef struct _ID3Tag
{
  gchar *file;
  gchar *title;
  gchar *artist;
  gchar *album;
  gchar *year;
  gchar *comment;
  gint   track;
  gchar *genre;
  gchar *charset;
} ID3Tag;


enum
{
  TARGET_MMAID
};


extern gboolean newfile;                /* ja:TRUE:新規ファイル,FALSE:なし */
extern gboolean second;                 /* ja:TRUE:新規,FALSE:既存 */
extern gboolean def_hold;               /* ja:TRUE:保持,FALSE:上書き */
extern gchar *open_path;                /* ja:開くのパス */
extern gchar *save_path;                /* ja:名前を付けて保存のパス */
extern gchar *clipboard_id3tag;         /* ja:クリップボードのタグ */
extern gchar *charset_list;             /* ja:キャラクターセットリスト */
extern gchar *cmd_play;                 /* ja:演奏コマンド */
extern gchar *cmd_stop;                 /* ja:停止コマンド */
extern gchar *genre[256][256];          /* ja:ジャンル */
extern gint genres;                     /* ja:ジャンルの数 */
extern gint def_gnum;                   /* ja:デフォルトのジャンル */
extern gint def_width, def_height;      /* ja:デフォルトのウインドウのサイズ */
extern gint license;                    /* ja:ライセンス */
extern gint def_plist;                  /* ja:プレイリスト */
extern gint def_sep;                    /* ja:パスの区切り */
extern gint def_crlf;                   /* ja:改行コード */
extern gboolean def_head;               /* ja:ヘッダ */
extern GObject *history;                /* ja:ファイルの履歴 */
extern GdkAtom atom_id3tag;             /* ja:ID3タグ */
extern GtkPositionType n_pos;           /* ja:ノートブックの位置 */
extern GtkWidget *window;               /* ja:ウインドウ */
extern GtkWidget *mdi;                  /* en:MDI */


G_END_DECLS


#endif /* __MMAID_H__ */
