/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "gcommon.h"


/******************************************************************************
* Character Set Conversion                                                    *
******************************************************************************/
#ifdef USE_GTK_EMULATE
gchar *
g_locale_to_utf8 (const gchar  *opsysstring,
                  gssize        len,
                  gsize        *bytes_read,
                  gsize        *bytes_written,
                  GError      **error)
{
  gsize length;

  length = len < 0 ? g_strlen (opsysstring) + 1 : len;
  if (bytes_read)
    *bytes_read = length;
  if (bytes_written)
    *bytes_written = length;
  return g_memdup (opsysstring, length);
}


gchar *
g_locale_from_utf8 (const gchar  *utf8string,
                    gssize        len,
                    gsize        *bytes_read,
                    gsize        *bytes_written,
                    GError      **error)
{
  gsize length;

  length = len < 0 ? g_strlen (utf8string) + 1 : len;
  if (bytes_read)
    *bytes_read = length;
  if (bytes_written)
    *bytes_written = length;
  return g_memdup (utf8string, length);
}


gchar *
g_filename_to_utf8 (const gchar  *opsysstring,
                    gssize        len,
                    gsize        *bytes_read,
                    gsize        *bytes_written,
                    GError      **error)
{
  gsize length;

  length = len < 0 ? g_strlen (opsysstring) + 1 : len;
  if (bytes_read)
    *bytes_read = length;
  if (bytes_written)
    *bytes_written = length;
  return g_memdup (opsysstring, length);
}


gchar *
g_filename_from_utf8 (const gchar  *utf8string,
                      gssize        len,
                      gsize        *bytes_read,
                      gsize        *bytes_written,
                      GError      **error)
{
  gsize length;

  length = len < 0 ? g_strlen (utf8string) + 1 : len;
  if (bytes_read)
    *bytes_read = length;
  if (bytes_written)
    *bytes_written = length;
  return g_memdup (utf8string, length);
}
#endif /* USE_GTK_EMULATE */


#if ! GLIB_CHECK_VERSION(2,6,0)
gchar *
g_filename_display_name (const gchar *filename)
{
  return g_filename_to_utf8 (filename, -1, NULL, NULL, NULL);
}


gchar *
g_filename_display_basename (const gchar *filename)
{
  gchar *basename, *display;

  basename = g_path_get_basename (filename);
  display = g_filename_to_utf8 (basename, -1, NULL, NULL, NULL);
  g_free (basename);
  return display;
}
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
