/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GLIBFILE_H__
#define __GLIBFILE_H__


#include "gcommon.h"


G_BEGIN_DECLS


/******************************************************************************
* File Utilities                                                              *
******************************************************************************/
#if GLIB_CHECK_VERSION(2,6,0)
# include <glib/gstdio.h>
#endif /* GLIB_CHECK_VERSION(2,6,0) */


#ifdef USE_GTK_EMULATE
typedef enum _GFileTest
{
  G_FILE_TEST_IS_REGULAR    = 1 << 0,
  G_FILE_TEST_IS_SYMLINK    = 1 << 1,
  G_FILE_TEST_IS_DIR        = 1 << 2,
  G_FILE_TEST_IS_EXECUTABLE = 1 << 3,
  G_FILE_TEST_EXISTS        = 1 << 4
} GFileTest;


gboolean g_file_get_contents (const gchar *file, gchar **contents, gsize *length, GError **error);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,8,0)
gboolean g_file_set_contents (const gchar *file, const gchar *contents, gssize length, GError **error);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
#ifdef USE_GTK_EMULATE
gboolean g_file_test (const gchar *file, GFileTest test);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,26,0)
typedef struct stat GStatBuf;
#endif /* not GLIB_CHECK_VERSION(2,26,0) */


#if ! GLIB_CHECK_VERSION(2,26,0)
gchar *g_mkdtemp (gchar *tmpl);
gchar *g_mkdtemp_full (gchar *tmpl, gint mode);
#endif /* not GLIB_CHECK_VERSION(2,26,0) */
#if ! GLIB_CHECK_VERSION(2,30,0)
gchar *g_dir_make_tmp (const gchar *tmpl, GError **error);
#endif /* not GLIB_CHECK_VERSION(2,30,0) */
#if ! GLIB_CHECK_VERSION(2,22,0)
# define g_mapped_file_unref(file) g_mapped_file_free(file)
#endif /* not GLIB_CHECK_VERSION(2,22,0) */
#if ! GLIB_CHECK_VERSION(2,6,0)
# define g_open open
# define g_rename rename
# ifdef G_OS_WIN32
gint g_mkdir (const gchar *filename, gint mode);
# else /* not G_OS_WIN32 */
#  define g_mkdir mkdir
# endif /* not G_OS_WIN32 */
# define g_stat stat
# ifdef HAVE_LSTAT
#  define g_lstat lstat
# else /* not HAVE_LSTAT */
#  define g_lstat stat
# endif /* not HAVE_LSTAT */
# define g_unlink unlink
# define g_remove remove
# define g_rmdir rmdir
# define g_fopen fopen
# define g_freopen freopen
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
#if ! GLIB_CHECK_VERSION(2,8,0)
# ifdef G_OS_WIN32
gint g_chmod (const gchar *filename, gint mode);
gint g_access (const gchar *filename, gint mode);
gint g_creat (const gchar *filename, gint mode);
gint g_chdir (const gchar *path);
# else /* not G_OS_WIN32 */
#  define g_chmod chmod
#  define g_access access
#  define g_creat creat
#  define g_chdir chdir
# endif /* not G_OS_WIN32 */
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
#if ! GLIB_CHECK_VERSION(2,18,0)
# ifdef G_OS_WIN32
#  include <sys/utime.h>
# endif /* G_OS_WIN32 */
gint g_utime (const gchar *filename, struct utimbuf *utb);
#endif /* not GLIB_CHECK_VERSION(2,18,0) */


G_END_DECLS


#endif /* __GLIBFILE_H__ */
