/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GLIBLIST_H__
#define __GLIBLIST_H__


#include "gcommon.h"


G_BEGIN_DECLS


/******************************************************************************
* Doubly-Linked Lists                                                         *
******************************************************************************/
#ifdef USE_GTK_EMULATE
typedef struct _GList {
  gpointer data;
  struct _GList *prev;
  struct _GList *next;
} GList;
typedef gint (*GCompareDataFunc) (gconstpointer a, gconstpointer b, gpointer user_data);
typedef gint (*GCompareFunc) (gconstpointer a, gconstpointer b);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,4,0)
typedef gpointer (*GCopyFunc) (gconstpointer src, gpointer data);
#endif /* not GLIB_CHECK_VERSION(2,4,0) */
#ifdef USE_GTK_EMULATE
typedef void (*GDestroyNotify) (gpointer data);
typedef void (*GFunc) (gpointer data, gpointer user_data);


GList *g_list_append (GList *list, gpointer data);
GList *g_list_prepend (GList *glist, gpointer  data);
GList *g_list_insert (GList *glist, gpointer data, gint position);
GList *g_list_insert_before (GList *glist, GList *sibling, gpointer data);
GList *g_list_insert_sorted (GList *glist, gpointer data, GCompareFunc compare);
GList *g_list_remove (GList *glist, gconstpointer data);
GList *g_list_remove_link (GList *glist, GList *glink);
GList *g_list_delete_link (GList *glist, GList *glink);
GList *g_list_remove_all (GList *glist, gconstpointer data);
void g_list_free (GList *glist);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,28,0)
void g_list_free_full (GList *glist, GDestroyNotify destroy);
#endif /* not GLIB_CHECK_VERSION(2,28,0) */
#ifdef USE_GTK_EMULATE
GList *g_list_alloc (void);
void g_list_free_1 (GList *glist);
# define g_list_free1 g_list_free_1
guint g_list_length (GList *glist);
GList *g_list_copy (GList *glist);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,34,0)
GList *g_list_copy_deep (GList *glist, GCopyFunc func, gpointer user_data);
#endif /* not GLIB_CHECK_VERSION(2,34,0) */
#ifdef USE_GTK_EMULATE
GList *g_list_reverse (GList *glist);
GList *g_list_sort (GList *glist, GCompareFunc compare_func);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,10,0)
GList *g_list_insert_sorted_with_data (GList *glist, gpointer data, GCompareDataFunc func, gpointer user_data);
#endif /* not GLIB_CHECK_VERSION(2,10,0) */
#ifdef USE_GTK_EMULATE
GList *g_list_sort_with_data (GList *glist, GCompareDataFunc compare_func, gpointer user_data);
GList *g_list_concat (GList *glist1, GList *glist2);
void g_list_foreach (GList *glist, GFunc func, gpointer user_data);
GList *g_list_first (GList *glist);
GList *g_list_last (GList *glist);
# define g_list_previous(glist) ((glist)?((GList *)(glist))->prev:NULL)
# define g_list_next(glist) ((glist)?((GList *)(glist))->next:NULL)
GList *g_list_nth (GList *glist, guint n);
gpointer g_list_nth_data (GList *glist, guint n);
GList *g_list_nth_prev (GList *glist, guint n);
GList *g_list_find (GList *glist, gconstpointer data);
GList *g_list_find_custom (GList *glist, gconstpointer data, GCompareFunc compare);
gint g_list_position (GList *glist, GList *llink);
gint g_list_index (GList *glist, gconstpointer data);
#endif /* USE_GTK_EMULATE */


G_END_DECLS


#endif /* __GLIBLIST_H__ */
