/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GLIBSTR_H__
#define __GLIBSTR_H__


#include "gcommon.h"


G_BEGIN_DECLS


/******************************************************************************
* String Utility Functions                                                    *
******************************************************************************/
#if GLIB_CHECK_VERSION(2,2,0)
# include <glib/gprintf.h>
#endif /* GLIB_CHECK_VERSION(2,2,0) */


#ifdef USE_GTK_EMULATE
gchar *g_strdup (const gchar *str);
gchar *g_strndup (const gchar *str, gsize n);
gchar **g_strdupv (gchar **str_array);
gchar *g_strnfill (gsize length, gchar fill_char);
gchar *g_stpcpy (gchar *dest, const gchar *src);
gchar *g_strstr_len (const gchar *haystack, gssize haystack_len, const gchar *needle);
gchar *g_strrstr (const gchar *haystack, const gchar *needle);
gchar *g_strrstr_len (const gchar *haystack, gssize haystack_len, const gchar *needle);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,2,0)
gboolean g_str_has_prefix (const gchar *str, const gchar *prefix);
gboolean g_str_has_suffix (const gchar *str, const gchar *suffix);
#endif /* GLIB_CHECK_VERSION(2,2,0) */
#if ! GLIB_CHECK_VERSION(2,16,0)
int g_strcmp0 (const char *str1, const char *str2);
#endif /* GLIB_CHECK_VERSION(2,16,0) */
#ifdef USE_GTK_EMULATE
gsize g_strlcpy (gchar *dest, const gchar *src, gsize dest_size);
gsize g_strlcat (gchar *dest, const gchar *src, gsize dest_size);
gchar *g_strdup_printf (const gchar *format, ...);
gchar *g_strdup_vprintf (const char *format, va_list args);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,2,0)
# define g_printf printf
# define g_vprintf vprintf
# define g_fprintf fprintf
# define g_vfprintf vfprintf
# define g_sprintf sprintf
# define g_vsprintf vsprintf
#endif /* GLIB_CHECK_VERSION(2,2,0) */
#if ! GLIB_CHECK_VERSION(2,4,0)
gint g_vasprintf (gchar **string, gchar const *format, va_list args);
#endif /* GLIB_CHECK_VERSION(2,4,0) */
#ifdef USE_GTK_EMULATE
gsize g_printf_string_upper_bound (const gchar *format, va_list args);
# define g_ascii_isalnum(c) isalnum(c)
# define g_ascii_isalpha(c) isalpha(c)
# define g_ascii_iscntrl(c) iscntrl(c)
# define g_ascii_isdigit(c) isdigit(c)
# define g_ascii_isgraph(c) isgraph(c)
# define g_ascii_islower(c) islower(c)
# define g_ascii_isprint(c) isprint(c)
# define g_ascii_ispunct(c) ispunct(c)
# define g_ascii_isspace(c) isspace(c)
# define g_ascii_isupper(c) isupper(c)
# define g_ascii_isxdigit(c) isxdigit(c)
gint g_ascii_digit_value (gchar c);
gint g_ascii_xdigit_value (gchar c);
gint g_ascii_strcasecmp (const gchar *s1, const gchar *s2);
gint g_ascii_strncasecmp (const gchar *s1, const gchar *s2, gsize n);
gchar *g_ascii_strup (const gchar *str, gssize len);
gchar *g_ascii_strdown (const gchar *str, gssize len);
# define g_ascii_tolower(c) tolower(c)
# define g_ascii_toupper(c) toupper(c)
gchar *g_strreverse (gchar *string);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,12,0)
gint64 g_ascii_strtoll (const gchar *nptr, gchar **endptr, guint base);
#endif /* not GLIB_CHECK_VERSION(2,12,0) */
#if ! GLIB_CHECK_VERSION(2,2,0)
guint64 g_ascii_strtoull (const gchar *nptr, gchar **endptr, guint base);
#endif /* not GLIB_CHECK_VERSION(2,2,0) */
#ifdef USE_GTK_EMULATE
gchar *g_strchug (gchar *string);
gchar *g_strchomp (gchar *string);
# define g_strstrip(string) g_strchomp(g_strchug(string))
gchar *g_strescape (const gchar *source, const gchar *exceptions);
gchar *g_strcompress (const gchar *source);
gchar **g_strsplit (const gchar *string, const gchar *delimiter, gint max_tokens);
void g_strfreev (gchar **str_array);
gchar *g_strconcat (const gchar *str, ...);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,6,0)
guint g_strv_length (gchar **str_array);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */


G_END_DECLS


#endif /* __GLIBSTR_H__ */
