/*
    argument
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __ARGUMENT_H__
#define __ARGUMENT_H__


#include "gcommon/gcommon.h"


G_BEGIN_DECLS


#define ARGUMENT_TYPE_BOOL 0
#define ARGUMENT_TYPE_VALUE 1
#define ARGUMENT_TYPE_ARRAY 2
#define ARGUMENT_TYPE_STRING 3
#define ARGUMENT_TYPE_EXIT 4
#define ARGUMENT_TYPE_HELP 5


typedef struct _ArgumentBool
{
  gboolean flag;
  gboolean def;
} ArgumentBool;
typedef struct _ArgumentValue
{
  gint val;
  gint def;
} ArgumentValue;
typedef struct _ArgumentArray
{
  gsize leng;
  gint *array;
  const gint *def;
} ArgumentArray;
typedef struct _ArgumentString
{
  gchar *str;
  const gchar *def;
} ArgumentString;
typedef struct _ArgumentExit
{
  const gchar *str;
} ArgumentExit, ArgumentHelp;
typedef struct _ArgumentList
{
  const gchar *name;
  const gchar key;
  const gchar *opt;
  const gchar *doc;
  const guint type;
  gpointer data;
} ArgumentList;


/******************************************************************************
*                                                                             *
* ja:引数解析関数群                                                           *
*                                                                             *
******************************************************************************/
/*  ja:引数を解析する
        argv,引数
    arg_opts,オプション
         RET,ファイル配列                                                   */
gboolean *
arg_analyse (gchar              **argv,
             const ArgumentList  *arg_opts);


G_END_DECLS


#endif /* __ARGUMENT_H__ */
