/*
    orzaccel
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __ORZ_ACCEL_H__
#define __ORZ_ACCEL_H__


#include "gcommon/gcommon.h"


G_BEGIN_DECLS


#define ORZ_TYPE_ACCEL            (orz_accel_get_type ())
#define ORZ_ACCEL(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORZ_TYPE_ACCEL, OrzAccel))
#define ORZ_ACCEL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), ORZ_TYPE_ACCEL, OrzAccelClass))
#define ORZ_IS_ACCEL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORZ_TYPE_ACCEL))
#define ORZ_IS_ACCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ORZ_TYPE_ACCEL))
#define ORZ_ACCEL_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), ORZ_TYPE_ACCEL, OrzAccelClass))


typedef struct _OrzAccel      OrzAccel;
typedef struct _OrzAccelClass OrzAccelClass;


struct _OrzAccel
{
  /*< private >*/
  GObject    parent;

  /*< public >*/

  /*< private >*/
  gulong         handler_destroy;
  gulong         handler_key_press;
  GSList        *gslist;
  GtkAccelGroup *accel_group;
  GtkWindow     *window;
};
struct _OrzAccelClass
{
  GObjectClass parent_class;
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
orz_accel_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:アクセラレータ関数群                                                     *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,オブジェクト                                                        */
GObject *
orz_accel_new (void);


/*  ja:ウインドウを取得する
    accel,オブジェクト
      RET,ウインドウ                                                        */
GtkWindow *
orz_accel_get_window (OrzAccel *accel);


/*  ja:ウインドウを設定する
     accel,オブジェクト
    window,ウインドウ                                                       */
void
orz_accel_set_window (OrzAccel  *accel,
                      GtkWindow *window);


/*  ja:アクセルグループを追加する
          accel,オブジェクト
    accel_group,アクセルグループ                                            */
void
orz_accel_add_accel_group (OrzAccel      *accel,
                           GtkAccelGroup *accel_group);


/*  ja:アクセルグループを削除する
          accel,オブジェクト
    accel_group,アクセルグループ                                            */
void
orz_accel_remove_accel_group (OrzAccel      *accel,
                              GtkAccelGroup *accel_group);


/*  ja:アクセルグループを取得する
    accel,オブジェクト
      RET,アクセルグループのリスト                                          */
GSList *
orz_accel_get_accel_group (OrzAccel *accel);


G_END_DECLS


#endif /* __ORZ_ACCEL_H__ */
