/*
    Melody maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "command.h"
#include "general.h"
#include "mm_list.h"
#include "toolbar.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ja:一般関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:メニューを設定する
    mmaid,ウインドウ情報                                                    */
void
set_menu_bar (MmaidWindow *mmaid)
{
  GList *glist;
  GtkWidget *menu;

  if (mmaid)
    {
      gboolean arrow_up = FALSE, arrow_down = FALSE, arrow_select = FALSE;
      gint i, count;

      count = mm_list_length (MM_LIST (mmaid->list));
      for (i = 0; i < count ; i++)
        if (mm_list_is_selected (MM_LIST (mmaid->list), i))
          {
            arrow_select = TRUE;
            break;
          }
      if (arrow_select)
        {
          for (i = count - 1; i > 0; i--)
            if (mm_list_is_selected (MM_LIST (mmaid->list), i))
              {
                arrow_up = TRUE;
                break;
              }
          if (arrow_up)
            {
              arrow_up = FALSE;
              while (--i >= 0)
                if (!mm_list_is_selected (MM_LIST (mmaid->list), i))
                  {
                    arrow_up = TRUE;
                    break;
                  }
            }
          for (i = 0; i < count - 1; i++)
            if (mm_list_is_selected (MM_LIST (mmaid->list), i))
              {
                arrow_down = TRUE;
                break;
              }
          if (arrow_down)
            {
              arrow_down = FALSE;
              while (++i < count)
                if (!mm_list_is_selected (MM_LIST (mmaid->list), i))
                  {
                    arrow_down = TRUE;
                    break;
                  }
            }
        }
      gtk_widget_set_sensitive (gtk_menu_get_attach_widget (GTK_MENU
            (gtk_item_factory_get_widget (ifactory_menu, "<main>/Tag"))),
                                                                        TRUE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Close"), TRUE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Save"), count);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Save As..."), count);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Reload..."), !mmaid->create);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Export..."), arrow_select);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Up"), arrow_up);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Down"), arrow_down);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Root..."), count);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Refresh..."), count);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Add..."), TRUE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Edit..."), arrow_select);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Search..."), TRUE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Cut"), arrow_select);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Copy"), arrow_select);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/Tag/Delete"), arrow_select);
      gtk_widget_set_sensitive (toolbar_items[ 2].item, count);
      gtk_widget_set_sensitive (toolbar_items[ 4].item, arrow_select);
      gtk_widget_set_sensitive (toolbar_items[ 5].item, arrow_select);
      gtk_widget_set_sensitive (toolbar_items[ 6].item, TRUE);
      gtk_widget_set_sensitive (toolbar_items[ 7].item, arrow_select);
      gtk_widget_set_sensitive (toolbar_items[ 9].item, count);
      gtk_widget_set_sensitive (toolbar_items[10].item, count);
      gtk_widget_set_sensitive (toolbar_items[11].item, TRUE);
      gtk_widget_set_sensitive (toolbar_items[12].item, arrow_select);
      gtk_widget_set_sensitive (toolbar_items[13].item, TRUE);
      gtk_widget_set_sensitive (toolbar_items[15].item, arrow_up);
      gtk_widget_set_sensitive (toolbar_items[16].item, arrow_down);
#ifdef G_OS_WIN32
      gtk_widget_set_sensitive (toolbar_items[18].item, TRUE);
#endif /* G_OS_WIN32 */
    }
  else
    {
      gtk_widget_set_sensitive (gtk_menu_get_attach_widget (GTK_MENU
            (gtk_item_factory_get_widget (ifactory_menu, "<main>/Tag"))),
                                                                        FALSE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Close"), FALSE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Save"), FALSE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Save As..."), FALSE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Reload..."), FALSE);
      gtk_widget_set_sensitive (gtk_item_factory_get_widget (ifactory_menu,
                                "<main>/File/Export..."), FALSE);
      gtk_widget_set_sensitive (toolbar_items[ 2].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[ 4].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[ 5].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[ 6].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[ 7].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[ 9].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[10].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[11].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[12].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[13].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[15].item, FALSE);
      gtk_widget_set_sensitive (toolbar_items[16].item, FALSE);
#ifdef G_OS_WIN32
      gtk_widget_set_sensitive (toolbar_items[18].item, FALSE);
#endif /* G_OS_WIN32 */
    }
  menu = gtk_item_factory_get_widget (ifactory_menu, "<main>/Window");
  glist = gtk_container_children (GTK_CONTAINER (menu));
  gtk_widget_set_sensitive (gtk_menu_get_attach_widget (GTK_MENU (menu)),
                                                    g_list_length (glist) > 0);
  g_list_free (glist);
}


/*  ja:ファイルの保存を問い合わせる
    mmaid,ウインドウ情報
      RET,TRUE:ファイルは閉じる,FALSE:ファイルを閉じない                    */
gboolean
prompt_close (MmaidWindow *mmaid)
{
  if (mmaid->edit)
    {
      gchar *text, *utf8str;

      utf8str = g_filename_to_utf8 (mmaid->file, -1, NULL, NULL, NULL);
      text = g_strdup_printf (_("File %s was edited.\nSave?"), utf8str);
      g_free (utf8str);
      switch (misc_message_box ("Melody maid", text, 0,
                                    _("_Yes"), _("_No"), _("Cancel"), NULL))
        {
          case 0:
            {
              GtkWidget *child;

              child = gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
                    gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)));
              if (g_object_get_data (G_OBJECT (child), "user_data") != mmaid)
                {
                  gint i;
                  GList *glist;

                  glist = gtk_container_children (GTK_CONTAINER (notebook));
                  for (i = g_list_length (glist) - 1; i >= 0; i--)
                    if (g_object_get_data (G_OBJECT (g_list_nth_data
                                            (glist, i)), "user_data") == mmaid)
                      {
                        gtk_notebook_set_current_page (GTK_NOTEBOOK (notebook),
                                                                            i);
                        break;
                      }
                  g_list_free (glist);
                }
              else
                {
                  child = NULL;
                }
              command_save (NULL, 0, NULL);
              if (child)
                gtk_notebook_set_current_page (GTK_NOTEBOOK (notebook),
                    gtk_notebook_page_num (GTK_NOTEBOOK (notebook), child));
              if (!mmaid->edit)
                break;
            }
          case 2:
          case -1:
            g_free (text);
            return FALSE;
        }
      g_free (text);
    }
  return TRUE;
}


/*  ja:タブの編集済みマークの変更
      mmaid,ウインドウ情報
    is_edit,TRUE:編集済み,FALSE:未編集                                      */
void
mmaid_change_edit (MmaidWindow *mmaid,
                   gboolean     is_edit)
{
  if (mmaid->edit != is_edit)
    {
      mmaid->edit = is_edit;
      if (is_edit)
        gtk_widget_show (mmaid->mark);
      else
        gtk_widget_hide (mmaid->mark);
    }
}


/******************************************************************************
*                                                                             *
* ja:項目関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:タグを比較する
    id3tag0,タグ0
    id3tag1,タグ1
        RET,TRUE:等しい,FALSE:異なる                                        */
gboolean
cmp_id3tag (const ID3Tag *id3tag0,
            const ID3Tag *id3tag1)
{
  return !g_strfilecmp (id3tag0->file, id3tag1->file)
      && ((!id3tag0->title   && !id3tag1->title)
                        || (id3tag0->title   && id3tag1->title
                        && !g_strcmp (id3tag0->title,   id3tag1->title)))
      && ((!id3tag0->artist  && !id3tag1->artist)
                        || (id3tag0->artist  && id3tag1->artist
                        && !g_strcmp (id3tag0->artist,  id3tag1->artist)))
      && ((!id3tag0->album   && !id3tag1->album)
                        || (id3tag0->album   && id3tag1->album
                        && !g_strcmp (id3tag0->album,   id3tag1->album)))
      && ((!id3tag0->year    && !id3tag1->year)
                        || (id3tag0->year    && id3tag1->year
                        && !g_strcmp (id3tag0->year,    id3tag1->year)))
      && ((!id3tag0->comment && !id3tag1->comment)
                        || (id3tag0->comment && id3tag1->comment
                        && !g_strcmp (id3tag0->comment, id3tag1->comment)))
      && id3tag0->track == id3tag1->track
      && ((!id3tag0->genre   && !id3tag1->genre)
                        || (id3tag0->genre   && id3tag1->genre
                        && !g_strcmp (id3tag0->genre,   id3tag1->genre)))
      && ((!id3tag0->charset && !id3tag1->charset)
                        || (id3tag0->charset && id3tag1->charset
                        && !g_strcmp (id3tag0->charset, id3tag1->charset)));
}


/*  ja:タグをコピーする
    id3tag,タグ
       RET,タグ                                                             */
ID3Tag *
copy_id3tag (const ID3Tag *id3tag)
{
  ID3Tag *id3tag0;

  if (!id3tag)
    return NULL;
  id3tag0 = g_malloc0 (sizeof (ID3Tag));
  id3tag0->file = g_strdup (id3tag->file);
  if (id3tag->title)
    id3tag0->title = g_strdup (id3tag->title);
  if (id3tag->artist)
    id3tag0->artist = g_strdup (id3tag->artist);
  if (id3tag->album)
    id3tag0->album = g_strdup (id3tag->album);
  if (id3tag->year)
    id3tag0->year = g_strdup (id3tag->year);
  if (id3tag->comment)
    id3tag0->comment = g_strdup (id3tag->comment);
    id3tag0->track = id3tag->track;
  if (id3tag->genre)
    id3tag0->genre = g_strdup (id3tag->genre);
  if (id3tag->charset)
    id3tag0->charset = g_strdup (id3tag->charset);
  return id3tag0;
}
