/*
    Melody maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "command.h"
#include "toolbar.h"


/******************************************************************************
*                                                                             *
* ja:ツールバー関数群                                                         *
*                                                                             *
******************************************************************************/
/* XPM */
static gchar *tb_new_xpm[] = {
"16 16 4 1",
"   c None",
".  c #000000",
"+  c #FF0000",
"@  c #FFFFFF",
"          +     ",
" ......+..+..+  ",
" .@@@@@@+@+@+   ",
" .@@@@@@@+++.   ",
" .@@@@+++++++++ ",
" .@@@@@@@+++.   ",
" .@@@@@@+@+@+   ",
" .@@@@@+@@+@.+  ",
" .@@@@@@@@+@.   ",
" .@@@@@@@@@@.   ",
" .@@@@@@@@@@.   ",
" .@@@@@@@@@@.   ",
" .@@@@@@@@@@.   ",
" .@@@@@@@@@@.   ",
" ............   ",
"                "};


/* XPM */
static gchar *tb_open_xpm[] = {
"16 16 5 1",
"   c None",
".  c #000000",
"=  c #808080",
">  c #FFFF00",
"!  c #FFFFFF",
"  ......        ",
" .!>!>!>.       ",
".!>!>!>!>.......",
".>!>!>!>!>!>!>!.",
".!============>.",
".>=!!!!!!!!!!=!.",
".!=!!!!!!.......",
".>=!!!!!.>!>!>!.",
"........>!>!>!>.",
".>!>!>!>!>!>!>!.",
".!>!>!>!>!>!>!>.",
".>!>!>!>!>!>!>!.",
".!>!>!>!>!>!>!>.",
".>!>!>!>!>!>!>!.",
".!>!>!>!>!>!>!>.",
"................"};


/* XPM */
static gchar *tb_save_xpm[] = {
"16 16 5 1",
"  c None",
". c #000000",
"+ c #808000",
"@ c #808080",
"# c #CCCCCC",
"                ",
" .............. ",
" .@@####@@##@@. ",
" .@@####@@##@@. ",
" .@@####@@##@@. ",
" .@@########@@. ",
" .@@@@@@@@@@@@. ",
" .@..........@. ",
" .@.++++++++.@. ",
" .@.++++++++.@. ",
" .@.++++++++.@. ",
" .@.++++++++.@. ",
" .@.++++++++.@. ",
" .@.++++++++.@. ",
" .............. ",
"                "};


/* XPM */
static gchar *tb_cut_xpm[] = {
"16 16 5 1",
"   c None",
".  c #000000",
"-  c #FF0000",
",  c #0000FF",
"!  c #FFFFFF",
"                ",
"....         ,, ",
"!!!.        ,  ,",
"......,,    ,  ,",
".!!!!.,,,    ,, ",
".!!!!.  ,,,,,   ",
".!!!!.,,,, ,,   ",
".!!,,,,,    ,,, ",
".,,,,,     ,   ,",
".!!!!.     ,   ,",
"......      ,,, ",
"-   -           ",
"--  --          ",
" ------         ",
"    --          ",
"    -           "};


/* XPM */
static gchar *tb_copy_xpm[] = {
"16 16 4 1",
"   c None",
".  c #000000",
"-  c #FF0000",
"!  c #FFFFFF",
"    .........   ",
"    .!!!!!!!.   ",
"    .!!!!!!!.   ",
"    .!!.........",
"    .!!.!!!!!!!.",
"    .!!.!!!!!!!.",
"    .!!.!!!!!!!.",
"    .!!.!!!!!!!.",
"-   .!!.!!!!!!!.",
"-   .!!.!!!!!!!.",
"-   ....!!!!!!!.",
"-  -   .!!!!!!!.",
"-- --  .!!!!!!!.",
" ----- .........",
"   --           ",
"   -            "};


/* XPM */
static gchar *tb_paste_xpm[] = {
"16 16 5 1",
"   c None",
".  c #000000",
"*  c #C0C0C0",
"=  c #808080",
"!  c #FFFFFF",
"                ",
"     .........  ",
"     .!!!!!!!.  ",
"     .!!!!!!!.  ",
"  ....!!!!!!!.  ",
"  .!!=!!!!!!!.  ",
"  .!!=!!!!!!!.  ",
"  .!!=====!!!.  ",
"  .!!!*!!=!!!.  ",
"  .!!!!*!=!!!.  ",
"  .!!!!!*=!!!.  ",
"  .!!!!!!=....  ",
"  .!!!!!!!.     ",
"  .!!!!!!!.     ",
"  .........     ",
"                "};


/* XPM */
static gchar *tb_delete_xpm[] = {
"16 16 2 1",
"   c None",
",  c #0000FF",
"                ",
"                ",
"                ",
"             ,, ",
" ,,,,       ,  ,",
"   ,,,,,    ,  ,",
"     ,,,,    ,, ",
"        ,,,,,   ",
"      ,,,, ,,   ",
"   ,,,,,    ,,, ",
" ,,,,,     ,   ,",
"           ,   ,",
"            ,,, ",
"                ",
"                ",
"                "};


/* XPM */
static gchar *tb_root_xpm[] = {
"16 16 5 1",
"   c None",
".  c #000000",
"-  c #FF0000",
">  c #FFFF00",
"!  c #FFFFFF",
"        -----   ",
"            --  ",
"       -     -  ",
"      ---  -----",
"     -----  --- ",
"       -     -  ",
"       --       ",
" ....   -----   ",
".>!>!.....      ",
".!>!>!>!>.      ",
".>!>!.....      ",
".....!>!>.      ",
".>!>!>!>!.      ",
".!>!>!>!>.      ",
".>!>!>!>!.      ",
"..........      "};


/* XPM */
static gchar *tb_refresh_xpm[] = {
"16 16 4 1",
"   c None",
".  c #000000",
"@  c #008000",
"!  c #FFFFFF",
"                ",
"  ............  ",
"  .!!!!!!!!!!.  ",
"  .!!!!!!!!!!.  ",
"  .!!@@@@@!!!.  ",
"  .!!!!!!@@!!.  ",
"  .!!@!!!!@!!.  ",
"  .!@@@!@@@@@.  ",
"  .@@@@@!@@@!.  ",
"  .!!@!!!!@!!.  ",
"  .!!@@!!!!!!.  ",
"  .!!!@@@@@!!.  ",
"  .!!!!!!!!!!.  ",
"  .!!!!!!!!!!.  ",
"  ............  ",
"                "};


/* XPM */
static gchar *tb_add_xpm[] = {
"16 16 5 1",
"   c None",
".  c #000000",
"*  c #808080",
"-  c #FF0000",
"!  c #FFFFFF",
"          -     ",
" ......-..-..-  ",
" .!!!!!!-!-!-   ",
" .!***!!!---.   ",
" .!!!!--------- ",
" .!!!!!!!---.   ",
" .!*****-*-!-   ",
" .!!!!!-!!-!.-  ",
" .!*******-!.   ",
" .!!!!!!!!!!.   ",
" .!********!.   ",
" .!!!!!!!!!!.   ",
" .!!!!!****!.   ",
" .!!!!!!!!!!.   ",
" ............   ",
"                "};


/* XPM */
static gchar *tb_edit_xpm[] = {
"16 16 7 1",
"   c None",
".  c #000000",
"@  c #008000",
"*  c #808080",
"-  c #FF0000",
">  c #FFFF00",
"!  c #FFFFFF",
"                ",
" ............   ",
" .!!!!!!!!!!.   ",
" .!***!!!!......",
" .!!!!!!!.>.@@@@",
" .!!!!!!.>-.....",
" .!****..->.@@@@",
" .!!!!!!.>-.....",
" .!******.>.@@@@",
" .!!!!!!!!......",
" .!********!.   ",
" .!!!!!!!!!!.   ",
" .!!!!!****!.   ",
" .!!!!!!!!!!.   ",
" ............   ",
"                "};


/* XPM */
static gchar *tb_search_xpm[] = {
"16 16 5 1",
"   c None",
".  c #000000",
"=  c #C0C0C0",
",  c #0000FF",
"!  c #FFFFFF",
"  .........     ",
"  .!!!!!!!.     ",
"  .!!!!!!!.     ",
"  .!!!!!!!.     ",
"  .!!!!!!!.     ",
"  .!!!!!!!.     ",
"  .!!!!!!...    ",
"  .!!!!!.=. .   ",
"  .!!!!.==.!!.  ",
"  .!!!!.==. !.  ",
"  .........  .  ",
"       ,.   .   ",
"      ,,,...    ",
"     ,,,        ",
"    ,,,         ",
"     ,          "};


/* XPM */
static gchar *tb_up_xpm[] = {
"16 16 2 1",
"   c None",
"-  c #FF0000",
"                ",
"       --       ",
"      ----      ",
"     ------     ",
"    --------    ",
"   ----------   ",
"  ------------  ",
"      ----      ",
"      ----      ",
"      ----      ",
"      ----      ",
"      ----      ",
"      ----      ",
"      ----      ",
"      ----      ",
"                "};


/* XPM */
static gchar *tb_down_xpm[] = {
"16 16 2 1",
"   c None",
",  c #0000FF",
"                ",
"      ,,,,      ",
"      ,,,,      ",
"      ,,,,      ",
"      ,,,,      ",
"      ,,,,      ",
"      ,,,,      ",
"      ,,,,      ",
"      ,,,,      ",
"  ,,,,,,,,,,,,  ",
"   ,,,,,,,,,,   ",
"    ,,,,,,,,    ",
"     ,,,,,,     ",
"      ,,,,      ",
"       ,,       ",
"                "};


#ifdef G_OS_WIN32
/* XPM */
static gchar *tb_close_xpm[] = {
"16 16 2 1",
"   c None",
".  c #000000",
"                ",
"                ",
"   ..      ..   ",
"    ..    ..    ",
"     ..  ..     ",
"      ....      ",
"       ..       ",
"       ..       ",
"      ....      ",
"     ..  ..     ",
"    ..    ..    ",
"   ..      ..   ",
"                ",
"                ",
"                "};
#endif /* G_OS_WIN32 */


ToolBar toolbar_items[] = {
/*  0 */ {N_("New"),     tb_new_xpm,     command_new,     NULL, NULL},
/*  1 */ {N_("Open"),    tb_open_xpm,    command_open,    NULL, NULL},
/*  2 */ {N_("Save"),    tb_save_xpm,    command_save,    NULL, NULL},
/*  3 */ {NULL,          NULL,           NULL,            NULL, NULL},
/*  4 */ {N_("Cut"),     tb_cut_xpm,     command_cut,     NULL, NULL},
/*  5 */ {N_("Copy"),    tb_copy_xpm,    command_copy,    NULL, NULL},
/*  6 */ {N_("Paste"),   tb_paste_xpm,   command_paste,   NULL, NULL},
/*  7 */ {N_("Delete"),  tb_delete_xpm,  command_delete,  NULL, NULL},
/*  8 */ {NULL,          NULL,           NULL,            NULL, NULL},
/*  9 */ {N_("Root"),    tb_root_xpm,    command_root,    NULL, NULL},
/* 10 */ {N_("Refresh"), tb_refresh_xpm, command_refresh, NULL, NULL},
/* 11 */ {N_("Add"),     tb_add_xpm,     command_add,     NULL, NULL},
/* 12 */ {N_("Edit"),    tb_edit_xpm,    command_edit,    NULL, NULL},
/* 13 */ {N_("Search"),  tb_search_xpm,  command_search,  NULL, NULL},
/* 14 */ {NULL,          NULL,           NULL,            NULL, NULL},
/* 15 */ {N_("Up"),      tb_up_xpm,      command_up,      NULL, NULL},
/* 16 */ {N_("Down"),    tb_down_xpm,    command_down,    NULL, NULL},
#ifdef G_OS_WIN32
/* 17 */ {NULL,          NULL,           NULL,            NULL, NULL},
/* 18 */ {N_("Close"),   tb_close_xpm,   command_close,   NULL, NULL},
#endif /* G_OS_WIN32 */
/*    */ {(gpointer)-1,  NULL,           NULL,            NULL, NULL}};
