/*
    Melody maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "charlist.h"
#include "command.h"
#include "file.h"
#include "general.h"
#include "mm_list.h"
#include "sigfile.h"
#include "misc/fileio.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(フレーム)                                        *
*                                                                             *
******************************************************************************/
void
signal_changed (GtkWidget   *widget,
                MmaidWindow *mmaid)
{
  if (mmaid == g_object_get_data (G_OBJECT
                (gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
                    gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
                                                                "user_data"))
    set_menu_bar (mmaid);
}


void
signal_clicked (GtkWidget   *widget,
                MmaidWindow *mmaid)
{
  mmaid_change_edit (mmaid, TRUE);
  if (mmaid == g_object_get_data (G_OBJECT
                (gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
                    gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
                                                                "user_data"))
    set_menu_bar (mmaid);
}


void
signal_edited (GtkWidget   *widget,
               const gint   n,
               const gint   c,
               MmaidWindow *mmaid)
{
  if (c == MM_LIST_ID3TAG || c == MM_LIST_FILE || c == MM_LIST_TITLE
            || c == MM_LIST_ARTIST || c == MM_LIST_ALBUM || c == MM_LIST_GENRE)
    mmaid_change_edit (mmaid, TRUE);
  if (mmaid == g_object_get_data (G_OBJECT
                (gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
                    gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
                                                                "user_data"))
    set_menu_bar (mmaid);
}


void
signal_inserted (GtkWidget   *widget,
                 const gint   n,
                 MmaidWindow *mmaid)
{
  mmaid_change_edit (mmaid, TRUE);
  if (mmaid == g_object_get_data (G_OBJECT
                (gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
                    gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
                                                                "user_data"))
    set_menu_bar (mmaid);
}


void
signal_moved (GtkWidget   *widget,
              const gint   n0,
              const gint   n1,
              MmaidWindow *mmaid)
{
  mmaid_change_edit (mmaid, TRUE);
  if (mmaid == g_object_get_data (G_OBJECT
                (gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
                    gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
                                                                "user_data"))
    set_menu_bar (mmaid);
}


void
signal_destroy_list (GtkWidget   *widget,
                     MmaidWindow *mmaid)
{
  GList *glist;
  GtkWidget *menu_shell;

  /* ja:ファイル名を調べる */
  file_delete_edit (mmaid->file);
  /* ja:ウインドウメニュー */
  menu_shell = gtk_item_factory_get_widget (ifactory_menu, "<main>/Window");
  gtk_container_remove (GTK_CONTAINER (menu_shell), mmaid->menu_item);
  /* ja:メニュー */
  glist = gtk_container_children (GTK_CONTAINER (notebook));
  if (g_list_length (glist) <= 1)
    set_menu_bar (NULL);
  g_list_free (glist);
  /* ja:メモリを解放する */
  g_free (mmaid->charset);
  g_free (mmaid->file);
  g_free (mmaid);
}
