////////////////////////////////////////////////////////////////////////////////////////////////
//
//  ShadowDraw.fx v0.3
//  쐬: f[^P
//
////////////////////////////////////////////////////////////////////////////////////////////////

#include "config.h"

// MMD{sampler㏑Ȃ߂̋LqłB폜sB
sampler MMDSamp0 : register(s0);
sampler MMDSamp1 : register(s1);
sampler MMDSamp2 : register(s2);

// eeNjbNȂ悤ɒׂ
technique MainTec < string MMDPass = "object"; > { }
technique MainTec < string MMDPass = "zplot"; > { }
technique MainTec < string MMDPass = "edge"; > { }
technique MainTec < string MMDPass = "shadow"; > { }

float4x4 LightWorldViewProjMatrix : WORLDVIEWPROJECTION < string Object = "Light"; >;
float4   MaterialDiffuse   : DIFFUSE  < string Object = "Geometry"; >;

#ifndef ShadowMinTr // ߂̌Œ艻Ή
float ShadowMinTr : CONTROLOBJECT <string name = "(OffscreenOwner)"; string item = "Tr"; >;
#endif

// IuWFNg̃eNX`
texture ObjectTexture: MATERIALTEXTURE;
sampler ObjTexSampler = sampler_state {
    texture = <ObjectTexture>;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

///////////////////////////////////////////////////////////////////////////////////////////////
// ZtVhEpZlvbg
struct VS_ZValuePlot_OUTPUT {
    float4 Pos : POSITION;              // ˉeϊW
    float4 ShadowMapTex : TEXCOORD0;    // Zobt@eNX`
    float2 Tex : TEXCOORD1;				// eNX`
};

// _VF[_
VS_ZValuePlot_OUTPUT ZValuePlot_VS( float4 Pos : POSITION, float2 Tex : TEXCOORD0)
{
    VS_ZValuePlot_OUTPUT Out = (VS_ZValuePlot_OUTPUT)0;

    // Cg̖ڐɂ郏[hr[ˉeϊ
    Out.Pos = mul(Pos, LightWorldViewProjMatrix);

    // eNX`W𒸓_ɍ킹
    Out.ShadowMapTex = Out.Pos;

	Out.Tex = Tex;
    return Out;
}

// sNZVF[_
float4 ZValuePlot_PS(VS_ZValuePlot_OUTPUT IN, uniform bool useTexture ) : COLOR
{
	float alph = MaterialDiffuse.a * (useTexture ? tex2D(ObjTexSampler, IN.Tex).a : 1);
	clip((MaterialDiffuse.a==0.98) ? -1 : alph - ShadowMinTr);
    // RFZlL^
    return float4(IN.ShadowMapTex.z/IN.ShadowMapTex.w,0,0,1);
}

technique ZplotTec < 
	string MMDPass = "object_ss";
	bool UseTexture = false;
>
{
    pass ZValuePlot {
		AlphaBlendEnable = false;
        CullMode = NONE;
        VertexShader = compile vs_2_0 ZValuePlot_VS();
        PixelShader  = compile ps_2_0 ZValuePlot_PS(false);
    }
}

technique ZplotTec2 < 
	string MMDPass = "object_ss";
	bool UseTexture = true;
>
{
    pass ZValuePlot {
		AlphaBlendEnable = false;
        CullMode = NONE;
        VertexShader = compile vs_2_0 ZValuePlot_VS();
        PixelShader  = compile ps_2_0 ZValuePlot_PS(true);
    }
}