////////////////////////////////////////////////////////////////////////////////////////////////
//@NCHLShader full lF[J[
//		Ql	Maverick Project(http://maverickproj.web.fc2.com/pg00.html)
//			Project ASURA(http://asura.iaigiri.com/top.html)
//			Phong.fx(NVIDIA Shader Library)
//			full.fx(͉P)
//			advancedTexureMapping2(Furia)
//			DetailUp_for_Landscape(f[^P)
////////////////////////////////////////////////////////////////////////////////////////////////

// p[^錾

#include "config.h"

float Script : STANDARDSGLOBAL <
    string ScriptOutput = "color";
    string ScriptClass = "sceneorobject";
    string ScriptOrder = "standard";
> = 0.8;

static float ShadowBias
<
    string UIName = "ShadowBias";
    string UIWidget = "Slider";
    bool UIVisible =  true;
    float UIMin = 0.00;
    float UIMax = 1.00;
    float UIStep = 0.01;
    string UIDefault = "0.80";
    string UIDescription = "e̐F(قǈÂȂ)";
> = float( 0.80 ); //̒lς


// @ϊs
float4x4 WorldViewProjMatrix      : WORLDVIEWPROJECTION;
float4x4 WorldMatrix              : WORLD;
float4x4 ViewMatrix               : VIEW;
float4x4 ViewProjMatrix           : VIEWPROJECTION;
float4x4 LightWorldViewProjMatrix : WORLDVIEWPROJECTION < string Object = "Light"; >;

// CgƃJ̕
float3   LightDirection    : DIRECTION < string Object = "Light"; >;
float3   CameraPosition    : POSITION  < string Object = "Camera"; >;

// }eAF
float4   MaterialDiffuse   : DIFFUSE  < string Object = "Geometry"; >;
float3   MaterialAmbient   : AMBIENT  < string Object = "Geometry"; >;
float3   MaterialEmmisive  : EMISSIVE < string Object = "Geometry"; >;
float3   MaterialSpecular  : SPECULAR < string Object = "Geometry"; >;
float    SpecularPower     : SPECULARPOWER < string Object = "Geometry"; >;
float3   MaterialToon      : TOONCOLOR;

// CgF
float3   LightAmbient      : AMBIENT   < string Object = "Light"; >;
static float4 DiffuseColor  = float4(MaterialDiffuse.rgb*LightAmbient, MaterialDiffuse.a+0.01);
static float3 AmbientColor  = MaterialToon*MaterialEmmisive*LightAmbient/0.6;

bool     parthf;   // p[XyNeButO
bool     transp;   // tO

#define SKII1    1500
#define SKII2    8000
#define Toon     3

// XyLƃCg̃p[^
static float Roughness	= MaterialSpecular.r;
static float Fresnel 	= MaterialSpecular.g;
static float SpecFactor	= MaterialSpecular.b;
static float RimFactor	= SpecularPower;

// IuWFNg̃eNX`
texture ObjectTexture: MATERIALTEXTURE;
sampler ObjTexSampler = sampler_state {
    texture = <ObjectTexture>;
    MINFILTER = ANISOTROPIC;
    MAGFILTER = ANISOTROPIC;
    MIPFILTER = LINEAR;
    MAXANISOTROPY = 16;
};

// m[}}bvpeNX`
texture NormalMapTexure: MATERIALSPHEREMAP;
sampler NormalMapTexSampler = sampler_state {
    texture = <NormalMapTexure>;
    MINFILTER = ANISOTROPIC;
    MAGFILTER = ANISOTROPIC;
    MIPFILTER = LINEAR;
    MAXANISOTROPY = 16;
    ADDRESSU = CLAMP;
    ADDRESSV = CLAMP;
};

// MMD{sampler㏑Ȃ߂̋LqłB폜sB
sampler MMDSamp0 : register(s0);
sampler MMDSamp1 : register(s1);
sampler MMDSamp2 : register(s2);

// VhEobt@
shared texture ShadowMap0 : OFFSCREENRENDERTARGET;
sampler ShadowMapSampler = sampler_state {
    texture = <ShadowMap0>;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

////////////////////////////////////////////////////////////////////////////////////////////////
// ֊s`
// ֊s`peNjbN
technique EdgeTec < string MMDPass = "edge"; > {}
// RgAEg΃GbWgp\B

///////////////////////////////////////////////////////////////////////////////////////////////
// ZtVhEpZlvbg
// ZlvbgpeNjbN
technique ZplotTec < string MMDPass = "zplot"; > {}
// WVhE}bvgpȂRgAEg

////////////////////////////////////////////////////////////////////////////////////////////////////////////
// MMDW̃ZtVhE̖邳vZ
// WVhE}bvgpȂ"ShadowMapSampler""MMDSamp0"
float MMDShadowBrightness(float2 ShadowMapPos, float DepthRef)
{
    float shadow = max(DepthRef - tex2D(ShadowMapSampler,ShadowMapPos).r, 0);
    float comp = 1 - saturate(shadow*
        (parthf ? SKII2*ShadowMapPos.y 	// ZtVhE[h2
                : SKII1 		// ZtVhE[h1
                )-0.3);
    return comp;
}

static const float2 sampstep = float2(1.0/SHADOWMAP_WIDTH, 1.0/SHADOWMAP_HEIGHT);

// ߂̃ZtVhE
// PCF 9_TvO
// 9_TvO
// WVhE}bvgpȂ"ShadowMapSampler""MMDSamp0"
float GetZBufSample(float2 texc, float t, float steprate)
{
    float Out;
    float step = sampstep * steprate;

    Out = (t>tex2D(ShadowMapSampler, texc)) * 2;

    Out += (t>tex2D(ShadowMapSampler, texc + float2(0, step)));
    Out += (t>tex2D(ShadowMapSampler, texc + float2(0, -step)));
    Out += (t>tex2D(ShadowMapSampler, texc + float2(step, 0)));
    Out += (t>tex2D(ShadowMapSampler, texc + float2(-step, 0)));
    Out += (t>tex2D(ShadowMapSampler, texc + float2(step, step))) * 0.7071; // 0.7071=sqrt(0.5) S̋
    Out += (t>tex2D(ShadowMapSampler, texc + float2(-step, step))) * 0.7071;
    Out += (t>tex2D(ShadowMapSampler, texc + float2(step, -step))) * 0.7071;
    Out += (t>tex2D(ShadowMapSampler, texc + float2(-step, -step))) * 0.7071;

    Out /= 2 + 4 + 4*(0.7071);
    return Out;
}

float ShadowBrightness(float2 ShadowMapPos, float DepthRef)
{
    float comp;
    if(parthf && (ShadowMapPos.y<SOFTSHADOW_DISTANCE)){
        comp = MMDShadowBrightness(ShadowMapPos, DepthRef);
    }
    else{
        comp = 1-GetZBufSample(ShadowMapPos, DepthRef-SOFTSHADOW_THRESHOLD, 1);
    }
    return comp;
}

///////////////////////////////////////////////////////////////////////////////////////////////
// IuWFNg`iZtVhEONj

struct BufferShadow_OUTPUT {
    float4 Pos      : POSITION;     // ˉeϊW
    float4 ZCalcTex : TEXCOORD0;    // Zl
    float2 Tex      : TEXCOORD1;    // eNX`
    float3 Normal   : TEXCOORD2;    // @
    float3 Eye      : TEXCOORD3;    // JƂ̑Έʒu
    float4 WPos     : TEXCOORD4;    // [hʒu
};

// _VF[_
BufferShadow_OUTPUT BufferShadow_VS(float4 Pos : POSITION, float3 Normal : NORMAL, float2 Tex : TEXCOORD0, uniform bool useTexture)
{
    BufferShadow_OUTPUT Out = (BufferShadow_OUTPUT)0;

    // J_̃[hr[ˉeϊ
    Out.Pos = mul( Pos, WorldViewProjMatrix );

    // [hʒu
    Out.WPos= mul( Pos, WorldMatrix ); 
    
    // JƂ̑Έʒu
    Out.Eye = CameraPosition - Out.WPos;

    // _@
    Out.Normal = mul( Normal, (float3x3)WorldMatrix );

    // Cg_ɂ郏[hr[ˉeϊ
    Out.ZCalcTex = mul( Pos, LightWorldViewProjMatrix );
           
    // eNX`W
    Out.Tex = Tex;
    
    return Out;
}

// ڋԎ擾
float3x3 compute_tangent_frame(float3 Normal, float3 View, float2 UV)
{
    float3 dp1 = ddx(View);
    float3 dp2 = ddy(View);
    float2 duv1 = ddx(UV);
    float2 duv2 = ddy(UV);

    float3x3 M = float3x3(dp1, dp2, cross(dp1, dp2));
    float2x3 inverseM = float2x3(cross(M[1], M[2]), cross(M[2], M[0]));
    float3 Tangent = mul(float2(duv1.x, duv2.x), inverseM);
    float3 Binormal = mul(float2(duv1.y, duv2.y), inverseM);

    return float3x3(normalize(Tangent), normalize(Binormal), Normal);
}

// Beckmannz֐
inline float Beckmann(float m, float NH)
{
    float NH2 = NH*NH;
    return exp(-(1-NH2)/(NH2*m*m))/(4*m*m*NH2*NH2);    
}

// gUˌƋʔˌ̌vZ
float3 LightVec(float3 L, float3 Nn, float3 Vn, float NV)
{
    float3 Ln = normalize(L);
    float3 Hn = normalize(Vn + Ln);
    float  NL = dot(Nn, Ln);
    float  NH = dot(Nn, Hn);
    float  VH = dot(Vn, Hn);

    // CeBO
    float Rim = (1.0f - max(0.0f, NV));

    // ʍގ̗̖邳} 낢Ə
    float Rim2 = MaterialDiffuse.a >= 0.98f && MaterialDiffuse.a < 1.0f ? Rim+min(0, NV) : Rim;   

    // n[to[gŖ邳vZ
    float hlambert = NL*0.5f + 0.5;
    hlambert *= hlambert;

    // Beckmannz
    float D = Beckmann(Roughness, NH);

    // 􉽌
    float G = min( 1, min(2*NH*NV/VH, 2*NH*NL/VH) );

    // tl Schlick̋ߎH
    float F = lerp( Fresnel, 1, pow(1-dot(Ln, Hn),5) );

    return float3( hlambert, max(0, F*D*G/NV), Rim2*hlambert*max(0.0f, dot(Vn ,-Ln)) );
}

// sNZVF[_
float4 BufferShadow_PS(BufferShadow_OUTPUT IN, uniform const bool useTexture, uniform const bool useNormalMap) : COLOR
{
    float3 Nn = normalize(IN.Normal);
    float3 Vn = normalize(IN.Eye);
    float  NV = dot(Nn, Vn);

    // m[}}bvKp
    if (useNormalMap) {
        float3x3 tangentFrame = compute_tangent_frame(IN.Normal, IN.Eye, IN.Tex);
        Nn = normalize( mul(2.0f * tex2D(NormalMapTexSampler, IN.Tex) - 1.0f, tangentFrame) );
    }

    // n[to[gŖ邳vZ
    float LdN = dot(-LightDirection, Nn);
    float hlambert = LdN*0.5f + 0.5;

    // VhE}bvW
    IN.ZCalcTex /= IN.ZCalcTex.w;
    float2 ShadowMapPos;
    ShadowMapPos.x = (1.0 + IN.ZCalcTex.x)*0.5;
    ShadowMapPos.y = (1.0 - IN.ZCalcTex.y)*0.5;

    // ZtVhEvZ
    float comp0  = 1;
    if( !any( saturate(ShadowMapPos) != ShadowMapPos ) ) {
	comp0 = min(1, ShadowBrightness(ShadowMapPos.xy, IN.ZCalcTex.z));
    }

    // ê(config.hŐݒ)
    float comp = SHADOWTOON

    // CeBO
    float Rim = 1.0f - max( 0.0f, NV );

    // ʍގ̗̖邳} 낢Ə
    float Rim2 = MaterialDiffuse.a >= 0.98f && MaterialDiffuse.a < 1.0f ? Rim+min(0, NV) : Rim;  
 
    // SɃZtVhE̓Cgキ 
    float RimPower = max( 0.0f, dot( Vn, LightDirection )) * saturate(2*(comp0+hlambert));

    Rim = Rim2*RimPower*RimFactor;

    // ƂɃCeBO
    float3 litV0 = LightVec(LightPosition0-IN.WPos, Nn, Vn, NV);
    float3 litV1 = LightVec(LightPosition1-IN.WPos, Nn, Vn, NV);
    float3 litV2 = LightVec(-LightPosition2, Nn, Vn, NV);
    float3 litV3 = LightVec(-LightPosition3, Nn, Vn, NV);

    // MMDW(XyL̂ݎgp)
    float2 litVD = LightVec(-LightDirection,Nn,Vn,NV);
    
    // FKp
    float3 dfCA = (litV0.x*LightColor0*LightPower0) + (litV1.x*LightColor1*LightPower1);
    float3 spCA = (litV0.y*LightColor0*LightPower0) + (litV1.y*LightColor1*LightPower1)
                + (litV2.y*LightColor2*clamp(0,10,LightPower2)) + (litV3.y*LightColor3*clamp(0,10,LightPower3)); // XyL̂Ń~bgݒ
    float3 rmCA = (litV0.z*LightColor0*LightPower0) + (litV1.z*LightColor1*LightPower1) 
                + (litV2.z*LightColor2*LightPower2) + (litV3.z*LightColor3*LightPower3);

    // eNX`Kp   
    if ( useTexture ) {
        DiffuseColor *= tex2D( ObjTexSampler, IN.Tex );
        AmbientColor *= tex2D( ObjTexSampler, IN.Tex );
    }

    // e탉CeBOZ
    float4 Color = float4(AmbientColor.rgb*(1+rmCA*RimFactor)
                    + saturate((DiffuseColor/LightAmbient)*dfCA)
                    + saturate(spCA*SpecFactor*hlambert)
                    + DiffuseColor*hlambert*saturate(comp+MaterialToon*ShadowBias),
                    DiffuseColor.a);

    // CgEXyLZ
    Color.rgb += max( Color.rgb*Rim*Rim, saturate(litVD.y*LightAmbient*SpecFactor*comp0) );
   
    if( transp ) Color.a = 0.5f;
    
    return Color;
}

// IuWFNg`peNjbN
technique MainTecBS0  < string MMDPass = "object_ss"; bool UseTexture = false;> {
    pass DrawObject {
        VertexShader = compile vs_3_0 BufferShadow_VS(false);
        PixelShader  = compile ps_3_0 BufferShadow_PS(false,false);
    }
}

technique MainTecBS1  < string MMDPass = "object_ss"; bool UseTexture = true; bool UseSphereMap = false;> {
    pass DrawObject {
        VertexShader = compile vs_3_0 BufferShadow_VS(true);
        PixelShader  = compile ps_3_0 BufferShadow_PS(true,false);
    }
}

technique MainTecBS2  < string MMDPass = "object_ss"; bool UseTexture = true; bool UseSphereMap = true;> {
    pass DrawObject {
        VertexShader = compile vs_3_0 BufferShadow_VS(true);
        PixelShader  = compile ps_3_0 BufferShadow_PS(true,true);
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////