// MoggDxOpenNI
//  Dinamic link library of OpenNI for DirectX named DxOpenNI.dll
//
//   This program is modified from OpenNI driver.
//   OpenNI is written and distributed under the GNU Lesser General Public License,
//  so this program(dll) is redistributed under the terms of the GNU Lesser General Public License
//  as published by the Free Software Foundation, either version 3 of the License.
//   See the GNU General Public License for more details: <http://www.gnu.org/licenses/>.
// 
//   ̃vOOpenNIhCogpĂ܂BOpenNIGNU LGPLCZXłB
//   āÃvOLGPLCZXɏ]A\[XR[hJ邱ƂƂ܂B
//   ȂÃvO̓_Ci~bNN(dll)ƂĎgpꍇAdll𗘗p
//   ̃vOLGPLCZXɏ]Kv͂܂B
//
//   ܂ÃvO͔MMikuMikuDancepDxOpenNÎłB
//   KIWiDxOpenNIۑĂĂB

#include "DxOpenNI.h"

//===========================================================
// {[␳NX̃x[X
//===========================================================
class CCorrectBonePositionBase
{
protected:
	int GetDepth(const XnDepthPixel* pDepth, int x, int y);
	int GetUserID(const XnLabel* pLabels, int x, int y);
};

//===========================================================
// Grounding\bh钊ۃNX
//===========================================================
class CGrounding : public CCorrectBonePositionBase
{
public:
	virtual void Grounding(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d) = 0;
};

// Grounding
class CNoopGrounding : public CGrounding
{
public:
	void Grounding(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d);
};

// ڒn␳s
class CMoggGrounding : public CGrounding
{
public:
	void Grounding(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d);
};

//===========================================================
// CorrectTilt\bh钊ۃNX
//===========================================================
class CCorrectTilt : public CCorrectBonePositionBase
{
public:
	D3DXMATRIX rotate;	//X␳s

	virtual void SetTilt(XnVector3D legpos, XnVector3D anclepos) = 0;
	virtual void CorrectTilt(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d) = 0;
};

// CorrectTilt
class CNoopCorrectTilt : public CCorrectTilt
{
public:
	void SetTilt(XnVector3D legpos, XnVector3D anclepos);
	void CorrectTilt(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d);
};

// X␳s
class CMoggCorrectTilt : public CCorrectTilt
{
public:
	void SetTilt(XnVector3D legpos, XnVector3D anclepos);
	void CorrectTilt(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d);
};

//===========================================================
// CorrectNeckPosition\bh钊ۃNX
//===========================================================
class CCorrectNeckPosition : public CCorrectBonePositionBase
{
public:
	virtual void CorrectNeckPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, float fineness, D3DXVECTOR3 move) = 0;
};

// CorrectNeckPosition
class CNoopCorrectNeckPosition : public CCorrectNeckPosition
{
public:
	void CorrectNeckPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, float fineness, D3DXVECTOR3 move);
};

// {[␳s
class CMoggCorrectNeckPosition : public CCorrectNeckPosition
{
public:
	void CorrectNeckPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, float fineness, D3DXVECTOR3 move);
};


//===========================================================
// CorrectWristPosition\bh钊ۃNX
//===========================================================
class CCorrectWristPosition : public CCorrectBonePositionBase
{
public:
	virtual void CorrectWristPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int elbow, int hand, int fingertip, float fineness, D3DXVECTOR3 move) = 0;
	virtual void CorrectHandDirection(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int hand, int fingertip, int handdir, float fineness) = 0;
};

// CorrectWristPosition
class CNoopCorrectWristPosition : public CCorrectWristPosition
{
public:
	void CorrectWristPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int elbow, int hand, int fingertip, float fineness, D3DXVECTOR3 move);
	void CorrectHandDirection(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int hand, int fingertip, int handdir, float fineness);
};

// {[␳s
class CMoggCorrectWristPosition : public CCorrectWristPosition
{
public:
	void CorrectWristPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int elbow, int hand, int fingertip, float fineness, D3DXVECTOR3 move);
	void CorrectHandDirection(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int hand, int fingertip, int handdir, float fineness);
};


//===========================================================
// CorrectTorsoPosition\bh钊ۃNX
//===========================================================
class CCorrectTorsoPosition : public CCorrectBonePositionBase
{
public:
	virtual void CorrectTorsoPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d) = 0;
};

// CorrectTorsoPosition
class CNoopCorrectTorsoPosition : public CCorrectTorsoPosition
{
public:
	void CorrectTorsoPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d);
};

// 㔼g{[␳s
class CMoggCorrectTorsoPosition : public CCorrectTorsoPosition
{
public:
	void CorrectTorsoPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d);
};


//===========================================================
// CorrectToePosition\bh钊ۃNX
//===========================================================
class CCorrectToePosition : public CCorrectBonePositionBase
{
public:
	virtual void CorrectToePosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int leg, int knee, int ancle, int toe, float fineness) = 0;
};

// CorrectToePosition
class CNoopCorrectToePosition : public CCorrectToePosition
{
public:
	void CorrectToePosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int leg, int knee, int ancle, int toe, float fineness);
};

// ܐʒus
class CMoggCorrectToePosition : public CCorrectToePosition
{
public:
	void CorrectToePosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int leg, int knee, int ancle, int toe, float fineness);
};


//===========================================================
// CorrectLegPosition\bh钊ۃNX
//===========================================================
class CCorrectLegPosition : public CCorrectBonePositionBase
{
public:
	virtual void CorrectLegPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, float fineness, D3DXVECTOR3 move) = 0;
};

// CorrectLegPosition
class CNoopCorrectLegPosition : public CCorrectLegPosition
{
public:
	void CorrectLegPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, float fineness, D3DXVECTOR3 move);
};

// ̌␳
class CMoggCorrectLegPosition : public CCorrectLegPosition
{
public:
	void CorrectLegPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, float fineness, D3DXVECTOR3 move);
};

//===========================================================
// CorrectShoulderPosition\bh钊ۃNX
//===========================================================
class CCorrectShoulderPosition : public CCorrectBonePositionBase
{
public:
	virtual void CorrectShoulderPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int shoulder_m, int shoulder, int elbow, float fineness, D3DXVECTOR3 move) = 0;
};

// CorrectShoulderPosition
class CNoopCorrectShoulderPosition : public CCorrectShoulderPosition
{
public:
	void CorrectShoulderPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int shoulder_m, int shoulder, int elbow, float fineness, D3DXVECTOR3 move);
};

// ̈ʒu␳
class CMoggCorrectShoulderPosition : public CCorrectShoulderPosition
{
public:
	void CorrectShoulderPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int shoulder_m, int shoulder, int elbow, float fineness, D3DXVECTOR3 move);
};

//===========================================================
// CorrectHeadFrontPosition\bh钊ۃNX
//===========================================================
class CCorrectHeadFrontPosition : public CCorrectBonePositionBase
{
public:
	virtual void CorrectHeadFrontPosition() = 0;
};

// CorrectShoulderPosition
class CNoopCorrectHeadFrontPosition : public CCorrectHeadFrontPosition
{
public:
	void CorrectHeadFrontPosition();
};

// ̌␳
class CForceFrontHeadFrontPosition : public CCorrectHeadFrontPosition
{
public:
	void CorrectHeadFrontPosition();
};

