// MoggDxOpenNI
//  Dinamic link library of OpenNI for DirectX named DxOpenNI.dll
//
//   This program is modified from OpenNI driver.
//   OpenNI is written and distributed under the GNU Lesser General Public License,
//  so this program(dll) is redistributed under the terms of the GNU Lesser General Public License
//  as published by the Free Software Foundation, either version 3 of the License.
//   See the GNU General Public License for more details: <http://www.gnu.org/licenses/>.
// 
//   ̃vOOpenNIhCogpĂ܂BOpenNIGNU LGPLCZXłB
//   āÃvOLGPLCZXɏ]A\[XR[hJ邱ƂƂ܂B
//   ȂÃvO̓_Ci~bNN(dll)ƂĎgpꍇAdll𗘗p
//   ̃vOLGPLCZXɏ]Kv͂܂B
//
//   ܂ÃvO͔MMikuMikuDancepDxOpenNÎłB
//   KIWiDxOpenNIۑĂĂB

#define _USE_MATH_DEFINES
#include "CCorrectBonePositionBase.h"

void CNoopCorrectHeadFrontPosition::CorrectHeadFrontPosition()
{
	//㔼gƓ
	const float len = 100.0f;
	D3DXVECTOR3 headv, shoulderv, frontv;

	headv = BP_Vector[HEAD] - BP_Vector[NECK];
	shoulderv = BP_Vector[SHOULDER_R] - BP_Vector[SHOULDER_L];

	D3DXVec3Cross(&frontv, &headv, &shoulderv);
	//Y͕sv
	frontv.y = 0;
	D3DXVec3Normalize(&frontv, &frontv);

	BP_Vector[HEAD_FRONT] = BP_Vector[HEAD] + frontv * len;
}

void CForceFrontHeadFrontPosition::CorrectHeadFrontPosition()
{
	//if (!BoneLost[HEAD] && !BoneLost[NECK] && !BoneLost[SHOULDER_L] && !BoneLost[SHOULDER_R])
	{
		const double radian = 0.45;
		const float len = 100.0f;
		D3DXVECTOR3 headv, shoulderv, frontv;

		headv = BP_Vector[HEAD] - BP_Vector[NECK];
		shoulderv = BP_Vector[SHOULDER_L] - BP_Vector[SHOULDER_R];

		D3DXVec3Cross(&frontv, &headv, &shoulderv);
		//Y͕sv
		frontv.y = 0;
		D3DXVec3Normalize(&frontv, &frontv);

		//̉܂ł͐^ʂ悤ɂ
		double r = acos(frontv.z), yr = 0;
		if (r < M_PI * radian)
		{
			//+Z()
			BP_Vector[HEAD_FRONT] = D3DXVECTOR3(0, 0, -len) + BP_Vector[HEAD];
		}
		else
		{
			//c͊炩ɉ](0.45-1.00-1.0ɂ)
			yr = (r - M_PI * radian) / (1.0 - radian);

			if (frontv.x > 0)
				BP_Vector[HEAD_FRONT] = D3DXVECTOR3((float)(-sin(yr) * len), 0, (float)(-cos(yr) * len)) + BP_Vector[HEAD];
			else
				BP_Vector[HEAD_FRONT] = D3DXVECTOR3((float)(sin(yr) * len), 0, (float)(-cos(yr) * len)) + BP_Vector[HEAD];
		}
	}
}