// MoggDxOpenNI
//  Dinamic link library of OpenNI for DirectX named DxOpenNI.dll
//
//   This program is modified from OpenNI driver.
//   OpenNI is written and distributed under the GNU Lesser General Public License,
//  so this program(dll) is redistributed under the terms of the GNU Lesser General Public License
//  as published by the Free Software Foundation, either version 3 of the License.
//   See the GNU General Public License for more details: <http://www.gnu.org/licenses/>.
// 
//   ̃vOOpenNIhCogpĂ܂BOpenNIGNU LGPLCZXłB
//   āÃvOLGPLCZXɏ]A\[XR[hJ邱ƂƂ܂B
//   ȂÃvO̓_Ci~bNN(dll)ƂĎgpꍇAdll𗘗p
//   ̃vOLGPLCZXɏ]Kv͂܂B
//
//   ܂ÃvO͔MMikuMikuDancepDxOpenNÎłB
//   KIWiDxOpenNIۑĂĂB

#define _USE_MATH_DEFINES
#include "CCorrectBonePositionBase.h"

void CNoopCorrectLegPosition::CorrectLegPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, float fineness, D3DXVECTOR3 move)
{
	//Ȃ
}

void CMoggCorrectLegPosition::CorrectLegPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, float fineness, D3DXVECTOR3 move)
{
	if (!BoneLost[LEG_L] && !BoneLost[LEG_R])
	{
		int n, x, y, depthsum;
		float left, right;
		D3DXVECTOR3 centerv, v;

		v.x = pos2d[LEG_R].Y - pos2d[TORSO].Y;	//E-Torso̒
		v.y = pos2d[LEG_R].Y - pos2d[LEG_L].Y;
		v.z = pos2d[LEG_R].Z - pos2d[LEG_L].Z;
		centerv.x = (pos2d[LEG_R].X + pos2d[LEG_L].X) / 2.0f;
		centerv.y = (pos2d[LEG_R].Y + pos2d[LEG_L].Y) / 2.0f;
		centerv.z = (pos2d[LEG_R].Z + pos2d[LEG_L].Z) / 2.0f;

		left = 0;
		right = 0;
		depthsum = 0;
		n = 0;
		//𒲂ׂ
		for (float i = 0; i < fineness; i += 1.0f)
		{
			x = (int)(centerv.x - v.x * i / fineness);
			y = (int)(centerv.y - v.y * i / fineness);
			if (GetUserID(pLabels, x, y) == 0)
			{
				left = i;
				break;
			}
			depthsum += GetDepth(pDepth, x, y);
			n++;
		}
		//E𒲂ׂ
		for (float i = 0; i < fineness; i += 1.0f)
		{
			x = (int)(centerv.x + v.x * i / fineness);
			y = (int)(centerv.y + v.y * i / fineness);
			if (GetUserID(pLabels, x, y) == 0)
			{
				right = i;
				break;
			}
			depthsum += GetDepth(pDepth, x, y);
			n++;
		}
		if (left == 0)
			left = fineness;
		if (right == 0)
			right = fineness;

		//SƂ̍xNg
		v = v * 1.2f * (right - left) / fineness;
		v.x *= move.x;
		v.y *= move.y;
		v.z *= move.z;

		//xNgɂȂ
		XnPoint3D result[2];
		result[0].X = pos2d[LEG_R].X + v.x;
		result[0].Y = pos2d[LEG_R].Y + v.y;
		result[0].Z = pos2d[LEG_R].Z + v.z;
		result[1].X = pos2d[LEG_L].X + v.x;
		result[1].Y = pos2d[LEG_L].Y + v.y;
		result[1].Z = pos2d[LEG_L].Z + v.z;

		
		if (n > 0)
		{
			result[0].Z += (centerv.z - depthsum / n);
			result[1].Z += (centerv.z - depthsum / n);
		}

		if (g_DepthGenerator.ConvertProjectiveToRealWorld(2, result, result) == XN_STATUS_OK)
		{
			//̈ʒu
			D3DXVECTOR3 oldpos = BP_Vector[LEG_L];

			//Ȇ炷
			BP_Vector[LEG_R].x = result[0].X;
			BP_Vector[LEG_R].y = result[0].Y;
			BP_Vector[LEG_R].z = result[0].Z;
			BP_Vector[LEG_L].x = result[1].X;
			BP_Vector[LEG_L].y = result[1].Y;
			BP_Vector[LEG_L].z = result[1].Z;

			BP_Vector[LEG_R] -= BP_Zero;
			BP_Vector[LEG_L] -= BP_Zero;

			//̃CƗƂ̃CāẢ]x߂
			D3DXMATRIX mat;
			D3DXVECTOR3 shoulderv, anclev, axis, llv, lrv, cv;

			D3DXVec3Normalize(&shoulderv, &(BP_Vector[SHOULDER_L] - BP_Vector[SHOULDER_R]));
			D3DXVec3Normalize(&anclev, &(BP_Vector[ANCLE_L] - BP_Vector[ANCLE_R]));

			//̃CZĂȂꍇ́A(Ƃ肠)
			if (abs(anclev.z) < sin(M_PI / 12) && anclev.x < 0)
			{
				//2̃ĈȂp
				float r = acos(D3DXVec3Dot(&shoulderv, &anclev));
				//]
				D3DXVec3Cross(&axis, &shoulderv, &anclev);

				//px
				r *= 0.6f;
				//]
				D3DXMatrixRotationAxis(&mat, &axis, r);
				cv = (BP_Vector[LEG_L] + BP_Vector[LEG_R]) / 2;
				D3DXVec3TransformCoord(&llv, &(BP_Vector[LEG_L] - cv), &mat);
				D3DXVec3TransformCoord(&lrv, &(BP_Vector[LEG_R] - cv), &mat);
				BP_Vector[LEG_R] = lrv + cv;
				BP_Vector[LEG_L] = llv + cv;
			}

			//TORSOʒu炷
			D3DXVECTOR3 diffv = BP_Vector[LEG_L] - oldpos;
			if (!BoneLost[TORSO])
				BP_Vector[TORSO] += diffv * 0.3f;
			//Eʒu炷
			if (!BoneLost[NECK])
				BP_Vector[NECK] += diffv * 0.2f;
			if (!BoneLost[HEAD])
				BP_Vector[HEAD] += diffv * 0.6f;
		}
	}
}