// MoggDxOpenNI
//  Dinamic link library of OpenNI for DirectX named DxOpenNI.dll
//
//   This program is modified from OpenNI driver.
//   OpenNI is written and distributed under the GNU Lesser General Public License,
//  so this program(dll) is redistributed under the terms of the GNU Lesser General Public License
//  as published by the Free Software Foundation, either version 3 of the License.
//   See the GNU General Public License for more details: <http://www.gnu.org/licenses/>.
// 
//   ̃vOOpenNIhCogpĂ܂BOpenNIGNU LGPLCZXłB
//   āÃvOLGPLCZXɏ]A\[XR[hJ邱ƂƂ܂B
//   ȂÃvO̓_Ci~bNN(dll)ƂĎgpꍇAdll𗘗p
//   ̃vOLGPLCZXɏ]Kv͂܂B
//
//   ܂ÃvO͔MMikuMikuDancepDxOpenNÎłB
//   KIWiDxOpenNIۑĂĂB

#include "CCorrectBonePositionBase.h"

void CNoopCorrectNeckPosition:: CorrectNeckPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, float fineness, D3DXVECTOR3 move)
{
	//Ȃ
}

void CMoggCorrectNeckPosition::CorrectNeckPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, float fineness, D3DXVECTOR3 move)
{
	if (!BoneLost[HEAD] && !BoneLost[NECK])
	{
		float x, y;
		int userid = 0;
		XnPoint3D result[1], pos[1];

		//-xNgƂ̒xNg
		D3DXVECTOR3 axisY, axisX, v;
		axisY.x = pos2d[NECK].X - pos2d[HEAD].X;
		axisY.y = pos2d[NECK].Y - pos2d[HEAD].Y;
		axisX.x = axisY.y;
		axisX.y = -axisY.x;

		//-xNg̒A̔Ɏg
		float width = 1.0f;

		//wiȊÖԍLA̒S𒲂ׂĂ
		int prevuserid;
		float s1, e1, s2, e2;
		float dn, center = 0, tc;
		for (float dy = 0; dy < 1.0f; dy += 1.0f / fineness)
		{
			x = (float)(pos2d[HEAD].X + axisY.x * dy - axisX.x * width);
			y = (float)(pos2d[HEAD].Y + axisY.y * dy - axisX.y * width);

			dn = 0;
			s1 = e1 = s2 = e2 = 0;
			prevuserid = 0;	//1OID

			for (float ix = 0; ix <= fineness; ix += 1.0)
			{
				userid = GetUserID(pLabels, (int)x, (int)y);
				
				if (userid > 0)
				{
					if (prevuserid == 0)
						s1 = ix;
					dn += 1.0f;
				}
				else
				{
					if (prevuserid != 0)
					{
						e1 = ix;
						if (e1 - s1 > e2 - s2)
						{
							//ő咷
							s2 = s1;
							e2 = e1;
						}
					}
				}

				x += (float)(axisX.x * width * 2 / fineness);
				y += (float)(axisX.y * width * 2 / fineness);
				prevuserid = userid;
			}

			//Ōオő̂Ƃ́A
			if (e2 == fineness)
				s2 = 0;
			//ŏő̂Ƃ́A
			if (s2 == 0)
				e2 = fineness;

			//̍s̒S̋(tc)߂
			tc = (e2 + s2) / fineness / 2.0f;
			//S̋ԗĂ̗̂p
			if (abs(center - 0.5f) < abs(tc - 0.5f))
				center = tc;
		}

		//X͖
		if (abs(center) < 0.1)
			center = 0;

		//ʒu(FX)
		pos[0].X = pos2d[HEAD].X + (axisY.x + axisX.x * center) * 2.0f;
		pos[0].Y = pos2d[HEAD].Y + (axisY.y * 0.4f + axisX.y * center) * 2.0f;
		pos[0].Z = pos2d[HEAD].Z + (pos3d[NECK].Z - pos3d[HEAD].Z) * 0.6f;

		//ˉeW֕ϊ
		
		if (g_DepthGenerator.ConvertProjectiveToRealWorld(1, pos, result) == XN_STATUS_OK)
		{
			if (result[0].Y > -500)
			{
				D3DXVECTOR3 newpos, diffv;

				newpos.x = result[0].X - BP_Zero.x;
				newpos.y = result[0].Y - BP_Zero.y;
				newpos.z = result[0].Z - BP_Zero.z;
				//pos2d[NECK] = pos[0];

				//XxNg
				diffv = BP_Vector[NECK] - newpos;
				diffv *= 1.5f;
				diffv.x *= move.x;
				diffv.y *= move.y;
				diffv.z *= move.z;

				//̈ʒu𒲐
				BP_Vector[HEAD] += diffv;

				//̈ʒu𒲐
				if (!BoneLost[SHOULDER_L])
					BP_Vector[SHOULDER_L] -= diffv * 0.5f;
				if (!BoneLost[SHOULDER_R])
					BP_Vector[SHOULDER_R] -= diffv * 0.5f;

				//̈ʒu𒲐
				float len = D3DXVec3Length(&(BP_Vector[LEG_L] - BP_Vector[LEG_R])) * 0.5f;	//Ҋ->E̕t ̒
				D3DXVECTOR3 shline;
				//CYW𑫂ɉ
				shline = BP_Vector[LEG_L] - BP_Vector[LEG_R];
				D3DXVec3Normalize(&shline, &shline);
				shline *= len;

				if (!BoneLost[LEG_L])
				{
					BP_Vector[LEG_L].y -= shline.y;
					BP_Vector[LEG_L] += diffv * 1.5f;
				}
				if (!BoneLost[LEG_R])
				{
					BP_Vector[LEG_R].y += shline.y;
					BP_Vector[LEG_R] += diffv * 1.5f;
				}
			}
		}
	}
}
