// MoggDxOpenNI
//  Dinamic link library of OpenNI for DirectX named DxOpenNI.dll
//
//   This program is modified from OpenNI driver.
//   OpenNI is written and distributed under the GNU Lesser General Public License,
//  so this program(dll) is redistributed under the terms of the GNU Lesser General Public License
//  as published by the Free Software Foundation, either version 3 of the License.
//   See the GNU General Public License for more details: <http://www.gnu.org/licenses/>.
// 
//   ̃vOOpenNIhCogpĂ܂BOpenNIGNU LGPLCZXłB
//   āÃvOLGPLCZXɏ]A\[XR[hJ邱ƂƂ܂B
//   ȂÃvO̓_Ci~bNN(dll)ƂĎgpꍇAdll𗘗p
//   ̃vOLGPLCZXɏ]Kv͂܂B
//
//   ܂ÃvO͔MMikuMikuDancepDxOpenNÎłB
//   KIWiDxOpenNIۑĂĂB

#define _USE_MATH_DEFINES
#include "CCorrectBonePositionBase.h"

void CNoopCorrectShoulderPosition::CorrectShoulderPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int shoulder_m, int shoulder, int elbow, float fineness, D3DXVECTOR3 move)
{
	//ʒuɒu
	if (!BoneLost[shoulder] && !BoneLost[elbow])
	{
		D3DXVECTOR3 shoulderv, elbowv;

		shoulderv = ((BP_Vector[SHOULDER_L] + BP_Vector[SHOULDER_R]) / 2.0f) - BP_Vector[shoulder];
		elbowv = BP_Vector[elbow] - BP_Vector[shoulder];

		//̒pxNg
		BP_Vector[shoulder_m] = BP_Vector[shoulder] + (shoulderv + elbowv) * 0.001f;

		BoneLost[shoulder_m] = false;
		return;
	}
	BoneLost[shoulder_m] = true;
}

void CMoggCorrectShoulderPosition::CorrectShoulderPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int shoulder_m, int shoulder, int elbow, float fineness, D3DXVECTOR3 move)
{
	if (!BoneLost[shoulder] && !BoneLost[elbow])
	{
		float ycos, vlen;
		D3DXVECTOR3 shoulderv, elbowv, v, yv, zv, nv;

		shoulderv = ((BP_Vector[SHOULDER_L] + BP_Vector[SHOULDER_R]) / 2.0f) - BP_Vector[shoulder];
		elbowv = BP_Vector[elbow] - BP_Vector[shoulder];

		//̒pxNg
		v = (shoulderv + elbowv) * 0.4f;
		v.x *= move.x;
		v.y *= move.y;
		v.z *= move.z;

		vlen = D3DXVec3Length(&v);
		D3DXVec3Normalize(&nv, &v);

		//-Torso̕(Y)́Aɂ͂܂蔽fȂ
		yv = BP_Vector[NECK] - BP_Vector[TORSO];
		D3DXVec3Normalize(&yv, &yv);

		ycos = D3DXVec3Dot(&yv, &nv) + 0.2f;
		if (ycos < 0)
		{
			v -= yv * vlen * ycos;
		}

		//ʕɂ܂s߂Ȃ悤ɂ
		D3DXVec3Normalize(&zv, &shoulderv);

		ycos = D3DXVec3Dot(&zv, &nv);
		v -= zv * vlen * ycos * 1.0f;
		

		BP_Vector[shoulder_m] = BP_Vector[shoulder] + v;

		BoneLost[shoulder_m] = false;
		return;
	}
	BoneLost[shoulder_m] = true;
}