// MoggDxOpenNI
//  Dinamic link library of OpenNI for DirectX named DxOpenNI.dll
//
//   This program is modified from OpenNI driver.
//   OpenNI is written and distributed under the GNU Lesser General Public License,
//  so this program(dll) is redistributed under the terms of the GNU Lesser General Public License
//  as published by the Free Software Foundation, either version 3 of the License.
//   See the GNU General Public License for more details: <http://www.gnu.org/licenses/>.
// 
//   ̃vOOpenNIhCogpĂ܂BOpenNIGNU LGPLCZXłB
//   āÃvOLGPLCZXɏ]A\[XR[hJ邱ƂƂ܂B
//   ȂÃvO̓_Ci~bNN(dll)ƂĎgpꍇAdll𗘗p
//   ̃vOLGPLCZXɏ]Kv͂܂B
//
//   ܂ÃvO͔MMikuMikuDancepDxOpenNÎłB
//   KIWiDxOpenNIۑĂĂB

#define _USE_MATH_DEFINES
#include "CCorrectBonePositionBase.h"

void CNoopCorrectToePosition::CorrectToePosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int leg, int knee, int ancle, int toe, float fineness)
{
	//Ȃ
	D3DXMATRIX mat;
	D3DXVECTOR3 legv, kneev, anclev;
	D3DXVECTOR3 zv, xv, yv, v;

	legv = D3DXVECTOR3(pos3d[leg].X, pos3d[leg].Y, pos3d[leg].Z);
	kneev = D3DXVECTOR3(pos3d[knee].X, pos3d[knee].Y, pos3d[knee].Z);
	anclev = D3DXVECTOR3(pos3d[ancle].X, pos3d[ancle].Y, pos3d[ancle].Z);

	yv = D3DXVECTOR3(0, 1, 0);
	D3DXVec3Cross(&zv, &(legv - kneev), &(BP_Vector[LEG_L] - BP_Vector[LEG_R]));

	D3DXVec3Normalize(&zv, &zv);
	zv *= D3DXVec3Length(&(legv - anclev)) * 1.1f;

	//XẐܐ
	zv = anclev - D3DXVECTOR3(legv.x + zv.x, anclev.y, legv.z + zv.z);
	
	//-Ђƒ
	D3DXVec3Cross(&zv, &zv, &yv);
	//zv110x炢܂킷
	D3DXMatrixRotationAxis(&mat, &zv, (float)(M_PI * 0.4));
	D3DXVec3TransformCoord(&v, &(anclev - kneev), &mat);
	//D3DXVec3Cross(&v, &zv, &(anclev - kneev));
	D3DXVec3Normalize(&v, &v);

	v *= 100.0f;
	BP_Vector[toe] = BP_Vector[ancle] + v;
}

void CMoggCorrectToePosition::CorrectToePosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int leg, int knee, int ancle, int toe, float fineness)
{
	if (!BoneLost[knee] && !BoneLost[ancle])
	{
		int x, y;
		float d, depth, centerdepth;

		//Ƃ𒆐Sɂƌn
		D3DXVECTOR3 center, v, xyv, depthv_low;
		D3DXMATRIX mat;
		center.x = pos2d[ancle].X;
		center.y = pos2d[ancle].Y;
		center.z = pos2d[ancle].Z;
		v.x = pos2d[knee].X - pos2d[ancle].X;
		v.y = pos2d[knee].Y - pos2d[ancle].Y;
		v.z = 0;
		v *= 0.5f;

		//ƈʒu𒲐
		D3DXVECTOR3 legv, kneev;

		kneev.x = pos3d[ancle].X - pos3d[leg].X;
		kneev.y = pos3d[ancle].Y - pos3d[leg].Y;
		kneev.z = pos3d[ancle].Z - pos3d[leg].Z;
		D3DXVec3Normalize(&kneev, &kneev);

		//ɒu
		legv.x = v.y;
		legv.y = v.x;
		legv.z = 0;

		//𒲂ׂ
		float i = 0;
		float sum = 0;
		while (GetUserID(pLabels, (int)(center.x + legv.x * i / fineness), (int)(center.y + legv.y * i / fineness)) > 0)
		{
			i += 1.0f;
			sum += 1.0f;
		}
		i = 0;
		while (GetUserID(pLabels, (int)(center.x - legv.x * i / fineness), (int)(center.y - legv.y * i / fineness)) > 0)
		{
			i += 1.0f;
			sum -= 1.0f;
		}
		sum /= 2;
		center.x += legv.x * sum / fineness;
		center.y += legv.y * sum / fineness;

		//Ђ-ƂY̊px(O)PI/4ȏォǂ𒲂ׂ(̂Ƃ͏㔼XYʋ𒲂ׂ)
		D3DXVECTOR3 tv = D3DXVECTOR3(pos3d[ancle].X, pos3d[ancle].Y, pos3d[ancle].Z) - D3DXVECTOR3(pos3d[knee].X, pos3d[knee].Y, pos3d[knee].Z);
		D3DXVec3Normalize(&tv, &tv);
		float cos = D3DXVec3Dot(&tv, &D3DXVECTOR3(0, -1, 0));
		bool isUpSkew = (cos < 0.7 && kneev.z < 0);
		bool isDownSkew = (cos < 0.8 && kneev.z > 0);

		//XYʂѐ[x牓T
		float maxlen = 0;
		float maxdepth_low = 0;
		xyv = D3DXVECTOR3(0, 0, 0);
		depthv_low = D3DXVECTOR3(0, 0, 0);
		centerdepth = (float)GetDepth(pDepth, (int)center.x, (int)center.y);

		//90x]Ƃ납Jn
		D3DXVec3TransformCoord(&v, &v, D3DXMatrixRotationZ(&mat, (float)(M_PI / 2.0)));

		for (i = 0; i < fineness * 4; i += 1.0f)
		{
			depth = centerdepth;
			for (float r = 1.0f; r < fineness; r += 1.0f)
			{
				x = (int)(center.x + v.x * r / fineness);
				y = (int)(center.y + v.y * r / fineness);

				//XY
				d = (float)GetDepth(pDepth, x, y);

				if (GetUserID(pLabels, x, y) == 0 || depth - d > 30 || d - depth > 20)	//[}ɕς炻ŏI
				{
					if ((isUpSkew || i < fineness * 2) && r > maxlen)
					{
						maxlen = r;
						xyv = v * (r - 1.0f) / fineness;
						xyv.z = depth;
					}
					break;
				}
				depth = d;

				//[x
				if ((!isDownSkew || i < fineness * 2))
				{
					if (centerdepth - depth > maxdepth_low)
					{
						maxdepth_low = centerdepth - depth;
						depthv_low = v * (r - 1.0f) / fineness;
						depthv_low.z = depth;
					}
				}
			}
			
			//]
			D3DXVec3TransformCoord(&v, &v, D3DXMatrixRotationZ(&mat, (float)(M_PI * 2 / (fineness * 4))));
		}

		//XYʂ̈ʒuƁA[ẍʒurĉI
		//ˉeW֕ϊ
		XnPoint3D pos[3], result[3];
		pos[2].X = center.x;
		pos[2].Y = center.y;
		pos[2].Z = center.z;
		pos[0].X = center.x + xyv.x;
		pos[0].Y = center.y + xyv.y;
		pos[0].Z = xyv.z;
		pos[1].X = center.x + depthv_low.x;
		pos[1].Y = center.y + depthv_low.y;
		pos[1].Z = depthv_low.z;

		if (g_DepthGenerator.ConvertProjectiveToRealWorld(3, pos, result) == XN_STATUS_OK)
		{
			int idx = 0;
			float len[2];
			D3DXVECTOR3 centerv = D3DXVECTOR3(result[2].X, result[2].Y, result[2].Z);
			D3DXVECTOR3 resultv[2];

			//
			for (int i = 0; i < 2; i++)
			{
				resultv[i] = D3DXVECTOR3(result[i].X, result[i].Y, result[i].Z) - centerv;
				len[i] = D3DXVec3Length(&resultv[i]);
				D3DXVec3Normalize(&resultv[i], &resultv[i]);
			}

			//Ƃ̊px𒲂ׂ
			for (int i = 0; i < 2; i++)
			{
				//Gɂ͖̂
				if (D3DXVec3Dot(&kneev, &resultv[i]) < -0.1)
					len[i] = 0;

				//񂺂Ⴄ͖̂
				D3DXVec3Normalize(&legv, &(BP_Vector[toe] - BP_Vector[ancle]));
				if (D3DXVec3Dot(&legv, &resultv[i]) < 0)
					len[i] = 0;

				//Zl[͏
				if (pos[i].Z == 0)
					len[i] = 0;
			}
			

			if (len[0] > 0 || len[1] > 0)
			{
				if (len[0] > len[1])
				{
					//XYʂ̂ق
					idx = 0;
				}
				else
				{
					//[x()̂ق
					idx = 1;
				}

				if (len[idx] > 80 && len[idx] < 200)
				{
					//Ē
					center.x = pos[2].X + (pos[idx].X - pos[2].X) * 0.8f;
					center.y = pos[2].Y + (pos[idx].Y - pos[2].Y) * 0.8f;
					D3DXVECTOR3 tv = D3DXVECTOR3(pos[idx].Y - pos[2].Y, -(pos[idx].X - pos[2].X), 0);	//xNg
					D3DXVec3Normalize(&tv, &tv);
					tv *= D3DXVec3Length(&v) / 2;

					float tw = 0, w = 0;
					while (tw < fineness / 2 && GetUserID(pLabels, (int)(center.x + tv.x * tw / fineness), (int)(center.y + tv.y * tw / fineness)) > 0)
					{
						tw += 1.0f;
						w += 1.0f;
					}
					tw = 0;
					while (tw < fineness / 2 && GetUserID(pLabels, (int)(center.x - tv.x * tw / fineness), (int)(center.y - tv.y * tw / fineness)) > 0)
					{
						tw += 1.0f;
						w -= 1.0f;
					}

					pos[0].X = pos[idx].X + tv.x * w / fineness / 2;
					pos[0].Y = pos[idx].Y + tv.y * w / fineness / 2;
					pos[0].Z = pos[idx].Z;
					//printf("%d %f %f, %f\n", toe, w, tv.x, tv.y);

					if (g_DepthGenerator.ConvertProjectiveToRealWorld(1, pos, result) == XN_STATUS_OK)
					{
						BP_Vector[toe].x = result[0].X - BP_Zero.x;
						BP_Vector[toe].y = result[0].Y - BP_Zero.y;
						BP_Vector[toe].z = result[0].Z - BP_Zero.z + 20.0f;
						BoneLost[toe] = false;
						//if (toe == TOE_L)
						//printf("%d; %f, %f, %f  %f\n", idx, BP_Vector[toe].x, BP_Vector[toe].y, BP_Vector[toe].z, maxdepth_low);
						return;
					}
				}
				//if (toe == TOE_L)
				//printf("%d; %f %f\n", idx, len[idx], pos[idx].Z);
			}
		}
		//XgAÖʒuێ
		BoneLost[toe] = false;
		//ʒuړ
		BP_Vector[toe] += BP_Vector[ancle] - g_BpHistory[ancle][HISTORY_COUNT - 1].position;
	}
	//Xg
	BoneLost[toe] = true;
}