// MoggDxOpenNI
//  Dinamic link library of OpenNI for DirectX named DxOpenNI.dll
//
//   This program is modified from OpenNI driver.
//   OpenNI is written and distributed under the GNU Lesser General Public License,
//  so this program(dll) is redistributed under the terms of the GNU Lesser General Public License
//  as published by the Free Software Foundation, either version 3 of the License.
//   See the GNU General Public License for more details: <http://www.gnu.org/licenses/>.
// 
//   ̃vOOpenNIhCogpĂ܂BOpenNIGNU LGPLCZXłB
//   āÃvOLGPLCZXɏ]A\[XR[hJ邱ƂƂ܂B
//   ȂÃvO̓_Ci~bNN(dll)ƂĎgpꍇAdll𗘗p
//   ̃vOLGPLCZXɏ]Kv͂܂B
//
//   ܂ÃvO͔MMikuMikuDancepDxOpenNÎłB
//   KIWiDxOpenNIۑĂĂB

#include "CCorrectBonePositionBase.h"

void CNoopCorrectWristPosition::CorrectWristPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int elbow, int hand, int fingertip, float fineness, D3DXVECTOR3 move)
{
	//ʒuɂ
	BP_Vector[fingertip] = BP_Vector[hand];
}
void CNoopCorrectWristPosition::CorrectHandDirection(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int hand, int fingertip, int handdir, float fineness)
{
	BP_Vector[handdir] = BP_Vector[fingertip];
	BP_Vector[handdir].y = LOSTBONE_VALUE;
	BoneLost[handdir] = true;
}

//ʒu𒲂ׂ
void CMoggCorrectWristPosition::CorrectWristPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int elbow, int hand, int fingertip, float fineness, D3DXVECTOR3 move)
{
	if (!BoneLost[hand] && !BoneLost[elbow])
	{
		float x, y;
		int userid = 0;
		XnPoint3D result[1];

		//I-xNgƂ̒xNg
		D3DXVECTOR3 axisY, axisX;

		axisY.x = pos2d[hand].X - pos2d[elbow].X;
		axisY.y = pos2d[hand].Y - pos2d[elbow].Y;
		axisY.z = pos2d[hand].Z - pos2d[elbow].Z;
		axisX.x = axisY.y;
		axisX.y = -axisY.x;
		axisX.z = axisY.z;

		//I-xNg̒AɎg
		float width = 0.6f;

		//wiȊÖԍLA̒S𒲂ׂĂ
		int prevuserid;
		int n = 0;
		float s1, e1, s2, e2, dn;
		float minz, maxz;
		D3DXVECTOR3 tv, v, iv, av;

		v.x = 0;
		v.y = 0;
		v.z = 0;
		//vxNg(ς邽)
		av.x = 0; av.y = 0, av.z = 0;
		//Z̍ŏEő
		minz = (float)min(pos2d[elbow].Z, pos2d[hand].Z);
		maxz = (float)max(pos2d[elbow].Z, pos2d[hand].Z);
		//ő[
		result[0].X = 0;
		result[0].Y = 0;
		result[0].Z = minz;
		
		for (float dy = 0.6f; dy < 0.8f; dy += 1.0f / fineness)
		{
			x = (float)(pos2d[elbow].X + axisY.x * dy - axisX.x * width);
			y = (float)(pos2d[elbow].Y + axisY.y * dy - axisX.y * width);

			dn = 0;
			s1 = e1 = s2 = e2 = 0;
			prevuserid = 0;	//1OID

			for (float ix = 0; ix <= fineness; ix += 1.0)
			{
				userid = GetUserID(pLabels, (int)x, (int)y);
				
				//[
				if (userid > 0 && GetDepth(pDepth, (int)x, (int)y) > maxz + 20) 
					userid = 0;

				if (userid > 0)
				{
					if (prevuserid == 0)
						s1 = ix;
					dn += 1.0f;
				}
				else
				{
					if (prevuserid != 0)
					{
						e1 = ix;
						if (e1 - s1 > e2 - s2 && s1 > 0)
						{
							//ő咷
							s2 = s1;
							e2 = e1;
						}
					}
				}

				x += (float)(axisX.x * width * 2 / fineness);
				y += (float)(axisX.y * width * 2 / fineness);
				prevuserid = userid;
			}

			//Ōオő̂Ƃ́A
			if (e2 == fineness)
				s2 = 0;
			//ŏő̂Ƃ́A
			if (s2 == 0)
				e2 = fineness;

			//̍s̒S̋(tc)߂
			tv.x = (e2 + s2) / fineness / 2.0f - 0.5f;
			tv.y = dy;

			//[
			x = (float)(pos2d[elbow].X + axisY.x * tv.y + axisX.x * tv.x * width);
			y = (float)(pos2d[elbow].Y + axisY.y * tv.y + axisX.y * tv.x * width);
			tv.z = (float)GetDepth(pDepth, (int)x, (int)y);

			//[[͑ΏۊO
			if (tv.z > 0)
			{
				//[ɐ
				if (tv.z < minz)
					tv.z = minz;
				if (tv.z > maxz)
					tv.z = maxz;
				//vxNg
				n++;
				av += tv;

				//S̋ԗĂ̗̂p
				if (abs(v.x) < abs(tv.x))
					v = av / (float)n;
			}
		}

		//́ANITE̎̈ʒu
		BP_Vector[fingertip] = BP_Vector[hand];
		BoneLost[fingertip] = false;
		pos2d[fingertip] = pos2d[hand];
		pos3d[fingertip] = pos3d[hand];

		//ʒu
		if (abs(v.x) < 0.01)
		{
			//ɋ߂Ƃɂ́A2/3̈ʒuɂ
			float l = 2.0f / 3.0f;
			BP_Vector[hand].x = pos3d[elbow].X + (pos3d[hand].X - pos3d[elbow].X) * l - BP_Zero.x;
			BP_Vector[hand].y = pos3d[elbow].Y + (pos3d[hand].Y - pos3d[elbow].Y) * l - BP_Zero.y;
			BP_Vector[hand].z = pos3d[elbow].Z + (pos3d[hand].Z - pos3d[elbow].Z) * l - BP_Zero.z;
			BoneLost[hand] = false;
			//ʒuȂ
			pos3d[hand].X = BP_Vector[hand].x;
			pos3d[hand].Y = BP_Vector[hand].y;
			pos3d[hand].Z = BP_Vector[hand].z;
			if (g_DepthGenerator.ConvertRealWorldToProjective(1, result, result) == XN_STATUS_OK)
				pos2d[hand] = result[0];
			return;
		}
		else
		{
			//ʒu𒲐
			v.x *= 1.5f * move.x;

			result[0].X = pos2d[elbow].X + axisY.x * v.y + axisX.x * v.x * width;
			result[0].Y = pos2d[elbow].Y + axisY.y * v.y + axisX.y * v.x * width;
			result[0].Z = v.z;

			//ˉeW֕ϊ
			if (g_DepthGenerator.ConvertProjectiveToRealWorld(1, result, result) == XN_STATUS_OK)
			{
				if (result[0].Y > -500)
				{
					//ɓƎ擾ʒu
					BP_Vector[hand].x = result[0].X - BP_Zero.x;
					BP_Vector[hand].y = result[0].Y - BP_Zero.y;
					BP_Vector[hand].z = result[0].Z - BP_Zero.z;
					BoneLost[hand] = false;
					//ʒuȂ
					pos3d[hand].X = BP_Vector[hand].x;
					pos3d[hand].Y = BP_Vector[hand].y;
					pos3d[hand].Z = BP_Vector[hand].z;
					if (g_DepthGenerator.ConvertRealWorldToProjective(1, result, result) == XN_STATUS_OK)
						pos2d[hand] = result[0];
					return;
				}
			}
		}
	}
	BoneLost[hand] = true;
	BoneLost[fingertip] = true;

}

//̂Ђ˂𒲂ׂ(gp)
void CMoggCorrectWristPosition::CorrectHandDirection(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int hand, int fingertip, int handdir, float fineness)
{
	if (!BoneLost[hand] && !BoneLost[fingertip])
	{
		float len;
		int userid;
		float depth;
		D3DXVECTOR2 initv, handv, pos;


		//-̂Ђ璼xNg
		initv.x = pos2d[hand].X + (pos2d[fingertip].X - pos2d[hand].X) * 0.5f;
		initv.y = pos2d[hand].Y + (pos2d[fingertip].Y - pos2d[hand].Y) * 0.5f;


		handv.x = pos2d[fingertip].Y - pos2d[hand].Y;
		handv.y = -(pos2d[fingertip].X - pos2d[hand].X);
		len = D3DXVec2Length(&handv);

		//ʒu
		pos = initv - handv * 0.5f;

		for (float idx = 0 ; idx < len; idx += 0.5f)
		{
			userid = GetUserID(pLabels, (int)pos.x, (int)pos.y);
			if (userid > 0)
			{
				depth = (float)GetDepth(pDepth, (int)pos.x, (int)pos.y);
				//printf("0");
				//printf("%4.0f ", depth);
			}

			pos = pos + handv * idx / len;
		}
		//printf("\ninfo %f (%f,%f)-(%f,%f)\n", len, pos2d[hand].X, pos2d[hand].Y, pos2d[fingertip].X, pos2d[fingertip].Y);
		//printf("\n");
	}
	BoneLost[handdir] = true;
}
