// MoggDxOpenNI
//  Dinamic link library of OpenNI for DirectX named DxOpenNI.dll
//
//   This program is modified from OpenNI driver.
//   OpenNI is written and distributed under the GNU Lesser General Public License,
//  so this program(dll) is redistributed under the terms of the GNU Lesser General Public License
//  as published by the Free Software Foundation, either version 3 of the License.
//   See the GNU General Public License for more details: <http://www.gnu.org/licenses/>.
// 
//   ̃vOOpenNIhCogpĂ܂BOpenNIGNU LGPLCZXłB
//   āÃvOLGPLCZXɏ]A\[XR[hJ邱ƂƂ܂B
//   ȂÃvO̓_Ci~bNN(dll)ƂĎgpꍇAdll𗘗p
//   ̃vOLGPLCZXɏ]Kv͂܂B
//
//   ܂ÃvO͔MMikuMikuDancepDxOpenNÎłB
//   KIWiDxOpenNIۑĂĂB

#include <Windows.h>
#include <TCHAR.H>
#include "CMoggDxOpenNI.h"

void CMoggDxOpenNI::LoadSettingFile()
{
	//t@C
	TCHAR path[MAX_PATH + 1];
	::GetCurrentDirectory(MAX_PATH, path);
	::_tcscat_s(path, MAX_PATH, L"\\Data\\moggdxopenni.ini");

	//ݒl
	int smoothing = ::GetPrivateProfileInt(L"Motion", L"Smoothing", 0, path);
	int bonelostaction = ::GetPrivateProfileInt(L"Motion", L"BoneLostAction", 1, path);
	int grounding = ::GetPrivateProfileInt(L"Motion", L"Grounding", 1, path);
	int tilt = ::GetPrivateProfileInt(L"Motion", L"CorrectTilt", 1, path);
	int neck = ::GetPrivateProfileInt(L"Motion", L"Neck", 1, path);
	int wrist = ::GetPrivateProfileInt(L"Motion", L"Wrist", 1, path);
	int torso = 0;//::GetPrivateProfileInt(L"Motion", L"Torso", 0, path);
	int hip = ::GetPrivateProfileInt(L"Motion", L"Hip", 1, path);
	int toe = ::GetPrivateProfileInt(L"Motion", L"Toe", 1, path);
	int shoulder = ::GetPrivateProfileInt(L"Motion", L"Shoulder", 1, path);
	int headfront = ::GetPrivateProfileInt(L"Motion", L"FrontFace", 1, path);

	bool custom = (::GetPrivateProfileInt(L"Motion", L"CustomMove", 0, path) == 1);

	if (custom)
	{
		neckMove.x = ::GetPrivateProfileInt(L"Motion", L"NeckMove_X", 100, path) / 100.0f;
		neckMove.y = ::GetPrivateProfileInt(L"Motion", L"NeckMove_Y", 100, path) / 100.0f;
		neckMove.z = ::GetPrivateProfileInt(L"Motion", L"NeckMove_Z", 100, path) / 100.0f;
		wristMove.x = ::GetPrivateProfileInt(L"Motion", L"WristMove_X", 100, path) / 100.0f;
		wristMove.y = ::GetPrivateProfileInt(L"Motion", L"WristMove_Y", 100, path) / 100.0f;
		wristMove.z = ::GetPrivateProfileInt(L"Motion", L"WristMove_Z", 100, path) / 100.0f;
		hipMove.x = ::GetPrivateProfileInt(L"Motion", L"HipMove_X", 100, path) / 100.0f;
		hipMove.y = ::GetPrivateProfileInt(L"Motion", L"HipMove_Y", 100, path) / 100.0f;
		hipMove.z = ::GetPrivateProfileInt(L"Motion", L"HipMove_Z", 100, path) / 100.0f;
		shoulderMove.x = ::GetPrivateProfileInt(L"Motion", L"ShoulderMove_X", 100, path) / 100.0f;
		shoulderMove.y = ::GetPrivateProfileInt(L"Motion", L"ShoulderMove_Y", 100, path) / 100.0f;
		shoulderMove.z = ::GetPrivateProfileInt(L"Motion", L"ShoulderMove_Z", 100, path) / 100.0f;
	}
	else
	{
		float v = ::GetPrivateProfileInt(L"Motion", L"NeckMove", 100, path) / 100.0f;
		neckMove.x = v;
		neckMove.y = v;
		neckMove.z = v;
		v = ::GetPrivateProfileInt(L"Motion", L"WristMove", 100, path) / 100.0f;
		wristMove.x = v;
		wristMove.y = v;
		wristMove.z = v;
		v = ::GetPrivateProfileInt(L"Motion", L"HipMove", 100, path) / 100.0f;
		hipMove.x = v;
		hipMove.y = v;
		hipMove.z = v;
		v = ::GetPrivateProfileInt(L"Motion", L"ShoulderMove", 100, path) / 100.0f;
		shoulderMove.x = v;
		shoulderMove.y = v;
		shoulderMove.z = v;
	}

#ifdef _DEBUG
	wprintf_s(L"ini: %s\n", path);
	printf("smoothing: %d\n", smoothing);
	printf("bonelost: %d\n", bonelostaction);
	printf("grounding: %d\n", grounding);
	printf("tilt: %d\n", tilt);
	printf("neck: %d\n", neck);
	printf("wrist: %d\n", wrist);
	//printf("torso: %d\n", torso);
	printf("hip: %d\n", hip);
	printf("toe: %d\n", toe);
	printf("shoulder: %d\n", shoulder);
	printf("headfront: %d\n", headfront);

	printf("neckMove: %f,%f,%f\n", neckMove.x, neckMove.y, neckMove.z);
	printf("wristMove: %f,%f,%f\n", wristMove.x, wristMove.y, wristMove.z);
	printf("hipMove: %f,%f,%f\n", hipMove.x, hipMove.y, hipMove.z);
	printf("ShoulderMove: %f,%f,%f\n", shoulderMove.x, shoulderMove.y, shoulderMove.z);
#endif


	//ݒɂďgݗĂ
	cInit = new CNoopOpenNIInit();
	cClean = new CNoopOpenNIClean();

	//NITEɂftHgX[WOON/OFF
	if (smoothing <= 10)
	{
		//Smoothing Factor (0.0f - 1.0f)
		smoothingFactor = (float)(smoothing / 10.0f);
#ifdef _DEBUG
		printf("SmoothingFactor: %f\n", smoothingFactor);
#endif
		cSetSmoothing = new CMoggSetSmoothing();
		cSmoothingBone = new CMoggSmoothingBone();
	}
	else
	{
		smoothingFactor = 0;
		cSetSmoothing = new CNoopSetSmoothing();
		cSmoothingBone = new CNoopSmoothingBone();
	}
	//{[Xg̓
	switch(bonelostaction)
	{
	case 0:
		cLostBoneBehavior = new CDefaultLostBoneBehavior();
		break;
	case 1:
		cLostBoneBehavior = new CKeepPositionLostBoneBehavior();
		break;
	}
	//X␳
	switch(tilt)
	{
	case 0:
		cCorrectTilt = new CNoopCorrectTilt();
		break;
	case 1:
		cCorrectTilt = new CMoggCorrectTilt();
		break;
	}
	//ڒn␳
	switch(grounding)
	{
	case 0:
		cGrounding = new CNoopGrounding();
		break;
	case 1:
		cGrounding = new CMoggGrounding();
		break;
	}
	//e{[̈ʒu␳
	//
	switch(neck)
	{
	case 0:
		cNeck = new CNoopCorrectNeckPosition();
		break;
	case 1:
		cNeck = new CMoggCorrectNeckPosition();
		break;
	}
	//
	switch(wrist)
	{
	case 0:
		cWrist = new CNoopCorrectWristPosition();
		break;
	case 1:
		cWrist = new CMoggCorrectWristPosition();
		break;
	}
	//㔼g
	switch(torso)
	{
	case 0:
		cTorso = new CNoopCorrectTorsoPosition();
		break;
	case 1:
		cTorso = new CMoggCorrectTorsoPosition();
		break;
	}
	//̈ʒu
	switch(hip)
	{
	case 0:
		cLeg = new CNoopCorrectLegPosition();
		break;
	case 1:
		cLeg = new CMoggCorrectLegPosition();
		break;
	}
	//ܐ
	switch(toe)
	{
	case 0:
		cToe = new CNoopCorrectToePosition();
		break;
	case 1:
		cToe = new CMoggCorrectToePosition();
		break;
	}
	//
	switch(shoulder)
	{
	case 0:
		cShoulder = new CNoopCorrectShoulderPosition();
		break;
	case 1:
		cShoulder = new CMoggCorrectShoulderPosition();
		break;
	}
	//̐
	switch(headfront)
	{
	case 0:
		cHeadFront = new CNoopCorrectHeadFrontPosition();
		break;
	case 1:
		cHeadFront = new CForceFrontHeadFrontPosition();
		break;
	}

	//{[␳ȂƂp
	correctbones = (neck != 0 || wrist != 0 || hip != 0 || toe != 0 || shoulder != 0 || headfront != 0);

}

void CMoggDxOpenNI::OpenNIInit(HWND hWnd, bool EngFlag, LPDIRECT3DDEVICE9 lpDevice, WCHAR* f_path, CHAR* onifilename)
{
	cInit->OpenNIInit(hWnd, EngFlag, lpDevice, f_path, onifilename);
}
void CMoggDxOpenNI::OpenNIClean()
{
	cClean->OpenNIClean();
}
XnStatus CMoggDxOpenNI::SetSmoothing()
{
	return cSetSmoothing->SetSmoothing(smoothingFactor);
}
void CMoggDxOpenNI::Grounding(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d)
{
	cGrounding->Grounding(pDepth, pLabels, pos3d, pos2d);
}
void CMoggDxOpenNI::SetTilt(XnVector3D legpos, XnVector3D anclepos)
{
	cCorrectTilt->SetTilt(legpos, anclepos);
}
void CMoggDxOpenNI::CorrectTilt(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d)
{
	cCorrectTilt->CorrectTilt(pDepth, pLabels, pos3d, pos2d);
}
void CMoggDxOpenNI::Smoothing()
{
	//Z^[A
	cSmoothingBone->SmoothingBone(CENTER, BP_Zero, cLostBoneBehavior);
	cSmoothingBone->SmoothingBone(TORSO, BP_Vector[CENTER], cLostBoneBehavior);
	//r
	cSmoothingBone->SmoothingBone(SHOULDER_L, BP_Vector[TORSO], cLostBoneBehavior);
	cSmoothingBone->SmoothingBone(SHOULDER_M_L, BP_Vector[TORSO], cLostBoneBehavior);
	cSmoothingBone->SmoothingBone(ELBOW_L, BP_Vector[SHOULDER_M_L], cLostBoneBehavior);
	cSmoothingBone->SmoothingBone(HAND_L, BP_Vector[ELBOW_L], cLostBoneBehavior);
	cSmoothingBone->SmoothingBone(FINGERTIP_L, BP_Vector[HAND_L], cLostBoneBehavior);
	//Er
	cSmoothingBone->SmoothingBone(SHOULDER_R, BP_Vector[TORSO], cLostBoneBehavior);
	cSmoothingBone->SmoothingBone(SHOULDER_M_R, BP_Vector[TORSO], cLostBoneBehavior);
	cSmoothingBone->SmoothingBone(ELBOW_R, BP_Vector[SHOULDER_M_R], cLostBoneBehavior);
	cSmoothingBone->SmoothingBone(HAND_R, BP_Vector[ELBOW_R], cLostBoneBehavior);
	cSmoothingBone->SmoothingBone(FINGERTIP_R, BP_Vector[HAND_R], cLostBoneBehavior);
	//
	cSmoothingBone->SmoothingBone(LEG_L, BP_Vector[TORSO], cLostBoneBehavior);
	cSmoothingBone->SmoothingBone(KNEE_L, BP_Vector[LEG_L], cLostBoneBehavior);
	cSmoothingBone->SmoothingBone(ANCLE_L, BP_Vector[KNEE_L], cLostBoneBehavior);
	cSmoothingBone->StrongSmoothingBone(TOE_L, BP_Vector[ANCLE_L], cLostBoneBehavior);
	//E
	cSmoothingBone->SmoothingBone(LEG_R, BP_Vector[TORSO], cLostBoneBehavior);
	cSmoothingBone->SmoothingBone(KNEE_R, BP_Vector[LEG_R], cLostBoneBehavior);
	cSmoothingBone->SmoothingBone(ANCLE_R, BP_Vector[KNEE_R], cLostBoneBehavior);
	cSmoothingBone->StrongSmoothingBone(TOE_R, BP_Vector[ANCLE_R], cLostBoneBehavior);
	//A
	cSmoothingBone->SmoothingBone(NECK, BP_Vector[TORSO], cLostBoneBehavior);
	cSmoothingBone->SmoothingBone(HEAD, BP_Vector[NECK], cLostBoneBehavior);

	//HEAD_FRONT̓X[WOȂ
}
void CMoggDxOpenNI::CorrectNeckPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, float fineness, D3DXVECTOR3 move)
{
	cNeck->CorrectNeckPosition(pDepth, pLabels, pos3d, pos2d, fineness, move);
}
void CMoggDxOpenNI::CorrectWristPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int elbow, int hand, int fingertip, float fineness, D3DXVECTOR3 move)
{
	cWrist->CorrectWristPosition(pDepth, pLabels, pos3d, pos2d, elbow, hand, fingertip, fineness, move);
}
void CMoggDxOpenNI::CorrectHandDirection(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int hand, int fingertip, int handdir, float fineness)
{
	cWrist->CorrectHandDirection(pDepth, pLabels, pos3d, pos2d, hand, fingertip, handdir, fineness);
}
void CMoggDxOpenNI::CorrectTorsoPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d)
{
	cTorso->CorrectTorsoPosition(pDepth, pLabels, pos3d, pos2d);
}
void CMoggDxOpenNI::CorrectToePosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int leg, int knee, int ancle, int toe, float fineness)
{
	cToe->CorrectToePosition(pDepth, pLabels, pos3d, pos2d, leg, knee, ancle, toe, fineness);
}
void CMoggDxOpenNI::CorrectLegPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, float fineness, D3DXVECTOR3 move)
{
	cLeg->CorrectLegPosition(pDepth, pLabels, pos3d, pos2d, fineness, move);
}
void CMoggDxOpenNI::CorrectShoulderPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int shoulder_m, int shoulder, int elbow, float fineness, D3DXVECTOR3 move)
{
	cShoulder->CorrectShoulderPosition(pDepth, pLabels, pos3d, pos2d, shoulder_m, shoulder, elbow, fineness, move);
}
void CMoggDxOpenNI::CorrectHeadFrontPosition()
{
	cHeadFront->CorrectHeadFrontPosition();
}

void CMoggDxOpenNI::CorrectBonePosition(const XnDepthPixel* pDepth, const XnLabel* pLabels)
{
	if (correctbones)
	{
		//ʒu擾
		XnPoint3D pos3d[BONECOUNT];
		XnPoint3D pos2d[BONECOUNT];
		D3DXVECTOR3 basev;
		for (int i = 0; i < BONECOUNT; i++)
		{
			basev = BP_Zero;
			pos3d[i].X = BP_Vector[i].x + basev.x;
			pos3d[i].Y = BP_Vector[i].y + basev.y;
			pos3d[i].Z = BP_Vector[i].z + basev.z;
		}
		//2D֎ˉeʂ̈ʒu擾
		if (g_DepthGenerator.ConvertRealWorldToProjective(BONECOUNT, pos3d, pos2d) != XN_STATUS_OK)
			return;

		//̈ʒu␳
		CorrectNeckPosition(pDepth, pLabels, pos3d, pos2d, 20.0f, neckMove);

		//̈ʒu𒲂ׂ
		CorrectWristPosition(pDepth, pLabels, pos3d, pos2d, ELBOW_L, HAND_L, FINGERTIP_L, 20.0f, wristMove);
		CorrectWristPosition(pDepth, pLabels, pos3d, pos2d, ELBOW_R, HAND_R, FINGERTIP_R, 20.0f, wristMove);

		//㔼g␳
		//CorrectTorsoPosition(pDepth, pLabels, pos3d, pos2d);

		//ܐ̈ʒu𒲂ׂ
		CorrectToePosition(pDepth, pLabels, pos3d, pos2d, LEG_L, KNEE_L, ANCLE_L, TOE_L, 20.0f);
		CorrectToePosition(pDepth, pLabels, pos3d, pos2d, LEG_R, KNEE_R, ANCLE_R, TOE_R, 20.0f);

		//̈ʒu␳
		CorrectLegPosition(pDepth, pLabels, pos3d, pos2d, 20.0f, hipMove);
		
		//̈ʒu␳
		CorrectShoulderPosition(pDepth, pLabels, pos3d, pos2d, SHOULDER_M_L, SHOULDER_L, ELBOW_L, 20.0f, shoulderMove);
		CorrectShoulderPosition(pDepth, pLabels, pos3d, pos2d, SHOULDER_M_R, SHOULDER_R, ELBOW_R, 20.0f, shoulderMove);
	}
	else
	{
		//ftHg삳
		CorrectNeckPosition(pDepth, pLabels, NULL, NULL, 0, D3DXVECTOR3());
		CorrectWristPosition(pDepth, pLabels, NULL, NULL, ELBOW_L, HAND_L, FINGERTIP_L, 0, D3DXVECTOR3());
		CorrectWristPosition(pDepth, pLabels, NULL, NULL, ELBOW_R, HAND_R, FINGERTIP_R, 0, D3DXVECTOR3());
		CorrectToePosition(pDepth, pLabels, NULL, NULL, LEG_L, KNEE_L, ANCLE_L, TOE_L, 0);
		CorrectToePosition(pDepth, pLabels, NULL, NULL, LEG_R, KNEE_R, ANCLE_R, TOE_R, 0);
		CorrectLegPosition(pDepth, pLabels, NULL, NULL, 0, D3DXVECTOR3());
		CorrectShoulderPosition(pDepth, pLabels, NULL, NULL, SHOULDER_M_L, SHOULDER_L, ELBOW_L, 0, D3DXVECTOR3());
		CorrectShoulderPosition(pDepth, pLabels, NULL, NULL, SHOULDER_M_R, SHOULDER_R, ELBOW_R, 0, D3DXVECTOR3());
	}
	//ڒn
	Grounding(pDepth, pLabels, NULL, NULL);
}