// MoggDxOpenNI
//  Dinamic link library of OpenNI for DirectX named DxOpenNI.dll
//
//   This program is modified from OpenNI driver.
//   OpenNI is written and distributed under the GNU Lesser General Public License,
//  so this program(dll) is redistributed under the terms of the GNU Lesser General Public License
//  as published by the Free Software Foundation, either version 3 of the License.
//   See the GNU General Public License for more details: <http://www.gnu.org/licenses/>.
// 
//   ̃vOOpenNIhCogpĂ܂BOpenNIGNU LGPLCZXłB
//   āÃvOLGPLCZXɏ]A\[XR[hJ邱ƂƂ܂B
//   ȂÃvO̓_Ci~bNN(dll)ƂĎgpꍇAdll𗘗p
//   ̃vOLGPLCZXɏ]Kv͂܂B
//
//   ܂ÃvO͔MMikuMikuDancepDxOpenNÎłB
//   KIWiDxOpenNIۑĂĂB

#include "DxOpenNI.h"
#include "COpenNIInit.h"
#include "COpenNIClean.h"
#include "CSetSmoothing.h"
#include "CSmoothingBone.h"
#include "CCorrectBonePositionBase.h"

//===========================================================
// C^[tF[XNX
//===========================================================
class CMoggDxOpenNI
{
public:

	//ݒt@Cǂݍŏ肷
	void LoadSettingFile();

	//eC^[tF[X
	void OpenNIInit(HWND hWnd, bool EngFlag, LPDIRECT3DDEVICE9 lpDevice, WCHAR* f_path, CHAR* onifilename);
	void OpenNIClean();
	XnStatus SetSmoothing();
	void SetTilt(XnVector3D legpos, XnVector3D anclepos);
	void Smoothing();
	void CorrectBonePosition(const XnDepthPixel* pDepth, const XnLabel* pLabels);
	//X
	void CorrectTilt(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d);
	//̌
	void CorrectHeadFrontPosition();

protected:
	bool correctbones;				//{[␳Ȃꍇp̃tO
	float smoothingFactor;			//NITE Smoothing Factor

	D3DXVECTOR3 neckMove;		//̉ғ
	D3DXVECTOR3 wristMove;		//̉ғ
	D3DXVECTOR3 hipMove;		//̉ғ
	D3DXVECTOR3 shoulderMove;	//̉ғ



	COpenNIInit *cInit;
	COpenNIClean *cClean;
	CSetSmoothing *cSetSmoothing;
	CLostBoneBehavior *cLostBoneBehavior;
	CSmoothingBone *cSmoothingBone;
	CGrounding *cGrounding;
	CCorrectTilt *cCorrectTilt;
	CCorrectNeckPosition *cNeck;
	CCorrectWristPosition *cWrist;
	CCorrectTorsoPosition *cTorso;
	CCorrectToePosition *cToe;
	CCorrectLegPosition *cLeg;
	CCorrectShoulderPosition *cShoulder;
	CCorrectHeadFrontPosition *cHeadFront;

	//ڒn
	void Grounding(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d);
	//{[␳
	void CorrectNeckPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, float fineness, D3DXVECTOR3 move);
	void CorrectWristPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int elbow, int hand, int fingertip, float fineness, D3DXVECTOR3 move);
	void CorrectHandDirection(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int hand, int fingertip, int handdir, float fineness);
	void CorrectTorsoPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d);
	void CorrectToePosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int leg, int knee, int ancle, int toe, float fineness);
	void CorrectLegPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, float fineness, D3DXVECTOR3 move);
	void CorrectShoulderPosition(const XnDepthPixel* pDepth, const XnLabel* pLabels, XnPoint3D* pos3d, XnPoint3D* pos2d, int shoulder_m, int shoulder, int elbow, float fineness, D3DXVECTOR3 move);
};