// MoggDxOpenNI
//  Dinamic link library of OpenNI for DirectX named DxOpenNI.dll
//
//   This program is modified from OpenNI driver.
//   OpenNI is written and distributed under the GNU Lesser General Public License,
//  so this program(dll) is redistributed under the terms of the GNU Lesser General Public License
//  as published by the Free Software Foundation, either version 3 of the License.
//   See the GNU General Public License for more details: <http://www.gnu.org/licenses/>.
// 
//   ̃vOOpenNIhCogpĂ܂BOpenNIGNU LGPLCZXłB
//   āÃvOLGPLCZXɏ]A\[XR[hJ邱ƂƂ܂B
//   ȂÃvO̓_Ci~bNN(dll)ƂĎgpꍇAdll𗘗p
//   ̃vOLGPLCZXɏ]Kv͂܂B
//
//   ܂ÃvO͔MMikuMikuDancepDxOpenNÎłB
//   KIWiDxOpenNIۑĂĂB

#include "CSmoothingBone.h"

//===========================================================
// SmoothingBone
//===========================================================
void CNoopSmoothingBone::SmoothingBone(int bone, D3DXVECTOR3 parent_position, CLostBoneBehavior *clost)
{
	//qXgXV
	for (int i = 1; i < HISTORY_COUNT; i++)
		g_BpHistory[bone][i - 1] = g_BpHistory[bone][i];
	

	//{[̃X[WO
	if (BoneLost[bone])
	{
		//{[Xg
		clost->LostBoneBehavior(bone);
	}
	else
	{
		//Vl
		g_BpHistory[bone][HISTORY_COUNT - 1].position = BP_Vector[bone];
	}
}
void CNoopSmoothingBone::StrongSmoothingBone(int bone, D3DXVECTOR3 parent_position, CLostBoneBehavior *clost)
{
	SmoothingBone(bone, parent_position, clost);
}


//===========================================================
// Smoothings
//===========================================================
void CMoggSmoothingBone::SmoothingBoneBase(int bone, D3DXVECTOR3 parent_position, CLostBoneBehavior *clost, D3DXVECTOR3 (CMoggSmoothingBone::*func)(int bone, D3DXVECTOR3 rpos))
{
	//qXgXV
	for (int i = 1; i < HISTORY_COUNT; i++)
		g_BpHistory[bone][i - 1] = g_BpHistory[bone][i];

	//{[̃X[WO
	if (BoneLost[bone])
	{
		//{[Xg
		clost->LostBoneBehavior(bone);
		g_BpHistory[bone][HISTORY_COUNT - 1].velocity = -1;
	}
	else
	{
		float dd;
		D3DXVECTOR3 rpos;	//eƂ̑Έʒu
		D3DXVECTOR3 sumv;

		//Έʒu
		rpos = BP_Vector[bone] - parent_position;
		g_BpHistory[bone][HISTORY_COUNT - 1].position = BP_Vector[bone];
		g_BpHistory[bone][HISTORY_COUNT - 1].relPosition = rpos;

		//Ot[Ƃ̍
		dd = D3DXVec3Length(&(rpos - g_BpHistory[bone][HISTORY_COUNT - 2].relPosition));

		//Ԃω
		if (g_BpHistory[bone][HISTORY_COUNT - 2].velocity >= 0 && g_BpHistory[bone][HISTORY_COUNT - 2].velocity < NOMOVE_THRESHOLD)
		{
			int count = 2;
			sumv = rpos;
			while (g_BpHistory[bone][HISTORY_COUNT - count].velocity >= 0 && g_BpHistory[bone][HISTORY_COUNT - count].velocity < NOMOVE_THRESHOLD && count <= HISTORY_COUNT)
			{
				sumv += g_BpHistory[bone][HISTORY_COUNT - count].relPosition;
				count++;
			}
			g_BpHistory[bone][HISTORY_COUNT - 1].relPosition = rpos;
			BP_Vector[bone] = parent_position + sumv / (float)(count - 1);
			g_BpHistory[bone][HISTORY_COUNT - 1].velocity = D3DXVec3Length(&(rpos - g_BpHistory[bone][HISTORY_COUNT - 2].relPosition));
		}
		else if (g_BpHistory[bone][HISTORY_COUNT - 3].velocity < 0 || g_BpHistory[bone][HISTORY_COUNT - 2].velocity < 0 || g_BpHistory[bone][HISTORY_COUNT - 1].velocity < 0)
		{
			BP_Vector[bone] = (g_BpHistory[bone][HISTORY_COUNT - 3].position + g_BpHistory[bone][HISTORY_COUNT - 2].position * 4.0f + g_BpHistory[bone][HISTORY_COUNT - 1].position) / 6.0f;
			g_BpHistory[bone][HISTORY_COUNT - 1].relPosition = BP_Vector[bone] - parent_position;
			g_BpHistory[bone][HISTORY_COUNT - 1].velocity = D3DXVec3Length(&(BP_Vector[bone] - g_BpHistory[bone][HISTORY_COUNT - 2].position));
		}
		else
		{
			//Ȃ
			g_BpHistory[bone][HISTORY_COUNT - 1].relPosition = (this->*func)(bone, rpos);
			BP_Vector[bone] = parent_position + g_BpHistory[bone][HISTORY_COUNT - 1].relPosition;
			g_BpHistory[bone][HISTORY_COUNT - 1].velocity = D3DXVec3Length(&(rpos - g_BpHistory[bone][HISTORY_COUNT - 2].relPosition));
		}

		g_BpHistory[bone][HISTORY_COUNT - 1].position = BP_Vector[bone];
	}
}

//ʏ̕
D3DXVECTOR3 CMoggSmoothingBone::NormalFunc(int bone, D3DXVECTOR3 rpos)
{
	return rpos;
}
//
D3DXVECTOR3 CMoggSmoothingBone::StrongFunc(int bone, D3DXVECTOR3 rpos)
{
	return (g_BpHistory[bone][HISTORY_COUNT - 3].relPosition + g_BpHistory[bone][HISTORY_COUNT - 2].relPosition * 4.0f + g_BpHistory[bone][HISTORY_COUNT - 1].relPosition) / 6.0f;
}

void CMoggSmoothingBone::SmoothingBone(int bone, D3DXVECTOR3 parent_position, CLostBoneBehavior *clost)
{
	SmoothingBoneBase(bone, parent_position, clost, &CMoggSmoothingBone::NormalFunc);
}
void CMoggSmoothingBone::StrongSmoothingBone(int bone, D3DXVECTOR3 parent_position, CLostBoneBehavior *clost)
{
	SmoothingBoneBase(bone, parent_position, clost, &CMoggSmoothingBone::StrongFunc);
}