// MoggDxOpenNI  Version 0.55
//  Dinamic link library of OpenNI for DirectX named DxOpenNI.dll
//
//   This program is modified from OpenNI driver.
//   OpenNI is written and distributed under the GNU Lesser General Public License,
//  so this program(dll) is redistributed under the terms of the GNU Lesser General Public License
//  as published by the Free Software Foundation, either version 3 of the License.
//   See the GNU General Public License for more details: <http://www.gnu.org/licenses/>.
// 
//   ̃vOOpenNIhCogpĂ܂BOpenNIGNU LGPLCZXłB
//   āÃvOLGPLCZXɏ]A\[XR[hJ邱ƂƂ܂B
//   ȂÃvO̓_Ci~bNN(dll)ƂĎgpꍇAdll𗘗p
//   ̃vOLGPLCZXɏ]Kv͂܂B
//
//   ܂ÃvO͔MMikuMikuDancepDxOpenNÎłB
//   KIWiDxOpenNIۑĂĂB

#include "CMoggDxOpenNI.h"

#ifdef _DEBUG
#include <wincon.h>
#include <stdio.h>
#include <time.h>
#endif

// export functions(MMDgp֐)
__declspec(dllexport) bool __stdcall OpenNIInit(HWND,bool,LPDIRECT3DDEVICE9,WCHAR*,CHAR*);
__declspec(dllexport) void __stdcall OpenNIClean();
__declspec(dllexport) void __stdcall OpenNIDrawDepthMap(bool);
__declspec(dllexport) void __stdcall OpenNIDepthTexture(IDirect3DTexture9**);
__declspec(dllexport) void __stdcall OpenNIGetSkeltonJointPosition(int,D3DXVECTOR3*);
__declspec(dllexport) void __stdcall OpenNIIsTracking(bool*);
__declspec(dllexport) void __stdcall OpenNIGetVersion(float*);


// callbacks
void XN_CALLBACK_TYPE User_NewUser(xn::UserGenerator&,XnUserID,void*);
void XN_CALLBACK_TYPE User_LostUser(xn::UserGenerator&,XnUserID,void*);
void XN_CALLBACK_TYPE UserCalibration_CalibrationStart(xn::SkeletonCapability&,XnUserID,void*);
void XN_CALLBACK_TYPE UserCalibration_CalibrationEnd(xn::SkeletonCapability&,XnUserID,XnBool,void*);
void XN_CALLBACK_TYPE UserPose_PoseDetected(xn::PoseDetectionCapability&,const XnChar*,XnUserID,void*);

//Ǝǉ֐
void Smoothing(int);
void CorrectBonePosition(const XnDepthPixel*, const XnLabel*);
void CorrectLegPosition(const XnDepthPixel*, const XnLabel*, XnPoint3D*, XnPoint3D*, int, int, float);
void CorrectShoulderPosition(const XnDepthPixel*, const XnLabel*, XnPoint3D*, XnPoint3D*, int, float);
void CorrectNeckPosition(const XnDepthPixel*, const XnLabel*, XnPoint3D*, XnPoint3D*, float);
void CorrectWristPosition(const XnDepthPixel*, const XnLabel*, XnPoint3D*, XnPoint3D*, int, int, int, float);
void WriteBone(UCHAR*, XnPoint3D);
void WriteBoneLine(UCHAR* pDestImage, XnPoint3D * points, int left, int right);
int GetDepth(const XnDepthPixel*, int, int);
int GetUserID(const XnLabel*, int, int);


// global variables
xn::Context				g_Context;					//OpenNIReLXg
xn::DepthGenerator		g_DepthGenerator;			//[x}bv擾邽߂̃NX
xn::UserGenerator		g_UserGenerator;			//[U[擾邽߂̃NX
int						g_nXRes;					//[x/[U[}bv
int						g_nYRes;					//[x/[U[}bv
D3DXVECTOR3				BP_Zero;					//ʒu
D3DXVECTOR3				BP_Center;					//Z^[ʒuBe{[͂̑ΈʒuۑB
D3DXVECTOR3				BP_Vector[BONECOUNT];		//{[ʒuB0:center 1:neck 2:head 3:shoulderL 4:elbowL 5:handL 6:shoulderR 7:elbowR 8:handR 9:legL 10:kneeL 11 ancleL 12:legR 13:kneeR 14:ancleR 15:torso
bool					BoneLost[BONECOUNT];		//{[Xg
XnBool					TrackingF = FALSE;			//gbLOtO
BpHistory				g_BpHistory[BONECOUNT][HISTORY_COUNT];		//X[WOp
D3DXVECTOR3				g_NoiseVector;				//mCYxNg
float					g_groundY;					//nʂ̈ʒu

XnBool					g_bDrawPixels = TRUE;		//[U[摜(Ԃl)\tO
XnBool					g_bDrawBackground = FALSE;	//wi\tO
XnBool					g_bQuit = FALSE;
int						g_texWidth;					//[U[摜eNX`
int						g_texHeight;				//[U[摜eNX`
int						TrCount[MAXUSER];			//[U[gbLOtOz
float					g_pDepthHist[MAX_DEPTH];	//qXgO
IDirect3DTexture9*		DepthTex = NULL;			//[U[摜peNX`
XnBool					g_bNeedPose = FALSE;
XnChar					g_strPose[20] = "";

//C^[tF[X
CMoggDxOpenNI g_moggContext;


//e[U[IDƂ̐F(fobOɂ͐F)
#ifdef _DEBUG
XnFloat					Colors[][3] ={{0.7f,1,1},{0.7f,0.7f,1},{0.7f,1,0.7f},{1,1,0.7f},{1,0.7f,0.7f},{1,0.7f,0.7f},{0.7f,1,0.7f},{0.7f,0.7f,1},{0.7f,0.7f,1},{1,1,0.7f},{1,1,1}};
#else
XnFloat					Colors[][3] ={{0,1,1},{0,0,1},{0,1,0},{1,1,0},{1,0,0},{1,.5,0},{.5,1,0},{0,.5,1},{.5,0,1},{1,1,.5},{1,1,1}};
#endif

#ifdef _DEBUG
XnUInt64 g_timestamp;
//fobOp̕ϐ(Ԍvp)
int g_count;
XnUInt64 g_sumtime;
#endif

#pragma region DllMain
//===========================================================
// DllMain
//===========================================================
BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
	switch( fdwReason )
	{
	case DLL_PROCESS_ATTACH:
		break;

	case DLL_PROCESS_DETACH:
		OpenNIClean();
		break;

	case DLL_THREAD_ATTACH:
		break;

	case DLL_THREAD_DETACH:
		break;
	}

	return TRUE;
}
#pragma endregion

#pragma region Callbacks
//===========================================================
// CALLBACK:User_NewUser()
// V[U[FꂽƂ̃R[obN֐
//===========================================================
void XN_CALLBACK_TYPE User_NewUser(xn::UserGenerator& generator, XnUserID nId, void* pCookie)
{
	// New user found
	if (g_bNeedPose){
		//|[YFJn
		g_UserGenerator.GetPoseDetectionCap().StartPoseDetection(g_strPose, nId);
#ifdef _DEBUG
		printf("Start Pose detection:%s\n", g_strPose);
#endif
	}else{
		g_UserGenerator.GetSkeletonCap().RequestCalibration(nId, TRUE);
#ifdef _DEBUG
		printf("Request Calibration UserID:%d\n", nId);
#endif
	}
}
//===========================================================
// CALLBACK:User_LostUser()
// [U[XgƂ̃R[obN֐
//===========================================================
void XN_CALLBACK_TYPE User_LostUser(xn::UserGenerator& generator, XnUserID nId, void* pCookie)
{
	TrackingF = false;
#ifdef _DEBUG
		printf("Lost UserID:%d\n", nId);
#endif
}
//===========================================================
// CALLBACK:UserCalibration_CalibrationStart()
// Lu[V(|[Yɂl̔F)JñR[obN֐
//===========================================================
void XN_CALLBACK_TYPE UserCalibration_CalibrationStart(xn::SkeletonCapability& capability, XnUserID nId, void* pCookie)
{
}
//===========================================================
// CALLBACK:UserCalibration_CalibrationEnd()
//Lu[V(|[Yɂl̔F)ĨR[obN֐
//===========================================================
void XN_CALLBACK_TYPE UserCalibration_CalibrationEnd(xn::SkeletonCapability& capability, XnUserID nId, XnBool bSuccess, void* pCookie)
{
	if (bSuccess){
		//gbLOJn
		g_UserGenerator.GetSkeletonCap().StartTracking(nId);
#ifdef _DEBUG
		printf("Start Tracking UserID:%d\n", nId);
#endif
	}else{
		if(g_bNeedPose){
			g_UserGenerator.GetPoseDetectionCap().StartPoseDetection(g_strPose, nId);
#ifdef _DEBUG
			printf("Start Pose detection:%s\n", g_strPose);
#endif
		}else{
			g_UserGenerator.GetSkeletonCap().RequestCalibration(nId, TRUE);
#ifdef _DEBUG
			printf("Request Calibration UserID:%d\n", nId);
#endif
		}
	}
}
//===========================================================
// CALLBACK:UserPose_PoseDetected()
// |[Y莞̃R[obN֐
//===========================================================
void XN_CALLBACK_TYPE UserPose_PoseDetected(xn::PoseDetectionCapability& capability, const XnChar* strPose, XnUserID nId, void* pCookie)
{
	g_UserGenerator.GetPoseDetectionCap().StopPoseDetection(nId);
	g_UserGenerator.GetSkeletonCap().RequestCalibration(nId, TRUE);
#ifdef _DEBUG
		printf("Stop Pose Detection UserID:%d\n", nId);
#endif
}

#pragma endregion

#pragma region Functions
//===========================================================
// FUNCTION:getClosestPowerOfTwo()
// nȏňԋ߂2ׂ̂߂(eNX`TCYp)
//===========================================================
UINT getClosestPowerOfTwo(UINT n)
{
	unsigned int m = 2;
	while(m < n) m<<=1;

	return m;
}
//===========================================================
// FUNCTION:PosCalc()
// MMDɓn{[ʒuݒ肷
//===========================================================
void PosCalc(XnUserID player, XnSkeletonJoint ejoint, int boneid, const D3DXVECTOR3* basepoint)
{
	XnSkeletonJointPosition jointx;
	g_UserGenerator.GetSkeletonCap().GetSkeletonJointPosition(player,ejoint,jointx);
	if(jointx.fConfidence < 0.5f){
		BoneLost[boneid] = true;
	}else{
		BoneLost[boneid] = false;
		BP_Vector[boneid].x = jointx.position.X - basepoint->x;
		BP_Vector[boneid].y = jointx.position.Y - basepoint->y;
		BP_Vector[boneid].z = jointx.position.Z - basepoint->z;
	}
}
//===========================================================
// FUNCTION:printError()
//===========================================================
void printError(HWND hWnd,const char *name, XnStatus nRetVal)
{
	char moji[256];
	sprintf_s(moji,sizeof(moji),"%s failed: %s\n", name, xnGetStatusString(nRetVal));
	MessageBoxA(hWnd,moji,"error",MB_OK);
}
//===========================================================
// EXPORT FUNCTION:Clean()
// kinectIAMMDIɌĂ΂
//===========================================================
__declspec(dllexport) void __stdcall OpenNIClean()
{
	//eNX`
	if(DepthTex){
		DepthTex->Release();
		DepthTex=NULL;
	}
	//OpenNI
	g_Context.Shutdown();
	TrackingF=false;

#ifdef _DEBUG
	printf("Close\n");
	::FreeConsole();
#endif
}

#pragma endregion

//===========================================================
// EXPORT FUNCTION:Init()
// OpenNIBMMDkinectLɂƂɌĂ΂B
//===========================================================
__declspec(dllexport) bool __stdcall OpenNIInit(HWND hWnd,bool EngFlag,LPDIRECT3DDEVICE9 lpDevice,WCHAR* f_path,CHAR* onifilename)
{
#ifdef _DEBUG
	::AllocConsole();
	freopen("CON", "w", stdout);
#endif

	TrackingF=false;
	for(int i=0;i<MAXUSER;i++) TrCount[i]=0;

	SetCurrentDirectoryW(f_path);

	FILE *fp;
	if((fp=fopen("Data\\SamplesConfig.xml","r"))!=NULL){
		fclose( fp );
	}else{
		if(EngFlag) MessageBox(hWnd,L"SamplesConfig.xml cannot find in Data folder.\n\nPlease download DxOpenNI and get SamplesConfig.xml from in it\nand put it into \"Data\" folder of MMD.",L"Kinect",MB_OK);
		else		MessageBox(hWnd,L"SamplesConfig.xmlDatatH_ɂ܂B\n\nDxOpenNI_E[hĂ̒SamplesConfig.xmlMMDDatatH_ɓĉB",L"Kinect",MB_OK);
		return false;
	}

#ifdef _DEBUG
	printf("Open SamplesConfig.xml\n");
#endif

	XnStatus nRetVal;
	if(onifilename!=NULL){
		nRetVal = g_Context.Init();
		if(nRetVal != XN_STATUS_OK){
			printError(hWnd,"Init", nRetVal);
			if(EngFlag) MessageBox(hWnd,L"Cannot find Kinect sensor",L"Kinect",MB_OK);
			else		MessageBox(hWnd,L"KinectڑĂ܂",L"Kinect",MB_OK);
			return false;
		}
		nRetVal = g_Context.OpenFileRecording(onifilename);
		if (nRetVal != XN_STATUS_OK){
			printError(hWnd,"Init", nRetVal);
			if(EngFlag) MessageBox(hWnd,L"Cannot open recording file",L"Kinect",MB_OK);
			else		MessageBox(hWnd,L"onit@CJ܂",L"Kinect",MB_OK);
			return false;
		}
	}else{
		nRetVal = g_Context.InitFromXmlFile("Data\\SamplesConfig.xml");
		if(nRetVal != XN_STATUS_OK){
			printError(hWnd,"InitFromXmlFile", nRetVal);
			if(EngFlag) MessageBox(hWnd,L"Cannot find Kinect sensor",L"Kinect",MB_OK);
			else		MessageBox(hWnd,L"KinectڑĂ܂",L"Kinect",MB_OK);
			return false;
		}
	}

#ifdef _DEBUG
	printf("Kinect sensor OK\n");
#endif

	nRetVal = g_Context.FindExistingNode(XN_NODE_TYPE_DEPTH, g_DepthGenerator);
	if(nRetVal != XN_STATUS_OK){
		printError(hWnd,"FindExistingNode", nRetVal);
		if(EngFlag) MessageBox(hWnd,L"Cannot find Kinect Depth generator",L"Kinect",MB_OK);
		else		MessageBox(hWnd,L"Kinect̐[xZT[Fł܂",L"Kinect",MB_OK);
		OpenNIClean();
		return false;
	}

#ifdef _DEBUG
	printf("Kinect Depth generator OK\n");
#endif

	nRetVal = g_Context.FindExistingNode(XN_NODE_TYPE_USER, g_UserGenerator);
	if(nRetVal != XN_STATUS_OK){
		nRetVal = g_UserGenerator.Create(g_Context);
		if(nRetVal != XN_STATUS_OK){
			printError(hWnd,"g_UserGenerator.Create", nRetVal);
			if(EngFlag) MessageBox(hWnd,L"Cannot find Kinect User generator",L"Kinect",MB_OK);
			else		MessageBox(hWnd,L"Kinect̃[U[ZT[Fł܂",L"Kinect",MB_OK);
			OpenNIClean();
			return false;
		}
	}

#ifdef _DEBUG
	printf("Kinect User generator OK\n");
#endif

	XnCallbackHandle hUserCallbacks, hCalibrationCallbacks, hPoseCallbacks;
	if(!g_UserGenerator.IsCapabilitySupported(XN_CAPABILITY_SKELETON)){
		if(EngFlag) MessageBox(hWnd,L"Supplied user generator doesn't support skeleton",L"Kinect",MB_OK);
		else		MessageBox(hWnd,L"Kinect̃[U[ZT[{[\T|[gĂ܂",L"Kinect",MB_OK);
		OpenNIClean();
		return false;
	}
	g_UserGenerator.RegisterUserCallbacks(User_NewUser, User_LostUser, NULL, hUserCallbacks);
	g_UserGenerator.GetSkeletonCap().RegisterCalibrationCallbacks(UserCalibration_CalibrationStart, UserCalibration_CalibrationEnd, NULL, hCalibrationCallbacks);

	if(g_UserGenerator.GetSkeletonCap().NeedPoseForCalibration()){
		g_bNeedPose = TRUE;
		if(!g_UserGenerator.IsCapabilitySupported(XN_CAPABILITY_POSE_DETECTION)){
			if(EngFlag) MessageBox(hWnd,L"Pose required, but not supported",L"Kinect",MB_OK);
			else		MessageBox(hWnd,L"KinectLu[V|[YT|[gĂ܂",L"Kinect",MB_OK);
			OpenNIClean();
			return false;
		}
		g_UserGenerator.GetPoseDetectionCap().RegisterToPoseCallbacks(UserPose_PoseDetected, NULL, NULL, hPoseCallbacks);
		g_UserGenerator.GetSkeletonCap().GetCalibrationPose(g_strPose);
	}

#ifdef _DEBUG
	printf("Pose Detection OK\n");
#endif

	g_UserGenerator.GetSkeletonCap().SetSkeletonProfile(XN_SKEL_PROFILE_ALL);

	nRetVal = g_Context.StartGeneratingAll();
	if(nRetVal != XN_STATUS_OK){
		printError(hWnd,"StartGeneratingAll", nRetVal);
		if(EngFlag) MessageBox(hWnd,L"Cannot start Kinect generating",L"Kinect",MB_OK);
		else		MessageBox(hWnd,L"KinectZT[nł܂",L"Kinect",MB_OK);
		OpenNIClean();
		return false;
	}

#ifdef _DEBUG
	printf("Kinect Start\n");
#endif

	xn::SceneMetaData sceneMD;
	xn::DepthMetaData depthMD;
	g_DepthGenerator.GetMetaData(depthMD);
	g_Context.WaitAndUpdateAll();
	//g_DepthGenerator.GetMetaData(depthMD);
	g_UserGenerator.GetUserPixels(0, sceneMD);

	g_nXRes = depthMD.XRes();	//g~Õ}bv擾
	g_nYRes = depthMD.YRes();	//g~Õ}bv擾
	g_texWidth =  getClosestPowerOfTwo(g_nXRes / REDUCE_SIZE);	//MMD\peNX`
	g_texHeight = getClosestPowerOfTwo(g_nYRes / REDUCE_SIZE);	//MMD\peNX`

	if (lpDevice != NULL)
	{
		if(FAILED(lpDevice->CreateTexture(g_texWidth,g_texHeight,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,&DepthTex,NULL))){
			if(EngFlag) MessageBox(hWnd,L"cannot make DepthTex",L"Kinect",MB_OK);
			else		MessageBox(hWnd,L"DepthTex쐬s",L"Kinect",MB_OK);
			OpenNIClean();
			return false;
		}
	}
#ifdef _DEBUG
	printf("Depth Texture OK\n\n");
#endif

	//MoggDxOpenNI̐ݒǂݍ
	g_moggContext.LoadSettingFile();

	//X[WOݒ肷
	if (g_moggContext.SetSmoothing() != XN_STATUS_OK)
	{
		if(EngFlag) MessageBox(hWnd,L"cannot set smoothing factor",L"Kinect",MB_OK);
		else		MessageBox(hWnd,L"X[WOt@N^[ݒ莸s",L"Kinect",MB_OK);
		return false;
	}

#ifdef _DEBUG
	//^CX^v
	xnOSGetHighResTimeStamp(&g_timestamp);

	printf("Settings OK\n\n");
	g_count = 0;
	g_sumtime = 0;
#endif

	return true;
}

//===========================================================
// EXPORT FUNCTION:DrawDepthMap()
// [x}bv,{[ʒuXVBMMDIɌĂ΂B
//===========================================================
__declspec(dllexport) void __stdcall OpenNIDrawDepthMap(bool waitflag)
{
#ifdef _DEBUG
	//Ԍvp
	XnUInt64 start, end;
	xnOSGetHighResTimeStamp(&start);
#endif
	xn::SceneMetaData sceneMD;	//V[^f[^
	xn::DepthMetaData depthMD;	//[x}bv^f[^

	//݂̐[x^f[^擾(t[ĂԕKv)
	g_DepthGenerator.GetMetaData(depthMD);

#ifdef _DEBUG
	//݂̃^CX^v
	//XnUInt64 nNow;
	//xnOSGetHighResTimeStamp(&nNow);
	//while (nNow - g_timestamp < 33330)
	//{
	//	Sleep(0);
	//	xnOSGetHighResTimeStamp(&nNow);
	//}
	//
	////printf("%d\n", nNow - g_timestamp);
	//xnOSGetHighResTimeStamp(&g_timestamp);
#endif

	//WaitAndUpdateAll:  ׂĂ̍XVI܂őҋ@AReLXgɂSWFl[^m[hXV
	//WaitNoneUpdateAll: ҋ@ɁAReLXgɂSWFl[^m[hXV
	//WaitOneUpdateAll:  w̃WFl[^XVĂꍇɁASWFl[^m[hXV
	//WaitAnyUpdateAll:  ǂꂩ1łXVꍇɁASWFl[^m[hXV

	if(waitflag)
		g_Context.WaitAndUpdateAll();
	else
		g_Context.WaitNoneUpdateAll();

	g_DepthGenerator.GetMetaData(depthMD);

	//V[^f[^擾B
	//V[^f[^ɂ̓[U[x(XnLabel)L^ꂽsNZf[^܂܂B
	//wiɂ̓[A[U[sNZɂ͊e[U[ID(1-15)L^B
	g_UserGenerator.GetUserPixels(0, sceneMD);

	//XnDepthPixel [x\Int16
	//Data(): [xf[^zւ̃|C^擾
	const XnDepthPixel* pDepth = depthMD.Data();

	//XnLabel [U[\Int16B 0:wi 1-15:[U[x
	//Data(): esNZƂ̃[U[xĂf[^ւ̃|C^擾
	const XnLabel* pLabels = sceneMD.Data();
	
#pragma region GetBonePositions

	////////////////////////////////////////////////////////////
	//{[ʒu BP_Vector ɕۑĂ
	////////////////////////////////////////////////////////////
	XnUserID aUsers[MAXUSER];
	XnUInt16 nUsers = MAXUSER;
	//XnSkeletonJointPosition sjp1,sjp2;

	//ݔFĂ郆[U[擾
	g_UserGenerator.GetUsers(aUsers, nUsers);

	//gbLÕ[U[ƂɃ{[ʒu擾Aۊǂ
	for(int i = 0; i < nUsers; ++i){
		if(g_UserGenerator.GetSkeletonCap().IsTracking(aUsers[i])){

			//INITIAL_FRAME(4t[)̈ʒuʒu(BP_Zero)Ƃĕۑ
			if(TrCount[i] < INITIAL_FRAME){
				TrCount[i]++;
				if(TrCount[i] == INITIAL_FRAME){
					//ʒuݒB
					//TORSOXZWAt̒SYWʒuƂA
					//ʒȗΈʒue{[ʒuƂBP_VectorɕۑB
					XnSkeletonJointPosition sjp1,sjp2;
					g_UserGenerator.GetSkeletonCap().GetSkeletonJointPosition(aUsers[i], XN_SKEL_TORSO,sjp1);
					BP_Zero.x = sjp1.position.X;
					BP_Zero.z = sjp1.position.Z;
					g_UserGenerator.GetSkeletonCap().GetSkeletonJointPosition(aUsers[i], XN_SKEL_LEFT_HIP,sjp1);
					g_UserGenerator.GetSkeletonCap().GetSkeletonJointPosition(aUsers[i], XN_SKEL_RIGHT_HIP,sjp2);
					BP_Zero.y = (sjp1.position.Y + sjp2.position.Y) / 2.0f;

					//Xݒ肷
					if (g_UserGenerator.GetSkeletonCap().GetSkeletonJointPosition(aUsers[i], XN_SKEL_LEFT_SHOULDER, sjp2) == XN_STATUS_OK)
						g_moggContext.SetTilt(sjp2.position, sjp1.position);

				}
			}

			//mCYxNg
			g_NoiseVector = D3DXVECTOR3(0, 0, 0);

			//Z^[Έʒu
			XnSkeletonJointPosition sjp1, sjp2;
			g_UserGenerator.GetSkeletonCap().GetSkeletonJointPosition(aUsers[i], XN_SKEL_TORSO, sjp1);
			BP_Center.x = sjp1.position.X;
			BP_Center.z = sjp1.position.Z;
			g_UserGenerator.GetSkeletonCap().GetSkeletonJointPosition(aUsers[i], XN_SKEL_LEFT_HIP,sjp1);
			g_UserGenerator.GetSkeletonCap().GetSkeletonJointPosition(aUsers[i], XN_SKEL_RIGHT_HIP,sjp2);
			BP_Center.y = (sjp1.position.Y + sjp2.position.Y) / 2.0f;

			//Z^[̏ʒuƂ̑Έʒu
			BP_Vector[CENTER] = BP_Center - BP_Zero;

			//e{[̃Z^[Ƃ̑Έʒuۑ
			//PosCalc(aUsers[i],XN_SKEL_TORSO,&BP_Vector[CENTER]);
			PosCalc(aUsers[i],XN_SKEL_NECK, NECK, &BP_Zero);
			PosCalc(aUsers[i],XN_SKEL_HEAD, HEAD, &BP_Zero);
			PosCalc(aUsers[i],XN_SKEL_LEFT_SHOULDER, SHOULDER_L, &BP_Zero);
			PosCalc(aUsers[i],XN_SKEL_LEFT_ELBOW, ELBOW_L, &BP_Zero);
			PosCalc(aUsers[i],XN_SKEL_LEFT_HAND, HAND_L, &BP_Zero);
			PosCalc(aUsers[i],XN_SKEL_RIGHT_SHOULDER, SHOULDER_R, &BP_Zero);
			PosCalc(aUsers[i],XN_SKEL_RIGHT_ELBOW, ELBOW_R, &BP_Zero);
			PosCalc(aUsers[i],XN_SKEL_RIGHT_HAND, HAND_R, &BP_Zero);
			PosCalc(aUsers[i],XN_SKEL_TORSO, TORSO, &BP_Zero);

			PosCalc(aUsers[i],XN_SKEL_LEFT_HIP, LEG_L, &BP_Zero);
			PosCalc(aUsers[i],XN_SKEL_RIGHT_HIP, LEG_R, &BP_Zero);
			PosCalc(aUsers[i],XN_SKEL_LEFT_KNEE, KNEE_L, &BP_Zero);
			PosCalc(aUsers[i],XN_SKEL_RIGHT_KNEE, KNEE_R, &BP_Zero);
			PosCalc(aUsers[i],XN_SKEL_LEFT_FOOT, ANCLE_L, &BP_Zero);
			PosCalc(aUsers[i],XN_SKEL_RIGHT_FOOT, ANCLE_R, &BP_Zero);
			
			
			//ŏ̂ƂɃ{[qXg
			if (!TrackingF && TrCount[i] == INITIAL_FRAME)
			{
				//ܐ
				BP_Vector[TOE_L] = BP_Vector[ANCLE_L] + D3DXVECTOR3(0, 0, 1);
				BP_Vector[TOE_R] = BP_Vector[ANCLE_R] + D3DXVECTOR3(0, 0, 1);

				//qXg
				for (int bone = 0; bone < BONECOUNT; bone++)
				{
					for (int h = 0; h < HISTORY_COUNT; h++)
					{
						g_BpHistory[bone][h].position = BP_Vector[bone];
						g_BpHistory[bone][h].relPosition = D3DXVECTOR3(0, 0, 0);
						g_BpHistory[bone][h].velocity = -1;
					}
				}
				//ƈʒuƂ
				g_groundY = min(BP_Vector[ANCLE_L].y, BP_Vector[ANCLE_R].y);


				//gbLOJnʒm
				TrackingF = true;
			}

			//ʒu𒲐
			g_moggContext.CorrectBonePosition(pDepth, pLabels);

			//Ǝ
			g_moggContext.Smoothing();

			//X␳
			g_moggContext.CorrectTilt(pDepth, pLabels, NULL, NULL);
			//̌
			g_moggContext.CorrectHeadFrontPosition();

			//1[U[̂ݑΉȂ̂ŁAfor𔲂
			break;
		}else{
			TrCount[i]=0;
		}
	}
#pragma endregion

#pragma region DrawUserImage
	////////////////////////////////////////////////////////////
	//[U[摜(Ԃl)쐬B
	//wi(l[)̏ꍇ͉`悵ȂB
	////////////////////////////////////////////////////////////
#ifdef _DEBUG
	//fobOphCop
	if (DepthTex != NULL)
	{
#endif
	D3DLOCKED_RECT LPdest;
	DepthTex->LockRect(0,&LPdest,NULL, 0);
	UCHAR *pDestImage=(UCHAR*)LPdest.pBits;

	//qXgO쐬B
	//KinectŌv[xɊւ炸ALN^̉ʂ\邽߂ɎgpB
	//AZW͕\ɏy
	//ZeroMemory(g_pDepthHist,MAX_DEPTH*sizeof(float));
	//UINT nValue=0;
	//UINT nNumberOfPoints = 0;
	//for(int nY=0;nY<g_nYRes;nY++){
	//	for(int nX=0;nX<g_nXRes;nX++){
	//		nValue = *pDepth;
	//		if(nValue !=0){
	//			g_pDepthHist[nValue]++;
	//			nNumberOfPoints++;
	//		}
	//		pDepth++;
	//	}
	//}

	//for(int nIndex=1;nIndex<MAX_DEPTH;nIndex++){
	//	g_pDepthHist[nIndex] += g_pDepthHist[nIndex-1];
	//}

	//if(nNumberOfPoints){
	//	for(int nIndex=1;nIndex<MAX_DEPTH;nIndex++){
	//		g_pDepthHist[nIndex] = (float)((UINT)(256 * (1.0f - (g_pDepthHist[nIndex] / nNumberOfPoints))));
	//	}
	//}

	pDepth = depthMD.Data();
	//UINT nHistValue = 0;
	if(g_bDrawPixels){
		//eNX`ɕ\摜Ă
		for(int nY = 0; nY < g_nYRes; nY += REDUCE_SIZE){
			for(int nX = 0; nX < g_nXRes; nX += REDUCE_SIZE){

				//ftHg̓At@l0̓߃sNZ
				pDestImage[0] = 0;
				pDestImage[1] = 0;
				pDestImage[2] = 0;
				pDestImage[3] = 0;

				//wi`tOTrueA̓[U[ID[(wi)ȊÔƂɕ`
				if(g_bDrawBackground || *pLabels != 0){
					//nValue = *pDepth;
					XnLabel label = *pLabels;
					XnUInt32 nColorID = label % NCOLORS;
					if(label == 0){
						nColorID = NCOLORS;
					}

					//[x0ȊȌꍇA[U[IDɊ֘AtꂽF
					if(*pDepth != 0){
						//nHistValue = (UINT)(g_pDepthHist[nValue]);

						pDestImage[0] = (UINT)(255 * Colors[nColorID][0]);
						pDestImage[1] = (UINT)(255 * Colors[nColorID][1]);
						pDestImage[2] = (UINT)(255 * Colors[nColorID][2]);
						pDestImage[3] = 255;
					}
				}

				//̃sNZɈڂ({l)
				pDepth += REDUCE_SIZE;
				pLabels += REDUCE_SIZE;
				pDestImage += TEX_PIXELSIZE;
			}

			//̍sɈڂ({lAsƂ΂)
			int pg = g_nXRes * (REDUCE_SIZE - 1);
			pDepth += pg;
			pLabels += pg;
			pDestImage += (g_texWidth - g_nXRes / REDUCE_SIZE) * TEX_PIXELSIZE;
		}
	}else{
		xnOSMemSet(LPdest.pBits, 0, TEX_PIXELSIZE * 2 * g_nXRes * g_nYRes);
	}

#ifdef _DEBUG

	XnPoint3D pt[BONECOUNT];
	if (TrackingF)
	{
		//{[}[N\
		for (int i = 0; i < BONECOUNT; i++)
		{
			pt[i].X = BP_Vector[i].x + BP_Zero.x;
			pt[i].Y = BP_Vector[i].y + BP_Zero.y;
			pt[i].Z = BP_Vector[i].z + BP_Zero.z;
		}

		g_DepthGenerator.ConvertRealWorldToProjective(BONECOUNT, pt, pt);

		//for (int i = 0; i < BONECOUNT; i++)
		//	WriteBone((UCHAR*)LPdest.pBits, pt[i]);

		//{[C\
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, HEAD, NECK);
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, SHOULDER_M_L, NECK);
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, SHOULDER_M_L, ELBOW_L);
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, ELBOW_L, HAND_L);
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, HAND_L, FINGERTIP_L);
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, SHOULDER_M_R, NECK);
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, SHOULDER_M_R, ELBOW_R);
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, ELBOW_R, HAND_R);
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, HAND_R, FINGERTIP_R);

		WriteBoneLine((UCHAR*)LPdest.pBits, pt, SHOULDER_R, SHOULDER_L);

		WriteBoneLine((UCHAR*)LPdest.pBits, pt, SHOULDER_L, TORSO);
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, SHOULDER_R, TORSO);
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, LEG_L, TORSO);
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, LEG_R, TORSO);
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, LEG_L, LEG_R);
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, LEG_L, KNEE_L);
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, KNEE_L, ANCLE_L);
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, LEG_R, KNEE_R);
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, KNEE_R, ANCLE_R);

		WriteBoneLine((UCHAR*)LPdest.pBits, pt, ANCLE_L, TOE_L);
		WriteBoneLine((UCHAR*)LPdest.pBits, pt, ANCLE_R, TOE_R);

		WriteBoneLine((UCHAR*)LPdest.pBits, pt, HEAD, HEAD_FRONT);
	}
	

	
#endif

	//eNX`̃bN
	DepthTex->UnlockRect(0);

#ifdef _DEBUG
	}
#endif

#pragma endregion

#ifdef _DEBUG
	xnOSGetHighResTimeStamp(&end);
	g_sumtime += end - start;
	g_count++;

	if (g_count % 100 == 0)
	{
		printf("Av %.8f\n", (double)g_sumtime / 100000 / 100);
		g_sumtime = 0;
		g_count = 0;
	}
#endif
}

//===========================================================
// DepthTexture()
// [x}bveNX`擾
//===========================================================
__declspec(dllexport) void __stdcall OpenNIDepthTexture(IDirect3DTexture9** lpTex)
{
	*lpTex = DepthTex;
}

//===========================================================
// GetSkeltonJointPosition()
// {[ʒu擾
//===========================================================
__declspec(dllexport) void __stdcall OpenNIGetSkeltonJointPosition(int num,D3DXVECTOR3* vec)
{
	*vec = BP_Vector[num];
}

//===========================================================
// IsTracking()
// [U[gbLOǂ擾
//===========================================================
__declspec(dllexport) void __stdcall OpenNIIsTracking(bool* lpb)
{
	if(TrackingF) *lpb = true;
	else		  *lpb = false;
}

//===========================================================
// GetVersion()
// o[W擾
//===========================================================
__declspec(dllexport) void __stdcall OpenNIGetVersion(float* ver)
{
	*ver = 1.50f;
}


#ifdef _DEBUG
//===========================================================
//{[}[NeNX`ɕ`悷(fobOp)
//===========================================================
void WriteBone(UCHAR* pDestImage, XnPoint3D pos)
{
	int w = (BONEMARK_WIDTH - 1) / 2;		//̕
	int x = (int)(pos.X / REDUCE_SIZE);		//eNX`Xʒu
	int y = (int)(pos.Y / REDUCE_SIZE);		//eNX`Yʒu

	//̈ʒu
	pDestImage += ((y - w) * g_texWidth + (x - w)) * TEX_PIXELSIZE;

	//``悷
	for (int iy = 0; iy < BONEMARK_WIDTH; iy++)
	{
		if (y + iy - w > 0 && y + iy - w < g_texHeight)
		{
			for (int ix = 0; ix < BONEMARK_WIDTH; ix++)
			{
				if (x + ix - w > 0 && x + ix - w < g_texWidth)
				{
					pDestImage[0] = 0;
					pDestImage[1] = 0;
					pDestImage[2] = 0;
					pDestImage[3] = 255;
				}
				pDestImage += TEX_PIXELSIZE;
			}
		}
		pDestImage += (g_texWidth - BONEMARK_WIDTH) * TEX_PIXELSIZE;
	}
}
//===========================================================
//{[CeNX`ɕ`悷(fobOp)
//===========================================================
void WriteBoneLine(UCHAR* pDestImage, XnPoint3D * points, int left, int right)
{
	if (BoneLost[left] || BoneLost[right])
		return;

	int t;
	int x1 = (int)(points[left].X / REDUCE_SIZE);		//eNX`X1ʒu
	int y1 = (int)(points[left].Y / REDUCE_SIZE);		//eNX`Y1ʒu
	int x2 = (int)(points[right].X / REDUCE_SIZE);		//eNX`X2ʒu
	int y2 = (int)(points[right].Y / REDUCE_SIZE);		//eNX`Y2ʒu

	//X̓vXɂ
	if (x1 > x2)
	{
		t = x2;
		x2 = x1;
		x1 = t;
		t = y2;
		y2 = y1;
		y1 = t;
	}

	int x, y, d = 1, loc;
	int dy = y2 - y1;
	int dx = x2 - x1;

	if (dx == 0)
		dx = 1;
	if (dy == 0)
		dy = 1;



	//`悷
	if (abs(dy / dx) < 1)
	{
		x = 0;
		if (dy < 0)
		{
			d = -1;
			dy = -dy;
		}
		for (int y = 0; y < dy; y++)
		{
			if (y1 + y * d > 0 && y1 + y * d < g_texHeight)
			{
				while ((x * dy) / dx < y + 1)
				{
					if (x1 + x > 0 && x1 + x < g_texWidth)
					{
						loc = ((y1 + y * d) * g_texWidth + x1 + x) * TEX_PIXELSIZE;
						pDestImage[loc] = 0;
						pDestImage[loc + 1] = 0;
						pDestImage[loc + 2] = 0;
						pDestImage[loc + 3] = 255;
					}
					x++;
				}
			}
		}
	}
	else
	{
		y = 0;
		if (dy < 0)
		{
			d = -1;
			dy = -dy;
		}
		for (int x = 0; x < dx; x++)
		{
			if (x1 + x > 0 && x1 + x < g_texWidth)
			{
				while ((y * dx) / dy < x + 1)
				{
					if (y1 + y * d > 0 && y1 + y * d < g_texHeight)
					{
						loc = ((y1 + y * d) * g_texWidth + x1 + x) * TEX_PIXELSIZE;
						pDestImage[loc] = 0;
						pDestImage[loc + 1] = 0;
						pDestImage[loc + 2] = 0;
						pDestImage[loc + 3] = 255;
					}
					y++;
				}
			}
		}
	}
}
#endif
