/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.ik_solver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import jp.sourceforge.mmd.ik_solver.BoneTableModel;
import jp.sourceforge.mmd.ik_solver.IKSolver;
import jp.sourceforge.mmd.ik_solver.ParentBoneListModel;
import jp.sourceforge.mmd.ik_solver.ParentBoneRenderer;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.Pose;
import jp.sourceforge.mmd.motion.model.Bone;
import jp.sourceforge.mmd.motion.model.Model;
import jp.sourceforge.mmd.motion.swing.BoneComboBox;
import jp.sourceforge.mmd.motion.swing.MmdDialog;
import jp.sourceforge.mmd.motion.swing.VMD2CSV;

public class IKSolver_GUI
extends JFrame {
    private IKSolver ikSolver;
    private Model IKmodel;
    private Motion IKMotion;
    private Model targetModel;
    private Motion targetMotion;
    private File modelFile;
    private File motionFile;
    private File motionOutFile;
    private JButton buttonInsert;
    private JButton buttonOpenIKModel;
    private JButton buttonOpenIKMotion;
    private JButton buttonOpenTargetModel;
    private JButton buttonOpenTargetMotion;
    private JButton buttonRemove;
    private JButton buttonSave;
    private JButton buttonSolve;
    private JCheckBox checkSameModel;
    private BoneComboBox comboArrowBone;
    private BoneComboBox comboMotionBone;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JTextArea jTextAreaLog;
    private JLabel labelIKModelName;
    private JLabel labelIKMotion;
    private JLabel labelTargetModel;
    private JLabel labelTargetMotion;
    private JList listParents;
    private JMenuItem menuAbout;
    private JMenuBar menuBar;
    private JMenuItem menuQuit;
    private JMenuItem menuVMD2CSV;
    private JTable tableBones;
    private JTable tableFrames;

    public IKSolver_GUI() {
        this.motionFile = this.motionOutFile = new File(".");
        this.modelFile = this.motionOutFile;
        this.initComponents();
        this.log("Welcome to MMD IK Solver.");
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.listParents = new JList();
        this.labelIKModelName = new JLabel();
        this.labelTargetModel = new JLabel();
        this.buttonSolve = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.jTextAreaLog = new JTextArea();
        this.buttonOpenTargetModel = new JButton();
        this.buttonOpenIKMotion = new JButton();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        this.buttonInsert = new JButton();
        this.buttonRemove = new JButton();
        this.jScrollPane4 = new JScrollPane();
        this.tableFrames = new JTable();
        this.jScrollPane5 = new JScrollPane();
        this.tableBones = new JTable();
        this.buttonSave = new JButton();
        this.comboArrowBone = new BoneComboBox();
        this.comboMotionBone = new BoneComboBox();
        JSeparator jSeparator1 = new JSeparator();
        this.buttonOpenIKModel = new JButton();
        this.buttonOpenTargetMotion = new JButton();
        this.checkSameModel = new JCheckBox();
        this.labelIKMotion = new JLabel();
        this.labelTargetMotion = new JLabel();
        this.menuBar = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.menuQuit = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.menuVMD2CSV = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.menuAbout = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("MMD IK Solver");
        this.getContentPane().setLayout(new GridBagLayout());
        jLabel1.setText("IK\u30e2\u30c7\u30eb");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)jLabel1, gridBagConstraints);
        jLabel2.setText("\u30bf\u30fc\u30b2\u30c3\u30c8");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.getContentPane().add((Component)jLabel2, gridBagConstraints);
        this.listParents.setCellRenderer(new ParentBoneRenderer());
        this.listParents.setMaximumSize(new Dimension(6000, 6000));
        this.listParents.setModel(new ParentBoneListModel(new Object[0][]));
        this.jScrollPane1.setViewportView(this.listParents);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.labelIKModelName.setText("\u307e\u3060");
        this.labelIKModelName.setMaximumSize(new Dimension(180, 20));
        this.labelIKModelName.setMinimumSize(new Dimension(80, 19));
        this.labelIKModelName.setPreferredSize(new Dimension(80, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.labelIKModelName, gridBagConstraints);
        this.labelTargetModel.setText("\u307e\u3060");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 80;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.labelTargetModel, gridBagConstraints);
        this.buttonSolve.setEnabled(false);
        this.buttonSolve.setLabel("IK \u89e3\u304f");
        this.buttonSolve.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.buttonSolveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.buttonSolve, gridBagConstraints);
        this.jScrollPane3.setPreferredSize(new Dimension(250, 96));
        this.jTextAreaLog.setEditable(false);
        this.jTextAreaLog.setColumns(20);
        this.jTextAreaLog.setRows(5);
        this.jScrollPane3.setViewportView(this.jTextAreaLog);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.ipady = 30;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 18, 10, 19);
        this.getContentPane().add((Component)this.jScrollPane3, gridBagConstraints);
        this.buttonOpenTargetModel.setText("\u30e2\u30c7\u30eb\u8aad\u307f");
        this.buttonOpenTargetModel.setEnabled(false);
        this.buttonOpenTargetModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.buttonOpenTargetModelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.buttonOpenTargetModel, gridBagConstraints);
        this.buttonOpenIKMotion.setText("\u30e2\u30fc\u30b7\u30e7\u30f3\u8aad\u307f");
        this.buttonOpenIKMotion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.buttonOpenIKMotionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.buttonOpenIKMotion, gridBagConstraints);
        jLabel5.setText("\u89aa");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)jLabel5, gridBagConstraints);
        jLabel6.setText("\u5909\u66f4\u5bfe\u8c61");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 15;
        this.getContentPane().add((Component)jLabel6, gridBagConstraints);
        this.buttonInsert.setText("\u2192");
        this.buttonInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.buttonInsertActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.getContentPane().add((Component)this.buttonInsert, gridBagConstraints);
        this.buttonRemove.setText("\u2190");
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.buttonRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.getContentPane().add((Component)this.buttonRemove, gridBagConstraints);
        this.jScrollPane4.setMinimumSize(new Dimension(80, 100));
        this.jScrollPane4.setPreferredSize(new Dimension(80, 100));
        this.tableFrames.setFont(new Font("MS UI Gothic", 0, 10));
        this.tableFrames.setModel(new DefaultTableModel(new Object[0][], new String[]{"Frame", "\u8ddd\u96e2"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Double.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tableFrames.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane4.setViewportView(this.tableFrames);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane4, gridBagConstraints);
        this.jScrollPane5.setMinimumSize(new Dimension(80, 80));
        this.jScrollPane5.setPreferredSize(new Dimension(100, 100));
        this.tableBones.setModel(new BoneTableModel());
        this.tableBones.setDefaultEditor(Boolean.class, new DefaultCellEditor(new JCheckBox()));
        this.tableBones.setMaximumSize(new Dimension(6000, 6000));
        this.tableBones.setMinimumSize(new Dimension(200, 200));
        this.tableBones.setPreferredSize(new Dimension(250, 200));
        this.jScrollPane5.setViewportView(this.tableBones);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jScrollPane5, gridBagConstraints);
        this.buttonSave.setText("\u4fdd\u5b58");
        this.buttonSave.setEnabled(false);
        this.buttonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.buttonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        this.getContentPane().add((Component)this.buttonSave, gridBagConstraints);
        this.comboArrowBone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.comboArrowBoneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.comboArrowBone, gridBagConstraints);
        this.comboMotionBone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.comboMotionBoneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.comboMotionBone, gridBagConstraints);
        jSeparator1.setBorder(BorderFactory.createBevelBorder(0, new Color(102, 102, 102), new Color(204, 204, 204), new Color(0, 0, 0), new Color(153, 153, 153)));
        jSeparator1.setMinimumSize(new Dimension(10, 50));
        jSeparator1.setPreferredSize(new Dimension(10, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 8;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)jSeparator1, gridBagConstraints);
        this.buttonOpenIKModel.setText("\u30e2\u30c7\u30eb\u8aad\u307f");
        this.buttonOpenIKModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.buttonOpenIKModelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.buttonOpenIKModel, gridBagConstraints);
        this.buttonOpenTargetMotion.setText("\u30e2\u30fc\u30b7\u30e7\u30f3\u8aad\u307f");
        this.buttonOpenTargetMotion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.buttonOpenTargetMotionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.buttonOpenTargetMotion, gridBagConstraints);
        this.checkSameModel.setSelected(true);
        this.checkSameModel.setText("IK\u30e2\u30c7\u30eb\u3068\u540c\u3058");
        this.checkSameModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.checkSameModelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.getContentPane().add((Component)this.checkSameModel, gridBagConstraints);
        this.labelIKMotion.setText("\u521d\u671f\u5024");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        this.getContentPane().add((Component)this.labelIKMotion, gridBagConstraints);
        this.labelTargetMotion.setText("\u521d\u671f\u5024");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        this.getContentPane().add((Component)this.labelTargetMotion, gridBagConstraints);
        this.jMenu1.setText("File");
        this.menuQuit.setText("\u7d42\u4e86");
        this.menuQuit.setToolTipText("\u7d42\u4e86");
        this.menuQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.menuQuitActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.menuQuit);
        this.menuBar.add(this.jMenu1);
        this.jMenu3.setText("Tool");
        this.menuVMD2CSV.setText("vmd2csv convert");
        this.menuVMD2CSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.menuVMD2CSVActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.menuVMD2CSV);
        this.menuBar.add(this.jMenu3);
        this.jMenu2.setText("help");
        this.jMenu2.setToolTipText("");
        this.menuBar.add(Box.createHorizontalGlue());
        this.menuAbout.setText("about");
        this.menuAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.menuAboutActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.menuAbout);
        this.menuBar.add(this.jMenu2);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void menuQuitActionPerformed(ActionEvent evt) {
        int i = JOptionPane.showConfirmDialog(this, "\u7d42\u4e86\u3057\u3066\u3044\u3044\u3067\u3059\u304b", "MMD IK Solver", 0);
        if (i == 0) {
            this.dispose();
        }
    }

    private void menuAboutActionPerformed(ActionEvent evt) {
        String ret = "<html>MMD IK Solver \u306f MMD Motion Library for Java \u306e<br>IK \u554f\u984c\u3092\u89e3\u3044\u3066\u3001MMD \u30e2\u30fc\u30b7\u30e7\u30f3\u306b\u3059\u308b<br>Java \u30e9\u30a4\u30d6\u30e9\u30ea\u30fc\u306e GUI \u3067\u3059\u3002<br>MMD IK Solver ";
        Class<?> c = this.getClass();
        URL u = c.getResource(c.getSimpleName() + ".class");
        String s = u.toExternalForm();
        Properties p = new Properties();
        if (s.startsWith("jar")) {
            String jar = s.substring(0, s.lastIndexOf("!/") + 2);
            try {
                InputStream is = new URL(jar + "META-INF/maven/jp.sourceforge.mmd/MMDIKSolver/pom.properties").openStream();
                p.load(is);
                is.close();
                ret = ret + "(" + p.getProperty("groupId") + "." + p.getProperty("artifactId") + ") Version: " + p.getProperty("version") + "<br>" + "Copyright 2015 by nazo, MIT License 2.0<br><br>\u4f9d\u5b58\u6027: ";
                JarURLConnection jarConnection = (JarURLConnection)new URL(jar).openConnection();
                Attributes attr = jarConnection.getMainAttributes();
                String el = attr.getValue("Extension-List");
                for (String l : el.split(" ")) {
                    String name = attr.getValue(l + "-Extension-Name");
                    ret = ret + name + " ";
                    name = attr.getValue(l + "-Implementation-Version");
                    ret = ret + "Version: " + name + " <br>";
                }
            }
            catch (MalformedURLException ex) {
                ret = ret + ex;
            }
            catch (IOException ex) {
                ret = ret + ex;
            }
        } else {
            String cp = s.substring(0, s.lastIndexOf("classes/"));
            try {
                InputStream is = new URL(cp + "maven-archiver/pom.properties").openStream();
                p.load(is);
                is.close();
                ret = ret + "(" + p.getProperty("groupId") + "." + p.getProperty("artifactId") + ") Version: " + p.getProperty("version") + "<br>";
            }
            catch (MalformedURLException ex) {
                ret = ret + ex;
            }
            catch (IOException ex) {
                ret = ret + "(jp.sourceforge.mmd.MMDIKSolver) http://sourceforge.jp/projects/mmdmotion-java/ Version: 1.0<br>";
            }
            ret = ret + "Copyright 2015 by nazo, MIT License 2.0<br><br>\u4f9d\u5b58\u6027: ";
            ret = ret + "TogaGem (jp.sourceforge.mikutoga.togagem) http://mikutoga.sourceforge.jp/ Version: 3.101.4-mod<br>MMD Motion (jp.sourceforge.mmd.MMDMotion) http://sourceforge.jp/projects/mmdmotion-java/ Version: 1.0<br>";
        }
        ret = ret + "</html>";
        JOptionPane.showMessageDialog(this, ret, "MMD IK Solver \u306b\u3064\u3044\u3066", 1);
    }

    private void buttonSolveActionPerformed(ActionEvent evt) {
        int i;
        this.ikSolver = new IKSolver();
        int l = this.tableBones.getRowCount();
        Bone[] bs = new Bone[l + 1];
        bs[0] = this.IKmodel.get((String)this.comboArrowBone.getSelectedItem());
        BoneTableModel btm = (BoneTableModel)this.tableBones.getModel();
        for (i = 1; i <= l; ++i) {
            bs[i] = this.IKmodel.get((String)btm.getValueAt(i - 1, 0));
        }
        this.ikSolver.setBones(bs);
        for (i = 1; i <= l; ++i) {
            int flags = (Boolean)btm.getValueAt(i - 1, 1) != false ? 128 : 0;
            flags += (Boolean)btm.getValueAt(i - 1, 2) != false ? 3 : 0;
            flags += (Boolean)btm.getValueAt(i - 1, 3) != false ? 12 : 0;
            this.ikSolver.setLimits(i, flags += (Boolean)btm.getValueAt(i - 1, 4) != false ? 48 : 0);
        }
        if (this.IKMotion == null) {
            this.IKMotion = new Motion(this.IKmodel.getName());
        }
        String targetBone = (String)this.comboMotionBone.getSelectedItem();
        Pose[] poses = this.targetMotion.get(targetBone);
        Bone boneTarget = this.targetModel.get(targetBone);
        for (Pose p : poses) {
            int frame = p.frame;
            this.log(String.valueOf(p.frame));
            this.IKmodel.setPoses(this.IKMotion.getInterporate(frame));
            if (this.targetModel != this.IKmodel) {
                this.targetModel.setPoses(this.targetMotion.get(frame));
            }
            this.IKmodel.resetChanged();
            this.ikSolver.solve(boneTarget.getPos());
            this.IKMotion.putAll(this.IKmodel.getChanged(), frame);
        }
        this.buttonSave.setEnabled(true);
    }

    private void buttonOpenTargetModelActionPerformed(ActionEvent evt) {
        Model m = MmdDialog.loadModel((Component)this);
        if (m == null) {
            return;
        }
        this.targetModel = m;
        this.labelTargetModel.setText(this.targetModel.getName());
    }

    private void buttonOpenIKMotionActionPerformed(ActionEvent evt) {
        Motion m = MmdDialog.loadMotion((Component)this);
        if (m == null) {
            return;
        }
        this.IKMotion = m;
        this.labelIKMotion.setText(this.IKMotion.getModelName());
    }

    private void menuVMD2CSVActionPerformed(ActionEvent evt) {
        VMD2CSV a = new VMD2CSV();
        a.setVisible(true);
    }

    private void buttonInsertActionPerformed(ActionEvent evt) {
        Object[] sel = (Object[])this.listParents.getSelectedValue();
        if (sel == null) {
            return;
        }
        ((BoneTableModel)this.tableBones.getModel()).add((String)sel[0], (Integer)sel[1]);
        this.tableBones.repaint();
        if (this.tableFrames.getRowCount() > 0) {
            this.buttonSolve.setEnabled(true);
        }
    }

    private void buttonRemoveActionPerformed(ActionEvent evt) {
        int i = this.tableBones.getSelectedRow();
        if (i < 0) {
            return;
        }
        BoneTableModel btm = (BoneTableModel)this.tableBones.getModel();
        btm.removeRow(i);
        this.tableBones.repaint();
        if (btm.getColumnCount() == 0) {
            this.buttonSolve.setEnabled(false);
        }
    }

    private void buttonSaveActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser(this.motionFile.getParentFile());
        jfc.setDialogTitle("\u30e2\u30fc\u30b7\u30e7\u30f3\u3092\u4fdd\u5b58");
        jfc.setFileFilter(new FileNameExtensionFilter("MMD motion", "vmd"));
        jfc.addChoosableFileFilter(new FileNameExtensionFilter("CSV motion", "csv"));
        jfc.setApproveButtonText("\u4fdd\u5b58");
        jfc.setDialogType(1);
        if (jfc.showSaveDialog(this) != 0) {
            return;
        }
        this.motionOutFile = jfc.getSelectedFile();
        try {
            FileOutputStream fos = new FileOutputStream(this.motionOutFile);
            if (this.motionOutFile.getName().toLowerCase().endsWith(".vmd")) {
                this.IKMotion.toVMD((OutputStream)fos);
            } else {
                this.IKMotion.toCSV((OutputStream)fos);
            }
            fos.close();
        }
        catch (UnsupportedCharsetException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
    }

    private void comboArrowBoneActionPerformed(ActionEvent evt) {
        this.listParents.removeAll();
        ((BoneTableModel)this.tableBones.getModel()).removeAll();
        this.tableBones.repaint();
        this.buttonSolve.setEnabled(false);
        String selected = (String)this.comboArrowBone.getSelectedItem();
        if (selected == null) {
            return;
        }
        Bone b = this.IKmodel.get(selected);
        if (b == null) {
            return;
        }
        ArrayList<Object[]> al = new ArrayList<Object[]>();
        int j = 0;
        while ((selected = b.getParent()) != null) {
            al.add(new Object[]{selected, j});
            ++j;
            b = this.IKmodel.get(selected);
        }
        this.listParents.setModel(new ParentBoneListModel((Object[][])al.toArray((T[])new Object[al.size()][])));
    }

    private void comboMotionBoneActionPerformed(ActionEvent evt) {
        String s = (String)this.comboMotionBone.getSelectedItem();
        if (s == null) {
            return;
        }
        Pose[] p = this.targetMotion.get(s);
        if (p == null) {
            return;
        }
        Object[][] table = new Object[p.length][];
        for (int i = 0; i < p.length; ++i) {
            table[i] = new Object[]{p[i].frame, null};
        }
        this.tableFrames.setModel(new DefaultTableModel(table, new String[]{"frame", "\u8ddd\u96e2"}));
        if (this.tableBones.getRowCount() > 0 && this.tableFrames.getRowCount() > 0) {
            this.buttonSolve.setEnabled(true);
        } else {
            this.buttonSolve.setEnabled(false);
        }
    }

    private void buttonOpenIKModelActionPerformed(ActionEvent evt) {
        Model m = MmdDialog.loadModel((Component)this);
        if (m == null) {
            return;
        }
        this.IKmodel = m;
        this.labelIKModelName.setText(this.IKmodel.getName());
        this.comboArrowBone.removeAllItems();
        this.comboArrowBone.setMMDModel(this.IKmodel);
        if (this.checkSameModel.isSelected()) {
            this.targetModel = this.IKmodel;
            this.labelTargetModel.setText(this.targetModel.getName());
        }
    }

    private void buttonOpenTargetMotionActionPerformed(ActionEvent evt) {
        Motion m = MmdDialog.loadMotion((Component)this);
        if (m == null) {
            return;
        }
        this.targetMotion = m;
        this.labelTargetMotion.setText(this.targetMotion.getModelName());
        this.comboMotionBone.setMMDMotion(this.targetMotion);
    }

    private void checkSameModelActionPerformed(ActionEvent evt) {
        if (this.checkSameModel.isSelected()) {
            this.buttonOpenTargetModel.setEnabled(false);
            this.targetModel = this.IKmodel;
            if (this.targetModel != null) {
                this.labelTargetModel.setText(this.targetModel.getName());
            }
        } else {
            this.buttonOpenTargetModel.setEnabled(true);
        }
    }

    private void log(String log) {
        this.jTextAreaLog.setText(this.jTextAreaLog.getText() + log + "\n");
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(IKSolver_GUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(IKSolver_GUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(IKSolver_GUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(IKSolver_GUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new IKSolver_GUI().setVisible(true);
            }
        });
    }
}

