/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.ik_solver;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

/**
 *
 * @author nazo
 */
public class BoneTableModel extends AbstractTableModel{
    class Row{
        String name;
        int order;
        boolean lx;
        boolean ly;
        boolean lz;
        boolean l;
        Row(String s,int i){
            name=s;
            order=i;
        }
    }
    static final private String [] colName= new String []{"name","limited","noX","noY","noZ"};
    ArrayList<Row>  entries=new ArrayList<Row>();
    @Override
    public int getRowCount() {
        return entries.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if(columnIndex>0&&columnIndex<5){
            return Boolean.class;
        }else {
            return String.class;
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if(columnIndex>1&&columnIndex<5){
            return true;
        }else {
            return false;
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        super.setValueAt(aValue, rowIndex, columnIndex); //To change body of generated methods, choose Tools | Templates.
        if(columnIndex<2)return;
        Row a=entries.get(rowIndex);
        Boolean b=(Boolean)aValue;
        switch(columnIndex){
            case 2:
                a.lx=b;
                return;
            case 3:
                a.ly=b;
                return; 
            case 4:
                a.lz=b;
                return; 
        }
        return;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Row a=entries.get(rowIndex);
        if(a==null)return null;
        switch(columnIndex){
            case 0:
                return a.name;
            case 1:
                return a.l;
            case 2:
                return a.lx;
            case 3:
                return a.ly;
            case 4:
                return a.lz;
            default:
                return null;
        }
    }
    public void add(String s,int order){
        Row n=new Row(s,order);
        int i=0;
        for(Row o:entries){
            if(o.order>=order){
                if(o.name.compareTo(s)==0){
                    return;
                }
                entries.add(i,n);
                break;
            }
            i++;
        }
        if(i==entries.size()){
            entries.add(n);
        }
    }
    @Override
    public String getColumnName(int col) {
        return colName[col];
    }
    public void removeRow(int row){
        if(0<=row&&row<entries.size()){
            entries.remove(row);
        }
    }
    public void removeAll(){
        entries.clear();
    }
}
