/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.ik_solver;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.Pose;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.model.Bone;
import jp.sourceforge.mmd.motion.model.Model;

/**
 *
 * @author nazo
 */
public class IKSolverTest {
    static public void main(String [] argv){
        IKSolver iks;
        Model model=null;
        try {
            FileInputStream fis=new FileInputStream("maki_cut.csv");
            model=Model.fromCSV(fis);
            fis.close();
        } catch (FileNotFoundException ex) {
            System.err.println(ex.getMessage());
        } catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        int i;
        double d;
        Motion maki_ini=null;
        try {
            FileInputStream fis=new FileInputStream("guiter_temp_cut.vmd");
            maki_ini=new Motion().fromVMD(fis);
            fis.close();
        }catch(FileNotFoundException e){
            System.exit(-1);
        }catch(IOException e){
        }catch (MmdFormatException ex) {
            Logger.getLogger(IKSolver.class.getName()).log(Level.SEVERE, null, ex);
        }

        Pose [] poses;
/*        Motion motion=new Motion(model.getName());*/
        Motion motionQ=new Motion("Coordinates");
        Motion motionT=new Motion("Coordinates");
/*        Motion motionQ=new Motion("Coordinates");*/

        Bone [] bs=new Bone []{model.get("左手首"),model.get("左ひじ"),model.get("左腕")};
        Pose ps;

        Bone mustan=model.get("むすタン");
        model.setPoses(maki_ini.get(0));
        Vector3D pos=mustan.getPos();
        Vector3D ly=mustan.getLy();
        Vector3D target;

        iks=new IKSolver();
        iks.setBones(bs);
        iks.setLimits(1, IKSolver.RLIMIT_NOX | IKSolver.RLIMIT_NOZ);
//        iks.setLimits(0, IKSolver.RLIMIT_NOGlobalR);
        model.resetChanged();
        iks.solve(model.get("左手首D").getPos());
        model.get("左手首").rotateToG(model.get("左手首D").getGMatrix());
        poses=model.getChanged();
        maki_ini.putAll(poses, 0);
        ps=bs[0].getCoordinate();
        ps.nameOfBone="原点1";
        ps.frame=0;
        motionQ.put(ps);
        ps=bs[1].getCoordinate();
        ps.nameOfBone="原点1";
        ps.frame=0;
        motionT.put(ps);

        for(i=-12;i<5;i++){
            model.resetChanged();
            iks.solve(
                    model.get("左手首D").getPos().add(
                            ly.times(7.6653090647*0.25
                                    *(Math.pow(2D,(double)(i+19)/12D)-Math.pow(2D,(double)19/12D))
                            )));
            model.get("左手首").rotateToG(model.get("左手首D").getGMatrix());
            poses=model.getChanged();
            maki_ini.putAll(poses, 13+i);

            ps=bs[0].getCoordinate();
            ps.nameOfBone="原点1";
            ps.frame=13+i;
            motionQ.put(ps);

            ps=bs[1].getCoordinate();
            ps.nameOfBone="原点1";
            ps.frame=13+i;
            motionT.put(ps);
        }
        
        try {
            FileOutputStream fos=new FileOutputStream("maki_solve.vmd");
            maki_ini.toVMD(fos);
            fos.close();
            motionQ.toVMD(fos=new FileOutputStream("testQ.vmd"));
            fos.close();
            motionT.toVMD(fos=new FileOutputStream("testT.vmd"));
            fos.close();
        } catch (FileNotFoundException ex) {
            Logger.getLogger(IKSolver.class.getName()).log(Level.SEVERE, null, ex);
        } catch (UnsupportedEncodingException ex) {
            Logger.getLogger(IKSolver.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(IKSolver.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}
