/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.ik_solver;

import jp.sourceforge.mmd.motion.model.Bone;
import jp.sourceforge.mmd.motion.model.Model;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.UnsupportedCharsetException;

import java.util.ArrayList;
import java.util.Properties;
import java.util.jar.Attributes;
import javax.swing.JCheckBox;
import javax.swing.Box;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.DefaultCellEditor;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.Pose;
import jp.sourceforge.mmd.motion.swing.VMD2CSV;
import jp.sourceforge.mmd.motion.swing.MmdDialog;

/**
 * IK Solver の簡易 GUI
 * @author nazo
 */
public class IKSolver_GUI extends javax.swing.JFrame {
    private IKSolver ikSolver;
    private Model IKmodel;
    private Motion IKMotion;
    private Model targetModel;
    private Motion targetMotion;
    private File modelFile;
    private File motionFile;
    private File motionOutFile;
    
    /**
     * Creates new form IKSover_GUI
     */
    public IKSolver_GUI() {
        modelFile=motionFile=motionOutFile= new File(".");
        initComponents();
        log("Welcome to MMD IK Solver.");
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
        javax.swing.JLabel jLabel2 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        listParents = new javax.swing.JList<String>();
        labelIKModelName = new javax.swing.JLabel();
        labelTargetModel = new javax.swing.JLabel();
        buttonSolve = new javax.swing.JButton();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTextAreaLog = new javax.swing.JTextArea();
        buttonOpenTargetModel = new javax.swing.JButton();
        buttonOpenIKMotion = new javax.swing.JButton();
        javax.swing.JLabel jLabel5 = new javax.swing.JLabel();
        javax.swing.JLabel jLabel6 = new javax.swing.JLabel();
        buttonInsert = new javax.swing.JButton();
        buttonRemove = new javax.swing.JButton();
        jScrollPane4 = new javax.swing.JScrollPane();
        tableFrames = new javax.swing.JTable();
        jScrollPane5 = new javax.swing.JScrollPane();
        tableBones = new javax.swing.JTable();
        buttonSave = new javax.swing.JButton();
        comboArrowBone = new jp.sourceforge.mmd.motion.swing.BoneComboBox();
        comboMotionBone = new jp.sourceforge.mmd.motion.swing.BoneComboBox();
        javax.swing.JSeparator jSeparator1 = new javax.swing.JSeparator();
        buttonOpenIKModel = new javax.swing.JButton();
        buttonOpenTargetMotion = new javax.swing.JButton();
        checkSameModel = new javax.swing.JCheckBox();
        labelIKMotion = new javax.swing.JLabel();
        labelTargetMotion = new javax.swing.JLabel();
        menuBar = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        menuQuit = new javax.swing.JMenuItem();
        jMenu3 = new javax.swing.JMenu();
        menuVMD2CSV = new javax.swing.JMenuItem();
        jMenu2 = new javax.swing.JMenu();
        menuAbout = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("MMD IK Solver");
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("IKモデル");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jLabel1, gridBagConstraints);

        jLabel2.setText("ターゲット");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        getContentPane().add(jLabel2, gridBagConstraints);

        listParents.setCellRenderer(new ParentBoneRenderer());
        listParents.setMaximumSize(new java.awt.Dimension(6000, 6000));
        listParents.setModel(new ParentBoneListModel(new Object[0][]));
        jScrollPane1.setViewportView(listParents);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jScrollPane1, gridBagConstraints);

        labelIKModelName.setText("まだ");
        labelIKModelName.setMaximumSize(new java.awt.Dimension(180, 20));
        labelIKModelName.setMinimumSize(new java.awt.Dimension(80, 19));
        labelIKModelName.setPreferredSize(new java.awt.Dimension(80, 19));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(labelIKModelName, gridBagConstraints);

        labelTargetModel.setText("まだ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 80;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(labelTargetModel, gridBagConstraints);

        buttonSolve.setEnabled(false);
        buttonSolve.setLabel("IK 解く");
        buttonSolve.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonSolveActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        getContentPane().add(buttonSolve, gridBagConstraints);

        jScrollPane3.setPreferredSize(new java.awt.Dimension(250, 96));

        jTextAreaLog.setEditable(false);
        jTextAreaLog.setColumns(20);
        jTextAreaLog.setRows(5);
        jScrollPane3.setViewportView(jTextAreaLog);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.ipady = 30;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 18, 10, 19);
        getContentPane().add(jScrollPane3, gridBagConstraints);

        buttonOpenTargetModel.setText("モデル読み");
        buttonOpenTargetModel.setEnabled(false);
        buttonOpenTargetModel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonOpenTargetModelActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(buttonOpenTargetModel, gridBagConstraints);

        buttonOpenIKMotion.setText("モーション読み");
        buttonOpenIKMotion.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonOpenIKMotionActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(buttonOpenIKMotion, gridBagConstraints);

        jLabel5.setText("親");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jLabel5, gridBagConstraints);

        jLabel6.setText("変更対象");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        getContentPane().add(jLabel6, gridBagConstraints);

        buttonInsert.setText("→");
        buttonInsert.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonInsertActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        getContentPane().add(buttonInsert, gridBagConstraints);

        buttonRemove.setText("←");
        buttonRemove.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        getContentPane().add(buttonRemove, gridBagConstraints);

        jScrollPane4.setMinimumSize(new java.awt.Dimension(80, 100));
        jScrollPane4.setPreferredSize(new java.awt.Dimension(80, 100));

        tableFrames.setFont(new java.awt.Font("MS UI Gothic", 0, 10)); // NOI18N
        tableFrames.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Frame", "距離"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.Integer.class, java.lang.Double.class
            };
            boolean[] canEdit = new boolean [] {
                false, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        tableFrames.getTableHeader().setReorderingAllowed(false);
        jScrollPane4.setViewportView(tableFrames);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jScrollPane4, gridBagConstraints);

        jScrollPane5.setMinimumSize(new java.awt.Dimension(80, 80));
        jScrollPane5.setPreferredSize(new java.awt.Dimension(100, 100));

        tableBones.setModel(new BoneTableModel()
        );
        tableBones.setDefaultEditor(Boolean.class,new DefaultCellEditor(new JCheckBox()));
        tableBones.setMaximumSize(new java.awt.Dimension(6000, 6000));
        tableBones.setMinimumSize(new java.awt.Dimension(200, 200));
        tableBones.setPreferredSize(new java.awt.Dimension(250, 200));
        jScrollPane5.setViewportView(tableBones);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        getContentPane().add(jScrollPane5, gridBagConstraints);

        buttonSave.setText("保存");
        buttonSave.setEnabled(false);
        buttonSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        getContentPane().add(buttonSave, gridBagConstraints);

        comboArrowBone.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                comboArrowBoneActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(comboArrowBone, gridBagConstraints);

        comboMotionBone.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                comboMotionBoneActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(comboMotionBone, gridBagConstraints);

        jSeparator1.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED, new java.awt.Color(102, 102, 102), new java.awt.Color(204, 204, 204), new java.awt.Color(0, 0, 0), new java.awt.Color(153, 153, 153)));
        jSeparator1.setMinimumSize(new java.awt.Dimension(10, 50));
        jSeparator1.setPreferredSize(new java.awt.Dimension(10, 50));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jSeparator1, gridBagConstraints);

        buttonOpenIKModel.setText("モデル読み");
        buttonOpenIKModel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonOpenIKModelActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(buttonOpenIKModel, gridBagConstraints);

        buttonOpenTargetMotion.setText("モーション読み");
        buttonOpenTargetMotion.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonOpenTargetMotionActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(buttonOpenTargetMotion, gridBagConstraints);

        checkSameModel.setSelected(true);
        checkSameModel.setText("IKモデルと同じ");
        checkSameModel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                checkSameModelActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        getContentPane().add(checkSameModel, gridBagConstraints);

        labelIKMotion.setText("初期値");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        getContentPane().add(labelIKMotion, gridBagConstraints);

        labelTargetMotion.setText("初期値");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        getContentPane().add(labelTargetMotion, gridBagConstraints);

        jMenu1.setText("File");

        menuQuit.setText("終了");
        menuQuit.setToolTipText("終了");
        menuQuit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                menuQuitActionPerformed(evt);
            }
        });
        jMenu1.add(menuQuit);

        menuBar.add(jMenu1);

        jMenu3.setText("Tool");

        menuVMD2CSV.setText("vmd2csv convert");
        menuVMD2CSV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                menuVMD2CSVActionPerformed(evt);
            }
        });
        jMenu3.add(menuVMD2CSV);

        menuBar.add(jMenu3);

        jMenu2.setText("help");
        jMenu2.setToolTipText("");
        menuBar.add(Box.createHorizontalGlue());

        menuAbout.setText("about");
        menuAbout.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                menuAboutActionPerformed(evt);
            }
        });
        jMenu2.add(menuAbout);

        menuBar.add(jMenu2);

        setJMenuBar(menuBar);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void menuQuitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_menuQuitActionPerformed
        int i=JOptionPane.showConfirmDialog(this,"終了していいですか","MMD IK Solver",JOptionPane.YES_NO_OPTION);
        if(i==JOptionPane.OK_OPTION){
            dispose();
        }
    }//GEN-LAST:event_menuQuitActionPerformed

    private void menuAboutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_menuAboutActionPerformed
        String ret="<html>MMD IK Solver は MMD Motion Library for Java の<br>"
                + "IK 問題を解いて、MMD モーションにする<br>"
                + "Java ライブラリーの GUI です。<br>MMD IK Solver ";
        Class<? extends IKSolver_GUI> c=this.getClass();
        URL u = c.getResource(c.getSimpleName() + ".class");
        String s=u.toExternalForm();
        Properties p=new Properties();

        if(s.startsWith("jar")){
            String jar = s.substring(0, s.lastIndexOf("!/")+2);
            JarURLConnection jarConnection;
            try {
                InputStream is=new URL(jar+"META-INF/maven/jp.sourceforge.mmd/MMDIKSolver/pom.properties").openStream();
                p.load(is);
                is.close();
                ret+="("+p.getProperty("groupId")+"."+p.getProperty("artifactId")+") Version: "+p.getProperty("version")+"<br>"
                    + "Copyright 2015 by nazo, MIT License 2.0<br><br>依存性: ";
                
                jarConnection = (JarURLConnection)new URL(jar).openConnection();

                Attributes attr = jarConnection.getMainAttributes();
                String el=attr.getValue("Extension-List");
                for(String l:el.split(" ")){
                    String name=attr.getValue(l+"-Extension-Name");
                    ret+=name+" ";
                    name=attr.getValue(l+"-Implementation-Version");
                    ret+="Version: "+name+" <br>";
                }
            } catch (MalformedURLException ex) {
                ret+=ex;
            } catch (IOException ex) {
                ret+=ex;
            }
        }else{
            String cp = s.substring(0, s.lastIndexOf("classes/"));
            InputStream is;
            try {
                is = new URL(cp+"maven-archiver/pom.properties").openStream();
                p.load(is);
                is.close();
                ret+="("+p.getProperty("groupId")+"."+p.getProperty("artifactId")+") Version: "+p.getProperty("version")+"<br>";
            } catch (MalformedURLException ex) {
                ret+=ex;
            } catch (IOException ex) {
                ret+= "(jp.sourceforge.mmd.MMDIKSolver) http://sourceforge.jp/projects/mmdmotion-java/ Version: 1.0<br>";
            }
            ret += "Copyright 2015 by nazo, MIT License 2.0<br><br>依存性: ";

            ret+= "TogaGem (jp.sourceforge.mikutoga.togagem) http://mikutoga.sourceforge.jp/ Version: 3.101.4-mod<br>"
                + "MMD Motion (jp.sourceforge.mmd.MMDMotion) http://sourceforge.jp/projects/mmdmotion-java/ Version: 1.0<br>";
        }
        ret += "</html>";

        JOptionPane.showMessageDialog(this, ret,
                "MMD IK Solver について", JOptionPane.INFORMATION_MESSAGE);
    }//GEN-LAST:event_menuAboutActionPerformed

    private void buttonSolveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonSolveActionPerformed
        ikSolver=new IKSolver();
        int l=tableBones.getRowCount();
        int i;
        Bone [] bs=new Bone[l+1];
        bs[0]=IKmodel.get((String)comboArrowBone.getSelectedItem());
        BoneTableModel btm=(BoneTableModel)tableBones.getModel();
        for(i=1;i<=l;i++){
            bs[i]=IKmodel.get((String)btm.getValueAt(i-1, 0));
        }
        ikSolver.setBones(bs);
        int flags;
        for(i=1;i<=l;i++){
            flags=((Boolean)(btm.getValueAt(i-1, 1)))?IKSolver.RLIMIT_LIMITED:0;
            flags+=((Boolean)(btm.getValueAt(i-1, 2)))?IKSolver.RLIMIT_NOX:0;
            flags+=((Boolean)(btm.getValueAt(i-1, 3)))?IKSolver.RLIMIT_NOY:0;
            flags+=((Boolean)(btm.getValueAt(i-1, 4)))?IKSolver.RLIMIT_NOZ:0;
            ikSolver.setLimits(i, flags);
        }
        if(IKMotion==null){
            IKMotion=new Motion(IKmodel.getName());
        }

        String targetBone=(String)comboMotionBone.getSelectedItem();
        Pose [] poses=targetMotion.get(targetBone);
        Bone boneTarget=targetModel.get(targetBone);
        int frame;
        for(Pose p: poses){
            frame=p.frame;
            log(String.valueOf(p.frame));

            IKmodel.setPoses(IKMotion.getInterporate(frame));
            if(targetModel!=IKmodel){
                targetModel.setPoses(targetMotion.get(frame));
            }
            IKmodel.resetChanged();
            ikSolver.solve(boneTarget.getPos());
            IKMotion.putAll(IKmodel.getChanged(), frame);
        }
        buttonSave.setEnabled(true);
    }//GEN-LAST:event_buttonSolveActionPerformed

    private void buttonOpenTargetModelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonOpenTargetModelActionPerformed
        Model m=MmdDialog.loadModel(this);
        if(m==null)
            return;
        targetModel=m;
        labelTargetModel.setText(targetModel.getName());
    }//GEN-LAST:event_buttonOpenTargetModelActionPerformed

    private void buttonOpenIKMotionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonOpenIKMotionActionPerformed
        Motion m=MmdDialog.loadMotion(this);
        if(m==null){
            return;
        }
        IKMotion=m;
        labelIKMotion.setText(IKMotion.getModelName()); 
    }//GEN-LAST:event_buttonOpenIKMotionActionPerformed

    private void menuVMD2CSVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_menuVMD2CSVActionPerformed
        JFrame a=new VMD2CSV();
        a.setVisible(true);
    }//GEN-LAST:event_menuVMD2CSVActionPerformed

    private void buttonInsertActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonInsertActionPerformed
        Object [] sel=(Object [])listParents.getSelectedValue();
        if(sel==null)return;
        ((BoneTableModel)tableBones.getModel()).add((String)sel[0],(Integer)sel[1]);
        tableBones.repaint();
        if(tableFrames.getRowCount()>0){
            buttonSolve.setEnabled(true);
        }
    }//GEN-LAST:event_buttonInsertActionPerformed

    private void buttonRemoveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonRemoveActionPerformed
        int i=tableBones.getSelectedRow();
        if(i<0)return;
        BoneTableModel btm=(BoneTableModel)tableBones.getModel();
        btm.removeRow(i);
        tableBones.repaint();
        if(btm.getColumnCount()==0){
            buttonSolve.setEnabled(false);
        }
    }//GEN-LAST:event_buttonRemoveActionPerformed

    private void buttonSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonSaveActionPerformed
        JFileChooser jfc=new JFileChooser(motionFile.getParentFile());
        jfc.setDialogTitle("モーションを保存");
        jfc.setFileFilter(new FileNameExtensionFilter("MMD motion","vmd"));
        jfc.addChoosableFileFilter(new FileNameExtensionFilter("CSV motion","csv"));
        jfc.setApproveButtonText("保存");
        jfc.setDialogType(JFileChooser.SAVE_DIALOG);
        if(jfc.showSaveDialog(this)!=JFileChooser.APPROVE_OPTION)
            return;
        motionOutFile=jfc.getSelectedFile();
        try{
            FileOutputStream fos=new FileOutputStream(motionOutFile);
            if(motionOutFile.getName().toLowerCase().endsWith(".vmd")){
                IKMotion.toVMD(fos);
            }else {
                IKMotion.toCSV(fos);
            }
            fos.close();
        }catch(UnsupportedCharsetException ex){
            JOptionPane.showMessageDialog(this, ex.getMessage());
        } catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        } catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
    }//GEN-LAST:event_buttonSaveActionPerformed

    private void comboArrowBoneActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_comboArrowBoneActionPerformed
        listParents.removeAll();
        ((BoneTableModel)tableBones.getModel()).removeAll();
        tableBones.repaint();
        buttonSolve.setEnabled(false);

        String selected=(String)comboArrowBone.getSelectedItem();
        if(selected==null)
            return;
        Bone b=IKmodel.get(selected);
        if(b==null)return;
        ArrayList <Object []> al=new ArrayList<Object []>();
        int j=0;
        while(true){
            selected=b.getParent();
            if(selected==null)break;
            al.add(new Object[]{selected,j});
            j++;
            b=IKmodel.get(selected);
        }
        listParents.setModel(new ParentBoneListModel(
                al.toArray(new Object[al.size()][])
        ));
    }//GEN-LAST:event_comboArrowBoneActionPerformed

    private void comboMotionBoneActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_comboMotionBoneActionPerformed
        String s=(String)comboMotionBone.getSelectedItem();
        if(s==null)
            return;
        Pose [] p=targetMotion.get(s);
        if(p==null)
            return;
//        DefaultTableModel dtm=(DefaultTableModel)tableFrames.getModel();
        Object [][] table=new Object[p.length][];
        for(int i=0;i<p.length;i++){
            table[i]=new Object[]{p[i].frame,null};          
//            dtm.addRow(new Object[]{p[i].frame,0});
        }
        tableFrames.setModel(new DefaultTableModel(table, new String[]{"frame","距離"}));
        if(tableBones.getRowCount()>00 && tableFrames.getRowCount()>0){
            buttonSolve.setEnabled(true);
        }else {
            buttonSolve.setEnabled(false);
        }
    }//GEN-LAST:event_comboMotionBoneActionPerformed

    private void buttonOpenIKModelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonOpenIKModelActionPerformed
        Model m=MmdDialog.loadModel(this);
        if(m==null)
            return;
        IKmodel=m;
        labelIKModelName.setText(IKmodel.getName());
        comboArrowBone.removeAllItems();
        comboArrowBone.setMMDModel(IKmodel);
        if(checkSameModel.isSelected()){
            targetModel=IKmodel;
            labelTargetModel.setText(targetModel.getName());
        }
    }//GEN-LAST:event_buttonOpenIKModelActionPerformed

    private void buttonOpenTargetMotionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonOpenTargetMotionActionPerformed
        Motion m=MmdDialog.loadMotion(this);
        if(m==null){
            return;
        }
        targetMotion=m;
        labelTargetMotion.setText(targetMotion.getModelName());
        comboMotionBone.setMMDMotion(targetMotion);
    }//GEN-LAST:event_buttonOpenTargetMotionActionPerformed

    private void checkSameModelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_checkSameModelActionPerformed
        if(checkSameModel.isSelected()){
            buttonOpenTargetModel.setEnabled(false);
            targetModel=IKmodel;
            if(targetModel!=null){
                labelTargetModel.setText(targetModel.getName());
            }
        }else {
            buttonOpenTargetModel.setEnabled(true);
        }
    }//GEN-LAST:event_checkSameModelActionPerformed

    private void log(String log){
        jTextAreaLog.setText(jTextAreaLog.getText()+log+"\n");        
    }
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(IKSolver_GUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(IKSolver_GUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(IKSolver_GUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(IKSolver_GUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                new IKSolver_GUI().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton buttonInsert;
    private javax.swing.JButton buttonOpenIKModel;
    private javax.swing.JButton buttonOpenIKMotion;
    private javax.swing.JButton buttonOpenTargetModel;
    private javax.swing.JButton buttonOpenTargetMotion;
    private javax.swing.JButton buttonRemove;
    private javax.swing.JButton buttonSave;
    private javax.swing.JButton buttonSolve;
    private javax.swing.JCheckBox checkSameModel;
    private jp.sourceforge.mmd.motion.swing.BoneComboBox comboArrowBone;
    private jp.sourceforge.mmd.motion.swing.BoneComboBox comboMotionBone;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenu jMenu2;
    private javax.swing.JMenu jMenu3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JScrollPane jScrollPane5;
    private javax.swing.JTextArea jTextAreaLog;
    private javax.swing.JLabel labelIKModelName;
    private javax.swing.JLabel labelIKMotion;
    private javax.swing.JLabel labelTargetModel;
    private javax.swing.JLabel labelTargetMotion;
    private javax.swing.JList listParents;
    private javax.swing.JMenuItem menuAbout;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JMenuItem menuQuit;
    private javax.swing.JMenuItem menuVMD2CSV;
    private javax.swing.JTable tableBones;
    private javax.swing.JTable tableFrames;
    // End of variables declaration//GEN-END:variables
}
