/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.parser;

import java.io.IOException;
import jp.sfjp.mikutoga.bin.parser.BinParser;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.bin.parser.ProxyParser;
import jp.sfjp.mikutoga.vmd.parser.VmdLightingHandler;
import jp.sfjp.mikutoga.vmd.parser.VmdUnifiedHandler;

class VmdLightingParser
extends ProxyParser {
    private VmdLightingHandler handler = VmdUnifiedHandler.EMPTY;

    VmdLightingParser(BinParser parser) {
        super(parser);
    }

    void setLightingHandler(VmdLightingHandler lightingHandler) {
        this.handler = lightingHandler == null ? VmdUnifiedHandler.EMPTY : lightingHandler;
    }

    void parse() throws IOException, MmdFormatException {
        this.parseVmdLighting();
        if (this.hasMore()) {
            this.parseVmdShadow();
        }
    }

    private void parseVmdLighting() throws IOException, MmdFormatException {
        int lightMotionNo = this.parseLeInt();
        this.handler.loopStart(VmdLightingHandler.LUMINOUS_LIST, lightMotionNo);
        for (int ct = 0; ct < lightMotionNo; ++ct) {
            int keyFrameNo = this.parseLeInt();
            this.handler.vmdLuminousMotion(keyFrameNo);
            float rVal = this.parseLeFloat();
            float gVal = this.parseLeFloat();
            float bVal = this.parseLeFloat();
            this.handler.vmdLuminousColor(rVal, gVal, bVal);
            float xVec = this.parseLeFloat();
            float yVec = this.parseLeFloat();
            float zVec = this.parseLeFloat();
            this.handler.vmdLuminousDirection(xVec, yVec, zVec);
            this.handler.loopNext(VmdLightingHandler.LUMINOUS_LIST);
        }
        this.handler.loopEnd(VmdLightingHandler.LUMINOUS_LIST);
    }

    private void parseVmdShadow() throws IOException, MmdFormatException {
        int shadowMotionNo = this.parseLeInt();
        this.handler.loopStart(VmdLightingHandler.SHADOW_LIST, shadowMotionNo);
        for (int ct = 0; ct < shadowMotionNo; ++ct) {
            int keyFrameNo = this.parseLeInt();
            this.handler.vmdShadowMotion(keyFrameNo);
            byte shadowMode = this.parseByte();
            this.handler.vmdShadowMode(shadowMode);
            float shadowScope = this.parseLeFloat();
            this.handler.vmdShadowScopeRaw(shadowScope);
            this.handler.loopNext(VmdLightingHandler.SHADOW_LIST);
        }
        this.handler.loopEnd(VmdLightingHandler.SHADOW_LIST);
    }
}

