/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.midiMotion;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.CsvSpliter;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.Pose;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;

/**
 * Bassist Motion. 単音専用
 * @author nazo
 */
public class BassMotionBuilder extends MotionBuilder{
    protected Motion playerTemp;
    protected Map<Integer,int[]> note2frames;
    protected Map<Integer,int[]> string2fingers;
    protected boolean finger;
    protected int lastNote=0;

    public BassMotionBuilder(){
        super();
        this.finger = true;
//        motion.setModelName("天音カナ");
        note2frames=new TreeMap<Integer, int[]>();
        string2fingers=new TreeMap<Integer, int[]>();
        playerTemp=null;
    }

    public void setTemplate(Motion player){
        this.playerTemp=player;
        motion.setModelName(player.getModelName());
    }

    public void loadFrameMap(InputStream is) throws IOException{
        BufferedReader br=new BufferedReader(new InputStreamReader(is,"MS932"));
        String line;
        String []p;
        Integer note;
        while(br.ready()){
            line=br.readLine();
            p=CsvSpliter.split(line);
            if(p[0].charAt(0)==';')continue;
            note=new Integer(p[1]);
            note2frames.put(note,
                    new int []{
                        Integer.parseInt(p[2]),//on
                        Integer.parseInt(p[3]),//off
                        Integer.parseInt(p[4])// string number
                    });
            if(note==128){
                string2fingers.put(Integer.parseInt(p[4]),new int[]{
                    Integer.parseInt(p[2]),//on
                    Integer.parseInt(p[3])//off
                });
            }
        }
    }

    /**
     * do setTemplate and load
     */
    @Override
    public void loadMessages(){
        if(playerTemp==null||note2frames.isEmpty()){
            return;
        }

        ShortMessage sm;
        int com;
        int note;
        int vel;
        int frame;
        int i,j;
        BonePose p;
        Pose [] ps;
        int []list;
        MidiEvent [] bass=null;

        for(i=0;i<16;i++){
            if(bass==null){
                bass=mm.getChannelMessage(i);
            }
        }
        reportProgressStart();
        for(MidiEvent me:bass){
            sm=(ShortMessage)me.getMessage();
            frame=ticsToframe(me.getTick());
            reportProgress(frame);

            if((com=sm.getCommand())==ShortMessage.NOTE_ON) {
                note=sm.getData1();
                vel=sm.getData2();

                list=note2frames.get(note);// 左手
                if(list==null)continue;
                j=list[0]; // on
                if(j==0){ // 開放弦
                    if(lastNote==0){
                        lastNote=note+1;
                    }else {
                        int [] list2=note2frames.get(lastNote);
                        lastNote=lastNote+5*(list2[2]-list[2]); // 同じ弦なら変わらない
                    }
                    list=note2frames.get(lastNote);
                    j=list[1]; // off
                }else{
                    lastNote=note;
                }
                ps = playerTemp.get(j);
                motion.putAll(ps, frame);

                list=string2fingers.get(list[2]);
                ps = playerTemp.get(list[0]+(finger?0:2));
                motion.putAll(ps, frame-1);
                ps = playerTemp.get(list[0]+(finger?2:0));
                motion.putAll(ps, frame+1);
                finger=!finger;
            } else if((com=sm.getCommand())==ShortMessage.NOTE_OFF){
                note=sm.getData1();
                vel=sm.getData2();

                list=note2frames.get(note);// 左手
                if(list==null)continue;
                j=list[0]; //on
                if(j==0){ // 開放弦
                    list=note2frames.get(lastNote);
                    j=list[1]; //off
                }else{
                    lastNote=note;
                }
                ps = playerTemp.get(j);
                motion.putAll(ps, frame-1);
                ps = playerTemp.get((j==list[1])?list[0]:list[1]);
                motion.putAll(ps, frame);
            }/*end of note OFF*/
        }
        list=note2frames.get(0);
        ps = playerTemp.get(list[0]);
        motion.putAll(ps,0);

        reportProgressEnd();
    }
}
