/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.midiMotion;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;
import jp.sourceforge.mmd.midiMotion.MotionBuilder;
import jp.sourceforge.mmd.motion.CsvSpliter;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.Pose;

public class SampleMotionBuilder
extends MotionBuilder {
    protected Motion template = null;
    protected Map<Integer, int[]> note2frames = new TreeMap<Integer, int[]>();

    public void setTemplate(Motion player) {
        this.template = player;
        this.motion.setModelName(player.getModelName());
    }

    public void loadFrameMap(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "MS932"));
        while (br.ready()) {
            String line = br.readLine();
            if (line.charAt(0) == ';') continue;
            String[] p = CsvSpliter.split(line);
            this.note2frames.put(new Integer(p[1]), new int[]{Integer.parseInt(p[2]), Integer.parseInt(p[3]), Integer.parseInt(p[4]), Integer.parseInt(p[5]), Integer.parseInt(p[6]), Integer.parseInt(p[7])});
        }
    }

    @Override
    public void loadMessages() {
        int i;
        if (this.template == null || this.note2frames.isEmpty()) {
            return;
        }
        TreeMap<Integer, int[]> extend = new TreeMap<Integer, int[]>();
        double n = 0.0;
        MidiEvent[] mes = this.mm.getChannelMessage(0);
        for (i = 0; i < 9; ++i) {
            if (mes != null) continue;
            mes = this.mm.getChannelMessage(i);
        }
        this.reportProgressStart();
        for (MidiEvent me : mes) {
            Pose[] ps;
            int j;
            int[] list;
            int note;
            ShortMessage sm = (ShortMessage)me.getMessage();
            int frame = this.ticsToframe(me.getTick());
            this.reportProgress(frame);
            int com = sm.getCommand();
            if (com == 144) {
                note = sm.getData1();
                int vel = sm.getData2();
                list = this.note2frames.get(note);
                if (list == null) continue;
                if (list[3] > 0) {
                    extend.put(note, new int[]{frame});
                    continue;
                }
                j = list[0];
                for (i = frame + list[0] - list[1]; i < frame + list[0] - list[1] + list[2]; ++i) {
                    ps = this.template.get(j);
                    this.motion.putAll(ps, i < 0 ? 0 : i);
                    ++j;
                }
                continue;
            }
            if (com != 128 || (list = this.note2frames.get(note = sm.getData1())) == null) continue;
            if (list[3] > 0) {
                int[] aset = (int[])extend.get(note);
                if (aset == null) continue;
                double d = (double)(frame - aset[0]) / (double)(list[2] - 1 + list[0] - list[1]);
                for (j = list[0]; j < list[0] + list[2]; ++j) {
                    ps = this.template.get(j);
                    i = aset[0] + (int)(d * (double)(j - list[1]));
                    this.motion.putAll(ps, i < 0 ? 0 : i);
                }
                continue;
            }
            if (list[4] <= 0) continue;
            j = list[4];
            for (i = frame; i <= frame + list[5] - list[4]; ++i) {
                ps = this.template.get(j);
                this.motion.putAll(ps, i);
                ++j;
            }
        }
        this.reportProgressEnd();
    }
}

